/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.Version;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.ThreadingUtil;
import jmri.util.swing.CountingBusyDialog;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullBackupExportAction
extends JmriAbstractAction {
    private Component _parent;
    private String filename;
    private CountingBusyDialog dialog;
    private static final Logger log = LoggerFactory.getLogger(FullBackupExportAction.class);

    public FullBackupExportAction(String s, WindowInterface wi) {
        super(s, wi);
        this._parent = wi.getFrame();
    }

    public FullBackupExportAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
        this._parent = wi.getFrame();
    }

    public FullBackupExportAction(String s, Component parent) {
        super(s);
        this._parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String roster_filename_extension = "roster";
        JmriJFileChooser chooser = new JmriJFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("JMRI full roster files", roster_filename_extension);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this._parent);
        if (returnVal != 0) {
            return;
        }
        this.filename = chooser.getSelectedFile().getAbsolutePath();
        if (!this.filename.endsWith("." + roster_filename_extension)) {
            this.filename = this.filename.concat("." + roster_filename_extension);
        }
        new Thread(() -> this.run()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Roster roster = Roster.getDefault();
            this.dialog = new CountingBusyDialog(null, "Exporting Roster", false, roster.getAllEntries().size());
            ThreadingUtil.runOnGUIEventually(() -> this.dialog.start());
            try (ZipOutputStream zipper = new ZipOutputStream(new FileOutputStream(this.filename));){
                int count = 0;
                for (RosterEntry entry : roster.getAllEntries()) {
                    int thisCount = ++count;
                    ThreadingUtil.runOnGUIEventually(() -> this.dialog.count(thisCount));
                    try {
                        this.copyFileToStream(entry.getPathName(), "roster", zipper, "roster: " + entry.getId());
                        if (entry.getImagePath() != null && !entry.getImagePath().isEmpty()) {
                            this.copyFileToStream(entry.getImagePath(), "roster", zipper, "image: " + entry.getId());
                        }
                        if (entry.getIconPath() == null || entry.getIconPath().isEmpty()) continue;
                        this.copyFileToStream(entry.getIconPath(), "roster", zipper, "icon: " + entry.getId());
                    }
                    catch (FileNotFoundException ex) {
                        log.error("Unable to find file in entry {}", (Object)entry.getId(), (Object)ex);
                    }
                    catch (IOException ex) {
                        log.error("Unable to write during entry {}", (Object)entry.getId(), (Object)ex);
                    }
                    catch (Exception ex) {
                        log.error("Unexpected exception during entry {}", (Object)entry.getId(), (Object)ex);
                    }
                }
                this.copyFileToStream(Roster.getDefault().getRosterIndexPath(), null, zipper, null);
                zipper.setComment("Roster file saved from DecoderPro " + Version.name());
                zipper.close();
            }
            catch (FileNotFoundException ex) {
                log.error("Unable to find file {}", (Object)this.filename, (Object)ex);
            }
            catch (IOException ex) {
                log.error("Unable to write to {}", (Object)this.filename, (Object)ex);
            }
        }
        finally {
            ThreadingUtil.runOnGUIEventually(() -> this.dialog.finish());
            log.info("Writing backup done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileToStream(String filename, String dirname, ZipOutputStream zipper, String comment) throws IOException {
        log.debug("write: {}", (Object)filename);
        File file = new File(filename);
        Object entryName = dirname != null ? dirname + "/" + file.getName() : file.getName();
        ZipEntry zipEntry = new ZipEntry((String)entryName);
        zipEntry.setTime(file.lastModified());
        zipEntry.setSize(file.length());
        if (comment != null) {
            zipEntry.setComment(comment);
        }
        zipper.putNextEntry(zipEntry);
        try (FileInputStream fis = new FileInputStream(file);){
            int c;
            while ((c = fis.read()) != -1) {
                zipper.write(c);
            }
        }
        zipper.closeEntry();
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

