/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.FileUtil;
import jmri.util.davidflanagan.HardcopyWriter;
import jmri.util.swing.EditableResizableImagePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionLabelPane
extends JPanel {
    RosterEntry re;
    JTextField[] labels;
    JCheckBox[] lockable;
    JCheckBox[] visible;
    JRadioButton[] shunterMode;
    ButtonGroup shunterModeGroup;
    EditableResizableImagePanel[] _imageFilePath;
    EditableResizableImagePanel[] _imagePressedFilePath;
    private int maxfunction = 28;
    boolean print = false;
    private static final Logger log = LoggerFactory.getLogger(FunctionLabelPane.class);

    public JTextField getLabel(int index) {
        return this.labels[index];
    }

    public JCheckBox getLockable(int index) {
        return this.lockable[index];
    }

    public JCheckBox getVisible(int index) {
        return this.visible[index];
    }

    public FunctionLabelPane() {
    }

    public FunctionLabelPane(RosterEntry r) {
        this.re = r;
        this.initGUI();
    }

    private void initGUI() {
        this.maxfunction = this.re.getMaxFnNumAsInt();
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints cL = new GridBagConstraints();
        this.setLayout(gbLayout);
        this.labels = new JTextField[this.maxfunction + 1];
        this.lockable = new JCheckBox[this.maxfunction + 1];
        this.visible = new JCheckBox[this.maxfunction + 1];
        this.shunterMode = new JRadioButton[this.maxfunction + 1];
        this.shunterModeGroup = new ButtonGroup();
        this._imageFilePath = new EditableResizableImagePanel[this.maxfunction + 1];
        this._imagePressedFilePath = new EditableResizableImagePanel[this.maxfunction + 1];
        cL.gridx = 0;
        cL.gridy = 0;
        cL.ipadx = 3;
        cL.anchor = 18;
        cL.insets = new Insets(0, 0, 0, 15);
        cL.fill = 2;
        cL.weighty = 1.0;
        int nextx = 0;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonN")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonLabel")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonLockable")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonVisible")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonImageOff")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonImageOn")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonShunterFn")), cL);
        ++cL.gridx;
        this.add(new JLabel("|"));
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonN")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonLabel")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonLockable")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonVisible")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonImageOff")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonImageOn")), cL);
        ++cL.gridx;
        this.add((Component)new JLabel(Bundle.getMessage("FunctionButtonShunterFn")), cL);
        cL.gridx = 0;
        cL.gridy = 1;
        for (int i = 0; i <= this.maxfunction; ++i) {
            this.add((Component)new JLabel("" + i), cL);
            ++cL.gridx;
            this.labels[i] = new JTextField(20);
            if (this.re.getFunctionLabel(i) != null) {
                this.labels[i].setText(this.re.getFunctionLabel(i));
            }
            this.add((Component)this.labels[i], cL);
            ++cL.gridx;
            this.lockable[i] = new JCheckBox();
            this.lockable[i].setSelected(this.re.getFunctionLockable(i));
            this.lockable[i].setToolTipText(Bundle.getMessage("FunctionButtonLockableToolTip"));
            this.add((Component)this.lockable[i], cL);
            ++cL.gridx;
            this.visible[i] = new JCheckBox();
            this.visible[i].setSelected(this.re.getFunctionVisible(i));
            this.visible[i].setToolTipText(Bundle.getMessage("FunctionButtonVisibleToolTip"));
            this.add((Component)this.visible[i], cL);
            ++cL.gridx;
            this._imageFilePath[i] = new EditableResizableImagePanel(this.re.getFunctionImage(i), 20, 20);
            this._imageFilePath[i].setDropFolder(Roster.getDefault().getRosterFilesLocation());
            this._imageFilePath[i].setBackground(new Color(0, 0, 0, 0));
            this._imageFilePath[i].setToolTipText(Bundle.getMessage("FunctionButtonRosterImageToolTip"));
            this._imageFilePath[i].setBorder(BorderFactory.createLineBorder(Color.blue));
            this._imageFilePath[i].addMenuItemBrowseFolder(Bundle.getMessage("MediaRosterOpenSystemFileBrowserOnJMRIfnButtonsRessources"), FileUtil.getExternalFilename("resources/icons/functionicons"));
            this.add((Component)this._imageFilePath[i], cL);
            ++cL.gridx;
            this._imagePressedFilePath[i] = new EditableResizableImagePanel(this.re.getFunctionSelectedImage(i), 20, 20);
            this._imagePressedFilePath[i].setDropFolder(Roster.getDefault().getRosterFilesLocation());
            this._imagePressedFilePath[i].setBackground(new Color(0, 0, 0, 0));
            this._imagePressedFilePath[i].setToolTipText(Bundle.getMessage("FunctionButtonPressedRosterImageToolTip"));
            this._imagePressedFilePath[i].setBorder(BorderFactory.createLineBorder(Color.blue));
            this._imagePressedFilePath[i].addMenuItemBrowseFolder(Bundle.getMessage("MediaRosterOpenSystemFileBrowserOnJMRIfnButtonsRessources"), FileUtil.getExternalFilename("resources/icons/functionicons"));
            this.add((Component)this._imagePressedFilePath[i], cL);
            ++cL.gridx;
            this.shunterMode[i] = new JRadioButton();
            this.shunterModeGroup.add(this.shunterMode[i]);
            if (("F" + i).compareTo(this.re.getShuntingFunction()) == 0) {
                this.shunterMode[i].setSelected(true);
            }
            this.shunterMode[i].setToolTipText(Bundle.getMessage("ShuntButtonToolTip"));
            this.add((Component)this.shunterMode[i], cL);
            if (cL.gridx == 6) {
                ++cL.gridx;
                this.add((Component)new JLabel("|"), cL);
            }
            ++cL.gridy;
            if (cL.gridy == (this.maxfunction + 2) / 2 + 1) {
                cL.gridy = 1;
                nextx += 8;
            }
            cL.gridx = nextx;
        }
    }

    public boolean guiChanged(RosterEntry r) {
        int i;
        if (this.labels != null) {
            for (i = 0; i < this.labels.length; ++i) {
                if (this.labels[i] == null) continue;
                if (r.getFunctionLabel(i) == null && !this.labels[i].getText().equals("")) {
                    return true;
                }
                if (r.getFunctionLabel(i) == null || r.getFunctionLabel(i).equals(this.labels[i].getText())) continue;
                return true;
            }
        }
        if (this.lockable != null) {
            for (i = 0; i < this.lockable.length; ++i) {
                if (this.lockable[i] == null) continue;
                if (r.getFunctionLockable(i) && !this.lockable[i].isSelected()) {
                    return true;
                }
                if (r.getFunctionLockable(i) || !this.lockable[i].isSelected()) continue;
                return true;
            }
        }
        if (this.visible != null) {
            for (i = 0; i < this.visible.length; ++i) {
                if (this.visible[i] == null) continue;
                if (r.getFunctionVisible(i) && !this.visible[i].isSelected()) {
                    return true;
                }
                if (r.getFunctionVisible(i) || !this.visible[i].isSelected()) continue;
                return true;
            }
        }
        if (this._imageFilePath != null) {
            for (i = 0; i < this._imageFilePath.length; ++i) {
                if (this._imageFilePath[i] == null) continue;
                if (r.getFunctionImage(i) == null && this._imageFilePath[i].getImagePath() != null) {
                    return true;
                }
                if (r.getFunctionImage(i) == null || r.getFunctionImage(i).equals(this._imageFilePath[i].getImagePath())) continue;
                return true;
            }
        }
        if (this._imagePressedFilePath != null) {
            for (i = 0; i < this._imagePressedFilePath.length; ++i) {
                if (this._imagePressedFilePath[i] == null) continue;
                if (r.getFunctionSelectedImage(i) == null && this._imagePressedFilePath[i].getImagePath() != null) {
                    return true;
                }
                if (r.getFunctionSelectedImage(i) == null || r.getFunctionSelectedImage(i).equals(this._imagePressedFilePath[i].getImagePath())) continue;
                return true;
            }
        }
        if (this.shunterMode != null) {
            Object shunFn = "";
            for (int i2 = 0; i2 < this.shunterMode.length; ++i2) {
                if (this.shunterMode[i2] == null || !this.shunterMode[i2].isSelected()) continue;
                shunFn = "F" + i2;
            }
            if (((String)shunFn).compareTo(r.getShuntingFunction()) != 0) {
                return true;
            }
        }
        return false;
    }

    public void updateFromEntry(RosterEntry re) {
        if (this.labels != null) {
            for (int i = 0; i < this.labels.length; ++i) {
                this.labels[i].setText(re.getFunctionLabel(i));
                this.lockable[i].setSelected(re.getFunctionLockable(i));
                this.visible[i].setSelected(re.getFunctionVisible(i));
            }
        }
        if (re.getShuntingFunction() != null) {
            try {
                int sfn = Integer.parseInt(re.getShuntingFunction().substring(1));
                if (sfn < this.shunterMode.length && this.shunterMode[sfn] != null) {
                    this.shunterMode[sfn].setSelected(true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void update(RosterEntry r) {
        if (this.labels != null) {
            Object shunFn = "";
            for (int i = 0; i < this.labels.length; ++i) {
                if (this.labels[i] != null && !this.labels[i].getText().equals("")) {
                    r.setFunctionLabel(i, this.labels[i].getText());
                    r.setFunctionLockable(i, this.lockable[i].isSelected());
                    r.setFunctionVisible(i, this.visible[i].isSelected());
                    r.setFunctionImage(i, this._imageFilePath[i].getImagePath());
                    r.setFunctionSelectedImage(i, this._imagePressedFilePath[i].getImagePath());
                } else if (this.labels[i] != null && this.labels[i].getText().equals("") && r.getFunctionLabel(i) != null) {
                    r.setFunctionLabel(i, null);
                    r.setFunctionImage(i, null);
                    r.setFunctionSelectedImage(i, null);
                }
                if (this.shunterMode[i] == null || !this.shunterMode[i].isSelected()) continue;
                shunFn = "F" + i;
            }
            r.setShuntingFunction((String)shunFn);
        }
    }

    public void dispose() {
        log.debug("dispose");
    }

    public boolean includeInPrint() {
        return this.print;
    }

    public void includeInPrint(boolean inc) {
        this.print = inc;
    }

    public void printPane(HardcopyWriter w) {
        int col1Width = w.getCharactersPerLine() / 2 - 3 - 5;
        int col2Width = w.getCharactersPerLine() / 2 - 3 + 5;
        try {
            StringBuilder spaces = new StringBuilder();
            for (int i = 0; i < col1Width; ++i) {
                spaces.append(" ");
            }
            String heading1 = Bundle.getMessage("ColumnHeadingFunction");
            String heading2 = Bundle.getMessage("ColumnHeadingDescription");
            int interval = spaces.length() - heading1.length();
            w.setFontStyle(1);
            Object s = Bundle.getMessage("HeadingFunctionLabels");
            w.write((String)s, 0, ((String)s).length());
            w.writeBorders();
            w.write(w.getCurrentLineNumber(), 0, w.getCurrentLineNumber(), w.getCharactersPerLine() + 1);
            s = "\n";
            w.write((String)s, 0, ((String)s).length());
            w.setFontStyle(3);
            s = "   " + heading1 + spaces.substring(0, interval) + "   " + heading2;
            w.write((String)s, 0, ((String)s).length());
            w.writeBorders();
            s = "\n";
            w.write((String)s, 0, ((String)s).length());
            w.setFontStyle(0);
            for (int i = 0; i <= this.maxfunction; ++i) {
                String value;
                Object name = "" + i;
                if (this.re.getFunctionLockable(i)) {
                    name = (String)name + " (lockable)";
                }
                if (!this.re.getFunctionVisible(i)) {
                    name = (String)name + " (not visible)";
                }
                if ((value = this.re.getFunctionLabel(i)) == null) continue;
                int nameLeftIndex = 0;
                int nameRightIndex = ((String)name).length();
                int valueLeftIndex = 0;
                int valueRightIndex = value.length();
                while (valueLeftIndex < value.length() || nameLeftIndex < ((String)name).length()) {
                    String trimmedValue;
                    int space;
                    String trimmedName;
                    String delimiter;
                    int j;
                    if (((String)name).substring(nameLeftIndex).length() > col1Width) {
                        for (j = 0; j < col1Width; ++j) {
                            delimiter = ((String)name).substring(nameLeftIndex + col1Width - j - 1, nameLeftIndex + col1Width - j);
                            if (!delimiter.equals(" ") && !delimiter.equals(";") && !delimiter.equals(",")) continue;
                            nameRightIndex = nameLeftIndex + col1Width - j;
                            break;
                        }
                        trimmedName = ((String)name).substring(nameLeftIndex, nameRightIndex);
                        nameLeftIndex = nameRightIndex;
                        space = spaces.length() - trimmedName.length();
                        s = "   " + trimmedName + spaces.substring(0, space);
                    } else {
                        trimmedName = ((String)name).substring(nameLeftIndex);
                        space = spaces.length() - trimmedName.length();
                        s = "   " + trimmedName + spaces.substring(0, space);
                        name = "";
                        nameLeftIndex = 0;
                    }
                    if (value.substring(valueLeftIndex).length() > col2Width) {
                        for (j = 0; j < col2Width; ++j) {
                            delimiter = value.substring(valueLeftIndex + col2Width - j - 1, valueLeftIndex + col2Width - j);
                            if (!delimiter.equals(" ") && !delimiter.equals(";") && !delimiter.equals(",")) continue;
                            valueRightIndex = valueLeftIndex + col2Width - j;
                            break;
                        }
                        trimmedValue = value.substring(valueLeftIndex, valueRightIndex);
                        valueLeftIndex = valueRightIndex;
                        s = (String)s + "   " + trimmedValue;
                    } else {
                        trimmedValue = value.substring(valueLeftIndex);
                        s = (String)s + "   " + trimmedValue;
                        valueLeftIndex = 0;
                        value = "";
                    }
                    w.write((String)s, 0, ((String)s).length());
                    w.writeBorders();
                    s = "\n";
                    w.write((String)s, 0, ((String)s).length());
                }
            }
            s = "\n";
            w.writeBorders();
            w.write((String)s, 0, ((String)s).length());
            w.writeBorders();
            w.write((String)s, 0, ((String)s).length());
        }
        catch (IOException e) {
            log.warn("error during printing", (Throwable)e);
        }
    }
}

