/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.util.ResourceBundle;
import jmri.Programmer;
import jmri.jmrit.AbstractIdentify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IdentifyLoco
extends AbstractIdentify {
    protected boolean shortAddr;
    private int cv17val;
    private int cv18val;
    protected int cv7val;
    protected int cv8val;
    int address = -1;
    private static final Logger log = LoggerFactory.getLogger(IdentifyLoco.class);

    public IdentifyLoco(Programmer programmer) {
        super(programmer);
    }

    @Override
    public boolean test1() {
        this.statusUpdate(ResourceBundle.getBundle("jmri/jmrit/roster/JmritRosterBundle").getString("READ CV 29"));
        this.readCV("29");
        return false;
    }

    @Override
    public boolean test2(int value) {
        if ((value & 0x20) != 0) {
            this.shortAddr = false;
            this.statusUpdate(ResourceBundle.getBundle("jmri/jmrit/roster/JmritRosterBundle").getString("LONG ADDRESS - READ CV 17"));
            this.readCV("17");
        } else {
            this.shortAddr = true;
            this.statusUpdate(ResourceBundle.getBundle("jmri/jmrit/roster/JmritRosterBundle").getString("SHORT ADDRESS - READ CV 1"));
            this.readCV("1");
        }
        return false;
    }

    @Override
    public boolean test3(int value) {
        if (this.shortAddr) {
            this.address = value;
            this.statusUpdate(ResourceBundle.getBundle("jmri/jmrit/roster/JmritRosterBundle").getString("READMFG"));
            this.readCV("7");
            return false;
        }
        this.cv17val = value;
        this.statusUpdate(ResourceBundle.getBundle("jmri/jmrit/roster/JmritRosterBundle").getString("LONG ADDRESS - READ CV 18"));
        this.readCV("18");
        return false;
    }

    @Override
    public boolean test4(int value) {
        if (this.shortAddr) {
            this.cv7val = value;
            this.statusUpdate(ResourceBundle.getBundle("jmri/jmrit/roster/JmritRosterBundle").getString("READMFGVER"));
            this.readCV("8");
            return false;
        }
        this.cv18val = value;
        this.address = (this.cv17val & 0x3F) * 256 + this.cv18val;
        this.statusUpdate(ResourceBundle.getBundle("jmri/jmrit/roster/JmritRosterBundle").getString("READMFG"));
        this.readCV("7");
        return false;
    }

    @Override
    public boolean test5(int value) {
        if (this.shortAddr) {
            this.cv8val = value;
            return true;
        }
        this.statusUpdate(ResourceBundle.getBundle("jmri/jmrit/roster/JmritRosterBundle").getString("READMFGVER"));
        this.readCV("8");
        this.cv7val = value;
        return false;
    }

    @Override
    public boolean test6(int value) {
        if (this.shortAddr) {
            log.error("test4 routine reached in short address mode");
            return true;
        }
        this.cv8val = value;
        return true;
    }

    @Override
    public boolean test7(int value) {
        log.error("unexpected step 7 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    public boolean test8(int value) {
        log.error("unexpected step 8 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    public boolean test9(int value) {
        log.error("unexpected step 9 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    protected void statusUpdate(String s) {
        this.message(s);
        if (s.equals("Done")) {
            this.done(this.address);
        } else if (log.isDebugEnabled()) {
            log.debug("received status: {}", (Object)s);
        }
    }

    protected abstract void done(int var1);

    protected abstract void message(String var1);
}

