/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jmri.beans.BeanUtil;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterFrame;
import jmri.util.FileUtil;
import jmri.util.StringUtil;
import jmri.util.davidflanagan.HardcopyWriter;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintListAction
extends JmriAbstractAction {
    Frame mFrame = new Frame();
    boolean isPreview;
    private static final Logger log = LoggerFactory.getLogger(PrintListAction.class);

    public PrintListAction(String s, WindowInterface wi) {
        super(s, wi);
        this.isPreview = true;
    }

    public PrintListAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
        this.isPreview = true;
    }

    public PrintListAction(String actionName, Frame frame, boolean preview) {
        super(actionName);
        this.mFrame = frame;
        this.isPreview = preview;
    }

    public void setPreview(boolean preview) {
        this.isPreview = preview;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Roster r = Roster.getDefault();
        Object title = Bundle.getMessage("TitleDecoderProRoster");
        String rosterGroup = r.getDefaultRosterGroup();
        if (BeanUtil.hasProperty(this.wi, "selectedRosterGroup")) {
            rosterGroup = (String)BeanUtil.getProperty(this.wi, "selectedRosterGroup");
        }
        title = rosterGroup == null ? (String)title + " " + Bundle.getMessage("ALLENTRIES") : (String)title + " " + Bundle.getMessage("TitleGroup") + " " + Bundle.getMessage("TitleEntries", rosterGroup);
        try (HardcopyWriter writer = new HardcopyWriter(this.mFrame, (String)title, 10, 0.5, 0.5, 0.5, 0.5, this.isPreview);){
            ImageIcon icon = new ImageIcon(FileUtil.findURL("resources/decoderpro.gif", FileUtil.Location.INSTALLED));
            writer.write(icon.getImage(), new JLabel(icon));
            int height = icon.getImage().getHeight(null);
            int blanks = (height - writer.getLineAscent()) / writer.getLineHeight();
            try {
                for (int i = 0; i < blanks; ++i) {
                    String s = "\n";
                    writer.write(s, 0, s.length());
                }
            }
            catch (IOException ex) {
                log.warn("error during printing", (Throwable)ex);
            }
            List<RosterEntry> l = BeanUtil.hasProperty(this.wi, "allRosterEntries") ? Arrays.asList(((RosterFrame)this.wi).getAllRosterEntries()) : r.matchingList(null, null, null, null, null, null, null);
            log.debug("Roster list size: {}", (Object)l.size());
            Object headerText = "";
            headerText = (String)headerText + StringUtil.padString(Bundle.getMessage("FieldID"), 15);
            headerText = (String)headerText + StringUtil.padString(Bundle.getMessage("FieldDCCAddress"), 6);
            headerText = (String)headerText + StringUtil.padString(Bundle.getMessage("FieldRoadName"), 6);
            headerText = (String)headerText + StringUtil.padString(Bundle.getMessage("FieldRoadNumber"), 6);
            headerText = (String)headerText + StringUtil.padString(Bundle.getMessage("FieldManufacturer"), 6);
            headerText = (String)headerText + StringUtil.padString(Bundle.getMessage("FieldModel"), 10);
            headerText = (String)headerText + StringUtil.padString(Bundle.getMessage("FieldDecoderModel"), 10);
            headerText = (String)headerText + StringUtil.padString(Bundle.getMessage("FieldProtocol"), 12);
            headerText = (String)headerText + StringUtil.padString(Bundle.getMessage("FieldOwner"), 6);
            headerText = (String)headerText + StringUtil.padString(Bundle.getMessage("FieldDateUpdated"), 10);
            try {
                writer.write("\n", 0, 1);
                writer.write((String)headerText);
            }
            catch (IOException ex) {
                log.warn("error during printing", (Throwable)ex);
            }
            for (RosterEntry re : l) {
                if (rosterGroup != null) {
                    if (re.getAttribute(Roster.getRosterGroupProperty(rosterGroup)) == null || !re.getAttribute(Roster.getRosterGroupProperty(rosterGroup)).equals("yes")) continue;
                    re.printEntryLine(writer);
                    continue;
                }
                re.printEntryLine(writer);
            }
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            log.debug("Print cancelled");
        }
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }

    @Override
    public void setParameter(String parameter, String value) {
        parameter = parameter.toLowerCase();
        value = value.toLowerCase();
        if (parameter.equals("ispreview")) {
            this.isPreview = value.equals("true");
        }
    }
}

