/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jmri.beans.BeanUtil;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.FileUtil;
import jmri.util.davidflanagan.HardcopyWriter;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintRosterAction
extends JmriAbstractAction {
    Frame mFrame = new Frame();
    boolean isPreview;
    private static final Logger log = LoggerFactory.getLogger(PrintRosterAction.class);

    public PrintRosterAction(String s, WindowInterface wi) {
        super(s, wi);
        this.isPreview = true;
    }

    public PrintRosterAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
        this.isPreview = true;
    }

    public PrintRosterAction(String actionName, Frame frame, boolean preview) {
        super(actionName);
        this.mFrame = frame;
        this.isPreview = preview;
    }

    public void setPreview(boolean preview) {
        this.isPreview = preview;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HardcopyWriter writer;
        Roster r = Roster.getDefault();
        Object title = Bundle.getMessage("TitleDecoderProRoster");
        String rosterGroup = r.getDefaultRosterGroup();
        if (BeanUtil.hasProperty(this.wi, "selectedRosterGroup")) {
            rosterGroup = (String)BeanUtil.getProperty(this.wi, "selectedRosterGroup");
        }
        title = rosterGroup == null ? (String)title + " " + Bundle.getMessage("ALLENTRIES") : (String)title + " " + Bundle.getMessage("TitleGroup") + " " + Bundle.getMessage("TitleEntries", rosterGroup);
        try {
            writer = new HardcopyWriter(this.mFrame, (String)title, 10, 0.5, 0.5, 0.5, 0.5, this.isPreview);
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            log.debug("Print cancelled");
            return;
        }
        ImageIcon icon = new ImageIcon(FileUtil.findURL("resources/decoderpro.gif", FileUtil.Location.INSTALLED));
        writer.write(icon.getImage(), new JLabel(icon));
        int height = icon.getImage().getHeight(null);
        int blanks = (height - writer.getLineAscent()) / writer.getLineHeight();
        try {
            for (int i = 0; i < blanks; ++i) {
                String s = "\n";
                writer.write(s, 0, s.length());
            }
        }
        catch (IOException ex) {
            log.warn("error during printing", (Throwable)ex);
        }
        List<RosterEntry> l = r.matchingList(null, null, null, null, null, null, null);
        log.debug("Roster list size: {}", (Object)l.size());
        for (RosterEntry re : l) {
            if (rosterGroup != null) {
                if (re.getAttribute(Roster.getRosterGroupProperty(rosterGroup)) == null || !re.getAttribute(Roster.getRosterGroupProperty(rosterGroup)).equals("yes")) continue;
                re.printEntry(writer);
                continue;
            }
            re.printEntry(writer);
        }
        writer.close();
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }

    @Override
    public void setParameter(String parameter, String value) {
        parameter = parameter.toLowerCase();
        value = value.toLowerCase();
        if (parameter.equals("ispreview")) {
            this.isPreview = value.equals("true");
        }
    }
}

