/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.implementation.FileLocationsPreferences;
import jmri.jmrit.roster.Bundle;
import jmri.jmrit.roster.Roster;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;
import jmri.spi.PreferencesManager;
import jmri.util.FileUtil;
import jmri.util.prefs.AbstractPreferencesManager;
import jmri.util.prefs.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosterConfigManager
extends AbstractPreferencesManager {
    private final HashMap<Profile, String> directories = new HashMap();
    private final HashMap<Profile, String> defaultOwners = new HashMap();
    private final HashMap<Profile, Roster> rosters = new HashMap();
    public static final String DIRECTORY = "directory";
    public static final String DEFAULT_OWNER = "defaultOwner";
    private static final Logger log = LoggerFactory.getLogger(RosterConfigManager.class);

    public RosterConfigManager() {
        log.debug("Roster is {}", this.directories);
        FileUtil.getDefault().addPropertyChangeListener("preference:", evt -> {
            FileUtil.Property oldValue = (FileUtil.Property)evt.getOldValue();
            FileUtil.Property newValue = (FileUtil.Property)evt.getNewValue();
            Profile project = oldValue.getKey();
            log.debug("UserFiles changed from {} to {}", evt.getOldValue(), evt.getNewValue());
            if (this.getDirectory(project).equals(oldValue.getValue())) {
                this.setDirectory(project, newValue.getValue());
            }
        });
    }

    @Override
    public void initialize(Profile profile) throws InitializationException {
        if (!this.isInitialized(profile)) {
            Preferences preferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
            this.setDefaultOwner(profile, preferences.get(DEFAULT_OWNER, this.getDefaultOwner(profile)));
            try {
                this.setDirectory(profile, preferences.get(DIRECTORY, this.getDirectory()));
            }
            catch (IllegalArgumentException ex) {
                this.setInitialized(profile, true);
                throw new InitializationException(Bundle.getMessage(Locale.ENGLISH, "IllegalRosterLocation", preferences.get(DIRECTORY, this.getDirectory())), ex.getMessage(), ex);
            }
            this.getRoster(profile).setRosterLocation(this.getDirectory());
            this.setInitialized(profile, true);
        }
    }

    @Override
    public void savePreferences(Profile profile) {
        Preferences preferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
        preferences.put(DIRECTORY, FileUtil.getPortableFilename(this.getDirectory()));
        preferences.put(DEFAULT_OWNER, this.getDefaultOwner(profile));
        try {
            preferences.sync();
        }
        catch (BackingStoreException ex) {
            log.error("Unable to save preferences", (Throwable)ex);
        }
    }

    @Override
    @Nonnull
    public Set<Class<? extends PreferencesManager>> getRequires() {
        Collection requires = super.getRequires();
        requires.add(FileLocationsPreferences.class);
        return requires;
    }

    @Nonnull
    public String getDefaultOwner() {
        return this.getDefaultOwner(ProfileManager.getDefault().getActiveProfile());
    }

    @Nonnull
    public String getDefaultOwner(@CheckForNull Profile profile) {
        String owner = this.defaultOwners.get(profile);
        if (owner == null) {
            owner = "";
            this.defaultOwners.put(profile, owner);
        }
        return owner;
    }

    public void setDefaultOwner(@CheckForNull Profile profile, @CheckForNull String defaultOwner) {
        if (defaultOwner == null) {
            defaultOwner = "";
        }
        String oldDefaultOwner = this.defaultOwners.get(profile);
        this.defaultOwners.put(profile, defaultOwner);
        this.firePropertyChange(DEFAULT_OWNER, oldDefaultOwner, defaultOwner);
    }

    @Nonnull
    public String getDirectory() {
        return this.getDirectory(ProfileManager.getDefault().getActiveProfile());
    }

    @Nonnull
    public String getDirectory(@CheckForNull Profile profile) {
        String directory = this.directories.get(profile);
        if (directory == null) {
            directory = "preference:";
        }
        if ("preference:".equals(directory)) {
            return FileUtil.getUserFilesPath();
        }
        return directory;
    }

    public void setDirectory(@CheckForNull Profile profile, @CheckForNull String directory) {
        if (directory == null || ((String)directory).isEmpty()) {
            directory = "preference:";
        }
        String oldDirectory = this.directories.get(profile);
        try {
            if (!FileUtil.getFile((String)directory).isDirectory()) {
                throw new IllegalArgumentException(Bundle.getMessage("IllegalRosterLocation", directory));
            }
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException(Bundle.getMessage("IllegalRosterLocation", directory));
        }
        if (!((String)directory).equals("preference:") && !((String)(directory = FileUtil.getAbsoluteFilename((String)directory))).endsWith(File.separator)) {
            directory = (String)directory + File.separator;
        }
        this.directories.put(profile, (String)directory);
        log.debug("Roster changed from {} to {}", (Object)oldDirectory, this.directories);
        this.firePropertyChange(DIRECTORY, oldDirectory, directory);
    }

    @Nonnull
    public Roster getRoster(@CheckForNull Profile profile) {
        Roster roster = this.rosters.get(profile);
        if (roster == null) {
            roster = new Roster();
            this.rosters.put(profile, roster);
        }
        return roster;
    }

    @Nonnull
    public Roster setRoster(@CheckForNull Profile profile, @Nonnull Roster roster) {
        this.rosters.put(profile, roster);
        return this.getRoster(profile);
    }
}

