/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;

public class RosterIconFactory
implements InstanceManagerAutoDefault {
    private final int iconHeight;
    HashMap<String, ImageIcon> icons = new HashMap();

    public RosterIconFactory(int h) {
        this.iconHeight = h;
    }

    public RosterIconFactory() {
        this.iconHeight = 19;
    }

    public ImageIcon getIcon(String id) {
        if (id == null) {
            return null;
        }
        RosterEntry re = Roster.getDefault().entryFromTitle(id);
        if (re == null) {
            return null;
        }
        return this.getIcon(re);
    }

    public ImageIcon getReversedIcon(String id) {
        if (id == null) {
            return null;
        }
        RosterEntry re = Roster.getDefault().entryFromTitle(id);
        if (re == null) {
            return null;
        }
        return this.getReversedIcon(re);
    }

    public ImageIcon getIcon(RosterEntry re) {
        if (re == null || re.getIconPath() == null) {
            return null;
        }
        ImageIcon icon = this.icons.get(re.getIconPath());
        if (icon == null) {
            icon = new ImageIcon(re.getIconPath(), re.getId());
            icon.setImage(icon.getImage().getScaledInstance(-1, this.iconHeight, 2));
            this.icons.put(re.getIconPath(), icon);
        }
        return icon;
    }

    public ImageIcon getReversedIcon(RosterEntry re) {
        if (re == null || re.getIconPath() == null) {
            return null;
        }
        ImageIcon revicon = this.icons.get("rev_" + re.getIconPath());
        if (revicon == null) {
            ImageIcon icon = this.getIcon(re);
            if (icon == null) {
                return null;
            }
            AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
            tx.translate(-icon.getImage().getWidth(null), 0.0);
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D g = bi.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            g.dispose();
            revicon = new ImageIcon();
            revicon.setImage(op.filter(bi, null).getScaledInstance(-1, this.iconHeight, 2));
            this.icons.put("rev_" + re.getIconPath(), revicon);
        }
        return revicon;
    }
}

