/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.configurexml;

import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterConfigManager;
import jmri.jmrit.roster.RosterConfigPane;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosterConfigPaneXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(RosterConfigPaneXml.class);

    @Override
    public Element store(Object o) {
        RosterConfigPane p = (RosterConfigPane)o;
        if ((p.getSelectedItem() == null || p.getSelectedItem().isEmpty()) && p.getDefaultOwner().isEmpty()) {
            return null;
        }
        Element roster = new Element("roster");
        if (p.getSelectedItem() != null && !p.getSelectedItem().isEmpty()) {
            roster.setAttribute("directory", p.getSelectedItem());
        }
        roster.setAttribute("class", this.getClass().getName());
        roster.setAttribute("ownerDefault", p.getDefaultOwner());
        return roster;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        ConfigureManager cm;
        boolean result = true;
        Profile project = ProfileManager.getDefault().getActiveProfile();
        if (shared.getAttribute("directory") != null) {
            InstanceManager.getDefault(RosterConfigManager.class).setDirectory(project, shared.getAttribute("directory").getValue());
            if (log.isDebugEnabled()) {
                log.debug("set roster location (1): {}", (Object)shared.getAttribute("directory").getValue());
            }
        }
        if (shared.getAttribute("ownerDefault") != null) {
            InstanceManager.getDefault(RosterConfigManager.class).setDefaultOwner(project, shared.getAttribute("ownerDefault").getValue());
        }
        if ((cm = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cm.registerPref(new RosterConfigPane());
        }
        return result;
    }

    @Override
    public void load(Element element, Object o) {
        ConfigureManager cm;
        if (log.isDebugEnabled()) {
            log.debug("set roster location (2): {}", (Object)element.getAttribute("directory").getValue());
        }
        if (element.getAttribute("directory") != null) {
            Roster.getDefault().setRosterLocation(element.getAttribute("directory").getValue());
        }
        if ((cm = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cm.registerPref(new RosterConfigPane());
        }
    }
}

