/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.rostergroup;

import java.util.List;
import jmri.beans.Bean;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterObject;

public class RosterGroup
extends Bean
implements RosterObject {
    private String name;

    public RosterGroup(String name) {
        this.name = name;
    }

    public List<RosterEntry> getEntries() {
        return Roster.getDefault().getEntriesInGroup(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (Roster.getDefault().getRosterGroups().containsKey(newName)) {
            return;
        }
        String oldName = this.name;
        String oldGroup = Roster.getRosterGroupProperty(oldName);
        String newGroup = Roster.getRosterGroupProperty(newName);
        Roster.getDefault().remapRosterGroup(this, newName);
        for (RosterEntry re : this.getEntries()) {
            re.putAttribute(newGroup, "yes");
            re.deleteAttribute(oldGroup);
        }
        this.name = newName;
        Roster.getDefault().rosterGroupRenamed(oldName, newName);
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    public boolean canEdit() {
        return true;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canChangeContents() {
        return true;
    }
}

