/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.Bundle;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateRosterGroupAction
extends JmriAbstractAction {
    Component _who;
    ArrayList<RosterEntry> rosterEntries;
    private static final Logger log = LoggerFactory.getLogger(CreateRosterGroupAction.class);

    public CreateRosterGroupAction(String s, WindowInterface wi) {
        super(s, wi);
    }

    public CreateRosterGroupAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
    }

    public CreateRosterGroupAction(String s, Component who) {
        super(s);
        this._who = who;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String entry = (String)JmriJOptionPane.showInputDialog(this._who, Bundle.getMessage("CreateRosterGroupDialog", Bundle.getMessage("MenuGroupCreate")), Bundle.getMessage("MenuGroupCreate"), 1, null, null, null);
        if (entry != null) {
            entry = entry.trim();
        }
        if (entry == null || entry.length() == 0 || entry.equals(Roster.ALLENTRIES)) {
            return;
        }
        if (this.rosterEntries != null) {
            for (RosterEntry re : this.rosterEntries) {
                log.debug("Adding RosterEntry {} to new group {}", (Object)re.getId(), (Object)entry);
                re.putAttribute("RosterGroup:" + entry, "yes");
                re.updateFile();
            }
        }
        Roster.getDefault().addRosterGroup(entry);
        Roster.getDefault().writeRoster();
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }

    @Override
    public void setParameter(String key, Object value) {
        if (key.equals("RosterEntries") && value.getClass().equals(ArrayList.class)) {
            this.rosterEntries = (ArrayList)value;
        }
    }
}

