/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.swing;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.Bundle;
import jmri.jmrit.roster.swing.RosterEntrySelectorPanel;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveRosterEntryToGroupAction
extends AbstractAction {
    Component _who;
    String curRosterGroup;
    JmriJFrame frame = null;
    JLabel jLabel = new JLabel(Bundle.getMessage("SelectTheGroup"));
    RosterEntrySelectorPanel rosterBox;
    JButton okButton = new JButton(Bundle.getMessage("ButtonRemove"));
    JButton cancelButton = new JButton(Bundle.getMessage("ButtonDone"));
    private static final Logger log = LoggerFactory.getLogger(RemoveRosterEntryToGroupAction.class);

    public RemoveRosterEntryToGroupAction(String s, Component who) {
        super(s);
        this._who = who;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.frame = new JmriJFrame(Bundle.getMessage("DeleteFromGroup"));
        this.rosterBox = new RosterEntrySelectorPanel();
        this.rosterBox.getRosterGroupComboBox().setAllEntriesEnabled(false);
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(this.jLabel);
        p.add(this.rosterBox);
        this.frame.getContentPane().add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoveRosterEntryToGroupAction.this.okPressed();
            }
        });
        p.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoveRosterEntryToGroupAction.this.dispose();
            }
        });
        this.frame.getContentPane().add(p);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    boolean userOK(String entry, String group) {
        return 0 == JmriJOptionPane.showConfirmDialog(this._who, Bundle.getMessage("DeleteEntryFromGroupDialog", entry, group), Bundle.getMessage("DeleteEntryFromGroupTitle", entry, group), 0);
    }

    public void okPressed() {
        String group = this.rosterBox.getSelectedRosterGroup();
        log.info("Selected {}", (Object)group);
        if (group != null && !group.equals(Roster.ALLENTRIES) && this.rosterBox.getSelectedRosterEntries().length != 0) {
            RosterEntry re = this.rosterBox.getSelectedRosterEntries()[0];
            log.info("Preparing to remove {} from {}", (Object)re.getId(), (Object)group);
            if (this.userOK(re.getId(), group)) {
                re.deleteAttribute(Roster.getRosterGroupProperty(group));
                re.updateFile();
                Roster.getDefault().writeRoster();
                this.rosterBox.getRosterEntryComboBox().update();
            }
        }
        this.frame.pack();
    }

    public void dispose() {
        this.frame.dispose();
    }
}

