/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComboBox;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterEntrySelector;
import jmri.jmrit.roster.swing.Bundle;
import jmri.jmrit.roster.swing.RosterEntryListCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosterEntryComboBox
extends JComboBox<Object>
implements RosterEntrySelector {
    protected Roster _roster;
    protected String _group;
    protected String _roadName;
    protected String _roadNumber;
    protected String _dccAddress;
    protected String _mfg;
    protected String _decoderMfgID;
    protected String _decoderVersionID;
    protected String _id;
    protected String _nonSelectedItem = Bundle.getMessage("RosterEntryComboBoxNoSelection");
    protected RosterEntry[] _currentSelection = null;
    private static final Logger log = LoggerFactory.getLogger(RosterEntryComboBox.class);

    public RosterEntryComboBox() {
        this(Roster.getDefault(), Roster.getDefault().getDefaultRosterGroup(), null, null, null, null, null, null, null);
    }

    public RosterEntryComboBox(Roster roster) {
        this(roster, Roster.getDefault().getDefaultRosterGroup(), null, null, null, null, null, null, null);
    }

    public RosterEntryComboBox(String rosterGroup) {
        this(Roster.getDefault(), rosterGroup, null, null, null, null, null, null, null);
    }

    public RosterEntryComboBox(Roster roster, String rosterGroup) {
        this(roster, rosterGroup, null, null, null, null, null, null, null);
    }

    public RosterEntryComboBox(String roadName, String roadNumber, String dccAddress, String mfg, String decoderMfgID, String decoderVersionID, String id) {
        this(Roster.getDefault(), Roster.getDefault().getDefaultRosterGroup(), roadName, roadNumber, dccAddress, mfg, decoderMfgID, decoderVersionID, id);
    }

    public RosterEntryComboBox(Roster roster, String roadName, String roadNumber, String dccAddress, String mfg, String decoderMfgID, String decoderVersionID, String id) {
        this(roster, Roster.getDefault().getDefaultRosterGroup(), roadName, roadNumber, dccAddress, mfg, decoderMfgID, decoderVersionID, id);
    }

    public RosterEntryComboBox(String rosterGroup, String roadName, String roadNumber, String dccAddress, String mfg, String decoderMfgID, String decoderVersionID, String id) {
        this(Roster.getDefault(), rosterGroup, roadName, roadNumber, dccAddress, mfg, decoderMfgID, decoderVersionID, id);
    }

    public RosterEntryComboBox(Roster roster, String rosterGroup, String roadName, String roadNumber, String dccAddress, String mfg, String decoderMfgID, String decoderVersionID, String id) {
        this.setRenderer(new RosterEntryListCellRenderer());
        this._roster = roster;
        this._group = rosterGroup;
        this.update(rosterGroup, roadName, roadNumber, dccAddress, mfg, decoderMfgID, decoderVersionID, id);
        this._roster.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getPropertyName().equals("add") || pce.getPropertyName().equals("remove") || pce.getPropertyName().equals("change")) {
                    RosterEntryComboBox.this.update();
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RosterEntryComboBox.this.fireSelectedRosterEntriesPropertyChange();
            }
        });
        this._nonSelectedItem = Bundle.getMessage("RosterEntryComboBoxNoSelection");
    }

    public void update() {
        this.update(this._group, this._roadName, this._roadNumber, this._dccAddress, this._mfg, this._decoderMfgID, this._decoderVersionID, this._id);
    }

    public final void update(String rosterGroup) {
        this.update(rosterGroup, this._roadName, this._roadNumber, this._dccAddress, this._mfg, this._decoderMfgID, this._decoderVersionID, this._id);
    }

    public void update(String roadName, String roadNumber, String dccAddress, String mfg, String decoderMfgID, String decoderVersionID, String id) {
        this.update(this._group, roadName, roadNumber, dccAddress, mfg, decoderMfgID, decoderVersionID, id);
    }

    public final void update(String rosterGroup, String roadName, String roadNumber, String dccAddress, String mfg, String decoderMfgID, String decoderVersionID, String id) {
        ActionListener[] ALs;
        Object selection = this.getSelectedItem();
        if (log.isDebugEnabled()) {
            log.debug("Old selection: {}", selection);
            log.debug("Old group: {}", (Object)this._group);
        }
        for (ActionListener al : ALs = this.getActionListeners()) {
            this.removeActionListener(al);
        }
        this.setSelectedItem(null);
        List<RosterEntry> l = this._roster.matchingList(roadName, roadNumber, dccAddress, mfg, decoderMfgID, decoderVersionID, id);
        this._group = rosterGroup;
        this._roadName = roadName;
        this._roadNumber = roadNumber;
        this._dccAddress = dccAddress;
        this._mfg = mfg;
        this._decoderMfgID = decoderMfgID;
        this._decoderVersionID = decoderVersionID;
        this._id = id;
        this.removeAllItems();
        if (this._nonSelectedItem != null) {
            this.insertItemAt(this._nonSelectedItem, 0);
            this.setSelectedItem(this._nonSelectedItem);
        }
        for (RosterEntry r : l) {
            if (rosterGroup != null && !rosterGroup.equals(Roster.ALLENTRIES)) {
                if (r.getAttribute(Roster.getRosterGroupProperty(rosterGroup)) != null && r.getAttribute(Roster.getRosterGroupProperty(rosterGroup)).equals("yes")) {
                    this.addItem(r);
                }
            } else {
                this.addItem(r);
            }
            if (!r.equals(selection)) continue;
            this.setSelectedItem(r);
        }
        if (log.isDebugEnabled()) {
            log.debug("New selection: {}", this.getSelectedItem());
            log.debug("New group: {}", (Object)this._group);
        }
        for (ActionListener al : ALs) {
            this.addActionListener(al);
        }
        if (this.getSelectedItem() != selection) {
            this.fireActionEvent();
            this.fireSelectedRosterEntriesPropertyChange();
        }
    }

    public void setNonSelectedItem(String itemText) {
        this._nonSelectedItem = itemText;
        this.update(this._group);
    }

    public String getNonSelectedItem() {
        return this._nonSelectedItem;
    }

    @Override
    public RosterEntry[] getSelectedRosterEntries() {
        return this.getSelectedRosterEntries(false);
    }

    protected RosterEntry[] getSelectedRosterEntries(boolean force) {
        if (this._currentSelection == null || force) {
            if (this.getSelectedItem() != null && !this.getSelectedItem().equals(this._nonSelectedItem)) {
                this._currentSelection = new RosterEntry[1];
                this._currentSelection[0] = (RosterEntry)this.getSelectedItem();
            } else {
                this._currentSelection = new RosterEntry[0];
            }
        }
        return this._currentSelection;
    }

    protected void fireSelectedRosterEntriesPropertyChange() {
        this.firePropertyChange("selectedRosterEntries", this._currentSelection, this.getSelectedRosterEntries(true));
    }
}

