/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.CheckForNull;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.ShutDownManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.progsupport.ProgModeSelector;
import jmri.jmrit.progsupport.ProgServiceModeComboBox;
import jmri.jmrit.roster.CopyRosterItemAction;
import jmri.jmrit.roster.DeleteRosterItemAction;
import jmri.jmrit.roster.ExportRosterItemAction;
import jmri.jmrit.roster.IdentifyLoco;
import jmri.jmrit.roster.PrintRosterEntry;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterEntrySelector;
import jmri.jmrit.roster.rostergroup.RosterGroupSelector;
import jmri.jmrit.roster.swing.Bundle;
import jmri.jmrit.roster.swing.RosterFrameAction;
import jmri.jmrit.roster.swing.RosterGroupsPanel;
import jmri.jmrit.roster.swing.RosterTable;
import jmri.jmrit.symbolicprog.ProgrammerConfigManager;
import jmri.jmrit.symbolicprog.tabbedframe.PaneOpsProgFrame;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgFrame;
import jmri.jmrit.symbolicprog.tabbedframe.PaneServiceProgFrame;
import jmri.jmrit.throttle.LargePowerManagerButton;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrix.ActiveSystemsMenu;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.ConnectionStatus;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.swing.JTablePersistenceManager;
import jmri.swing.RowSorterUtil;
import jmri.util.FileUtil;
import jmri.util.HelpUtil;
import jmri.util.ThreadingUtil;
import jmri.util.WindowMenu;
import jmri.util.datatransfer.RosterEntrySelection;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseAdapter;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.swing.ResizableImagePanel;
import jmri.util.swing.multipane.TwoPaneTBWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosterFrame
extends TwoPaneTBWindow
implements RosterEntrySelector,
RosterGroupSelector {
    static final ArrayList<RosterFrame> frameInstances = new ArrayList();
    protected boolean allowQuit = true;
    protected String baseTitle = "Roster";
    protected JmriAbstractAction newWindowAction;
    final JRadioButtonMenuItem contextEdit = new JRadioButtonMenuItem(Bundle.getMessage("EditOnly"));
    final JRadioButtonMenuItem contextOps = new JRadioButtonMenuItem(Bundle.getMessage("ProgrammingOnMain"));
    final JRadioButtonMenuItem contextService = new JRadioButtonMenuItem(Bundle.getMessage("ProgrammingTrack"));
    final JTextPane dateUpdated = new JTextPane();
    final JTextPane dccAddress = new JTextPane();
    final JTextPane decoderFamily = new JTextPane();
    final JTextPane decoderModel = new JTextPane();
    final JRadioButton edit = new JRadioButton(Bundle.getMessage("EditOnly"));
    final JTextPane filename = new JTextPane();
    JLabel firstHelpLabel;
    int groupSplitPaneLocation = 0;
    RosterGroupsPanel groups;
    boolean hideGroups = false;
    boolean hideRosterImage = false;
    final JTextPane id = new JTextPane();
    boolean inStartProgrammer = false;
    ResizableImagePanel locoImage;
    JTextPane maxSpeed = new JTextPane();
    final JTextPane mfg = new JTextPane();
    final ProgModeSelector modePanel = new ProgServiceModeComboBox();
    final JTextPane model = new JTextPane();
    final JLabel operationsModeProgrammerLabel = new JLabel();
    final JRadioButton ops = new JRadioButton(Bundle.getMessage("ProgrammingOnMain"));
    ConnectionConfig opsModeProCon = null;
    final JTextPane owner = new JTextPane();
    UserPreferencesManager prefsMgr;
    final JButton prog1Button = new JButton(Bundle.getMessage("Program"));
    final JButton prog2Button = new JButton(Bundle.getMessage("BasicProgrammer"));
    ActionListener programModeListener;
    String programmer1 = "Comprehensive";
    String programmer2 = "Basic";
    final ResourceBundle rb = ResourceBundle.getBundle("apps.AppsBundle");
    transient RosterEntry re;
    final JTextPane roadName = new JTextPane();
    final JTextPane roadNumber = new JTextPane();
    final JPanel rosterDetailPanel = new JPanel();
    PropertyChangeListener rosterEntryUpdateListener;
    JSplitPane rosterGroupSplitPane;
    final JButton rosterMedia = new JButton(Bundle.getMessage("LabelsAndMedia"));
    RosterTable rtable;
    ConnectionConfig serModeProCon = null;
    final JRadioButton service = new JRadioButton(Bundle.getMessage("ProgrammingTrack"));
    final JLabel serviceModeProgrammerLabel = new JLabel();
    final JLabel statusField = new JLabel();
    final Dimension summaryPaneDim = new Dimension(0, 170);
    final JButton throttleLabels = new JButton(Bundle.getMessage("ThrottleLabels"));
    final JButton throttleLaunch = new JButton(Bundle.getMessage("Throttle"));
    private boolean isUpdatingSelection = false;
    private static final Logger log = LoggerFactory.getLogger(RosterFrame.class);

    public RosterFrame() {
        this(Bundle.getMessage("RosterTitle"));
    }

    public RosterFrame(String name) {
        this(name, "xml/config/parts/jmri/jmrit/roster/swing/RosterFrameMenu.xml", "xml/config/parts/jmri/jmrit/roster/swing/RosterFrameToolBar.xml");
    }

    public RosterFrame(String name, String menubarFile, String toolbarFile) {
        super(name, menubarFile, toolbarFile);
        this.allowInFrameServlet = false;
        this.setBaseTitle(name);
        this.buildWindow();
        this.locoSelected(null);
    }

    protected void additionsToToolBar() {
        this.getToolBar().add(new LargePowerManagerButton(true));
        this.getToolBar().add(Box.createHorizontalGlue());
        JPanel p = new JPanel();
        p.setAlignmentX(1.0f);
        p.add(this.modePanel);
        this.getToolBar().add(p);
    }

    protected void allowQuit(boolean quitAllowed) {
        if (this.allowQuit != quitAllowed) {
            this.newWindowAction = null;
            this.allowQuit = quitAllowed;
            this.groups.setNewWindowMenuAction(this.getNewWindowAction());
        }
        this.firePropertyChange("quit", "setEnabled", (Object)this.allowQuit);
        if (!this.allowQuit) {
            this.firePropertyChange("closewindow", "setEnabled", (Object)true);
        }
    }

    JPanel bottomRight() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        ButtonGroup progMode = new ButtonGroup();
        progMode.add(this.service);
        progMode.add(this.ops);
        progMode.add(this.edit);
        this.service.setEnabled(false);
        this.ops.setEnabled(false);
        this.edit.setEnabled(true);
        this.firePropertyChange("setprogservice", "setEnabled", (Object)false);
        this.firePropertyChange("setprogops", "setEnabled", (Object)false);
        this.firePropertyChange("setprogedit", "setEnabled", (Object)true);
        this.ops.setOpaque(false);
        this.service.setOpaque(false);
        this.edit.setOpaque(false);
        JPanel progModePanel = new JPanel();
        GridLayout buttonLayout = new GridLayout(3, 1, 0, 0);
        progModePanel.setLayout(buttonLayout);
        progModePanel.add(this.service);
        progModePanel.add(this.ops);
        progModePanel.add(this.edit);
        this.programModeListener = e -> this.updateProgMode();
        this.service.addActionListener(this.programModeListener);
        this.ops.addActionListener(this.programModeListener);
        this.edit.addActionListener(this.programModeListener);
        this.service.setVisible(false);
        this.ops.setVisible(false);
        panel.add(progModePanel);
        JPanel buttonHolder = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 11;
        c.gridx = 0;
        c.ipady = 20;
        c.gridwidth = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        buttonHolder.add((Component)this.prog1Button, c);
        c.weightx = 1.0;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.ipady = 0;
        buttonHolder.add((Component)this.rosterMedia, c);
        c.weightx = 1.0;
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.ipady = 0;
        buttonHolder.add((Component)this.throttleLaunch, c);
        panel.add(buttonHolder);
        this.prog1Button.setEnabled(false);
        this.prog1Button.addActionListener(e -> {
            log.debug("Open programmer pressed");
            this.startProgrammer(null, this.re, this.programmer1);
        });
        this.rosterMedia.setEnabled(false);
        this.rosterMedia.addActionListener(e -> {
            log.debug("Open Media pressed");
            this.edit.setSelected(true);
            this.startProgrammer(null, this.re, "dp3" + File.separator + "MediaPane");
        });
        this.throttleLaunch.setEnabled(false);
        this.throttleLaunch.addActionListener(e -> {
            log.debug("Launch Throttle pressed");
            if (!this.checkIfEntrySelected()) {
                return;
            }
            ThrottleFrame tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame();
            tf.toFront();
            tf.getAddressPanel().setRosterEntry(this.re);
        });
        return panel;
    }

    protected final void buildWindow() {
        this.additionsToToolBar();
        frameInstances.add(this);
        this.prefsMgr = InstanceManager.getDefault(UserPreferencesManager.class);
        this.getTop().add(this.createTop());
        this.getBottom().setMinimumSize(this.summaryPaneDim);
        this.getBottom().add(this.createBottom());
        this.statusBar();
        this.systemsMenu();
        this.helpMenu(this.getMenu(), this);
        if (!this.prefsMgr.getSimplePreferenceState(this.getClass().getName() + ".hideGroups") && !Roster.getDefault().getRosterGroupList().isEmpty()) {
            this.hideGroupsPane(false);
        } else {
            this.hideGroupsPane(true);
        }
        if (this.prefsMgr.getSimplePreferenceState(this.getClass().getName() + ".hideSummary")) {
            this.hideBottomPane(false);
            this.hideBottomPane(true);
        }
        PropertyChangeListener propertyChangeListener = changeEvent -> {
            JSplitPane sourceSplitPane = (JSplitPane)changeEvent.getSource();
            String propertyName = changeEvent.getPropertyName();
            if (propertyName.equals("lastDividerLocation")) {
                int current = sourceSplitPane.getDividerLocation() + sourceSplitPane.getDividerSize();
                int panesize = (int)sourceSplitPane.getSize().getHeight();
                this.hideBottomPane = panesize - current <= 1;
            }
        };
        this.updateProgrammerStatus(null);
        ConnectionStatus.instance().addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("change") || e.getPropertyName().equals("add")) {
                log.debug("Received property {} with value {} ", (Object)e.getPropertyName(), e.getNewValue());
                this.updateProgrammerStatus(e);
            }
        });
        InstanceManager.addPropertyChangeListener(InstanceManager.getListPropertyName(AddressedProgrammerManager.class), evt -> {
            log.debug("Received property {} with value {} ", (Object)evt.getPropertyName(), evt.getNewValue());
            AddressedProgrammerManager m = (AddressedProgrammerManager)evt.getNewValue();
            if (m != null) {
                m.addPropertyChangeListener(this::updateProgrammerStatus);
            }
            this.updateProgrammerStatus(evt);
        });
        InstanceManager.getList(AddressedProgrammerManager.class).forEach(m -> m.addPropertyChangeListener(this::updateProgrammerStatus));
        InstanceManager.addPropertyChangeListener(InstanceManager.getListPropertyName(GlobalProgrammerManager.class), evt -> {
            log.debug("Received property {} with value {} ", (Object)evt.getPropertyName(), evt.getNewValue());
            GlobalProgrammerManager m = (GlobalProgrammerManager)evt.getNewValue();
            if (m != null) {
                m.addPropertyChangeListener(this::updateProgrammerStatus);
            }
            this.updateProgrammerStatus(evt);
        });
        InstanceManager.getList(GlobalProgrammerManager.class).forEach(m -> m.addPropertyChangeListener(this::updateProgrammerStatus));
        this.getSplitPane().addPropertyChangeListener(propertyChangeListener);
        if (this.getProgrammerConfigManager().getDefaultFile() != null) {
            this.programmer1 = this.getProgrammerConfigManager().getDefaultFile();
        }
        this.getProgrammerConfigManager().addPropertyChangeListener("defaultFile", evt -> {
            if (this.getProgrammerConfigManager().getDefaultFile() != null) {
                this.programmer1 = this.getProgrammerConfigManager().getDefaultFile();
            }
        });
        String lastProg = (String)this.prefsMgr.getProperty(this.getWindowFrameRef(), "selectedProgrammer");
        if (lastProg != null) {
            if (lastProg.equals("service") && this.service.isEnabled()) {
                this.service.setSelected(true);
                this.updateProgMode();
            } else if (lastProg.equals("ops") && this.ops.isEnabled()) {
                this.ops.setSelected(true);
                this.updateProgMode();
            } else if (lastProg.equals("edit") && this.edit.isEnabled()) {
                this.edit.setSelected(true);
                this.updateProgMode();
            }
        }
        if (frameInstances.size() > 1) {
            this.firePropertyChange("closewindow", "setEnabled", (Object)true);
            this.allowQuit(frameInstances.get(0).isAllowQuit());
        } else {
            this.firePropertyChange("closewindow", "setEnabled", (Object)false);
        }
    }

    boolean checkIfEntrySelected() {
        return this.checkIfEntrySelected(false);
    }

    boolean checkIfEntrySelected(boolean allowMultiple) {
        if (this.re == null && !allowMultiple || this.getSelectedRosterEntries().length < 1) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorNoSelection"));
            return false;
        }
        return true;
    }

    void closeWindow(WindowEvent e) {
        this.saveWindowDetails();
        Roster.getDefault().writeRoster();
        if (this.allowQuit && frameInstances.size() == 1 && !InstanceManager.getDefault(ShutDownManager.class).isShuttingDown()) {
            this.handleQuit(e);
        } else {
            frameInstances.remove(this);
            super.windowClosing(e);
            if (frameInstances.size() == 1 && this.allowQuit) {
                frameInstances.get(0).firePropertyChange("closewindow", "setEnabled", (Object)false);
            }
            this.dispose();
        }
    }

    protected void copyLoco() {
        CopyRosterItem act = new CopyRosterItem("Copy", this, this.re);
        act.actionPerformed(null);
    }

    JComponent createBottom() {
        this.locoImage = new ResizableImagePanel(null, 240, 160);
        this.locoImage.setBorder(BorderFactory.createLineBorder(Color.blue));
        this.locoImage.setOpaque(true);
        this.locoImage.setRespectAspectRatio(true);
        this.rosterDetailPanel.setLayout(new BorderLayout());
        this.rosterDetailPanel.add((Component)this.locoImage, "West");
        this.rosterDetailPanel.add((Component)this.rosterDetails(), "Center");
        this.rosterDetailPanel.add((Component)this.bottomRight(), "East");
        if (this.prefsMgr.getSimplePreferenceState(this.getClass().getName() + ".hideRosterImage")) {
            this.locoImage.setVisible(false);
            this.hideRosterImage = true;
        }
        this.rosterEntryUpdateListener = e -> this.updateDetails();
        return this.rosterDetailPanel;
    }

    JComponent createTop() {
        Object selectedRosterGroup = this.prefsMgr.getProperty(this.getWindowFrameRef(), "selectedRosterGroup");
        this.groups = new RosterGroupsPanel(selectedRosterGroup != null ? selectedRosterGroup.toString() : null);
        this.groups.setNewWindowMenuAction(this.getNewWindowAction());
        this.setTitle(this.groups.getSelectedRosterGroup());
        JPanel rosters = new JPanel();
        rosters.setLayout(new BorderLayout());
        this.rtable = new RosterTable(true, 2);
        this.rtable.setRosterGroup(this.getSelectedRosterGroup());
        this.rtable.setRosterGroupSource(this.groups);
        rosters.add((Component)this.rtable, "Center");
        this.rtable.getTable().getSelectionModel().addListSelectionListener(e -> {
            JTable table = this.rtable.getTable();
            if (!e.getValueIsAdjusting()) {
                if (this.rtable.getSelectedRosterEntries().length == 1 && table.getSelectedRow() >= 0) {
                    log.debug("Selected row {}", (Object)table.getSelectedRow());
                    this.locoSelected(this.rtable.getModel().getValueAt(table.getRowSorter().convertRowIndexToModel(table.getSelectedRow()), 0).toString());
                } else if (this.rtable.getSelectedRosterEntries().length > 1) {
                    log.debug("Multiple selection");
                    this.locoSelected(null);
                } else if (table.getSelectedRow() < 0 && !this.isUpdatingSelection) {
                    this.isUpdatingSelection = true;
                    if (this.re != null) {
                        log.debug("Selected roster entry {}", (Object)this.re.getId());
                        if (!this.rtable.setSelection(this.re)) {
                            this.re = null;
                        }
                    }
                    this.updateDetails();
                    this.rtable.moveTableViewToSelected();
                    this.isUpdatingSelection = false;
                }
            }
        });
        String rostertableref = this.getWindowFrameRef() + ":roster";
        this.rtable.getTable().setName(rostertableref);
        RowSorterUtil.addSingleSortableColumnListener(this.rtable.getTable().getRowSorter());
        JTablePersistenceManager tpm = InstanceManager.getNullableDefault(JTablePersistenceManager.class);
        if (tpm != null) {
            tpm.resetState(this.rtable.getTable());
            tpm.persist(this.rtable.getTable());
        }
        this.rtable.getTable().setDragEnabled(true);
        this.rtable.getTable().setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            public Transferable createTransferable(JComponent c) {
                JTable table = RosterFrame.this.rtable.getTable();
                ArrayList<String> Ids = new ArrayList<String>(table.getSelectedRowCount());
                for (int i = 0; i < table.getSelectedRowCount(); ++i) {
                    Ids.add(RosterFrame.this.rtable.getModel().getValueAt(table.getRowSorter().convertRowIndexToModel(table.getSelectedRows()[i]), 0).toString());
                }
                return new RosterEntrySelection(Ids);
            }

            @Override
            public void exportDone(JComponent c, Transferable t, int action) {
            }
        });
        RosterPopupListener rosterMouseListener = new RosterPopupListener();
        this.rtable.getTable().addMouseListener(JmriMouseListener.adapt(rosterMouseListener));
        this.rosterGroupSplitPane = new JSplitPane(1, this.groups, rosters);
        this.rosterGroupSplitPane.setOneTouchExpandable(true);
        this.rosterGroupSplitPane.setResizeWeight(0.0);
        Object w = this.prefsMgr.getProperty(this.getWindowFrameRef(), "rosterGroupPaneDividerLocation");
        if (w != null) {
            this.groupSplitPaneLocation = (Integer)w;
            this.rosterGroupSplitPane.setDividerLocation(this.groupSplitPaneLocation);
        }
        if (!Roster.getDefault().getRosterGroupList().isEmpty()) {
            if (this.prefsMgr.getSimplePreferenceState(this.getClass().getName() + ".hideGroups")) {
                this.hideGroupsPane(true);
            }
        } else {
            this.enableRosterGroupMenuItems(false);
        }
        PropertyChangeListener propertyChangeListener = changeEvent -> {
            JSplitPane sourceSplitPane = (JSplitPane)changeEvent.getSource();
            String propertyName = changeEvent.getPropertyName();
            if (propertyName.equals("lastDividerLocation")) {
                int current = sourceSplitPane.getDividerLocation();
                this.hideGroups = current <= 1;
                Integer last = (Integer)changeEvent.getNewValue();
                if (current >= 2) {
                    this.groupSplitPaneLocation = current;
                } else if (last >= 2) {
                    this.groupSplitPaneLocation = last;
                }
            }
        };
        this.groups.addPropertyChangeListener("selectedRosterGroup", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                RosterFrame.this.prefsMgr.setProperty(this.getClass().getName(), "selectedRosterGroup", pce.getNewValue());
                RosterFrame.this.setTitle((String)pce.getNewValue());
            }
        });
        this.rosterGroupSplitPane.addPropertyChangeListener(propertyChangeListener);
        Roster.getDefault().addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("RosterGroupAdded") && Roster.getDefault().getRosterGroupList().size() == 1) {
                this.hideGroupsPane(false);
                this.enableRosterGroupMenuItems(true);
            } else if (!this.rtable.isVisible() && e.getPropertyName().equals("saved")) {
                if (this.firstHelpLabel != null) {
                    this.firstHelpLabel.setVisible(false);
                }
                this.rtable.setVisible(true);
                this.rtable.resetColumnWidths();
            }
        });
        if (Roster.getDefault().numEntries() == 0) {
            try {
                BufferedImage myPicture = ImageIO.read(FileUtil.findURL("resources/" + Bundle.getMessage("ThrottleFirstUseImage"), FileUtil.Location.INSTALLED));
                this.firstHelpLabel = new JLabel(new ImageIcon(myPicture));
                this.rtable.setVisible(false);
                rosters.add((Component)this.firstHelpLabel, "North");
                this.rtable.setVisible(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.rosterGroupSplitPane;
    }

    protected void deleteLoco() {
        DeleteRosterItemAction act = new DeleteRosterItemAction("Delete", this);
        act.actionPerformed(null);
    }

    void editMediaButton() {
        boolean serviceSelected = this.service.isSelected();
        boolean opsSelected = this.ops.isSelected();
        this.edit.setSelected(true);
        this.startProgrammer(null, this.re, "dp3" + File.separator + "MediaPane");
        this.service.setSelected(serviceSelected);
        this.ops.setSelected(opsSelected);
    }

    protected void enableRosterGroupMenuItems(boolean enable) {
        this.firePropertyChange("groupspane", "setEnabled", (Object)enable);
        this.firePropertyChange("grouptable", "setEnabled", (Object)enable);
        this.firePropertyChange("deletegroup", "setEnabled", (Object)enable);
    }

    protected void exportLoco() {
        ExportRosterItem act = new ExportRosterItem(Bundle.getMessage("Export"), this, this.re);
        act.actionPerformed(null);
    }

    void formatTextAreaAsLabel(JTextPane pane) {
        pane.setOpaque(false);
        pane.setEditable(false);
        pane.setBorder(null);
    }

    public boolean isAllowQuit() {
        return this.allowQuit;
    }

    public void setAllowQuit(boolean allowQuit) {
        this.allowQuit(allowQuit);
    }

    protected String getBaseTitle() {
        return this.baseTitle;
    }

    protected final void setBaseTitle(String baseTitle) {
        String title = null;
        if (this.baseTitle == null) {
            title = this.getTitle();
        }
        this.baseTitle = baseTitle;
        if (title != null) {
            this.setTitle(title);
        }
    }

    protected JmriAbstractAction getNewWindowAction() {
        if (this.newWindowAction == null) {
            this.newWindowAction = new RosterFrameAction("newWindow", this, this.allowQuit);
        }
        return this.newWindowAction;
    }

    protected void setNewWindowAction(JmriAbstractAction newWindowAction) {
        this.newWindowAction = newWindowAction;
        this.groups.setNewWindowMenuAction(newWindowAction);
    }

    @Override
    public void setTitle(String title) {
        if (title == null || title.isEmpty()) {
            title = Roster.ALLENTRIES;
        }
        if (this.baseTitle != null) {
            if (!title.equals(this.baseTitle) && !title.startsWith(this.baseTitle)) {
                super.setTitle(this.baseTitle + ": " + title);
            }
        } else {
            super.setTitle(title);
        }
    }

    @Override
    public Object getProperty(String key) {
        if (key.equalsIgnoreCase("selectedRosterGroup")) {
            return this.getSelectedRosterGroup();
        }
        if (key.equalsIgnoreCase("hideSummary")) {
            return this.hideBottomPane;
        }
        return super.getProperty(key);
    }

    public Object getRemoteObject(String value) {
        return this.getProperty(value);
    }

    @Override
    public RosterEntry[] getSelectedRosterEntries() {
        RosterEntry[] entries = this.rtable.getSelectedRosterEntries();
        return Arrays.copyOf(entries, entries.length);
    }

    public RosterEntry[] getAllRosterEntries() {
        RosterEntry[] entries = this.rtable.getSortedRosterEntries();
        return Arrays.copyOf(entries, entries.length);
    }

    @Override
    public String getSelectedRosterGroup() {
        return this.groups.getSelectedRosterGroup();
    }

    protected ProgrammerConfigManager getProgrammerConfigManager() {
        return InstanceManager.getDefault(ProgrammerConfigManager.class);
    }

    void handleQuit(WindowEvent e) {
        if (e != null && frameInstances.size() == 1) {
            String rememberWindowClose = this.getClass().getName() + ".closeDP3prompt";
            if (!this.prefsMgr.getSimplePreferenceState(rememberWindowClose)) {
                JPanel message = new JPanel();
                JLabel question = new JLabel(this.rb.getString("MessageLongCloseWarning"));
                JCheckBox remember = new JCheckBox(this.rb.getString("MessageRememberSetting"));
                remember.setFont(remember.getFont().deriveFont(10.0f));
                message.setLayout(new BoxLayout(message, 1));
                message.add(question);
                message.add(remember);
                int result = JmriJOptionPane.showConfirmDialog(null, message, this.rb.getString("MessageShortCloseWarning"), 0);
                if (remember.isSelected()) {
                    this.prefsMgr.setSimplePreferenceState(rememberWindowClose, true);
                }
                if (result == 0) {
                    this.handleQuit();
                }
            } else {
                this.handleQuit();
            }
        } else if (frameInstances.size() > 1) {
            String rememberWindowClose = this.getClass().getName() + ".closeMultipleDP3prompt";
            if (!this.prefsMgr.getSimplePreferenceState(rememberWindowClose)) {
                JPanel message = new JPanel();
                JLabel question = new JLabel(this.rb.getString("MessageLongMultipleCloseWarning"));
                JCheckBox remember = new JCheckBox(this.rb.getString("MessageRememberSetting"));
                remember.setFont(remember.getFont().deriveFont(10.0f));
                message.setLayout(new BoxLayout(message, 1));
                message.add(question);
                message.add(remember);
                int result = JmriJOptionPane.showConfirmDialog(null, message, this.rb.getString("MessageShortCloseWarning"), 0);
                if (remember.isSelected()) {
                    this.prefsMgr.setSimplePreferenceState(rememberWindowClose, true);
                }
                if (result == 0) {
                    this.handleQuit();
                }
            } else {
                this.handleQuit();
            }
        }
    }

    private void handleQuit() {
        try {
            InstanceManager.getDefault(ShutDownManager.class).shutdown();
        }
        catch (Exception e) {
            log.error("Continuing after error in handleQuit", (Throwable)e);
        }
    }

    protected void helpMenu(JMenuBar menuBar, JFrame frame) {
        JMenu helpMenu = HelpUtil.makeHelpMenu("package.apps.gui3.dp3.DecoderPro3", true);
        menuBar.add(helpMenu);
    }

    protected void hideGroups() {
        boolean boo = !this.hideGroups;
        this.hideGroupsPane(boo);
    }

    public void hideGroupsPane(boolean hide) {
        if (this.hideGroups == hide) {
            return;
        }
        this.hideGroups = hide;
        if (hide) {
            this.groupSplitPaneLocation = this.rosterGroupSplitPane.getDividerLocation();
            this.rosterGroupSplitPane.setDividerLocation(1);
            this.rosterGroupSplitPane.getLeftComponent().setMinimumSize(new Dimension());
            if (Roster.getDefault().getRosterGroupList().isEmpty()) {
                this.rosterGroupSplitPane.setOneTouchExpandable(false);
                this.rosterGroupSplitPane.setDividerSize(0);
            }
        } else {
            this.rosterGroupSplitPane.setDividerSize(UIManager.getInt("SplitPane.dividerSize"));
            this.rosterGroupSplitPane.setOneTouchExpandable(true);
            if (this.groupSplitPaneLocation >= 2) {
                this.rosterGroupSplitPane.setDividerLocation(this.groupSplitPaneLocation);
            } else {
                this.rosterGroupSplitPane.resetToPreferredSizes();
            }
        }
    }

    protected void hideRosterImage() {
        boolean bl = this.hideRosterImage = !this.hideRosterImage;
        if (this.hideRosterImage) {
            this.locoImage.setVisible(false);
        } else {
            this.locoImage.setVisible(true);
        }
    }

    protected void hideSummary() {
        boolean boo = !this.hideBottomPane;
        this.hideBottomPane(boo);
    }

    final void locoSelected(String id) {
        if (id != null) {
            log.debug("locoSelected ID {}", (Object)id);
            if (this.re != null) {
                this.re.removePropertyChangeListener(this.rosterEntryUpdateListener);
            }
            this.re = Roster.getDefault().entryFromTitle(id);
            this.re.addPropertyChangeListener(this.rosterEntryUpdateListener);
        } else {
            log.debug("Multiple selection");
            this.re = null;
        }
        this.updateDetails();
    }

    protected void newWindow() {
        this.newWindow(this.getNewWindowAction());
    }

    protected void newWindow(JmriAbstractAction action) {
        action.setWindowInterface(this);
        action.actionPerformed(null);
        this.firePropertyChange("closewindow", "setEnabled", (Object)true);
    }

    protected void printLoco(boolean preview) {
        log.debug("Selected entry: {}", (Object)this.re.getDisplayName());
        String programmer = "Basic";
        if (this.getProgrammerConfigManager().getDefaultFile() != null) {
            programmer = this.getProgrammerConfigManager().getDefaultFile();
        } else {
            log.error("programmer is NULL");
        }
        PrintRosterEntry pre = new PrintRosterEntry(this.re, this, "programmers" + File.separator + programmer + ".xml");
        pre.printPanes(preview);
    }

    @Override
    public void remoteCalls(String[] args) {
        args[0] = args[0].toLowerCase();
        switch (args[0]) {
            case "identifyloco": {
                this.startIdentifyLoco();
                break;
            }
            case "printloco": {
                if (!this.checkIfEntrySelected()) break;
                this.printLoco(false);
                break;
            }
            case "printpreviewloco": {
                if (!this.checkIfEntrySelected()) break;
                this.printLoco(true);
                break;
            }
            case "exportloco": {
                if (!this.checkIfEntrySelected()) break;
                this.exportLoco();
                break;
            }
            case "basicprogrammer": {
                if (!this.checkIfEntrySelected()) break;
                this.startProgrammer(null, this.re, this.programmer2);
                break;
            }
            case "comprehensiveprogrammer": {
                if (!this.checkIfEntrySelected()) break;
                this.startProgrammer(null, this.re, this.programmer1);
                break;
            }
            case "editthrottlelabels": {
                if (!this.checkIfEntrySelected()) break;
                this.startProgrammer(null, this.re, "dp3" + File.separator + "ThrottleLabels");
                break;
            }
            case "editrostermedia": {
                if (!this.checkIfEntrySelected()) break;
                this.startProgrammer(null, this.re, "dp3" + File.separator + "MediaPane");
                break;
            }
            case "hiderosterimage": {
                this.hideRosterImage();
                break;
            }
            case "summarypane": {
                this.hideSummary();
                break;
            }
            case "copyloco": {
                if (!this.checkIfEntrySelected()) break;
                this.copyLoco();
                break;
            }
            case "deleteloco": {
                if (!this.checkIfEntrySelected(true)) break;
                this.deleteLoco();
                break;
            }
            case "setprogservice": {
                this.service.setSelected(true);
                break;
            }
            case "setprogops": {
                this.ops.setSelected(true);
                break;
            }
            case "setprogedit": {
                this.edit.setSelected(true);
                break;
            }
            case "groupspane": {
                this.hideGroups();
                break;
            }
            case "quit": {
                this.saveWindowDetails();
                this.handleQuit(new WindowEvent(this, frameInstances.size()));
                break;
            }
            case "closewindow": {
                this.closeWindow(null);
                break;
            }
            case "newwindow": {
                this.newWindow();
                break;
            }
            case "resettablecolumns": {
                this.rtable.resetColumnWidths();
                break;
            }
            default: {
                log.error("method {} not found", (Object)args[0]);
            }
        }
    }

    JPanel rosterDetails() {
        JPanel panel = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints cL = new GridBagConstraints();
        GridBagConstraints cR = new GridBagConstraints();
        Dimension minFieldDim = new Dimension(30, 20);
        cL.gridx = 0;
        cL.gridy = 0;
        cL.ipadx = 3;
        cL.anchor = 13;
        cL.insets = new Insets(0, 0, 0, 15);
        JLabel row0Label = new JLabel(Bundle.getMessage("FieldID") + ":", 2);
        gbLayout.setConstraints(row0Label, cL);
        panel.setLayout(gbLayout);
        panel.add(row0Label);
        cR.gridx = 1;
        cR.gridy = 0;
        cR.anchor = 17;
        this.id.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.id, cR);
        this.formatTextAreaAsLabel(this.id);
        panel.add(this.id);
        cL.gridy = 1;
        JLabel row1Label = new JLabel(Bundle.getMessage("FieldRoadName") + ":", 2);
        gbLayout.setConstraints(row1Label, cL);
        panel.add(row1Label);
        cR.gridy = 1;
        this.roadName.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.roadName, cR);
        this.formatTextAreaAsLabel(this.roadName);
        panel.add(this.roadName);
        cL.gridy = 2;
        JLabel row2Label = new JLabel(Bundle.getMessage("FieldRoadNumber") + ":");
        gbLayout.setConstraints(row2Label, cL);
        panel.add(row2Label);
        cR.gridy = 2;
        this.roadNumber.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.roadNumber, cR);
        this.formatTextAreaAsLabel(this.roadNumber);
        panel.add(this.roadNumber);
        cL.gridy = 3;
        JLabel row3Label = new JLabel(Bundle.getMessage("FieldManufacturer") + ":");
        gbLayout.setConstraints(row3Label, cL);
        panel.add(row3Label);
        cR.gridy = 3;
        this.mfg.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.mfg, cR);
        this.formatTextAreaAsLabel(this.mfg);
        panel.add(this.mfg);
        cL.gridy = 4;
        JLabel row4Label = new JLabel(Bundle.getMessage("FieldOwner") + ":");
        gbLayout.setConstraints(row4Label, cL);
        panel.add(row4Label);
        cR.gridy = 4;
        this.owner.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.owner, cR);
        this.formatTextAreaAsLabel(this.owner);
        panel.add(this.owner);
        cL.gridy = 5;
        JLabel row5Label = new JLabel(Bundle.getMessage("FieldModel") + ":");
        gbLayout.setConstraints(row5Label, cL);
        panel.add(row5Label);
        cR.gridy = 5;
        this.model.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.model, cR);
        this.formatTextAreaAsLabel(this.model);
        panel.add(this.model);
        cL.gridy = 6;
        JLabel row6Label = new JLabel(Bundle.getMessage("FieldDCCAddress") + ":");
        gbLayout.setConstraints(row6Label, cL);
        panel.add(row6Label);
        cR.gridy = 6;
        this.dccAddress.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.dccAddress, cR);
        this.formatTextAreaAsLabel(this.dccAddress);
        panel.add(this.dccAddress);
        cL.gridy = 7;
        cR.gridy = 7;
        cL.gridy = 8;
        cR.gridy = 8;
        cL.gridy = 9;
        JLabel row9Label = new JLabel(Bundle.getMessage("FieldDecoderFamily") + ":");
        gbLayout.setConstraints(row9Label, cL);
        panel.add(row9Label);
        cR.gridy = 9;
        this.decoderFamily.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.decoderFamily, cR);
        this.formatTextAreaAsLabel(this.decoderFamily);
        panel.add(this.decoderFamily);
        cL.gridy = 10;
        JLabel row10Label = new JLabel(Bundle.getMessage("FieldDecoderModel") + ":");
        gbLayout.setConstraints(row10Label, cL);
        panel.add(row10Label);
        cR.gridy = 10;
        this.decoderModel.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.decoderModel, cR);
        this.formatTextAreaAsLabel(this.decoderModel);
        panel.add(this.decoderModel);
        cL.gridy = 11;
        cR.gridy = 11;
        cL.gridy = 12;
        JLabel row12Label = new JLabel(Bundle.getMessage("FieldFilename") + ":");
        gbLayout.setConstraints(row12Label, cL);
        panel.add(row12Label);
        cR.gridy = 12;
        this.filename.setMinimumSize(minFieldDim);
        gbLayout.setConstraints(this.filename, cR);
        this.formatTextAreaAsLabel(this.filename);
        panel.add(this.filename);
        cL.gridy = 13;
        cR.gridy = 13;
        this.formatTextAreaAsLabel(this.dateUpdated);
        JPanel retval = new JPanel(new FlowLayout(0));
        retval.add(panel);
        return retval;
    }

    void saveWindowDetails() {
        this.prefsMgr.setSimplePreferenceState(this.getClass().getName() + ".hideSummary", this.hideBottomPane);
        this.prefsMgr.setSimplePreferenceState(this.getClass().getName() + ".hideGroups", this.hideGroups);
        this.prefsMgr.setSimplePreferenceState(this.getClass().getName() + ".hideRosterImage", this.hideRosterImage);
        this.prefsMgr.setProperty(this.getWindowFrameRef(), "selectedRosterGroup", this.groups.getSelectedRosterGroup());
        String selectedProgMode = "edit";
        if (this.service.isSelected()) {
            selectedProgMode = "service";
        }
        if (this.ops.isSelected()) {
            selectedProgMode = "ops";
        }
        this.prefsMgr.setProperty(this.getWindowFrameRef(), "selectedProgrammer", selectedProgMode);
        if (this.rosterGroupSplitPane.getDividerLocation() > 2) {
            this.prefsMgr.setProperty(this.getWindowFrameRef(), "rosterGroupPaneDividerLocation", this.rosterGroupSplitPane.getDividerLocation());
        } else if (this.groupSplitPaneLocation > 2) {
            this.prefsMgr.setProperty(this.getWindowFrameRef(), "rosterGroupPaneDividerLocation", this.groupSplitPaneLocation);
        }
    }

    protected void selectLoco(int dccAddress, boolean isLong, int mfgId, int modelId) {
        this.inStartProgrammer = false;
        if (this.re != null) {
            this.re.removePropertyChangeListener(this.rosterEntryUpdateListener);
        }
        List<RosterEntry> l = Roster.getDefault().matchingList(null, null, Integer.toString(dccAddress), null, null, null, null);
        log.debug("selectLoco found {} matches", (Object)l.size());
        if (!l.isEmpty()) {
            if (l.size() > 1) {
                List<Object> l2 = new ArrayList<RosterEntry>();
                for (RosterEntry _re : l) {
                    if (_re.isLongAddress() != isLong) continue;
                    l2.add(_re);
                }
                if (l2.size() == 1) {
                    this.re = (RosterEntry)l2.get(0);
                } else {
                    if (l2.isEmpty()) {
                        l2 = l;
                    }
                    log.trace("Checking against decoder family with mfg {} model {}", (Object)mfgId, (Object)modelId);
                    ArrayList<RosterEntry> l3 = new ArrayList<RosterEntry>();
                    List<DecoderFile> temp = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, "" + mfgId, "" + modelId, null, null);
                    log.trace("found {}", (Object)temp.size());
                    ArrayList<String> decoderFam = new ArrayList<String>();
                    for (DecoderFile decoderFile : temp) {
                        if (decoderFam.contains(decoderFile.getModel())) continue;
                        decoderFam.add(decoderFile.getModel());
                    }
                    log.trace("matched {} times", (Object)decoderFam.size());
                    for (RosterEntry rosterEntry : l2) {
                        if (!decoderFam.contains(rosterEntry.getDecoderModel())) continue;
                        l3.add(rosterEntry);
                    }
                    this.re = l3.isEmpty() ? (RosterEntry)l2.get(0) : (RosterEntry)l3.get(0);
                }
            } else {
                this.re = l.get(0);
            }
            this.re.addPropertyChangeListener(this.rosterEntryUpdateListener);
            this.rtable.setSelection(this.re);
            this.updateDetails();
            this.rtable.moveTableViewToSelected();
        } else {
            log.warn("Read address {}, but no such loco in roster", (Object)dccAddress);
            JmriJOptionPane.showMessageDialog(this, dccAddress + " was read from the decoder\nbut has not been found in the Roster", dccAddress + " No roster entry found", 1);
        }
    }

    public void setProgrammerLaunch(int buttonId, String programmer, String buttonText) {
        if (buttonId == 1) {
            this.programmer1 = programmer;
            this.prog1Button.setText(buttonText);
        } else if (buttonId == 2) {
            this.programmer2 = programmer;
            this.prog2Button.setText(buttonText);
        }
    }

    public void setSelectedRosterGroup(String rosterGroup) {
        this.groups.setSelectedRosterGroup(rosterGroup);
    }

    protected void showPopup(JmriMouseEvent e) {
        int row = this.rtable.getTable().rowAtPoint(e.getPoint());
        if (!this.rtable.getTable().isRowSelected(row)) {
            this.rtable.getTable().changeSelection(row, 0, false, false);
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(Bundle.getMessage("Program"));
        menuItem.addActionListener(e1 -> this.startProgrammer(null, this.re, this.programmer1));
        if (this.re == null) {
            menuItem.setEnabled(false);
        }
        popupMenu.add(menuItem);
        ButtonGroup group = new ButtonGroup();
        group.add(this.contextService);
        group.add(this.contextOps);
        group.add(this.contextEdit);
        JMenu progMenu = new JMenu(Bundle.getMessage("ProgrammerType"));
        this.contextService.addActionListener(e1 -> {
            this.service.setSelected(true);
            this.updateProgMode();
        });
        progMenu.add(this.contextService);
        this.contextOps.addActionListener(e1 -> {
            this.ops.setSelected(true);
            this.updateProgMode();
        });
        progMenu.add(this.contextOps);
        this.contextEdit.addActionListener(e1 -> {
            this.edit.setSelected(true);
            this.updateProgMode();
        });
        if (this.service.isSelected()) {
            this.contextService.setSelected(true);
        } else if (this.ops.isSelected()) {
            this.contextOps.setSelected(true);
        } else {
            this.contextEdit.setSelected(true);
        }
        progMenu.add(this.contextEdit);
        popupMenu.add(progMenu);
        popupMenu.addSeparator();
        menuItem = new JMenuItem(Bundle.getMessage("LabelsAndMedia"));
        menuItem.addActionListener(e1 -> this.editMediaButton());
        if (this.re == null) {
            menuItem.setEnabled(false);
        }
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(Bundle.getMessage("Throttle"));
        menuItem.addActionListener(e1 -> {
            ThrottleFrame tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame();
            tf.toFront();
            tf.getAddressPanel().getRosterEntrySelector().setSelectedRosterGroup(this.getSelectedRosterGroup());
            tf.getAddressPanel().setRosterEntry(this.re);
        });
        if (this.re == null) {
            menuItem.setEnabled(false);
        }
        popupMenu.add(menuItem);
        popupMenu.addSeparator();
        menuItem = new JMenuItem(Bundle.getMessage("PrintSelection"));
        menuItem.addActionListener(e1 -> this.printLoco(false));
        if (this.re == null) {
            menuItem.setEnabled(false);
        }
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(Bundle.getMessage("PreviewSelection"));
        menuItem.addActionListener(e1 -> this.printLoco(true));
        if (this.re == null) {
            menuItem.setEnabled(false);
        }
        popupMenu.add(menuItem);
        popupMenu.addSeparator();
        menuItem = new JMenuItem(Bundle.getMessage("Duplicateddd"));
        menuItem.addActionListener(e1 -> this.copyLoco());
        if (this.re == null) {
            menuItem.setEnabled(false);
        }
        popupMenu.add(menuItem);
        menuItem = new JMenuItem(this.getSelectedRosterGroup() != null ? Bundle.getMessage("DeleteFromGroup") : Bundle.getMessage("DeleteFromRoster"));
        menuItem.addActionListener(e1 -> this.deleteLoco());
        popupMenu.add(menuItem);
        menuItem.setEnabled(this.getSelectedRosterEntries().length > 0);
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected void startIdentifyLoco() {
        final RosterFrame me = this;
        Programmer programmer = null;
        if (this.modePanel.isSelected()) {
            programmer = this.modePanel.getProgrammer();
        }
        if (programmer == null) {
            GlobalProgrammerManager gpm = InstanceManager.getNullableDefault(GlobalProgrammerManager.class);
            if (gpm != null) {
                programmer = gpm.getGlobalProgrammer();
                log.warn("Selector did not provide a programmer, attempt to use GlobalProgrammerManager default: {}", (Object)programmer);
            } else {
                log.warn("Selector did not provide a programmer, and no ProgramManager found in InstanceManager");
            }
        }
        if (programmer == null) {
            log.error("Identify loco called when no service mode programmer is available; button should have been disabled");
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("IdentifyError"));
            return;
        }
        IdentifyLoco ident = new IdentifyLoco(programmer){
            private final RosterFrame who;
            {
                super(programmer);
                this.who = me;
            }

            @Override
            protected void done(int dccAddress) {
                ThreadingUtil.runOnGUI(() -> this.who.selectLoco(dccAddress, !this.shortAddr, this.cv8val, this.cv7val));
            }

            @Override
            protected void message(String m) {
                ThreadingUtil.runOnGUI(() -> RosterFrame.this.statusField.setText(m));
            }

            @Override
            protected void error() {
            }
        };
        ident.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startProgrammer(DecoderFile decoderFile, RosterEntry re, String filename) {
        if (this.inStartProgrammer) {
            log.debug("Call to start programmer has been called twice when the first call hasn't opened");
            return;
        }
        if (!this.checkIfEntrySelected()) {
            return;
        }
        try {
            this.setCursor(new Cursor(3));
            this.inStartProgrammer = true;
            String title = re.getId();
            PaneProgFrame progFrame = null;
            if (this.edit.isSelected()) {
                progFrame = new PaneProgFrame(decoderFile, re, title, "programmers" + File.separator + filename + ".xml", null, false){

                    @Override
                    protected JPanel getModePane() {
                        return null;
                    }
                };
            } else if (this.service.isSelected()) {
                progFrame = new PaneServiceProgFrame(decoderFile, re, title, "programmers" + File.separator + filename + ".xml", this.modePanel.getProgrammer());
            } else if (this.ops.isSelected()) {
                int address = Integer.parseInt(re.getDccAddress());
                boolean longAddr = re.isLongAddress();
                AddressedProgrammer pProg = InstanceManager.getDefault(AddressedProgrammerManager.class).getAddressedProgrammer(longAddr, address);
                progFrame = new PaneOpsProgFrame(decoderFile, re, title, "programmers" + File.separator + filename + ".xml", pProg);
            }
            if (progFrame == null) {
                return;
            }
            ((Window)progFrame).pack();
            progFrame.setVisible(true);
        }
        finally {
            this.setCursor(new Cursor(0));
        }
        this.inStartProgrammer = false;
    }

    protected void statusBar() {
        this.addToStatusBox(this.serviceModeProgrammerLabel, null);
        this.addToStatusBox(this.operationsModeProgrammerLabel, null);
        JLabel programmerStatusLabel = new JLabel(Bundle.getMessage("ProgrammerStatus"));
        this.statusField.setText(Bundle.getMessage("StateIdle"));
        this.addToStatusBox(programmerStatusLabel, this.statusField);
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        if (profile != null) {
            this.addToStatusBox(new JLabel(Bundle.getMessage("ActiveProfile", profile.getName())), null);
        }
    }

    protected void systemsMenu() {
        ActiveSystemsMenu.addItems(this.getMenu());
        this.getMenu().add(new WindowMenu(this));
    }

    void updateDetails() {
        if (this.re == null) {
            String value = this.rtable.getTable().getSelectedRowCount() > 1 ? "Multiple Items Selected" : "";
            this.filename.setText(value);
            this.dateUpdated.setText(value);
            this.decoderModel.setText(value);
            this.decoderFamily.setText(value);
            this.id.setText(value);
            this.roadName.setText(value);
            this.dccAddress.setText(value);
            this.roadNumber.setText(value);
            this.mfg.setText(value);
            this.model.setText(value);
            this.owner.setText(value);
            this.locoImage.setImagePath(null);
            this.service.setEnabled(false);
            this.ops.setEnabled(false);
            this.edit.setEnabled(false);
            this.prog1Button.setEnabled(false);
            this.prog2Button.setEnabled(false);
            this.throttleLabels.setEnabled(false);
            this.rosterMedia.setEnabled(false);
            this.throttleLaunch.setEnabled(false);
        } else {
            this.filename.setText(this.re.getFileName());
            this.dateUpdated.setText(this.re.getDateModified() != null ? DateFormat.getDateTimeInstance().format(this.re.getDateModified()) : this.re.getDateUpdated());
            this.decoderModel.setText(this.re.getDecoderModel());
            this.decoderFamily.setText(this.re.getDecoderFamily());
            this.dccAddress.setText(this.re.getDccAddress());
            this.id.setText(this.re.getId());
            this.roadName.setText(this.re.getRoadName());
            this.roadNumber.setText(this.re.getRoadNumber());
            this.mfg.setText(this.re.getMfg());
            this.model.setText(this.re.getModel());
            this.owner.setText(this.re.getOwner());
            this.locoImage.setImagePath(this.re.getImagePath());
            if (this.hideRosterImage) {
                this.locoImage.setVisible(false);
            } else {
                this.locoImage.setVisible(true);
            }
            this.service.setEnabled(true);
            this.ops.setEnabled(true);
            this.edit.setEnabled(true);
            this.prog1Button.setEnabled(true);
            this.prog2Button.setEnabled(true);
            this.throttleLabels.setEnabled(true);
            this.rosterMedia.setEnabled(true);
            this.throttleLaunch.setEnabled(true);
            this.updateProgMode();
        }
    }

    void updateProgMode() {
        String progMode = this.service.isSelected() ? "setprogservice" : (this.ops.isSelected() ? "setprogops" : "setprogedit");
        this.firePropertyChange(progMode, "setSelected", (Object)true);
    }

    protected void updateProgrammerStatus(@CheckForNull PropertyChangeEvent evt) {
        String strProgMode;
        log.debug("Updating Programmer Status");
        ConnectionConfig oldServMode = this.serModeProCon;
        ConnectionConfig oldOpsMode = this.opsModeProCon;
        GlobalProgrammerManager gpm = null;
        AddressedProgrammerManager apm = null;
        if (InstanceManager.containsDefault(GlobalProgrammerManager.class) || evt != null && evt.getPropertyName().equals(InstanceManager.getDefaultsPropertyName(GlobalProgrammerManager.class)) && evt.getNewValue() == null) {
            gpm = InstanceManager.getNullableDefault(GlobalProgrammerManager.class);
            log.trace("found global programming manager {}", (Object)gpm);
        }
        if (gpm != null) {
            String serviceModeProgrammerName = gpm.getUserName();
            log.debug("GlobalProgrammerManager found of class {} name {} ", gpm.getClass(), (Object)serviceModeProgrammerName);
            InstanceManager.getOptionalDefault(ConnectionConfigManager.class).ifPresent(ccm -> {
                for (ConnectionConfig connection : ccm) {
                    log.debug("Checking connection name {}", (Object)connection.getConnectionName());
                    if (connection.getConnectionName() == null || !connection.getConnectionName().equals(serviceModeProgrammerName)) continue;
                    log.debug("Connection found for GlobalProgrammermanager");
                    this.serModeProCon = connection;
                }
            });
        }
        if (InstanceManager.containsDefault(AddressedProgrammerManager.class) || evt != null && evt.getPropertyName().equals(InstanceManager.getDefaultsPropertyName(AddressedProgrammerManager.class)) && evt.getNewValue() == null) {
            apm = InstanceManager.getNullableDefault(AddressedProgrammerManager.class);
            log.trace("found addressed programming manager {}", (Object)gpm);
        }
        if (apm != null) {
            String opsModeProgrammerName = apm.getUserName();
            log.debug("AddressedProgrammerManager found of class {} name {} ", apm.getClass(), (Object)opsModeProgrammerName);
            InstanceManager.getOptionalDefault(ConnectionConfigManager.class).ifPresent(ccm -> {
                for (ConnectionConfig connection : ccm) {
                    log.debug("Checking connection name {}", (Object)connection.getConnectionName());
                    if (connection.getConnectionName() == null || !connection.getConnectionName().equals(opsModeProgrammerName)) continue;
                    log.debug("Connection found for AddressedProgrammermanager");
                    this.opsModeProCon = connection;
                }
            });
        }
        log.trace("start global check with {}, {}, {}", new Object[]{this.serModeProCon, gpm, gpm != null ? Boolean.valueOf(gpm.isGlobalProgrammerAvailable()) : "<none>"});
        if (this.serModeProCon != null && gpm != null && gpm.isGlobalProgrammerAvailable()) {
            if (ConnectionStatus.instance().isConnectionOk(this.serModeProCon.getConnectionName(), this.serModeProCon.getInfo())) {
                log.debug("GPM Connection online 1");
                this.serviceModeProgrammerLabel.setText(Bundle.getMessage("ServiceModeProgOnline", this.serModeProCon.getConnectionName()));
                this.serviceModeProgrammerLabel.setForeground(new Color(0, 128, 0));
            } else {
                log.debug("GPM Connection offline");
                this.serviceModeProgrammerLabel.setText(Bundle.getMessage("ServiceModeProgOffline", this.serModeProCon.getConnectionName()));
                this.serviceModeProgrammerLabel.setForeground(Color.red);
            }
            if (oldServMode == null) {
                log.debug("Re-enable user interface");
                this.contextService.setEnabled(true);
                this.contextService.setVisible(true);
                this.service.setEnabled(true);
                this.service.setVisible(true);
                this.firePropertyChange("setprogservice", "setEnabled", (Object)true);
                this.getToolBar().getComponents()[1].setEnabled(true);
            }
        } else if (gpm != null && gpm.isGlobalProgrammerAvailable()) {
            if (ConnectionStatus.instance().isSystemOk(gpm.getUserName())) {
                log.debug("GPM Connection online 2");
                this.serviceModeProgrammerLabel.setText(Bundle.getMessage("ServiceModeProgOnline", gpm.getUserName()));
                this.serviceModeProgrammerLabel.setForeground(new Color(0, 128, 0));
            } else {
                log.debug("GPM Connection onffline");
                this.serviceModeProgrammerLabel.setText(Bundle.getMessage("ServiceModeProgOffline", gpm.getUserName()));
                this.serviceModeProgrammerLabel.setForeground(Color.red);
            }
            if (oldServMode == null) {
                log.debug("Re-enable user interface");
                this.contextService.setEnabled(true);
                this.contextService.setVisible(true);
                this.service.setEnabled(true);
                this.service.setVisible(true);
                this.firePropertyChange("setprogservice", "setEnabled", (Object)true);
                this.getToolBar().getComponents()[1].setEnabled(true);
            }
        } else {
            log.debug("no service programmer");
            this.serviceModeProgrammerLabel.setText(Bundle.getMessage("NoServiceProgrammerAvailable"));
            this.serviceModeProgrammerLabel.setForeground(Color.red);
            if (oldServMode != null) {
                this.contextService.setEnabled(false);
                this.contextService.setVisible(false);
                this.service.setEnabled(false);
                this.service.setVisible(false);
                this.firePropertyChange("setprogservice", "setEnabled", (Object)false);
            }
            this.getToolBar().getComponents()[1].setEnabled(false);
            this.serModeProCon = null;
        }
        if (this.opsModeProCon != null && apm != null && apm.isAddressedModePossible()) {
            if (ConnectionStatus.instance().isConnectionOk(this.opsModeProCon.getConnectionName(), this.opsModeProCon.getInfo())) {
                log.debug("Ops Mode Connection online");
                this.operationsModeProgrammerLabel.setText(Bundle.getMessage("OpsModeProgOnline", this.opsModeProCon.getConnectionName()));
                this.operationsModeProgrammerLabel.setForeground(new Color(0, 128, 0));
            } else {
                log.debug("Ops Mode Connection offline");
                this.operationsModeProgrammerLabel.setText(Bundle.getMessage("OpsModeProgOffline", this.opsModeProCon.getConnectionName()));
                this.operationsModeProgrammerLabel.setForeground(Color.red);
            }
            if (oldOpsMode == null) {
                this.contextOps.setEnabled(true);
                this.contextOps.setVisible(true);
                this.ops.setEnabled(true);
                this.ops.setVisible(true);
                this.firePropertyChange("setprogops", "setEnabled", (Object)true);
            }
        } else if (apm != null && apm.isAddressedModePossible()) {
            if (ConnectionStatus.instance().isSystemOk(apm.getUserName())) {
                log.debug("Ops Mode Connection online");
                this.operationsModeProgrammerLabel.setText(Bundle.getMessage("OpsModeProgOnline", apm.getUserName()));
                this.operationsModeProgrammerLabel.setForeground(new Color(0, 128, 0));
            } else {
                log.debug("Ops Mode Connection offline");
                this.operationsModeProgrammerLabel.setText(Bundle.getMessage("OpsModeProgOffline", apm.getUserName()));
                this.operationsModeProgrammerLabel.setForeground(Color.red);
            }
            if (oldOpsMode == null) {
                this.contextOps.setEnabled(true);
                this.contextOps.setVisible(true);
                this.ops.setEnabled(true);
                this.ops.setVisible(true);
                this.firePropertyChange("setprogops", "setEnabled", (Object)true);
            }
        } else {
            log.debug("no ops mode programmer");
            this.operationsModeProgrammerLabel.setText(Bundle.getMessage("NoOpsProgrammerAvailable"));
            this.operationsModeProgrammerLabel.setForeground(Color.red);
            if (oldOpsMode != null) {
                this.contextOps.setEnabled(false);
                this.contextOps.setVisible(false);
                this.ops.setEnabled(false);
                this.ops.setVisible(false);
                this.firePropertyChange("setprogops", "setEnabled", (Object)false);
            }
            this.opsModeProCon = null;
        }
        if (this.service.isEnabled()) {
            this.contextService.setSelected(true);
            this.service.setSelected(true);
            strProgMode = "setprogservice";
            this.modePanel.setVisible(true);
        } else if (this.ops.isEnabled()) {
            this.contextOps.setSelected(true);
            this.ops.setSelected(true);
            strProgMode = "setprogops";
            this.modePanel.setVisible(false);
        } else {
            this.contextEdit.setSelected(true);
            this.edit.setSelected(true);
            this.modePanel.setVisible(false);
            strProgMode = "setprogedit";
        }
        this.firePropertyChange(strProgMode, "setSelected", (Object)true);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.closeWindow(e);
    }

    private static class CopyRosterItem
    extends CopyRosterItemAction {
        CopyRosterItem(String pName, Component pWho, RosterEntry re) {
            super(pName, pWho);
            super.setExistingEntry(re);
        }

        @Override
        protected boolean selectFrom() {
            return true;
        }
    }

    private static class ExportRosterItem
    extends ExportRosterItemAction {
        ExportRosterItem(String pName, Component pWho, RosterEntry re) {
            super(pName, pWho);
            super.setExistingEntry(re);
        }

        @Override
        protected boolean selectFrom() {
            return true;
        }
    }

    private class RosterPopupListener
    extends JmriMouseAdapter {
        private RosterPopupListener() {
        }

        @Override
        public void mousePressed(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                RosterFrame.this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                RosterFrame.this.showPopup(e);
            }
        }

        @Override
        public void mouseClicked(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                RosterFrame.this.showPopup(e);
                return;
            }
            if (e.getClickCount() == 2) {
                RosterFrame.this.startProgrammer(null, RosterFrame.this.re, RosterFrame.this.programmer1);
            }
        }
    }
}

