/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jmri.jmrit.roster.FullBackupExportAction;
import jmri.jmrit.roster.FullBackupImportAction;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.rostergroup.RosterGroupSelector;
import jmri.jmrit.roster.swing.Bundle;
import jmri.jmrit.roster.swing.CopyRosterGroupAction;
import jmri.jmrit.roster.swing.CreateRosterGroupAction;
import jmri.jmrit.roster.swing.DeleteRosterGroupAction;
import jmri.jmrit.roster.swing.RenameRosterGroupAction;
import jmri.util.FileUtil;
import jmri.util.IterableEnumeration;
import jmri.util.datatransfer.RosterEntrySelection;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.WindowInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosterGroupsPanel
extends JPanel
implements RosterGroupSelector {
    private static int GROUPS_MENU = 1;
    private static int ALL_ENTRIES_MENU = 2;
    private JScrollPane scrollPane = new JScrollPane(this.getTree());
    private JTree _tree;
    private DefaultTreeModel _model;
    private DefaultMutableTreeNode _root;
    private DefaultMutableTreeNode _groups;
    private TreeSelectionListener _TSL;
    private String selectedRosterGroup = "";
    private JPopupMenu groupsMenu;
    private JPopupMenu allEntriesMenu;
    private JmriAbstractAction newWindowMenuItemAction = null;
    private static final Logger log = LoggerFactory.getLogger(RosterGroupsPanel.class);

    public RosterGroupsPanel() {
        this((String)null);
    }

    public RosterGroupsPanel(String defaultRosterGroup) {
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.setGroupsMenu(this.defaultMenu(GROUPS_MENU));
        this.setAllEntriesMenu(this.defaultMenu(ALL_ENTRIES_MENU));
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.getButtons(), "South");
        this.setSelectedRosterGroup(defaultRosterGroup);
    }

    @Override
    public String getSelectedRosterGroup() {
        return this.selectedRosterGroup;
    }

    public final void setSelectedRosterGroup(String group) {
        if (group == null ? this.selectedRosterGroup != null : !group.equals(this.selectedRosterGroup)) {
            String oldGroup = this.selectedRosterGroup;
            this.selectedRosterGroup = group;
            this.setSelectionToGroup(group);
            this.firePropertyChange("selectedRosterGroup", oldGroup, group);
        }
    }

    public boolean isSelectionUserDefinedRosterGroup() {
        return this.selectedRosterGroup != null && !this.selectedRosterGroup.equals(Roster.ALLENTRIES);
    }

    public final void setGroupsMenu(JPopupMenu menu) {
        this.groupsMenu = menu;
    }

    public JPopupMenu getGroupsMenu() {
        return this.groupsMenu;
    }

    public final void setAllEntriesMenu(JPopupMenu menu) {
        this.allEntriesMenu = menu;
    }

    public JPopupMenu getAllEntriesMenu() {
        return this.allEntriesMenu;
    }

    public void setNewWindowMenuAction(JmriAbstractAction action) {
        if (action != null) {
            if (this.newWindowMenuItemAction == null) {
                MenuActionListener ml = new MenuActionListener();
                JMenuItem mi = new JMenuItem(ResourceBundle.getBundle("jmri.jmrit.Bundle").getString("MenuOpenInNewWindow"));
                mi.addActionListener(ml);
                mi.setActionCommand("newWindow");
                this.groupsMenu.insert(mi, 0);
                this.groupsMenu.insert(new JSeparator(), 1);
                mi = new JMenuItem(ResourceBundle.getBundle("jmri.jmrit.Bundle").getString("MenuOpenInNewWindow"));
                mi.addActionListener(ml);
                mi.setActionCommand("newWindow");
                this.allEntriesMenu.insert(mi, 0);
                this.allEntriesMenu.insert(new JSeparator(), 1);
            }
            this.newWindowMenuItemAction = action;
        } else if (this.newWindowMenuItemAction != null) {
            this.groupsMenu.remove(0);
            this.groupsMenu.remove(0);
            this.allEntriesMenu.remove(0);
            this.allEntriesMenu.remove(0);
            this.newWindowMenuItemAction = null;
        }
        this.groupsMenu.revalidate();
        this.allEntriesMenu.revalidate();
    }

    public JmriAbstractAction getNewWindowMenuAction() {
        return this.newWindowMenuItemAction;
    }

    private void setSelectionToGroup(String group) {
        this._tree.removeTreeSelectionListener(this._TSL);
        if (group == null || group.equals(Roster.ALLENTRIES) || group.equals("")) {
            this._tree.setSelectionPath(new TreePath(this._model.getPathToRoot(this._groups.getFirstChild())));
        } else {
            for (TreeNode n : new IterableEnumeration<TreeNode>(this._groups.children())) {
                if (!n.toString().equals(group)) continue;
                this._tree.setSelectionPath(new TreePath(this._model.getPathToRoot(n)));
            }
        }
        this._tree.addTreeSelectionListener(this._TSL);
    }

    private JToolBar getButtons() {
        JToolBar controls = new JToolBar();
        controls.setLayout(new GridLayout(1, 0, 0, 0));
        controls.setFloatable(false);
        final JToggleButton addGroupBtn = new JToggleButton(new ImageIcon(FileUtil.findURL("resources/icons/misc/gui3/Add.png")), false);
        final JToggleButton actGroupBtn = new JToggleButton(new ImageIcon(FileUtil.findURL("resources/icons/misc/gui3/Action.png")), false);
        addGroupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CreateRosterGroupAction("", RosterGroupsPanel.this.scrollPane.getTopLevelAncestor()).actionPerformed(e);
                addGroupBtn.setSelected(false);
            }
        });
        actGroupBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    TreePath g = new TreePath(RosterGroupsPanel.this._model.getPathToRoot(RosterGroupsPanel.this._groups));
                    if (RosterGroupsPanel.this._tree.getSelectionPath() != null) {
                        if (RosterGroupsPanel.this._tree.getSelectionPath().getLastPathComponent().toString().equals(Roster.ALLENTRIES)) {
                            RosterGroupsPanel.this.allEntriesMenu.show((JComponent)ie.getSource(), actGroupBtn.getX() - actGroupBtn.getWidth(), actGroupBtn.getY() - RosterGroupsPanel.this.allEntriesMenu.getPreferredSize().height);
                        } else if (g.isDescendant(RosterGroupsPanel.this._tree.getSelectionPath()) && !RosterGroupsPanel.this._tree.getSelectionPath().isDescendant(g)) {
                            RosterGroupsPanel.this.groupsMenu.show((JComponent)ie.getSource(), actGroupBtn.getX() - actGroupBtn.getWidth(), actGroupBtn.getY() - RosterGroupsPanel.this.groupsMenu.getPreferredSize().height);
                        }
                    }
                }
            }
        });
        PopupMenuListener PML = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
                actGroupBtn.setSelected(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent pme) {
                actGroupBtn.setSelected(false);
            }
        };
        this.allEntriesMenu.addPopupMenuListener(PML);
        this.groupsMenu.addPopupMenuListener(PML);
        controls.add(addGroupBtn);
        controls.add(actGroupBtn);
        return controls;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public final JTree getTree() {
        if (this._tree == null) {
            DefaultTreeSelectionModel sm = new DefaultTreeSelectionModel();
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            sm.setSelectionMode(1);
            renderer.setLeafIcon(null);
            renderer.setClosedIcon(null);
            renderer.setOpenIcon(null);
            this._tree = new JTree(this.getModel());
            this._tree.setUI(new TreeUI());
            this._tree.putClientProperty("JTree.lineStyle", "None");
            this._tree.setRootVisible(false);
            this._tree.expandRow(0);
            this._tree.setSelectionModel(sm);
            this._tree.setCellRenderer(renderer);
            this._tree.addTreeWillExpandListener(new TreeWillExpandListener());
            this._TSL = new TreeSelectionListener();
            this._tree.addTreeSelectionListener(this._TSL);
            this._tree.setDragEnabled(true);
            this._tree.setDropMode(DropMode.ON);
            this._tree.setTransferHandler(new TransferHandler());
            this._tree.addMouseListener(new MouseAdapter());
            this.setSelectionToGroup(this.selectedRosterGroup);
            Roster.getDefault().addPropertyChangeListener(new PropertyChangeListener());
        }
        return this._tree;
    }

    private DefaultTreeModel getModel() {
        if (this._model == null) {
            this._model = new DefaultTreeModel(this.getRoot());
        }
        return this._model;
    }

    private DefaultMutableTreeNode getRoot() {
        if (this._root == null) {
            this._root = new DefaultMutableTreeNode();
            this._groups = new DefaultMutableTreeNode(Bundle.getMessage("MenuRosterGroups"));
            this._root.add(this._groups);
            this.setRosterGroups(this._groups);
        }
        return this._root;
    }

    private JPopupMenu defaultMenu(int menu) {
        JPopupMenu pm = new JPopupMenu();
        MenuActionListener ml = new MenuActionListener();
        JMenuItem mi = new JMenuItem(Bundle.getMessage("Exportddd"));
        mi.addActionListener(ml);
        mi.setActionCommand("export");
        pm.add(mi);
        mi = new JMenuItem(Bundle.getMessage("Importddd"));
        mi.addActionListener(ml);
        mi.setActionCommand("import");
        pm.add(mi);
        if (menu == GROUPS_MENU) {
            pm.addSeparator();
            mi = new JMenuItem(Bundle.getMessage("Renameddd"));
            mi.addActionListener(ml);
            mi.setActionCommand("rename");
            pm.add(mi);
            mi = new JMenuItem(Bundle.getMessage("Duplicateddd"));
            mi.addActionListener(ml);
            mi.setActionCommand("duplicate");
            pm.add(mi);
            mi = new JMenuItem(Bundle.getMessage("ButtonDelete"));
            mi.addActionListener(ml);
            mi.setActionCommand("delete");
            pm.add(mi);
        }
        return pm;
    }

    private void setRosterGroups(DefaultMutableTreeNode root) {
        root.removeAllChildren();
        root.add(new DefaultMutableTreeNode(Roster.ALLENTRIES));
        for (String g : Roster.getDefault().getRosterGroupList()) {
            root.add(new DefaultMutableTreeNode(g));
        }
    }

    protected void firePropertyChangeAsRGP(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.equals("selectedRosterGroup")) {
            this.selectedRosterGroup = (String)newValue;
        }
        this.firePropertyChange(propertyName, oldValue, newValue);
    }

    public static class TreeUI
    extends BasicTreeUI {
        @Override
        public void paint(Graphics g, JComponent c) {
            g.setColor(UIManager.getColor("Tree.textBackground"));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
            int selectedRow = this.getSelectionModel().getLeadSelectionRow();
            if (selectedRow >= 0 && this.tree.isVisible(this.tree.getPathForRow(selectedRow))) {
                Rectangle bounds = this.tree.getRowBounds(selectedRow);
                Graphics2D selectionBackgroundGraphics = (Graphics2D)g.create();
                selectionBackgroundGraphics.translate(0, bounds.y);
                selectionBackgroundGraphics.setColor(UIManager.getColor("Tree.selectionBackground"));
                selectionBackgroundGraphics.fillRect(0, 0, c.getWidth(), bounds.height);
                selectionBackgroundGraphics.dispose();
            }
            super.paint(g, c);
        }

        @Override
        protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        }

        @Override
        protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        }
    }

    public class TreeWillExpandListener
    implements javax.swing.event.TreeWillExpandListener {
        @Override
        public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
            log.debug("Selected rows {}", (Object)RosterGroupsPanel.this._tree.getSelectionRows());
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
            if (e.getPath().getLastPathComponent().toString().equals("Roster Groups")) {
                throw new ExpandVetoException(e);
            }
        }
    }

    public class TreeSelectionListener
    implements javax.swing.event.TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath g = new TreePath(RosterGroupsPanel.this._model.getPathToRoot(RosterGroupsPanel.this._groups));
            String oldGroup = RosterGroupsPanel.this.selectedRosterGroup;
            if (e.getNewLeadSelectionPath() == null) {
                if (Roster.getDefault().getRosterGroupList().isEmpty()) {
                    RosterGroupsPanel.this._tree.setSelectionPath(new TreePath(RosterGroupsPanel.this._model.getPathToRoot(RosterGroupsPanel.this._groups.getFirstChild())));
                }
            } else if (e.getNewLeadSelectionPath().isDescendant(g)) {
                RosterGroupsPanel.this._tree.setSelectionPath(e.getOldLeadSelectionPath());
            } else if (g.isDescendant(e.getNewLeadSelectionPath())) {
                RosterGroupsPanel.this.selectedRosterGroup = RosterGroupsPanel.this._tree.getSelectionPath().getLastPathComponent().toString();
                if (Roster.ALLENTRIES.equals(RosterGroupsPanel.this.selectedRosterGroup)) {
                    RosterGroupsPanel.this.selectedRosterGroup = null;
                }
            } else {
                RosterGroupsPanel.this.selectedRosterGroup = null;
            }
            RosterGroupsPanel.this.firePropertyChangeAsRGP("selectedRosterGroup", oldGroup, RosterGroupsPanel.this.selectedRosterGroup);
        }
    }

    public static class TreeCellRenderer
    extends DefaultTreeCellRenderer {
    }

    class TransferHandler
    extends javax.swing.TransferHandler {
        TransferHandler() {
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] transferFlavors) {
            for (DataFlavor flavor : transferFlavors) {
                if (!RosterEntrySelection.rosterEntryFlavor.equals(flavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(JComponent c, Transferable t) {
            if (this.canImport(c, t.getTransferDataFlavors()) && c instanceof JTree) {
                return this.importData(c, t, ((JTree)c).getDropLocation().getPath());
            }
            return false;
        }

        public boolean importData(JComponent c, Transferable t, TreePath p) {
            if (p != null) {
                TreePath g = new TreePath(RosterGroupsPanel.this._model.getPathToRoot(RosterGroupsPanel.this._groups));
                if (g.isDescendant(p) && !p.isDescendant(g) && c instanceof JTree && !p.isDescendant(((JTree)c).getSelectionPath())) {
                    try {
                        ArrayList<RosterEntry> REs = RosterEntrySelection.getRosterEntries(t);
                        for (RosterEntry re : REs) {
                            re.putAttribute(Roster.getRosterGroupProperty(p.getLastPathComponent().toString()), "yes");
                            re.updateFile();
                        }
                        Roster.getDefault().writeRoster();
                        RosterGroupsPanel.this.setSelectedRosterGroup(p.getLastPathComponent().toString());
                    }
                    catch (UnsupportedFlavorException | IOException | RuntimeException e) {
                        log.warn("Exception dragging RosterEntries onto RosterGroups", (Throwable)e);
                    }
                }
            } else {
                try {
                    CreateRosterGroupAction a = new CreateRosterGroupAction("Create From Selection", RosterGroupsPanel.this.scrollPane.getTopLevelAncestor());
                    ((JmriAbstractAction)a).setParameter("RosterEntries", RosterEntrySelection.getRosterEntries(t));
                    ((JmriAbstractAction)a).actionPerformed(null);
                }
                catch (UnsupportedFlavorException | IOException | RuntimeException e) {
                    log.warn("Exception creating RosterGroups from selection", (Throwable)e);
                }
            }
            return false;
        }
    }

    class PropertyChangeListener
    implements java.beans.PropertyChangeListener {
        PropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("RosterGroupRemoved") || e.getPropertyName().equals("RosterGroupAdded") || e.getPropertyName().equals("RosterGroupRenamed")) {
                RosterGroupsPanel.this.setRosterGroups(RosterGroupsPanel.this._groups);
                RosterGroupsPanel.this._model.reload(RosterGroupsPanel.this._groups);
                RosterGroupsPanel.this.setSelectionToGroup(RosterGroupsPanel.this.selectedRosterGroup);
                log.debug("Refreshed Roster Groups pane");
            }
        }
    }

    class MouseAdapter
    extends java.awt.event.MouseAdapter {
        MouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                JTree t = (JTree)e.getSource();
                int closestRow = t.getClosestRowForLocation(e.getX(), e.getY());
                Rectangle closestRowBounds = t.getRowBounds(closestRow);
                if ((double)e.getY() >= closestRowBounds.getY() && (double)e.getY() < closestRowBounds.getY() + closestRowBounds.getHeight()) {
                    t.setSelectionRow(closestRow);
                }
            } else if (e.isPopupTrigger()) {
                this.showMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showMenu(e);
            }
        }

        public void showMenu(MouseEvent e) {
            JTree t = (JTree)e.getSource();
            int closestRow = t.getClosestRowForLocation(e.getX(), e.getY());
            Rectangle closestRowBounds = t.getRowBounds(closestRow);
            if ((double)e.getY() >= closestRowBounds.getY() && (double)e.getY() < closestRowBounds.getY() + closestRowBounds.getHeight()) {
                t.setSelectionRow(closestRow);
                TreePath g = new TreePath(RosterGroupsPanel.this._model.getPathToRoot(RosterGroupsPanel.this._groups));
                if (t.getSelectionPath().getLastPathComponent().toString().equals(Roster.ALLENTRIES)) {
                    RosterGroupsPanel.this.allEntriesMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
                } else if (g.isDescendant(t.getSelectionPath()) && !t.getSelectionPath().isDescendant(g)) {
                    RosterGroupsPanel.this.groupsMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        }
    }

    class MenuActionListener
    implements ActionListener {
        MenuActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath g = new TreePath(RosterGroupsPanel.this._model.getPathToRoot(RosterGroupsPanel.this._groups));
            WindowInterface wi = (WindowInterface)((Object)RosterGroupsPanel.this.scrollPane.getTopLevelAncestor());
            if (g.isDescendant(RosterGroupsPanel.this._tree.getSelectionPath())) {
                if (e.getActionCommand().equals("export")) {
                    new FullBackupExportAction(ResourceBundle.getBundle("jmri.jmrit.roster.JmritRosterBundle").getString("Exportddd"), wi).actionPerformed(e);
                } else if (e.getActionCommand().equals("import")) {
                    new FullBackupImportAction(ResourceBundle.getBundle("jmri.jmrit.roster.JmritRosterBundle").getString("Importddd"), wi).actionPerformed(e);
                } else if (e.getActionCommand().equals("rename")) {
                    new RenameRosterGroupAction("Rename", wi).actionPerformed(e);
                } else if (e.getActionCommand().equals("duplicate")) {
                    new CopyRosterGroupAction("Duplicate", wi).actionPerformed(e);
                } else if (e.getActionCommand().equals("delete")) {
                    new DeleteRosterGroupAction("Delete", wi).actionPerformed(e);
                } else if (e.getActionCommand().equals("newWindow") && RosterGroupsPanel.this.newWindowMenuItemAction != null) {
                    RosterGroupsPanel.this.newWindowMenuItemAction.actionPerformed(e);
                } else {
                    JmriJOptionPane.showMessageDialog((JComponent)e.getSource(), ResourceBundle.getBundle("jmri.jmrit.roster.JmritRosterBundle").getString("NotImplemented"), ResourceBundle.getBundle("jmri.jmrit.roster.JmritRosterBundle").getString("NotImplemented"), 0);
                }
            }
        }
    }
}

