/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.swing;

import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterIconFactory;
import jmri.jmrit.roster.rostergroup.RosterGroup;
import jmri.jmrit.roster.swing.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosterTableModel
extends DefaultTableModel
implements PropertyChangeListener {
    public static final int IDCOL = 0;
    static final int ADDRESSCOL = 1;
    static final int ICONCOL = 2;
    static final int DECODERCOL = 3;
    static final int ROADNAMECOL = 4;
    static final int ROADNUMBERCOL = 5;
    static final int MFGCOL = 6;
    static final int MODELCOL = 7;
    static final int OWNERCOL = 8;
    static final int DATEUPDATECOL = 9;
    public static final int PROTOCOL = 10;
    public static final int NUMCOL = 11;
    private String rosterGroup = null;
    boolean editable = false;
    RosterIconFactory iconFactory = null;
    private String[] attributeKeys = null;
    private static final Logger log = LoggerFactory.getLogger(RosterTableModel.class);

    public RosterTableModel() {
        this(false);
    }

    public RosterTableModel(boolean editable) {
        this.editable = editable;
        Roster.getDefault().addPropertyChangeListener(this);
        this.setRosterGroup(null);
    }

    public RosterTableModel(@CheckForNull RosterGroup group) {
        this(false);
        if (group != null) {
            this.setRosterGroup(group.getName());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("add")) {
            this.setRosterGroup(this.getRosterGroup());
            this.fireTableDataChanged();
        } else if (e.getPropertyName().equals("remove")) {
            this.fireTableDataChanged();
        } else if (e.getPropertyName().equals("saved")) {
            if (e.getSource() instanceof RosterEntry) {
                int row = Roster.getDefault().getGroupIndex(this.rosterGroup, (RosterEntry)e.getSource());
                this.fireTableRowsUpdated(row, row);
            } else {
                this.fireTableDataChanged();
            }
        } else if (e.getPropertyName().equals("selectedRosterGroup")) {
            this.setRosterGroup(e.getNewValue() != null ? e.getNewValue().toString() : null);
        } else if (e.getPropertyName().startsWith("attribute") && e.getSource() instanceof RosterEntry) {
            int row = Roster.getDefault().getGroupIndex(this.rosterGroup, (RosterEntry)e.getSource());
            this.fireTableRowsUpdated(row, row);
        } else if (e.getPropertyName().equals("RosterGroupAdded") && e.getNewValue().equals(this.rosterGroup)) {
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getRowCount() {
        return Roster.getDefault().numGroupEntries(this.rosterGroup);
    }

    @Override
    public int getColumnCount() {
        return 11 + this.getModelAttributeKeyColumnNames().length;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("FieldID");
            }
            case 1: {
                return Bundle.getMessage("FieldDCCAddress");
            }
            case 3: {
                return Bundle.getMessage("FieldDecoderModel");
            }
            case 7: {
                return Bundle.getMessage("FieldModel");
            }
            case 4: {
                return Bundle.getMessage("FieldRoadName");
            }
            case 5: {
                return Bundle.getMessage("FieldRoadNumber");
            }
            case 6: {
                return Bundle.getMessage("FieldManufacturer");
            }
            case 2: {
                return Bundle.getMessage("FieldIcon");
            }
            case 8: {
                return Bundle.getMessage("FieldOwner");
            }
            case 9: {
                return Bundle.getMessage("FieldDateUpdated");
            }
            case 10: {
                return Bundle.getMessage("FieldProtocol");
            }
        }
        return this.getColumnNameAttribute(col);
    }

    private String getColumnNameAttribute(int col) {
        if (col < this.getColumnCount()) {
            String attributeKey = this.getAttributeKey(col);
            try {
                return Bundle.getMessage(attributeKey);
            }
            catch (MissingResourceException missingResourceException) {
                String[] r = attributeKey.split("(?=\\p{Lu})");
                StringBuilder sb = new StringBuilder();
                sb.append(r[0].trim());
                for (int j = 1; j < r.length; ++j) {
                    sb.append(" ");
                    sb.append(r[j].trim());
                }
                return sb.toString();
            }
        }
        return "<UNKNOWN>";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 1: {
                return Integer.class;
            }
            case 2: {
                return ImageIcon.class;
            }
            case 9: {
                return Date.class;
            }
        }
        return this.getColumnClassAttribute(col);
    }

    private Class<?> getColumnClassAttribute(int col) {
        if ("LastOperated".equals(this.getAttributeKey(col))) {
            return Date.class;
        }
        if ("OperatingDuration".equals(this.getAttributeKey(col))) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        RosterEntry re;
        if (col == 1) {
            return false;
        }
        if (col == 10) {
            return false;
        }
        if (col == 3) {
            return false;
        }
        if (col == 2) {
            return false;
        }
        if (col == 9) {
            return false;
        }
        if (this.editable && (re = Roster.getDefault().getGroupEntry(this.rosterGroup, row)) != null) {
            return !re.isOpen();
        }
        return this.editable;
    }

    ImageIcon getIcon(RosterEntry re) {
        if (this.iconFactory == null) {
            this.iconFactory = new RosterIconFactory(Math.max(19, new JLabel((String)this.getColumnName((int)0)).getPreferredSize().height));
        }
        return this.iconFactory.getIcon(re);
    }

    @Override
    public Object getValueAt(int row, int col) {
        RosterEntry re = Roster.getDefault().getGroupEntry(this.rosterGroup, row);
        if (re == null) {
            log.debug("roster entry is null!");
            return null;
        }
        switch (col) {
            case 0: {
                return re.getId();
            }
            case 1: {
                return re.getDccLocoAddress().getNumber();
            }
            case 3: {
                return re.getDecoderModel();
            }
            case 7: {
                return re.getModel();
            }
            case 4: {
                return re.getRoadName();
            }
            case 5: {
                return re.getRoadNumber();
            }
            case 6: {
                return re.getMfg();
            }
            case 2: {
                return this.getIcon(re);
            }
            case 8: {
                return re.getOwner();
            }
            case 9: {
                return re.getDateModified();
            }
            case 10: {
                return re.getProtocolAsString();
            }
        }
        return this.getValueAtAttribute(re, col);
    }

    private Object getValueAtAttribute(RosterEntry re, int col) {
        String attributeKey = this.getAttributeKey(col);
        String value = re.getAttribute(attributeKey);
        if ("LastOperated".equals(attributeKey)) {
            if (value == null) {
                return null;
            }
            try {
                return new StdDateFormat().parse(value);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        if ("OperatingDuration".equals(attributeKey)) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                log.debug("could not format duration ( String integer of total seconds ) in {}", (Object)value, (Object)e);
                return 0;
            }
        }
        return value == null ? "" : value;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        RosterEntry re = Roster.getDefault().getGroupEntry(this.rosterGroup, row);
        if (re == null) {
            log.warn("roster entry is null!");
            return;
        }
        if (re.isOpen()) {
            log.warn("Entry is already open");
            return;
        }
        if (Objects.equals(value, this.getValueAt(row, col))) {
            return;
        }
        String valueToSet = (String)value;
        switch (col) {
            case 0: {
                re.setId(valueToSet);
                break;
            }
            case 4: {
                re.setRoadName(valueToSet);
                break;
            }
            case 5: {
                re.setRoadNumber(valueToSet);
                break;
            }
            case 6: {
                re.setMfg(valueToSet);
                break;
            }
            case 7: {
                re.setModel(valueToSet);
                break;
            }
            case 8: {
                re.setOwner(valueToSet);
                break;
            }
            default: {
                this.setValueAtAttribute(valueToSet, re, col);
            }
        }
        re.changeDateUpdated();
        re.updateFile();
    }

    private void setValueAtAttribute(String valueToSet, RosterEntry re, int col) {
        String attributeKey = this.getAttributeKey(col);
        if (valueToSet == null || valueToSet.isEmpty()) {
            re.deleteAttribute(attributeKey);
        } else {
            re.putAttribute(attributeKey, valueToSet);
        }
    }

    public int getPreferredWidth(int column) {
        int retval = 20;
        retval = Math.max(retval, new JLabel((String)this.getColumnName((int)column)).getPreferredSize().width + 15);
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (this.getColumnClass(column).equals(String.class)) {
                retval = Math.max(retval, new JLabel((String)this.getValueAt((int)row, (int)column).toString()).getPreferredSize().width);
                continue;
            }
            if (this.getColumnClass(column).equals(Integer.class)) {
                retval = Math.max(retval, new JLabel((String)this.getValueAt((int)row, (int)column).toString()).getPreferredSize().width);
                continue;
            }
            if (!this.getColumnClass(column).equals(ImageIcon.class)) continue;
            retval = Math.max(retval, new JLabel((Icon)((Icon)this.getValueAt((int)row, (int)column))).getPreferredSize().width);
        }
        return retval + 5;
    }

    public final void setRosterGroup(String rosterGroup) {
        Roster.getDefault().getEntriesInGroup(this.rosterGroup).forEach(re -> re.removePropertyChangeListener(this));
        this.rosterGroup = rosterGroup;
        Roster.getDefault().getEntriesInGroup(rosterGroup).forEach(re -> re.addPropertyChangeListener(this));
        this.fireTableDataChanged();
    }

    public final String getRosterGroup() {
        return this.rosterGroup;
    }

    private String[] getModelAttributeKeyColumnNames() {
        if (this.attributeKeys == null) {
            TreeSet<String> result = new TreeSet<String>();
            for (String s : Roster.getDefault().getAllAttributeKeys()) {
                if (s.contains("RosterGroup") || s.toLowerCase().startsWith("sys") || s.toUpperCase().startsWith("VSD")) continue;
                result.add(s);
            }
            this.attributeKeys = (String[])result.toArray(String[]::new);
        }
        return this.attributeKeys;
    }

    private String getAttributeKey(int col) {
        if (col >= 11 && col < this.getColumnCount()) {
            return this.getModelAttributeKeyColumnNames()[col - 11];
        }
        return "";
    }

    public void dispose() {
        Roster.getDefault().removePropertyChangeListener(this);
        Roster.getDefault().getEntriesInGroup(this.rosterGroup).forEach(re -> re.removePropertyChangeListener(this));
    }
}

