/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.swing.rostergroup;

import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.rostergroup.Bundle;

public class RosterGroupTableModel
extends AbstractTableModel {
    static final int IDCOL = 0;
    static final int ROADNUMBERCOL = 1;
    static final int ROADNAMECOL = 2;
    static final int MFGCOL = 3;
    static final int OWNERCOL = 4;
    static final int ADDTOGROUPCOL = 5;
    String group = "RosterGroup:";
    static final int NUMCOL = 6;

    @Override
    public int getRowCount() {
        return Roster.getDefault().numEntries();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("FieldID");
            }
            case 1: {
                return Bundle.getMessage("FieldRoadNumber");
            }
            case 2: {
                return Bundle.getMessage("FieldRoadName");
            }
            case 3: {
                return Bundle.getMessage("FieldManufacturer");
            }
            case 5: {
                return Bundle.getMessage("Include");
            }
            case 4: {
                return Bundle.getMessage("FieldOwner");
            }
        }
        return "<UNKNOWN>";
    }

    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: {
                return new JTextField((int)10).getPreferredSize().width;
            }
            case 1: {
                return 75;
            }
            case 2: 
            case 4: {
                return new JTextField((int)20).getPreferredSize().width;
            }
            case 5: {
                return 50;
            }
            case 3: {
                return new JTextField((int)5).getPreferredSize().width;
            }
        }
        return new JTextField((int)8).getPreferredSize().width;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col == 5) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        RosterEntry re = Roster.getDefault().getEntry(row);
        switch (col) {
            case 0: {
                return re.getId();
            }
            case 1: {
                return re.getRoadNumber();
            }
            case 2: {
                return re.getRoadName();
            }
            case 3: {
                return re.getMfg();
            }
            case 4: {
                return re.getOwner();
            }
            case 5: {
                if (this.group == null) {
                    return false;
                }
                if (re.getAttribute(this.group) != null) {
                    return true;
                }
                return false;
            }
        }
        return "<UNKNOWN>";
    }

    public void configureTable(JTable table) {
        table.getTableHeader().setReorderingAllowed(true);
        table.setAutoResizeMode(0);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int width = this.getPreferredWidth(i);
            table.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
        table.sizeColumnsToFit(-1);
    }

    public synchronized void dispose() {
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        RosterEntry re = Roster.getDefault().getEntry(row);
        if (col == 5 && !this.group.equals("RosterGroup:")) {
            if (value.toString().equals("true")) {
                re.putAttribute(this.group, "yes");
            } else {
                re.deleteAttribute(this.group);
            }
            re.updateFile();
            Roster.getDefault().writeRoster();
        }
    }

    public void setGroup(String grp) {
        this.group = grp;
    }

    public void getGroupEnabled(RosterEntry re) {
    }
}

