/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster.swing.speedprofile;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import jmri.InstanceManager;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.logix.MergePrompt;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterSpeedProfile;
import jmri.jmrit.roster.swing.speedprofile.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;

public class SpeedProfileTable
extends JmriJFrame {
    DecimalFormat threeDigit = new DecimalFormat("0.000");
    int interp;
    float loScale;
    JLabel description;
    String rosterId;
    RosterSpeedProfile speedProfile;
    Map<Integer, Boolean> anomalies;
    boolean hasAnomaly;
    static float SCALE = 44.704f;
    static Color myRed = new Color(255, 120, 120);

    public SpeedProfileTable(RosterEntry re) {
        this(re.getSpeedProfile(), re.getId());
    }

    public SpeedProfileTable(RosterSpeedProfile sp, String id) {
        super(false, true);
        String str;
        this.speedProfile = sp;
        this.rosterId = id;
        this.anomalies = MergePrompt.validateSpeedProfile(this.speedProfile);
        this.hasAnomaly = this.anomalies != null && this.anomalies.size() > 0;
        this.setTitle(Bundle.getMessage("SpeedTable", this.rosterId));
        this.getContentPane().setLayout(new BorderLayout(15, 15));
        this.interp = InstanceManager.getDefault(SignalSpeedMap.class).getInterpretation();
        this.loScale = InstanceManager.getDefault(SignalSpeedMap.class).getLayoutScale();
        SpeedTableModel model = new SpeedTableModel(this.speedProfile);
        final JTable table = new JTable(model);
        table.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent ke) {
                char ch = ke.getKeyChar();
                if (ch == '\u007f' || ch == 'X') {
                    SpeedProfileTable.this.deleteRow(table);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        table.getColumnModel().getColumn(2).setCellRenderer(new ColorCellRenderer());
        table.getColumnModel().getColumn(4).setCellRenderer(new ColorCellRenderer());
        for (int i = 0; i < model.getColumnCount(); ++i) {
            int width = model.getPreferredWidth(i);
            TableColumn column = table.getColumnModel().getColumn(i);
            column.setPreferredWidth(width);
        }
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout(5, 5));
        Font font = table.getFont();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        JLabel label = new JLabel(Bundle.getMessage("units"));
        label.setFont(font);
        ButtonGroup bp = new ButtonGroup();
        JRadioButton mm = new JRadioButton(Bundle.getMessage("mmps"));
        mm.setFont(font);
        mm.addActionListener(e -> this.update(model, 1));
        JRadioButton mph = new JRadioButton(Bundle.getMessage("mph"));
        mph.setFont(font);
        mph.addActionListener(e -> this.update(model, 3));
        JRadioButton kph = new JRadioButton(Bundle.getMessage("kph"));
        kph.setFont(font);
        kph.addActionListener(e -> this.update(model, 4));
        bp.add(mm);
        bp.add(mph);
        bp.add(kph);
        panel.add(Box.createHorizontalGlue());
        panel.add(label);
        panel.add(mm);
        panel.add(mph);
        panel.add(kph);
        panel.add(Box.createHorizontalGlue());
        switch (this.interp) {
            case 3: {
                mph.setSelected(true);
                str = "scale";
                break;
            }
            case 4: {
                kph.setSelected(true);
                str = "scale";
                break;
            }
            default: {
                mm.setSelected(true);
                str = "track";
            }
        }
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new EmptyBorder(0, 8, 8, 8));
        topPanel.setLayout(new BoxLayout(topPanel, 3));
        this.description = new JLabel(Bundle.getMessage("rosterId", Bundle.getMessage(str), this.rosterId));
        this.description.setHorizontalAlignment(0);
        topPanel.add(this.description);
        JLabel info = new JLabel(Bundle.getMessage("cellInfo"));
        info.setFont(font);
        topPanel.add(info);
        if (this.hasAnomaly) {
            JLabel redInfo = new JLabel(Bundle.getMessage("redInfo_1"));
            redInfo.setFont(font);
            redInfo.setForeground(Color.RED);
            redInfo.setHorizontalAlignment(0);
            topPanel.add(redInfo);
            redInfo = new JLabel(Bundle.getMessage("redInfo_2"));
            redInfo.setForeground(Color.RED);
            redInfo.setHorizontalAlignment(0);
            redInfo.setFont(font);
            topPanel.add(redInfo);
            redInfo = new JLabel(Bundle.getMessage("redInfo_3"));
            redInfo.setForeground(Color.RED);
            redInfo.setHorizontalAlignment(0);
            redInfo.setFont(font);
            topPanel.add(redInfo);
        }
        contentPane.add((Component)topPanel, "North");
        contentPane.add((Component)panel, "Center");
        JScrollPane pane = new JScrollPane(table);
        contentPane.add((Component)pane, "South");
        this.getContentPane().add(contentPane);
        this.pack();
    }

    private void deleteRow(JTable table) {
        int row = table.getSelectedRow();
        if (row >= 0) {
            SpeedTableModel model = (SpeedTableModel)table.getModel();
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = model.speedArray.get(row);
            int step = Math.round((float)(entry.getKey() * 126) / 1000.0f);
            if (0 == JmriJOptionPane.showConfirmDialog(table, Bundle.getMessage("DeleteRow", step), Bundle.getMessage("SpeedTable", this.rosterId), 0)) {
                model.speedArray.remove(entry);
                this.speedProfile.deleteStep(entry.getKey());
                model.fireTableDataChanged();
            }
        }
    }

    private void update(SpeedTableModel model, int which) {
        String str;
        this.interp = which;
        switch (this.interp) {
            case 3: 
            case 4: {
                str = "scale";
                break;
            }
            default: {
                str = "track";
            }
        }
        this.description.setText(Bundle.getMessage("rosterId", Bundle.getMessage(str), this.rosterId));
        model.fireTableDataChanged();
    }

    class SpeedTableModel
    extends AbstractTableModel {
        static final int STEP_COL = 0;
        static final int THROTTLE_COL = 1;
        static final int FORWARD_SPEED_COL = 2;
        static final int FORWARD_FACTOR_COL = 3;
        static final int REVERSE_SPEED_COL = 4;
        static final int REVERSE_FACTOR_COL = 5;
        static final int NUMCOLS = 6;
        ArrayList<Map.Entry<Integer, RosterSpeedProfile.SpeedStep>> speedArray = new ArrayList();

        SpeedTableModel(RosterSpeedProfile sp) {
            TreeMap<Integer, RosterSpeedProfile.SpeedStep> speeds = sp.getProfileSpeeds();
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = speeds.firstEntry();
            while (entry != null) {
                this.speedArray.add(entry);
                entry = speeds.higherEntry(entry.getKey());
            }
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public int getRowCount() {
            return this.speedArray.size();
        }

        @Override
        public String getColumnName(int col) {
            String rate = Bundle.getMessage("speed");
            switch (col) {
                case 0: {
                    return Bundle.getMessage("step");
                }
                case 1: {
                    return Bundle.getMessage("throttle");
                }
                case 2: {
                    return Bundle.getMessage("forwardSpeed", rate);
                }
                case 4: {
                    return Bundle.getMessage("reverseSpeed", rate);
                }
                case 3: 
                case 5: {
                    return Bundle.getMessage("factor");
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return String.class;
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)3).getPreferredSize().width;
                }
                case 1: 
                case 3: 
                case 5: {
                    return new JTextField((int)5).getPreferredSize().width;
                }
                case 2: 
                case 4: {
                    return new JTextField((int)8).getPreferredSize().width;
                }
            }
            return new JTextField((int)8).getPreferredSize().width;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return SpeedProfileTable.this.hasAnomaly && (col == 2 || col == 4);
        }

        @Override
        public Object getValueAt(int row, int col) {
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = this.speedArray.get(row);
            switch (col) {
                case 0: {
                    return Math.round((float)(entry.getKey() * 126) / 1000.0f);
                }
                case 1: {
                    return SpeedProfileTable.this.threeDigit.format((float)entry.getKey().intValue() / 1000.0f);
                }
                case 2: {
                    float speed = entry.getValue().getForwardSpeed();
                    switch (SpeedProfileTable.this.interp) {
                        case 3: {
                            speed = speed * SpeedProfileTable.this.loScale * 3.6f * 0.621371f / 1000.0f;
                            break;
                        }
                        case 4: {
                            speed = speed * SpeedProfileTable.this.loScale * 3.6f / 1000.0f;
                            break;
                        }
                    }
                    return SpeedProfileTable.this.threeDigit.format(speed);
                }
                case 3: {
                    return SpeedProfileTable.this.threeDigit.format(entry.getValue().getForwardSpeed() * SCALE / (SpeedProfileTable.this.loScale * (float)entry.getKey().intValue()));
                }
                case 4: {
                    float speed = entry.getValue().getReverseSpeed();
                    switch (SpeedProfileTable.this.interp) {
                        case 3: {
                            speed = speed * SpeedProfileTable.this.loScale * 3.6f * 0.621371f / 1000.0f;
                            break;
                        }
                        case 4: {
                            speed = speed * SpeedProfileTable.this.loScale * 3.6f / 1000.0f;
                            break;
                        }
                    }
                    return SpeedProfileTable.this.threeDigit.format(speed);
                }
                case 5: {
                    return SpeedProfileTable.this.threeDigit.format(entry.getValue().getReverseSpeed() * SCALE / (SpeedProfileTable.this.loScale * (float)entry.getKey().intValue()));
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (!SpeedProfileTable.this.hasAnomaly) {
                return;
            }
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = this.speedArray.get(row);
            try {
                switch (col) {
                    case 2: {
                        entry.getValue().setForwardSpeed(Float.parseFloat(((String)value).replace(',', '.')));
                        return;
                    }
                    case 4: {
                        entry.getValue().setReverseSpeed(Float.parseFloat(((String)value).replace(',', '.')));
                        return;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        Map.Entry<Integer, RosterSpeedProfile.SpeedStep> getEntry(int row) {
            return this.speedArray.get(row);
        }
    }

    public class ColorCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            SpeedTableModel model = (SpeedTableModel)table.getModel();
            if (SpeedProfileTable.this.anomalies == null || SpeedProfileTable.this.anomalies.size() == 0) {
                c.setBackground(table.getBackground());
                return c;
            }
            Map.Entry<Integer, RosterSpeedProfile.SpeedStep> entry = model.getEntry(row);
            Boolean direction = SpeedProfileTable.this.anomalies.get(entry.getKey());
            if (direction == null) {
                c.setBackground(table.getBackground());
                return c;
            }
            boolean dir = direction;
            if (dir && col == 2) {
                c.setBackground(myRed);
            } else if (!dir && col == 4) {
                c.setBackground(myRed);
            }
            return c;
        }
    }
}

