/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.sensorgroup;

import javax.swing.table.AbstractTableModel;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrit.sensorgroup.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanTableModel
extends AbstractTableModel {
    public static final int SNAME_COLUMN = 0;
    public static final int UNAME_COLUMN = 1;
    public static final int INCLUDE_COLUMN = 2;
    private static final Logger log = LoggerFactory.getLogger(BeanTableModel.class);

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 2) {
            return Boolean.class;
        }
        return String.class;
    }

    public abstract Manager<?> getManager();

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.getManager().getNamedBeanSet().size();
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return c == 2;
    }

    @Override
    public String getColumnName(int c) {
        switch (c) {
            case 0: {
                return Bundle.getMessage("ColumnSystemName");
            }
            case 1: {
                return Bundle.getMessage("ColumnUserName");
            }
            case 2: {
                return Bundle.getMessage("ColumnIncluded");
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int r, int c) {
        switch (c) {
            case 0: {
                int i = 0;
                for (NamedBean bean : this.getManager().getNamedBeanSet()) {
                    if (i == r) {
                        return bean.getSystemName();
                    }
                    ++i;
                }
                log.error("No system name for row {}", (Object)r);
                return "";
            }
        }
        log.warn("getValueAt should not have been asked about c={}", (Object)c);
        return null;
    }
}

