/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.sensorgroup;

import java.util.ArrayList;
import jmri.InstanceManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.implementation.DefaultRoute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorGroup {
    private static final String NAME_PREFIX = "SENSOR GROUP:";
    private static final String NAME_DIVIDER = ":";
    private final String name;
    private final ArrayList<String> sensorList;
    private static final Logger log = LoggerFactory.getLogger(SensorGroup.class);

    SensorGroup(String name) {
        this.name = name;
        RouteManager rm = InstanceManager.getDefault(RouteManager.class);
        String group = name;
        String prefix = NAME_PREFIX + group + NAME_DIVIDER;
        this.sensorList = new ArrayList();
        for (Route route : rm.getNamedBeanSet()) {
            String routeName = route.getSystemName();
            if (!routeName.startsWith(prefix)) continue;
            String sensor = routeName.substring(prefix.length());
            this.sensorList.add(sensor);
        }
    }

    void addPressed() {
        Object routeName;
        log.debug("start with {} lines", (Object)this.sensorList.size());
        RouteManager rm = InstanceManager.getDefault(RouteManager.class);
        String group = this.name;
        String prefix = NAME_PREFIX + group + NAME_DIVIDER;
        for (Route r : rm.getNamedBeanSet()) {
            routeName = r.getSystemName();
            if (!((String)routeName).startsWith(prefix)) continue;
            r.deActivateRoute();
            rm.deleteRoute(r);
        }
        for (int i = 0; i < this.sensorList.size(); ++i) {
            String sensor = this.sensorList.get(i);
            routeName = NAME_PREFIX + group + NAME_DIVIDER + sensor;
            DefaultRoute r = new DefaultRoute((String)routeName);
            r.addSensorToRoute(sensor, 0);
            for (int j = 0; j < this.sensorList.size(); ++j) {
                String outSensor = this.sensorList.get(j);
                int mode = 4;
                if (i == j) {
                    mode = 2;
                }
                r.addOutputSensor(outSensor, mode);
            }
            r.activateRoute();
            rm.register(r);
        }
    }
}

