/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.sensorgroup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jmri.InstanceManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.sensorgroup.BeanTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorTableModel
extends BeanTableModel
implements PropertyChangeListener {
    String[] _sysNameList;
    Boolean[] _includedSensors;
    private static final Logger log = LoggerFactory.getLogger(SensorTableModel.class);

    public SensorTableModel() {
        this.init();
        this.getManager().addPropertyChangeListener(this);
    }

    private void init() {
        this._sysNameList = new String[this.getManager().getObjectCount()];
        this._includedSensors = new Boolean[this.getManager().getObjectCount()];
        int i = 0;
        for (Sensor s : this.getManager().getNamedBeanSet()) {
            this._sysNameList[i] = s.getSystemName();
            this._includedSensors[i] = Boolean.FALSE;
            ++i;
        }
    }

    public void dispose() {
        this.getManager().removePropertyChangeListener(this);
    }

    public SensorManager getManager() {
        return InstanceManager.sensorManagerInstance();
    }

    @Override
    public int getRowCount() {
        return this._sysNameList.length;
    }

    @Override
    public Object getValueAt(int r, int c) {
        if (r >= this._sysNameList.length) {
            return null;
        }
        switch (c) {
            case 2: {
                return this._includedSensors[r];
            }
            case 0: {
                return this._sysNameList[r];
            }
            case 1: {
                return InstanceManager.sensorManagerInstance().provideSensor(this._sysNameList[r]).getUserName();
            }
        }
        return super.getValueAt(r, c);
    }

    @Override
    public void setValueAt(Object type, int r, int c) {
        if (r > this._sysNameList.length) {
            return;
        }
        switch (c) {
            case 2: {
                this._includedSensors[r] = (Boolean)type;
                return;
            }
        }
        log.warn("default hit in setValueAt");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("length")) {
            this.init();
            this.fireTableDataChanged();
        }
    }
}

