/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.signalling;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Section;
import jmri.SectionManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.SignalMastManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.beantable.RowComboBoxPanel;
import jmri.jmrit.display.layoutEditor.LayoutBlockConnectivityTools;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.signalling.Bundle;
import jmri.swing.NamedBeanComboBox;
import jmri.swing.RowSorterUtil;
import jmri.util.AlphanumComparator;
import jmri.util.StringUtil;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignallingPanel
extends JmriPanel {
    private final NamedBeanComboBox<SignalMast> sourceMastBox;
    private final NamedBeanComboBox<SignalMast> destMastBox;
    private JLabel fixedSourceMastLabel = new JLabel();
    private JLabel fixedDestMastLabel = new JLabel();
    private static final JLabel sourceMastLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("SourceMast")), 11);
    private static final JLabel destMastLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("DestMast")), 11);
    private final JCheckBox useLayoutEditor = new JCheckBox(Bundle.getMessage("UseLayoutEditorPaths"));
    private final JCheckBox useLayoutEditorTurnout = new JCheckBox(Bundle.getMessage("UseTurnoutDetails"));
    private final JCheckBox useLayoutEditorBlock = new JCheckBox(Bundle.getMessage("UseBlockDetails"));
    private final JCheckBox allowAutoMastGeneration = new JCheckBox(Bundle.getMessage("AllowAutomaticSignalMast"));
    private final JCheckBox lockTurnouts = new JCheckBox(Bundle.getMessage("LockTurnouts"));
    private static final JButton sizer = new JButton("Sizer");
    private SignalMast sourceMast;
    private SignalMast destMast;
    private SignalMastLogic sml;
    private final NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    private JFrame jFrame;
    private static final Dimension TABLESIZEPREFERRED = new Dimension(720, 200);
    private JScrollPane _manualBlockScrollPane;
    private JScrollPane _manualSignalMastScrollPane;
    private JScrollPane _manualSensorScrollPane;
    private BlockModel _blockModel;
    private AutoBlockModel _autoBlockModel;
    private List<ManualBlockList> _manualBlockList;
    private List<AutoBlockList> _automaticBlockList = new ArrayList<AutoBlockList>();
    private TurnoutModel _turnoutModel;
    private AutoTurnoutModel _autoTurnoutModel;
    private List<ManualTurnoutList> _manualTurnoutList;
    private List<AutoTurnoutList> _automaticTurnoutList = new ArrayList<AutoTurnoutList>();
    private SensorModel _sensorModel;
    private List<ManualSensorList> _manualSensorList;
    private SignalMastModel _signalMastModel;
    private AutoMastModel _autoSignalMastModel;
    private List<ManualSignalMastList> _manualSignalMastList;
    private List<AutoSignalMastList> _automaticSignalMastList = new ArrayList<AutoSignalMastList>();
    private final JPanel p2xb = new JPanel();
    private final JPanel p2xa = new JPanel();
    private final JPanel p2xsm = new JPanel();
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean destOK = true;
    private static final String[] blockInputModes = new String[]{Bundle.getMessage("UnOccupied"), Bundle.getMessage("Occupied")};
    private static final int[] blockInputModeValues = new int[]{4, 2};
    private final JRadioButton allButton;
    private boolean showAll = true;
    private static final String SET_TO_ACTIVE = Bundle.getMessage("SensorStateActive");
    private static final String SET_TO_INACTIVE = Bundle.getMessage("SensorStateInactive");
    private static final String SET_TO_CLOSED = InstanceManager.turnoutManagerInstance().getClosedText();
    private static final String SET_TO_THROWN = InstanceManager.turnoutManagerInstance().getThrownText();
    private static final String SET_TO_UNOCCUPIED = Bundle.getMessage("UnOccupied");
    private static final String SET_TO_OCCUPIED = Bundle.getMessage("Occupied");
    private static final String SET_TO_ANY = Bundle.getMessage("AnyState");
    private static int ROW_HEIGHT;
    private List<ManualBlockList> _includedManualBlockList;
    private List<ManualTurnoutList> _includedManualTurnoutList;
    private List<ManualSensorList> _includedManualSensorList;
    private List<ManualSignalMastList> _includedManualSignalMastList;
    private static final Logger log;

    public SignallingPanel(JFrame frame) {
        this(null, null, frame);
    }

    public SignallingPanel(SignalMast source, SignalMast dest, JFrame frame) {
        this.jFrame = frame;
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        JButton updateButton = new JButton(Bundle.getMessage("UpdateLogicButton"));
        JButton applyButton = new JButton(Bundle.getMessage("ButtonApply"));
        JLabel mastSpeed = new JLabel();
        if (source != null) {
            this.sourceMast = source;
            this.sml = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic(source);
            this.fixedSourceMastLabel = new JLabel(this.sourceMast.getDisplayName());
        }
        if (dest != null && this.sml != null) {
            this.destMast = dest;
            if (!this.sml.isDestinationValid(dest)) {
                this.sml.setDestinationMast(dest);
            }
            this.fixedDestMastLabel = new JLabel(this.destMast.getDisplayName());
            this.useLayoutEditor.setSelected(this.sml.useLayoutEditor(this.destMast));
            this.useLayoutEditorTurnout.setSelected(this.sml.useLayoutEditorTurnouts(this.destMast));
            this.useLayoutEditorBlock.setSelected(this.sml.useLayoutEditorBlocks(this.destMast));
            this.allowAutoMastGeneration.setSelected(this.sml.allowAutoMaticSignalMastGeneration(this.destMast));
            this.lockTurnouts.setSelected(this.sml.isTurnoutLockAllowed(this.destMast));
            float pathSpeed = this.sml.getMaximumSpeed(dest);
            if (pathSpeed == 0.0f) {
                mastSpeed.setText(Bundle.getMessage("MakeLabel", Bundle.getMessage("PathSpeed")) + " " + Bundle.getMessage("NoneSet"));
            } else {
                String speed = InstanceManager.getDefault(SignalSpeedMap.class).getNamedSpeed(pathSpeed);
                if (speed != null) {
                    mastSpeed.setText(Bundle.getMessage("MakeLabel", Bundle.getMessage("PathSpeed")) + " " + speed);
                } else {
                    mastSpeed.setText(Bundle.getMessage("MakeLabel", Bundle.getMessage("PathSpeed")) + " " + pathSpeed);
                }
            }
        } else if (dest == null) {
            this.sml = null;
        }
        SignalMastManager smm = InstanceManager.getDefault(SignalMastManager.class);
        this.sourceMastBox = new NamedBeanComboBox<SignalMast>(smm, this.sourceMast, NamedBean.DisplayOptions.DISPLAYNAME);
        this.sourceMastBox.setMaximumSize(this.sourceMastBox.getPreferredSize());
        this.destMastBox = new NamedBeanComboBox<SignalMast>(smm, this.destMast, NamedBean.DisplayOptions.DISPLAYNAME);
        this.destMastBox.setMaximumSize(this.destMastBox.getPreferredSize());
        JComboBoxUtil.setupComboBoxMaxRows(this.sourceMastBox);
        JComboBoxUtil.setupComboBoxMaxRows(this.destMastBox);
        Container contentPane = frame.getContentPane();
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 1));
        JPanel mastGrid = new JPanel();
        GridLayout layout = new GridLayout(2, 2, 10, 0);
        mastGrid.setLayout(layout);
        mastGrid.add(sourceMastLabel);
        JPanel sourcePanel = new JPanel();
        sourcePanel.setLayout(new BoxLayout(sourcePanel, 0));
        sourcePanel.add(this.sourceMastBox);
        sourcePanel.add(this.fixedSourceMastLabel);
        mastGrid.add(sourcePanel);
        mastGrid.add(destMastLabel);
        JPanel destPanel = new JPanel();
        destPanel.setLayout(new BoxLayout(destPanel, 0));
        destPanel.add(this.destMastBox);
        destPanel.add(this.fixedDestMastLabel);
        this.destMastBox.addActionListener(e -> {
            if (this.useLayoutEditor.isSelected()) {
                try {
                    boolean valid = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlockConnectivityTools().checkValidDest((NamedBean)this.sourceMastBox.getSelectedItem(), (NamedBean)this.destMastBox.getSelectedItem(), LayoutBlockConnectivityTools.Routing.MASTTOMAST);
                    if (!valid) {
                        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorUnReachableDestination"));
                    }
                }
                catch (JmriException je) {
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("WarningUnableToValidate"));
                }
            }
        });
        mastGrid.add(destPanel);
        header.add(mastGrid);
        header.add(mastSpeed);
        JPanel editor = new JPanel();
        editor.setLayout(new BoxLayout(editor, 1));
        this.useLayoutEditor.setAlignmentX(0.0f);
        editor.add(this.useLayoutEditor);
        JPanel useLayoutEditorSubPanel = new JPanel();
        useLayoutEditorSubPanel.setLayout(new BoxLayout(useLayoutEditorSubPanel, 1));
        useLayoutEditorSubPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        useLayoutEditorSubPanel.add(this.useLayoutEditorTurnout);
        useLayoutEditorSubPanel.add(this.useLayoutEditorBlock);
        editor.add(useLayoutEditorSubPanel);
        useLayoutEditorSubPanel.setVisible(false);
        this.useLayoutEditor.addActionListener(e -> {
            useLayoutEditorSubPanel.setVisible(this.useLayoutEditor.isSelected());
            if (this.useLayoutEditor.isSelected()) {
                int response;
                this.jFrame.pack();
                if (!InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled() && (response = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("EnableLayoutBlockRouting"), Bundle.getMessage("QuestionTitle"), 3)) == 0) {
                    InstanceManager.getDefault(LayoutBlockManager.class).enableAdvancedRouting(true);
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LayoutBlockRoutingEnabled"));
                }
                if (this.sml != null && this.destMast != null) {
                    try {
                        this.sml.useLayoutEditor(this.useLayoutEditor.isSelected(), this.destMast);
                    }
                    catch (JmriException je) {
                        JmriJOptionPane.showMessageDialog(this, je.toString());
                    }
                    try {
                        boolean valid = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlockConnectivityTools().checkValidDest((NamedBean)this.sourceMastBox.getSelectedItem(), (NamedBean)this.destMastBox.getSelectedItem(), LayoutBlockConnectivityTools.Routing.MASTTOMAST);
                        if (!valid) {
                            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorUnReachableDestination"));
                        }
                    }
                    catch (JmriException je) {
                        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("WarningUnableToValidate"));
                    }
                }
            }
        });
        header.add(editor);
        header.add(this.allowAutoMastGeneration);
        header.add(this.lockTurnouts);
        JPanel py = new JPanel();
        py.add(new JLabel(Bundle.getMessage("Show")));
        ButtonGroup selGroup = new ButtonGroup();
        this.allButton = new JRadioButton(Bundle.getMessage("All"), true);
        selGroup.add(this.allButton);
        py.add(this.allButton);
        this.allButton.addActionListener(e -> {
            if (!this.showAll) {
                this.showAll = true;
                this._blockModel.fireTableDataChanged();
                this._turnoutModel.fireTableDataChanged();
                this._signalMastModel.fireTableDataChanged();
                this._sensorModel.fireTableDataChanged();
            }
        });
        JRadioButton includedButton = new JRadioButton(Bundle.getMessage("Included"), false);
        selGroup.add(includedButton);
        py.add(includedButton);
        includedButton.addActionListener(e -> {
            if (this.showAll) {
                this.showAll = false;
                this.initializeIncludedList();
                this._blockModel.fireTableDataChanged();
                this._turnoutModel.fireTableDataChanged();
                this._signalMastModel.fireTableDataChanged();
                this._sensorModel.fireTableDataChanged();
            }
        });
        py.add(new JLabel("  " + Bundle.getMessage("Elements")));
        header.add(py);
        contentPane.add(header);
        JTabbedPane detailsTab = new JTabbedPane();
        detailsTab.add(Bundle.getMessage("Blocks"), this.buildBlocksPanel());
        detailsTab.add(Bundle.getMessage("Turnouts"), this.buildTurnoutPanel());
        detailsTab.add(Bundle.getMessage("Sensors"), this.buildSensorPanel());
        detailsTab.add(Bundle.getMessage("SignalMasts"), this.buildSignalMastPanel());
        JScrollPane detailsScrollPane = new JScrollPane(detailsTab);
        contentPane.add(detailsScrollPane);
        JPanel footer = new JPanel();
        footer.setLayout(new FlowLayout(4));
        footer.add(cancelButton);
        cancelButton.addActionListener(this::cancelPressed);
        footer.add(updateButton);
        updateButton.addActionListener(this::updatePressed);
        updateButton.setToolTipText(Bundle.getMessage("UpdateButtonToolTip"));
        updateButton.setVisible(true);
        footer.add(applyButton);
        applyButton.addActionListener(this::applyPressed);
        applyButton.setToolTipText(Bundle.getMessage("ApplyButtonToolTip"));
        applyButton.setVisible(true);
        contentPane.add(Box.createVerticalGlue());
        contentPane.add(footer);
        if (this.sourceMast != null) {
            this.fixedSourceMastLabel.setVisible(true);
            this.sourceMastBox.setVisible(false);
        } else {
            this.fixedSourceMastLabel.setVisible(false);
            this.sourceMastBox.setVisible(true);
        }
        if (this.sml != null && this.destMast != null) {
            this.fixedDestMastLabel.setVisible(true);
            this.destMastBox.setVisible(false);
            useLayoutEditorSubPanel.setVisible(this.useLayoutEditor.isSelected());
            this.initializeIncludedList();
            this.editDetails();
        } else {
            useLayoutEditorSubPanel.setVisible(this.useLayoutEditor.isSelected());
            this.fixedDestMastLabel.setVisible(false);
            this.destMastBox.setVisible(true);
        }
    }

    private JPanel buildBlocksPanel() {
        JPanel blockPanel = new JPanel();
        blockPanel.setLayout(new BoxLayout(blockPanel, 1));
        BlockManager bm = InstanceManager.getDefault(BlockManager.class);
        this._manualBlockList = new ArrayList<ManualBlockList>();
        for (Object b : bm.getNamedBeanSet()) {
            this._manualBlockList.add(new ManualBlockList((Block)b));
        }
        if (this.sml != null && this.destMast != null) {
            List<Block> blkList = this.sml.getAutoBlocks(this.destMast);
            this._automaticBlockList = new ArrayList<AutoBlockList>(blkList.size());
            for (Block blk : blkList) {
                AutoBlockList blockitem = new AutoBlockList(blk);
                blockitem.setState(this.sml.getAutoBlockState(blk, this.destMast));
                this._automaticBlockList.add(blockitem);
            }
        }
        JPanel p2xc = new JPanel();
        JPanel p2xcSpace = new JPanel();
        p2xcSpace.setLayout(new BoxLayout(p2xcSpace, 1));
        p2xcSpace.add(new JLabel("XXX"));
        p2xc.add(p2xcSpace);
        JPanel p21c = new JPanel();
        p21c.setLayout(new BoxLayout(p21c, 1));
        p21c.add(new JLabel(Bundle.getMessage("LabelSelectChecked", Bundle.getMessage("Blocks"))));
        p2xc.add(p21c);
        this._blockModel = new BlockModel();
        JTable manualBlockTable = new JTable(this._blockModel);
        TableRowSorter<BlockModel> manualBlockSorter = new TableRowSorter<BlockModel>(this._blockModel);
        manualBlockTable.setRowHeight(SignallingPanel.sizer.getPreferredSize().height - 2);
        manualBlockSorter.setComparator(0, new AlphanumComparator());
        manualBlockSorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(manualBlockSorter, 0, SortOrder.ASCENDING);
        this._blockModel.configStateColumn(manualBlockTable);
        manualBlockTable.setRowSorter(manualBlockSorter);
        manualBlockTable.setRowSelectionAllowed(false);
        manualBlockTable.setPreferredScrollableViewportSize(TABLESIZEPREFERRED);
        TableColumnModel _manualBlockColumnModel = manualBlockTable.getColumnModel();
        TableColumn includeColumnC = _manualBlockColumnModel.getColumn(2);
        includeColumnC.setResizable(false);
        includeColumnC.setMinWidth(9 * Bundle.getMessage("Include").length());
        includeColumnC.setMaxWidth(includeColumnC.getMinWidth() + 5);
        TableColumn sNameColumnC = _manualBlockColumnModel.getColumn(0);
        sNameColumnC.setResizable(true);
        sNameColumnC.setMinWidth(75);
        TableColumn stateColumnC = _manualBlockColumnModel.getColumn(3);
        stateColumnC.setResizable(false);
        stateColumnC.setMinWidth(9 * Math.max(SET_TO_UNOCCUPIED.length(), SET_TO_OCCUPIED.length()) + 40);
        stateColumnC.setMaxWidth(stateColumnC.getMinWidth() + 10);
        this._manualBlockScrollPane = new JScrollPane(manualBlockTable);
        p2xc.add((Component)this._manualBlockScrollPane, "Center");
        blockPanel.add(p2xc);
        p2xc.setVisible(true);
        SignallingPanel.setRowHeight(manualBlockTable.getRowHeight());
        p2xcSpace.setVisible(false);
        JPanel p2xaSpace = new JPanel();
        p2xaSpace.setLayout(new BoxLayout(p2xaSpace, 1));
        p2xaSpace.add(new JLabel("XXX"));
        this.p2xb.add(p2xaSpace);
        JPanel p21a = new JPanel();
        p21a.setLayout(new BoxLayout(p21a, 1));
        p21a.add(new JLabel(Bundle.getMessage("LabelAutogenerated", Bundle.getMessage("Blocks"))));
        this.p2xb.add(p21a);
        this._autoBlockModel = new AutoBlockModel();
        JTable autoBlockTable = new JTable(this._autoBlockModel);
        TableRowSorter<AutoBlockModel> autoBlockSorter = new TableRowSorter<AutoBlockModel>(this._autoBlockModel);
        autoBlockSorter.setComparator(0, new AlphanumComparator());
        autoBlockSorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(autoBlockSorter, 0, SortOrder.ASCENDING);
        autoBlockTable.setRowSorter(autoBlockSorter);
        autoBlockTable.setRowSelectionAllowed(false);
        autoBlockTable.setPreferredScrollableViewportSize(TABLESIZEPREFERRED);
        TableColumnModel _autoBlockColumnModel = autoBlockTable.getColumnModel();
        TableColumn sNameColumnA = _autoBlockColumnModel.getColumn(0);
        sNameColumnA.setResizable(true);
        sNameColumnA.setMinWidth(75);
        TableColumn stateColumnA = _autoBlockColumnModel.getColumn(2);
        stateColumnA.setResizable(false);
        stateColumnA.setMinWidth(90);
        stateColumnA.setMaxWidth(100);
        JScrollPane _autoBlockScrollPane = new JScrollPane(autoBlockTable);
        this.p2xb.add((Component)_autoBlockScrollPane, "Center");
        blockPanel.add(this.p2xb);
        this.p2xb.setVisible(true);
        SignallingPanel.setRowHeight(autoBlockTable.getRowHeight());
        p2xaSpace.setVisible(false);
        return blockPanel;
    }

    private JPanel buildTurnoutPanel() {
        JPanel turnoutPanel = new JPanel();
        turnoutPanel.setLayout(new BoxLayout(turnoutPanel, 1));
        TurnoutManager bm = InstanceManager.turnoutManagerInstance();
        this._manualTurnoutList = new ArrayList<ManualTurnoutList>();
        for (Object b : bm.getNamedBeanSet()) {
            String systemName = b.getSystemName();
            String userName = b.getUserName();
            this._manualTurnoutList.add(new ManualTurnoutList(systemName, userName));
        }
        if (this.sml != null && this.destMast != null) {
            List<Turnout> turnList = this.sml.getAutoTurnouts(this.destMast);
            this._automaticTurnoutList = new ArrayList<AutoTurnoutList>(turnList.size());
            for (Turnout turn : turnList) {
                String systemName = turn.getSystemName();
                String userName = turn.getUserName();
                AutoTurnoutList turnItem = new AutoTurnoutList(systemName, userName);
                turnItem.setState(this.sml.getAutoTurnoutState(turn, this.destMast));
                this._automaticTurnoutList.add(turnItem);
            }
        }
        JPanel p2xt = new JPanel();
        JPanel p2xcSpace = new JPanel();
        p2xcSpace.setLayout(new BoxLayout(p2xcSpace, 1));
        p2xcSpace.add(new JLabel("XXX"));
        p2xt.add(p2xcSpace);
        JPanel p21c = new JPanel();
        p21c.setLayout(new BoxLayout(p21c, 1));
        p21c.add(new JLabel(Bundle.getMessage("LabelSelectChecked", Bundle.getMessage("Turnouts"))));
        p2xt.add(p21c);
        this._turnoutModel = new TurnoutModel();
        JTable manualTurnoutTable = new JTable(this._turnoutModel);
        TableRowSorter<TurnoutModel> manualTurnoutSorter = new TableRowSorter<TurnoutModel>(this._turnoutModel);
        manualTurnoutTable.setRowHeight(SignallingPanel.sizer.getPreferredSize().height - 2);
        manualTurnoutSorter.setComparator(0, new AlphanumComparator());
        manualTurnoutSorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(manualTurnoutSorter, 0, SortOrder.ASCENDING);
        this._turnoutModel.configStateColumn(manualTurnoutTable);
        manualTurnoutTable.setRowSorter(manualTurnoutSorter);
        manualTurnoutTable.setRowSelectionAllowed(false);
        manualTurnoutTable.setPreferredScrollableViewportSize(TABLESIZEPREFERRED);
        TableColumnModel _manualTurnoutColumnModel = manualTurnoutTable.getColumnModel();
        TableColumn includeColumnC = _manualTurnoutColumnModel.getColumn(2);
        includeColumnC.setResizable(false);
        includeColumnC.setMinWidth(9 * Bundle.getMessage("Include").length());
        includeColumnC.setMaxWidth(includeColumnC.getMinWidth() + 5);
        TableColumn sNameColumnC = _manualTurnoutColumnModel.getColumn(0);
        sNameColumnC.setResizable(true);
        sNameColumnC.setMinWidth(75);
        TableColumn stateColumnC = _manualTurnoutColumnModel.getColumn(3);
        stateColumnC.setResizable(false);
        log.debug("L = {}", (Object)SET_TO_ANY.length());
        stateColumnC.setMinWidth(9 * Math.max(SET_TO_ANY.length(), SET_TO_CLOSED.length()) + 30);
        stateColumnC.setMaxWidth(stateColumnC.getMinWidth() + 10);
        JScrollPane _manualTurnoutScrollPane = new JScrollPane(manualTurnoutTable);
        p2xt.add((Component)_manualTurnoutScrollPane, "Center");
        turnoutPanel.add(p2xt);
        p2xt.setVisible(true);
        ROW_HEIGHT = manualTurnoutTable.getRowHeight();
        p2xcSpace.setVisible(false);
        JPanel p2xaSpace = new JPanel();
        p2xaSpace.setLayout(new BoxLayout(p2xaSpace, 1));
        p2xaSpace.add(new JLabel("XXX"));
        this.p2xa.add(p2xaSpace);
        JPanel p21a = new JPanel();
        p21a.setLayout(new BoxLayout(p21a, 1));
        p21a.add(new JLabel(Bundle.getMessage("LabelAutogenerated", Bundle.getMessage("Turnouts"))));
        this.p2xa.add(p21a);
        this._autoTurnoutModel = new AutoTurnoutModel();
        JTable autoTurnoutTable = new JTable(this._autoTurnoutModel);
        TableRowSorter<AutoTurnoutModel> autoTurnoutSorter = new TableRowSorter<AutoTurnoutModel>(this._autoTurnoutModel);
        autoTurnoutSorter.setComparator(0, new AlphanumComparator());
        autoTurnoutSorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(autoTurnoutSorter, 0, SortOrder.ASCENDING);
        autoTurnoutTable.setRowSorter(autoTurnoutSorter);
        autoTurnoutTable.setRowSelectionAllowed(false);
        autoTurnoutTable.setPreferredScrollableViewportSize(TABLESIZEPREFERRED);
        TableColumnModel _autoTurnoutColumnModel = autoTurnoutTable.getColumnModel();
        TableColumn sNameColumnA = _autoTurnoutColumnModel.getColumn(0);
        sNameColumnA.setResizable(true);
        sNameColumnA.setMinWidth(75);
        TableColumn stateColumnA = _autoTurnoutColumnModel.getColumn(2);
        stateColumnA.setResizable(false);
        stateColumnA.setMinWidth(90);
        stateColumnA.setMaxWidth(100);
        JScrollPane _autoTurnoutScrollPane = new JScrollPane(autoTurnoutTable);
        this.p2xa.add((Component)_autoTurnoutScrollPane, "Center");
        turnoutPanel.add(this.p2xa);
        this.p2xa.setVisible(true);
        ROW_HEIGHT = autoTurnoutTable.getRowHeight();
        p2xaSpace.setVisible(false);
        return turnoutPanel;
    }

    private JPanel buildSensorPanel() {
        JPanel sensorPanel = new JPanel();
        sensorPanel.setLayout(new BoxLayout(sensorPanel, 1));
        SensorManager bm = InstanceManager.sensorManagerInstance();
        this._manualSensorList = new ArrayList<ManualSensorList>();
        for (Sensor ss : bm.getNamedBeanSet()) {
            String systemName = ss.getSystemName();
            String userName = ss.getUserName();
            this._manualSensorList.add(new ManualSensorList(systemName, userName));
        }
        JPanel p2xs = new JPanel();
        JPanel p2xsSpace = new JPanel();
        p2xsSpace.setLayout(new BoxLayout(p2xsSpace, 1));
        p2xsSpace.add(new JLabel("XXX"));
        p2xs.add(p2xsSpace);
        JPanel p21c = new JPanel();
        p21c.setLayout(new BoxLayout(p21c, 1));
        p21c.add(new JLabel(Bundle.getMessage("LabelSelectChecked", Bundle.getMessage("Sensors"))));
        p2xs.add(p21c);
        this._sensorModel = new SensorModel();
        JTable manualSensorTable = new JTable(this._sensorModel);
        TableRowSorter<SensorModel> manualSensorSorter = new TableRowSorter<SensorModel>(this._sensorModel);
        manualSensorTable.setRowHeight(SignallingPanel.sizer.getPreferredSize().height - 2);
        manualSensorSorter.setComparator(0, new AlphanumComparator());
        manualSensorSorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(manualSensorSorter, 0, SortOrder.ASCENDING);
        this._sensorModel.configStateColumn(manualSensorTable);
        manualSensorTable.setRowSorter(manualSensorSorter);
        manualSensorTable.setRowSelectionAllowed(false);
        manualSensorTable.setPreferredScrollableViewportSize(TABLESIZEPREFERRED);
        TableColumnModel _manualSensorColumnModel = manualSensorTable.getColumnModel();
        TableColumn includeColumnC = _manualSensorColumnModel.getColumn(2);
        includeColumnC.setResizable(false);
        includeColumnC.setMinWidth(9 * Bundle.getMessage("Include").length());
        includeColumnC.setMaxWidth(includeColumnC.getMinWidth() + 5);
        TableColumn sNameColumnC = _manualSensorColumnModel.getColumn(0);
        sNameColumnC.setResizable(true);
        sNameColumnC.setMinWidth(75);
        TableColumn stateColumnC = _manualSensorColumnModel.getColumn(3);
        stateColumnC.setResizable(false);
        stateColumnC.setMinWidth(9 * SET_TO_INACTIVE.length() + 30);
        stateColumnC.setMaxWidth(stateColumnC.getMinWidth() + 10);
        this._manualSensorScrollPane = new JScrollPane(manualSensorTable);
        p2xs.add((Component)this._manualSensorScrollPane, "Center");
        sensorPanel.add(p2xs);
        p2xs.setVisible(true);
        ROW_HEIGHT = manualSensorTable.getRowHeight();
        p2xsSpace.setVisible(false);
        return sensorPanel;
    }

    private JPanel buildSignalMastPanel() {
        JPanel SignalMastPanel = new JPanel();
        SignalMastPanel.setLayout(new BoxLayout(SignalMastPanel, 1));
        SignalMastManager bm = InstanceManager.getDefault(SignalMastManager.class);
        this._manualSignalMastList = new ArrayList<ManualSignalMastList>();
        for (SignalMast m : bm.getNamedBeanSet()) {
            this._manualSignalMastList.add(new ManualSignalMastList(m));
        }
        JPanel p2xm = new JPanel();
        JPanel p2xmSpace = new JPanel();
        p2xmSpace.setLayout(new BoxLayout(p2xmSpace, 1));
        p2xmSpace.add(new JLabel("XXX"));
        p2xm.add(p2xmSpace);
        JPanel p21c = new JPanel();
        p21c.setLayout(new BoxLayout(p21c, 1));
        p21c.add(new JLabel(Bundle.getMessage("LabelSelectChecked", Bundle.getMessage("SignalMasts"))));
        p2xm.add(p21c);
        this._signalMastModel = new SignalMastModel();
        TableRowSorter<SignalMastModel> manualMastSorter = new TableRowSorter<SignalMastModel>(this._signalMastModel);
        JTable manualSignalMastTable = new JTable(this._signalMastModel);
        manualSignalMastTable.setRowHeight(SignallingPanel.sizer.getPreferredSize().height - 2);
        this._signalMastModel.configStateColumn(manualSignalMastTable);
        manualMastSorter.setComparator(0, new AlphanumComparator());
        manualMastSorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(manualMastSorter, 0, SortOrder.ASCENDING);
        manualSignalMastTable.setRowSorter(manualMastSorter);
        manualSignalMastTable.setRowSelectionAllowed(false);
        manualSignalMastTable.setPreferredScrollableViewportSize(TABLESIZEPREFERRED);
        TableColumnModel _manualSignalMastColumnModel = manualSignalMastTable.getColumnModel();
        TableColumn includeColumnC = _manualSignalMastColumnModel.getColumn(2);
        includeColumnC.setResizable(false);
        includeColumnC.setMinWidth(9 * Bundle.getMessage("Include").length());
        includeColumnC.setMaxWidth(includeColumnC.getMinWidth() + 5);
        TableColumn sNameColumnC = _manualSignalMastColumnModel.getColumn(0);
        sNameColumnC.setResizable(true);
        sNameColumnC.setMinWidth(75);
        TableColumn stateColumnC = _manualSignalMastColumnModel.getColumn(3);
        stateColumnC.setResizable(false);
        stateColumnC.setMinWidth(9 * "Diverging Approach Medium".length() + 20);
        stateColumnC.setMaxWidth(stateColumnC.getMinWidth() + 10);
        this._manualSignalMastScrollPane = new JScrollPane(manualSignalMastTable);
        p2xm.add((Component)this._manualSignalMastScrollPane, "Center");
        SignalMastPanel.add(p2xm);
        p2xm.setVisible(true);
        ROW_HEIGHT = manualSignalMastTable.getRowHeight();
        p2xmSpace.setVisible(false);
        JPanel p2xaSpace = new JPanel();
        p2xaSpace.setLayout(new BoxLayout(p2xaSpace, 1));
        p2xaSpace.add(new JLabel("XXX"));
        this.p2xsm.add(p2xaSpace);
        JPanel p21a = new JPanel();
        p21a.setLayout(new BoxLayout(p21a, 1));
        p21a.add(new JLabel(Bundle.getMessage("LabelAutogenerated", Bundle.getMessage("SignalMasts"))));
        this.p2xsm.add(p21a);
        this._autoSignalMastModel = new AutoMastModel();
        JTable autoMastTable = new JTable(this._autoSignalMastModel);
        TableRowSorter<AutoMastModel> autoMastSorter = new TableRowSorter<AutoMastModel>(this._autoSignalMastModel);
        autoMastSorter.setComparator(0, new AlphanumComparator());
        autoMastSorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(autoMastSorter, 0, SortOrder.ASCENDING);
        autoMastTable.setRowSorter(autoMastSorter);
        autoMastTable.setRowSelectionAllowed(false);
        autoMastTable.setPreferredScrollableViewportSize(TABLESIZEPREFERRED);
        TableColumnModel _autoMastColumnModel = autoMastTable.getColumnModel();
        TableColumn sNameColumnA = _autoMastColumnModel.getColumn(0);
        sNameColumnA.setResizable(true);
        sNameColumnA.setMinWidth(75);
        TableColumn stateColumnA = _autoMastColumnModel.getColumn(2);
        stateColumnA.setResizable(false);
        stateColumnA.setMinWidth(90);
        stateColumnA.setMaxWidth(100);
        JScrollPane _autoSignalMastScrollPane = new JScrollPane(autoMastTable);
        this.p2xsm.add((Component)_autoSignalMastScrollPane, "Center");
        SignalMastPanel.add(this.p2xsm);
        this.p2xsm.setVisible(true);
        ROW_HEIGHT = autoMastTable.getRowHeight();
        p2xaSpace.setVisible(false);
        return SignalMastPanel;
    }

    private void updatePressed(ActionEvent e) {
        boolean smlPairAdded;
        block22: {
            this.sourceMast = (SignalMast)this.sourceMastBox.getSelectedItem();
            this.destMast = (SignalMast)this.destMastBox.getSelectedItem();
            smlPairAdded = false;
            this.destOK = true;
            if (this.sourceMastBox.getSelectedItem() == null || this.destMastBox.getSelectedItem() == null) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorSignalMastNull", Bundle.getMessage("SourceMast"), Bundle.getMessage("DestMast")));
                this.destOK = false;
                log.debug("No Source or Destination Mast selected, keep pane open");
                return;
            }
            if (this.sourceMast == this.destMast || this.fixedSourceMastLabel.getText().equals(this.destMast.getDisplayName())) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorSignalMastIdentical"));
                this.destOK = false;
                log.debug("Destination Mast check failed, keep pane open");
                return;
            }
            if (this.sml == null && this.useLayoutEditor.isSelected()) {
                try {
                    boolean valid = InstanceManager.getDefault(LayoutBlockManager.class).getLayoutBlockConnectivityTools().checkValidDest(this.sourceMast, this.destMast, LayoutBlockConnectivityTools.Routing.MASTTOMAST);
                    if (!valid) {
                        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorUnReachableDestination"));
                        return;
                    }
                }
                catch (JmriException je) {
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("WarningUnableToValidate"));
                }
            }
            if (this.sml == null) {
                this.sml = InstanceManager.getDefault(SignalMastLogicManager.class).newSignalMastLogic(this.sourceMast);
                if (!this.sml.getDestinationList().contains(this.destMast)) {
                    smlPairAdded = true;
                    this.sml.setDestinationMast(this.destMast);
                } else {
                    int mes = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("WarningExistingPair"), Bundle.getMessage("WarningTitle"), 0);
                    if (mes != 0) {
                        return;
                    }
                }
                this.fixedSourceMastLabel.setText(this.sourceMast.getDisplayName());
                this.fixedDestMastLabel.setText(this.destMast.getDisplayName());
                this.sourceMastBox.setVisible(false);
                this.destMastBox.setVisible(false);
                this.fixedSourceMastLabel.setVisible(true);
                this.fixedDestMastLabel.setVisible(true);
                this._autoTurnoutModel.smlValid();
                this._autoBlockModel.smlValid();
                this._autoSignalMastModel.smlValid();
            }
            this.initializeIncludedList();
            this.sml.allowAutoMaticSignalMastGeneration(this.allowAutoMastGeneration.isSelected(), this.destMast);
            boolean layoutEditorGen = true;
            try {
                this.sml.useLayoutEditor(this.useLayoutEditor.isSelected(), this.destMast);
            }
            catch (JmriException je) {
                JmriJOptionPane.showMessageDialog(this, je.toString());
                layoutEditorGen = false;
            }
            try {
                if (this.useLayoutEditor.isSelected()) {
                    this.sml.useLayoutEditorDetails(this.useLayoutEditorTurnout.isSelected(), this.useLayoutEditorBlock.isSelected(), this.destMast);
                }
            }
            catch (JmriException ji) {
                if (!layoutEditorGen) break block22;
                JmriJOptionPane.showMessageDialog(this, ji.toString());
            }
        }
        Hashtable<Block, Integer> hashBlocks = new Hashtable<Block, Integer>();
        for (ManualBlockList manualBlockList : this._includedManualBlockList) {
            Block block = InstanceManager.getDefault(BlockManager.class).getBlock(manualBlockList.getSysName());
            if (block == null) continue;
            hashBlocks.put(block, manualBlockList.getState());
        }
        this.sml.setBlocks(hashBlocks, this.destMast);
        Hashtable<NamedBeanHandle<Turnout>, Integer> hashTurnouts = new Hashtable<NamedBeanHandle<Turnout>, Integer>();
        for (ManualTurnoutList manualTurnoutList : this._includedManualTurnoutList) {
            String turnoutName = manualTurnoutList.getDisplayName();
            Turnout turnout = InstanceManager.turnoutManagerInstance().getTurnout(turnoutName);
            if (turnout == null) continue;
            NamedBeanHandle<Turnout> namedTurnout = this.nbhm.getNamedBeanHandle(turnoutName, turnout);
            hashTurnouts.put(namedTurnout, manualTurnoutList.getState());
        }
        this.sml.setTurnouts(hashTurnouts, this.destMast);
        Hashtable<NamedBeanHandle<Sensor>, Integer> hashtable = new Hashtable<NamedBeanHandle<Sensor>, Integer>();
        for (ManualSensorList msl : this._includedManualSensorList) {
            String sensorName = msl.getDisplayName();
            Sensor sensor = InstanceManager.sensorManagerInstance().getSensor(msl.getDisplayName());
            if (sensor == null) continue;
            NamedBeanHandle<Sensor> namedSensor = this.nbhm.getNamedBeanHandle(sensorName, sensor);
            hashtable.put(namedSensor, msl.getState());
        }
        this.sml.setSensors(hashtable, this.destMast);
        Hashtable<SignalMast, String> hashtable2 = new Hashtable<SignalMast, String>();
        for (ManualSignalMastList msml : this._includedManualSignalMastList) {
            if (msml.getMast() == this.sourceMast || msml.getMast() == this.destMast) {
                int mes = JmriJOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("SignalMastCriteriaOwn"), msml.getMast().getDisplayName()), Bundle.getMessage("SignalMastCriteriaOwnTitle"), 0);
                if (mes == 0) {
                    hashtable2.put(msml.getMast(), msml.getSetToState());
                    continue;
                }
                msml.setIncluded(false);
                this.initializeIncludedList();
                this._signalMastModel.fireTableDataChanged();
                continue;
            }
            hashtable2.put(msml.getMast(), msml.getSetToState());
        }
        this.sml.setMasts(hashtable2, this.destMast);
        this.sml.allowTurnoutLock(this.lockTurnouts.isSelected(), this.destMast);
        this.sml.initialise(this.destMast);
        if (smlPairAdded) {
            log.debug("New SML");
            this.firePropertyChange("newDestination", null, this.destMastBox.getSelectedItem());
        }
    }

    void setAssociatedSection(SignalMast destMast) {
        SectionManager sm = InstanceManager.getDefault(SectionManager.class);
        if (!this.sml.getAutoBlocksBetweenMasts(destMast).isEmpty()) {
            String secUserName = this.sml.getSourceMast().getDisplayName() + ":" + destMast.getDisplayName();
            Section sec = sm.getSection(secUserName);
            if (sec != null) {
                if (sec.getSectionType() != Section.SIGNALMASTLOGIC) {
                    return;
                }
            } else {
                try {
                    sec = sm.createNewSection(secUserName);
                }
                catch (IllegalArgumentException ex) {
                    log.warn("Could not create Section for {} {}", (Object)secUserName, (Object)ex.getMessage());
                }
            }
            this.sml.setAssociatedSection(sec, destMast);
        }
    }

    void applyPressed(ActionEvent e) {
        this.updatePressed(e);
        if (this.destOK) {
            this.cancelPressed(e);
        }
    }

    void cancelPressed(ActionEvent e) {
        if (this.jFrame != null) {
            this.jFrame.setVisible(false);
            this.jFrame.dispose();
        }
        this.jFrame = null;
    }

    int blockModeFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, blockInputModeValues, blockInputModes);
        if (result < 0) {
            log.warn("unexpected mode string in blockMode: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    void setBlockModeBox(int mode, JComboBox<String> box) {
        String result = StringUtil.getNameFromState(mode, blockInputModeValues, blockInputModes);
        box.setSelectedItem(result);
    }

    private void initializeIncludedList() {
        this._includedManualBlockList = new ArrayList<ManualBlockList>();
        for (ManualBlockList manualBlockList : this._manualBlockList) {
            if (!manualBlockList.isIncluded()) continue;
            this._includedManualBlockList.add(manualBlockList);
        }
        if (this.sml != null && this.destMast != null) {
            List<Block> blkList = this.sml.getAutoBlocks(this.destMast);
            this._automaticBlockList = new ArrayList<AutoBlockList>(blkList.size());
            Iterator iterator = blkList.iterator();
            while (iterator.hasNext()) {
                Block blk = (Block)iterator.next();
                AutoBlockList newABlk = new AutoBlockList(blk);
                this._automaticBlockList.add(newABlk);
                newABlk.setState(this.sml.getAutoBlockState(blk, this.destMast));
            }
        }
        this._includedManualTurnoutList = new ArrayList<ManualTurnoutList>();
        for (ManualTurnoutList manualTurnoutList : this._manualTurnoutList) {
            if (!manualTurnoutList.isIncluded()) continue;
            this._includedManualTurnoutList.add(manualTurnoutList);
        }
        if (this.sml != null && this.destMast != null) {
            Iterator<ManualSignalMastList> turnList = this.sml.getAutoTurnouts(this.destMast);
            this._automaticTurnoutList = new ArrayList<AutoTurnoutList>(turnList.size());
            Iterator iterator = turnList.iterator();
            while (iterator.hasNext()) {
                Turnout turn = (Turnout)iterator.next();
                String systemName = turn.getSystemName();
                String userName = turn.getUserName();
                AutoTurnoutList newAturn = new AutoTurnoutList(systemName, userName);
                this._automaticTurnoutList.add(newAturn);
                newAturn.setState(this.sml.getAutoTurnoutState(turn, this.destMast));
            }
        }
        this._includedManualSensorList = new ArrayList<ManualSensorList>();
        for (ManualSensorList manualSensorList : this._manualSensorList) {
            if (!manualSensorList.isIncluded()) continue;
            this._includedManualSensorList.add(manualSensorList);
        }
        this._includedManualSignalMastList = new ArrayList<ManualSignalMastList>();
        for (ManualSignalMastList manualSignalMastList : this._manualSignalMastList) {
            if (!manualSignalMastList.isIncluded()) continue;
            this._includedManualSignalMastList.add(manualSignalMastList);
        }
        if (this.sml != null && this.destMast != null) {
            List<SignalMast> mastList = this.sml.getAutoMasts(this.destMast);
            this._automaticSignalMastList = new ArrayList<AutoSignalMastList>(mastList.size());
            for (SignalMast mast : mastList) {
                AutoSignalMastList newAmast = new AutoSignalMastList(mast);
                this._automaticSignalMastList.add(newAmast);
                newAmast.setState(this.sml.getAutoSignalMastState(mast, this.destMast));
            }
        }
    }

    private static void setRowHeight(int newHeight) {
        ROW_HEIGHT = newHeight;
    }

    void cancelIncludedOnly() {
        if (!this.showAll) {
            this.allButton.doClick();
        }
    }

    private void editDetails() {
        String tSysName;
        int i;
        int setRow = 0;
        for (i = this._manualBlockList.size() - 1; i >= 0; --i) {
            ManualBlockList block = this._manualBlockList.get(i);
            tSysName = block.getSysName();
            Block blk = InstanceManager.getDefault(BlockManager.class).getBlock(tSysName);
            if (this.sml.isBlockIncluded(blk, this.destMast)) {
                block.setIncluded(true);
                block.setState(this.sml.getBlockState(blk, this.destMast));
                setRow = i;
                continue;
            }
            block.setIncluded(false);
            block.setState(4);
        }
        if (--setRow < 0) {
            setRow = 0;
        }
        this._manualBlockScrollPane.getVerticalScrollBar().setValue(setRow * ROW_HEIGHT);
        this._blockModel.fireTableDataChanged();
        setRow = 0;
        for (i = this._manualTurnoutList.size() - 1; i >= 0; --i) {
            ManualTurnoutList turnout = this._manualTurnoutList.get(i);
            tSysName = turnout.getSysName();
            Turnout turn = InstanceManager.turnoutManagerInstance().getTurnout(tSysName);
            if (this.sml.isTurnoutIncluded(turn, this.destMast)) {
                turnout.setIncluded(true);
                turnout.setState(this.sml.getTurnoutState(turn, this.destMast));
                setRow = i;
                continue;
            }
            turnout.setIncluded(false);
            turnout.setState(2);
        }
        if (--setRow < 0) {
            setRow = 0;
        }
        this._manualSensorScrollPane.getVerticalScrollBar().setValue(setRow * ROW_HEIGHT);
        this._sensorModel.fireTableDataChanged();
        setRow = 0;
        for (i = this._manualSensorList.size() - 1; i >= 0; --i) {
            ManualSensorList sensor = this._manualSensorList.get(i);
            tSysName = sensor.getSysName();
            Sensor sen = InstanceManager.sensorManagerInstance().getSensor(tSysName);
            if (this.sml.isSensorIncluded(sen, this.destMast)) {
                sensor.setIncluded(true);
                sensor.setState(this.sml.getSensorState(sen, this.destMast));
                setRow = i;
                continue;
            }
            sensor.setIncluded(false);
            sensor.setState(4);
        }
        if (--setRow < 0) {
            setRow = 0;
        }
        this._manualSensorScrollPane.getVerticalScrollBar().setValue(setRow * ROW_HEIGHT);
        this._sensorModel.fireTableDataChanged();
        setRow = 0;
        for (i = this._manualSignalMastList.size() - 1; i >= 0; --i) {
            ManualSignalMastList mast = this._manualSignalMastList.get(i);
            SignalMast sigMast = this._manualSignalMastList.get(i).getMast();
            if (this.sml.isSignalMastIncluded(sigMast, this.destMast)) {
                mast.setIncluded(true);
                mast.setSetToState(this.sml.getSignalMastState(sigMast, this.destMast));
                setRow = i;
                continue;
            }
            mast.setIncluded(false);
        }
        if (--setRow < 0) {
            setRow = 0;
        }
        this._manualSignalMastScrollPane.getVerticalScrollBar().setValue(setRow * ROW_HEIGHT);
        this._signalMastModel.fireTableDataChanged();
    }

    static {
        log = LoggerFactory.getLogger(SignallingPanel.class);
    }

    class AutoMastModel
    extends AutoTableModel {
        AutoMastModel() {
        }

        @Override
        public int getRowCount() {
            return SignallingPanel.this._automaticSignalMastList.size();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("automasts")) {
                SignallingPanel.this.initializeIncludedList();
                this.fireTableDataChanged();
            }
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    return SignallingPanel.this._automaticSignalMastList.get(r).getSysName();
                }
                case 1: {
                    return SignallingPanel.this._automaticSignalMastList.get(r).getUserName();
                }
                case 2: {
                    return SignallingPanel.this._automaticSignalMastList.get(r).getSetToState();
                }
            }
            return null;
        }
    }

    class AutoTurnoutModel
    extends AutoTableModel {
        AutoTurnoutModel() {
        }

        @Override
        public int getRowCount() {
            return SignallingPanel.this._automaticTurnoutList.size();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("autoturnouts")) {
                SignallingPanel.this.initializeIncludedList();
                this.fireTableDataChanged();
            }
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    return SignallingPanel.this._automaticTurnoutList.get(r).getSysName();
                }
                case 1: {
                    return SignallingPanel.this._automaticTurnoutList.get(r).getUserName();
                }
                case 2: {
                    return SignallingPanel.this._automaticTurnoutList.get(r).getSetToState();
                }
            }
            return null;
        }
    }

    class AutoBlockModel
    extends AutoTableModel {
        static final int SPEED_COLUMN = 3;
        static final int PERMISSIVE_COLUMN = 4;

        AutoBlockModel() {
            if (SignallingPanel.this.sml != null) {
                SignallingPanel.this.sml.addPropertyChangeListener(this);
            }
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 3: {
                    return Bundle.getMessage("ColumnSpeed");
                }
                case 4: {
                    return Bundle.getMessage("ColumnPermissive");
                }
            }
            return super.getColumnName(col);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("autoblocks")) {
                SignallingPanel.this.initializeIncludedList();
                this.fireTableDataChanged();
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 4) {
                return Boolean.class;
            }
            return super.getColumnClass(c);
        }

        @Override
        public int getRowCount() {
            return SignallingPanel.this._automaticBlockList.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            switch (c) {
                case 0: {
                    return SignallingPanel.this._automaticBlockList.get(r).getSysName();
                }
                case 1: {
                    return SignallingPanel.this._automaticBlockList.get(r).getUserName();
                }
                case 2: {
                    return SignallingPanel.this._automaticBlockList.get(r).getSetToState();
                }
                case 3: {
                    return SignallingPanel.this._automaticBlockList.get(r).getBlockSpeed();
                }
                case 4: {
                    return SignallingPanel.this._automaticBlockList.get(r).getPermissiveWorking();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return false;
        }
    }

    abstract class AutoTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int SNAME_COLUMN = 0;
        public static final int UNAME_COLUMN = 1;
        public static final int STATE_COLUMN = 2;

        AutoTableModel() {
            this.smlValid();
        }

        final void smlValid() {
            if (SignallingPanel.this.sml != null) {
                SignallingPanel.this.sml.addPropertyChangeListener(this);
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        public void dispose() {
            InstanceManager.turnoutManagerInstance().removePropertyChangeListener(this);
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnSystemName");
                }
                case 1: {
                    return Bundle.getMessage("ColumnUserName");
                }
                case 2: {
                    return Bundle.getMessage("ColumnAspect");
                }
            }
            return "unknown";
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return false;
        }
    }

    class SignalMastModel
    extends TableModel {
        Hashtable<Object, JComboBox<String>> editorMap;
        private final Hashtable<Object, Vector<String>> boxMap;

        SignalMastModel() {
            this.editorMap = new Hashtable();
            this.boxMap = new Hashtable();
            InstanceManager.getDefault(SignalMastManager.class).addPropertyChangeListener(this);
        }

        @Override
        public int getRowCount() {
            if (SignallingPanel.this.showAll) {
                return SignallingPanel.this._manualSignalMastList.size();
            }
            return SignallingPanel.this._includedManualSignalMastList.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            List<ManualSignalMastList> signalMastList = SignallingPanel.this.showAll ? SignallingPanel.this._manualSignalMastList : SignallingPanel.this._includedManualSignalMastList;
            if (r >= signalMastList.size()) {
                log.debug("row index is greater than mast list");
                return "error";
            }
            switch (c) {
                case 2: {
                    return signalMastList.get(r).isIncluded();
                }
                case 0: {
                    return signalMastList.get(r).getSysName();
                }
                case 1: {
                    return signalMastList.get(r).getUserName();
                }
                case 3: {
                    try {
                        return signalMastList.get(r).getSetToState();
                    }
                    catch (NullPointerException e) {
                        log.debug("Aspect for mast {} not set", (Object)r);
                        return Bundle.getMessage("BeanStateUnknown");
                    }
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            List<ManualSignalMastList> signalMastList = SignallingPanel.this.showAll ? SignallingPanel.this._manualSignalMastList : SignallingPanel.this._includedManualSignalMastList;
            switch (c) {
                case 3: {
                    if (type == null) break;
                    log.debug("setValueAt (rowConverted={}; value={})", (Object)r, type);
                    signalMastList.get(r).setSetToState((String)type);
                    this.fireTableRowsUpdated(r, r);
                    break;
                }
                case 2: {
                    signalMastList.get(r).setIncluded((Boolean)type);
                    break;
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 3) {
                return RowComboBoxPanel.class;
            }
            return super.getColumnClass(c);
        }

        public String getValue(String name) {
            SignalMast sm = InstanceManager.getDefault(SignalMastManager.class).getBySystemName(name);
            if (sm != null) {
                return sm.getAspect();
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 3) {
                return Bundle.getMessage("ColumnAspect");
            }
            return super.getColumnName(col);
        }

        @Override
        protected void configStateColumn(JTable table) {
            log.debug("Mast configStateColumn (I am {})", (Object)super.toString());
            table.setDefaultEditor(RowComboBoxPanel.class, new AspectComboBoxPanel());
            table.setDefaultRenderer(RowComboBoxPanel.class, new AspectComboBoxPanel());
        }

        JComboBox<String> getAspectEditorBox(int row) {
            JComboBox<String> editCombo = this.editorMap.get(this.getValueAt(row, 0));
            if (editCombo == null) {
                editCombo = new JComboBox<String>(this.getAspectVector(row));
                this.editorMap.put(this.getValueAt(row, 0), editCombo);
            }
            return editCombo;
        }

        Vector<String> getAspectVector(int row) {
            SignalMast mast;
            Vector<String> comboaspects = this.boxMap.get(this.getValueAt(row, 0));
            if (comboaspects == null && (mast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast((String)this.getValueAt(row, 0))) != null) {
                comboaspects = mast.getValidAspects();
                this.boxMap.put(this.getValueAt(row, 0), comboaspects);
            }
            return comboaspects;
        }

        public class AspectComboBoxPanel
        extends RowComboBoxPanel {
            @Override
            protected final void eventEditorMousePressed() {
                this.editor.add(this.getEditorBox(this.table.convertRowIndexToModel(this.currentRow)));
                this.editor.revalidate();
                SwingUtilities.invokeLater(this.comboBoxFocusRequester);
                log.debug("eventEditorMousePressed in row: {}; me = {})", (Object)this.currentRow, (Object)this.toString());
            }

            @Override
            protected JComboBox<String> getEditorBox(int row) {
                return SignalMastModel.this.getAspectEditorBox(row);
            }
        }
    }

    class SensorModel
    extends TableModel {
        SensorModel() {
            InstanceManager.sensorManagerInstance().addPropertyChangeListener(this);
        }

        @Override
        public int getRowCount() {
            if (SignallingPanel.this.showAll) {
                return SignallingPanel.this._manualSensorList.size();
            }
            return SignallingPanel.this._includedManualSensorList.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            List<ManualSensorList> sensorList = SignallingPanel.this.showAll ? SignallingPanel.this._manualSensorList : SignallingPanel.this._includedManualSensorList;
            if (r >= sensorList.size()) {
                log.debug("row index is greater than sensor list");
                return null;
            }
            switch (c) {
                case 2: {
                    return sensorList.get(r).isIncluded();
                }
                case 0: {
                    return sensorList.get(r).getSysName();
                }
                case 1: {
                    return sensorList.get(r).getUserName();
                }
                case 3: {
                    return sensorList.get(r).getSetToState();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            List<ManualSensorList> sensorList = SignallingPanel.this.showAll ? SignallingPanel.this._manualSensorList : SignallingPanel.this._includedManualSensorList;
            switch (c) {
                case 2: {
                    sensorList.get(r).setIncluded((Boolean)type);
                    break;
                }
                case 3: {
                    sensorList.get(r).setSetToState((String)type);
                    break;
                }
            }
        }

        @Override
        JComboBox<String> getStateEditorBox(int row) {
            JComboBox<String> editCombo = new JComboBox<String>();
            editCombo.addItem(SET_TO_INACTIVE);
            editCombo.addItem(SET_TO_ACTIVE);
            return editCombo;
        }
    }

    class TurnoutModel
    extends TableModel {
        TurnoutModel() {
            InstanceManager.turnoutManagerInstance().addPropertyChangeListener(this);
        }

        @Override
        public int getRowCount() {
            if (SignallingPanel.this.showAll) {
                return SignallingPanel.this._manualTurnoutList.size();
            }
            return SignallingPanel.this._includedManualTurnoutList.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            List<ManualTurnoutList> turnoutList = SignallingPanel.this.showAll ? SignallingPanel.this._manualTurnoutList : SignallingPanel.this._includedManualTurnoutList;
            if (r >= turnoutList.size()) {
                log.debug("row index is greater than turnout list");
                return "error";
            }
            switch (c) {
                case 2: {
                    return turnoutList.get(r).isIncluded();
                }
                case 0: {
                    return turnoutList.get(r).getSysName();
                }
                case 1: {
                    return turnoutList.get(r).getUserName();
                }
                case 3: {
                    return turnoutList.get(r).getSetToState();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            List<ManualTurnoutList> turnoutList = SignallingPanel.this.showAll ? SignallingPanel.this._manualTurnoutList : SignallingPanel.this._includedManualTurnoutList;
            switch (c) {
                case 2: {
                    turnoutList.get(r).setIncluded((Boolean)type);
                    break;
                }
                case 3: {
                    log.debug("State = {}", type);
                    if (type == null) break;
                    turnoutList.get(r).setSetToState((String)type);
                    this.fireTableRowsUpdated(r, r);
                    break;
                }
            }
        }

        @Override
        JComboBox<String> getStateEditorBox(int row) {
            JComboBox<String> editCombo = new JComboBox<String>();
            editCombo.addItem(SET_TO_THROWN);
            editCombo.addItem(SET_TO_CLOSED);
            editCombo.addItem(SET_TO_ANY);
            return editCombo;
        }
    }

    class BlockModel
    extends TableModel {
        private static final int SPEED_COLUMN = 4;
        private static final int PERMISSIVE_COLUMN = 5;

        BlockModel() {
            InstanceManager.getDefault(BlockManager.class).addPropertyChangeListener(this);
        }

        @Override
        public int getRowCount() {
            if (SignallingPanel.this.showAll) {
                return SignallingPanel.this._manualBlockList.size();
            }
            return SignallingPanel.this._includedManualBlockList.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public Object getValueAt(int r, int c) {
            List<ManualBlockList> blockList = SignallingPanel.this.showAll ? SignallingPanel.this._manualBlockList : SignallingPanel.this._includedManualBlockList;
            if (r >= blockList.size()) {
                log.debug("row index is greater than block list");
                return "error";
            }
            switch (c) {
                case 2: {
                    return blockList.get(r).isIncluded();
                }
                case 0: {
                    return blockList.get(r).getSysName();
                }
                case 1: {
                    return blockList.get(r).getUserName();
                }
                case 3: {
                    return blockList.get(r).getSetToState();
                }
                case 4: {
                    return blockList.get(r).getBlockSpeed();
                }
                case 5: {
                    return blockList.get(r).getPermissiveWorking();
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 5) {
                return Boolean.class;
            }
            return super.getColumnClass(c);
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 4: {
                    return Bundle.getMessage("ColumnSpeed");
                }
                case 5: {
                    return Bundle.getMessage("ColumnPermissive");
                }
            }
            return super.getColumnName(col);
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            List<ManualBlockList> blockList = SignallingPanel.this.showAll ? SignallingPanel.this._manualBlockList : SignallingPanel.this._includedManualBlockList;
            switch (c) {
                case 2: {
                    blockList.get(r).setIncluded((Boolean)type);
                    break;
                }
                case 3: {
                    log.debug("State = {}", type);
                    blockList.get(r).setSetToState((String)type);
                    break;
                }
            }
        }

        @Override
        JComboBox<String> getStateEditorBox(int row) {
            JComboBox<String> editCombo = new JComboBox<String>();
            editCombo.addItem(SET_TO_UNOCCUPIED);
            editCombo.addItem(SET_TO_OCCUPIED);
            editCombo.addItem(SET_TO_ANY);
            return editCombo;
        }
    }

    abstract class TableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int SNAME_COLUMN = 0;
        public static final int UNAME_COLUMN = 1;
        static final int INCLUDE_COLUMN = 2;
        public static final int STATE_COLUMN = 3;

        TableModel() {
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 2: {
                    return Boolean.class;
                }
                case 3: {
                    return RowComboBoxPanel.class;
                }
            }
            return String.class;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.fireTableDataChanged();
            }
        }

        public void dispose() {
            InstanceManager.turnoutManagerInstance().removePropertyChangeListener(this);
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnSystemName");
                }
                case 1: {
                    return Bundle.getMessage("ColumnUserName");
                }
                case 2: {
                    return Bundle.getMessage("Include");
                }
                case 3: {
                    return Bundle.getMessage("ColumnState");
                }
            }
            return "unknown";
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 2 || c == 3;
        }

        protected void configStateColumn(JTable table) {
            log.debug("Bean configStateColumn (I am {})", (Object)super.toString());
            table.setDefaultEditor(RowComboBoxPanel.class, new StateComboBoxPanel());
            table.setDefaultRenderer(RowComboBoxPanel.class, new StateComboBoxPanel());
        }

        JComboBox<String> getStateEditorBox(int row) {
            JComboBox<String> editCombo = new JComboBox<String>();
            editCombo.addItem(Bundle.getMessage("None"));
            return editCombo;
        }

        public class StateComboBoxPanel
        extends RowComboBoxPanel {
            @Override
            protected final void eventEditorMousePressed() {
                this.editor.add(this.getEditorBox(this.table.convertRowIndexToModel(this.currentRow)));
                this.editor.revalidate();
                SwingUtilities.invokeLater(this.comboBoxFocusRequester);
                log.debug("eventEditorMousePressed in row: {})", (Object)this.currentRow);
            }

            @Override
            protected JComboBox<String> getEditorBox(int row) {
                return TableModel.this.getStateEditorBox(row);
            }
        }
    }

    private static class AutoSignalMastList
    extends ManualSignalMastList {
        AutoSignalMastList(SignalMast s) {
            super(s);
        }

        @Override
        void setSetToState(String state) {
        }

        void setState(String state) {
            this._setToAspect = state;
        }
    }

    private static class ManualSignalMastList
    extends SignalMastElement {
        String _setToAspect = "";
        SignalMast mast;

        ManualSignalMastList(SignalMast s) {
            this.mast = s;
        }

        SignalMast getMast() {
            return this.mast;
        }

        @Override
        String getSysName() {
            return this.mast.getSystemName();
        }

        @Override
        String getUserName() {
            return this.mast.getUserName();
        }

        @Override
        String getSetToState() {
            return this._setToAspect;
        }

        @Override
        void setSetToState(String state) {
            this._setToAspect = state;
        }
    }

    private static class ManualSensorList
    extends SignalMastElement {
        ManualSensorList(String sysName, String userName) {
            super(sysName, userName);
        }

        @Override
        String getSetToState() {
            switch (this._setToState) {
                case 4: {
                    return SET_TO_INACTIVE;
                }
                case 2: {
                    return SET_TO_ACTIVE;
                }
            }
            return "";
        }

        @Override
        void setSetToState(String state) {
            if (SET_TO_INACTIVE.equals(state)) {
                this._setToState = 4;
            } else if (SET_TO_ACTIVE.equals(state)) {
                this._setToState = 2;
            }
        }
    }

    private static class AutoTurnoutList
    extends ManualTurnoutList {
        AutoTurnoutList(String sysName, String userName) {
            super(sysName, userName);
        }

        @Override
        void setSetToState(String state) {
        }
    }

    private static class ManualTurnoutList
    extends SignalMastElement {
        ManualTurnoutList(String sysName, String userName) {
            super(sysName, userName);
        }

        @Override
        String getSetToState() {
            switch (this._setToState) {
                case 4: {
                    return SET_TO_THROWN;
                }
                case 2: {
                    return SET_TO_CLOSED;
                }
            }
            return SET_TO_ANY;
        }

        @Override
        void setSetToState(String state) {
            this._setToState = SET_TO_THROWN.equals(state) ? 4 : (SET_TO_CLOSED.equals(state) ? 2 : 0);
        }
    }

    private static class AutoBlockList
    extends ManualBlockList {
        AutoBlockList(Block block) {
            super(block);
        }

        @Override
        void setSetToState(String state) {
        }
    }

    private static class ManualBlockList
    extends SignalMastElement {
        Block block;

        ManualBlockList(Block block) {
            this.block = block;
        }

        @Override
        String getSysName() {
            return this.block.getSystemName();
        }

        @Override
        String getUserName() {
            return this.block.getUserName();
        }

        boolean getPermissiveWorking() {
            return this.block.getPermissiveWorking();
        }

        String getBlockSpeed() {
            return this.block.getBlockSpeed();
        }

        @Override
        String getSetToState() {
            switch (this._setToState) {
                case 2: {
                    return SET_TO_OCCUPIED;
                }
                case 4: {
                    return SET_TO_UNOCCUPIED;
                }
            }
            return SET_TO_ANY;
        }

        @Override
        void setSetToState(String state) {
            this._setToState = SET_TO_UNOCCUPIED.equals(state) ? 4 : (SET_TO_OCCUPIED.equals(state) ? 2 : 3);
        }
    }

    private static abstract class SignalMastElement {
        String _sysName;
        String _userName;
        boolean _included;
        int _setToState;

        SignalMastElement() {
        }

        SignalMastElement(String sysName, String userName) {
            this._sysName = sysName;
            this._userName = userName;
            this._included = false;
            this._setToState = 4;
        }

        String getSysName() {
            return this._sysName;
        }

        String getUserName() {
            return this._userName;
        }

        String getDisplayName() {
            String name = this.getUserName();
            if (name != null && name.length() > 0) {
                return name;
            }
            return this.getSysName();
        }

        boolean isIncluded() {
            return this._included;
        }

        void setIncluded(boolean include) {
            this._included = include;
        }

        abstract String getSetToState();

        abstract void setSetToState(String var1);

        int getState() {
            return this._setToState;
        }

        void setState(int state) {
            this._setToState = state;
        }
    }
}

