/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.signalling;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.signalling.Bundle;
import jmri.jmrit.signalling.SignallingAction;
import jmri.swing.RowSorterUtil;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriPanel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignallingSourcePanel
extends JmriPanel
implements PropertyChangeListener {
    SignalMastLogic sml;
    SignalMast sourceMast;
    JLabel fixedSourceMastLabel = new JLabel();
    JButton discoverPairs = new JButton(Bundle.getMessage("ButtonDiscover"));
    SignalMastAspectModel _AppearanceModel;
    JScrollPane _SignalAppearanceScrollPane;
    JmriJFrame signalMastLogicFrame = null;
    JLabel sourceLabel = new JLabel();
    private List<SignalMast> _signalMastList;
    private static final Logger log = LoggerFactory.getLogger(SignallingSourcePanel.class);

    public SignallingSourcePanel(SignalMast sourceMast) {
        this.sml = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic(sourceMast);
        this.sourceMast = sourceMast;
        this.fixedSourceMastLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("SourceMast")) + " " + sourceMast.getDisplayName());
        if (this.sml != null) {
            this._signalMastList = this.sml.getDestinationList();
        }
        this.initGui();
    }

    @Override
    public void initComponents() {
        InstanceManager.getDefault(LayoutBlockManager.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(SignalMastLogicManager.class).addPropertyChangeListener(this);
    }

    private void initGui() {
        this.setLayout(new BorderLayout());
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 1));
        JPanel sourcePanel = new JPanel();
        sourcePanel.add(this.fixedSourceMastLabel);
        header.add(sourcePanel);
        this.add((Component)header, "North");
        this._AppearanceModel = new SignalMastAspectModel();
        JTable table = new JTable(this._AppearanceModel);
        TableRowSorter<SignalMastAspectModel> sorter = new TableRowSorter<SignalMastAspectModel>(this._AppearanceModel);
        RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
        table.setRowSorter(sorter);
        table.setRowSelectionAllowed(false);
        table.setPreferredScrollableViewportSize(new Dimension(600, 120));
        this._AppearanceModel.configureTable(table);
        this._SignalAppearanceScrollPane = new JScrollPane(table);
        this._AppearanceModel.fireTableDataChanged();
        this.add((Component)this._SignalAppearanceScrollPane, "Center");
        JPanel footer = new JPanel();
        footer.add(this.discoverPairs);
        this.discoverPairs.addActionListener(this::discoverPressed);
        JButton addLogic = new JButton(Bundle.getMessage("AddLogic"));
        footer.add(addLogic);
        addLogic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                class WindowMaker
                implements Runnable {
                    WindowMaker() {
                    }

                    @Override
                    public void run() {
                        SignallingAction sigLog = new SignallingAction();
                        sigLog.setMast(SignallingSourcePanel.this.sourceMast, null);
                        sigLog.actionPerformed(null);
                    }
                }
                WindowMaker t = new WindowMaker();
                SwingUtilities.invokeLater(t);
            }
        });
        this.add((Component)footer, "South");
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(LayoutBlockManager.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(SignalMastLogicManager.class).removePropertyChangeListener(this);
        super.dispose();
    }

    void discoverPressed(ActionEvent e) {
        SortedSet<LayoutEditor> layout;
        int response;
        if (!InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled() && (response = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("EnableLayoutBlockRouting"), Bundle.getMessage("QuestionTitle"), 0)) == 0) {
            InstanceManager.getDefault(LayoutBlockManager.class).enableAdvancedRouting(true);
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LayoutBlockRoutingEnabledShort"));
        }
        if (!(layout = InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class)).isEmpty()) {
            this.signalMastLogicFrame = new JmriJFrame(Bundle.getMessage("DiscoverMastsTitle"), false, false);
            this.signalMastLogicFrame.setPreferredSize(null);
            JPanel panel1 = new JPanel();
            this.sourceLabel = new JLabel(Bundle.getMessage("DiscoveringMasts"));
            this.sourceLabel.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
            panel1.add(this.sourceLabel);
            this.signalMastLogicFrame.add(this.sourceLabel);
            this.signalMastLogicFrame.pack();
            this.signalMastLogicFrame.setVisible(true);
            for (LayoutEditor editor : layout) {
                try {
                    InstanceManager.getDefault(SignalMastLogicManager.class).discoverSignallingDest(this.sourceMast, editor);
                }
                catch (JmriException ex) {
                    this.signalMastLogicFrame.setVisible(false);
                    JmriJOptionPane.showMessageDialog(this, ex.toString());
                }
            }
            this.signalMastLogicFrame.setVisible(false);
            this.signalMastLogicFrame.dispose();
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("GenComplete"));
        } else {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("GenSkipped"));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("autoSignalMastGenerateComplete".equals(e.getPropertyName())) {
            if (this.sml == null) {
                this.updateDetails();
            }
            log.debug("Generate complete for a LE panel ({}): mast = {}", (Object)this.hashCode(), (Object)this.sourceMast);
        }
        if ("advancedRoutingEnabled".equals(e.getPropertyName())) {
            boolean newValue = (Boolean)e.getNewValue();
            this.discoverPairs.setEnabled(newValue);
        }
        log.debug("SSP 173 Event: {}; Source: {}", (Object)e.getPropertyName(), (Object)e);
        if ("length".equals(e.getPropertyName())) {
            this.updateDetails();
        }
    }

    private void updateDetails() {
        SignalMastLogic old = this.sml;
        this.sml = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic(this.sourceMast);
        if (this.sml != null) {
            this._signalMastList = this.sml.getDestinationList();
            this._AppearanceModel.updateSignalMastLogic(old, this.sml);
        }
    }

    public class SignalMastAspectModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int SYSNAME_COLUMN = 0;
        public static final int USERNAME_COLUMN = 1;
        public static final int ACTIVE_COLUMN = 2;
        public static final int ENABLE_COLUMN = 3;
        public static final int EDIT_COLUMN = 4;
        public static final int DEL_COLUMN = 5;

        SignalMastAspectModel() {
            if (SignallingSourcePanel.this.sml != null) {
                SignallingSourcePanel.this.sml.addPropertyChangeListener(this);
            }
        }

        void updateSignalMastLogic(SignalMastLogic smlOld, SignalMastLogic smlNew) {
            if (smlOld != null) {
                smlOld.removePropertyChangeListener(this);
            }
            if (smlNew != null) {
                smlNew.addPropertyChangeListener(this);
            }
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 2) {
                return Boolean.class;
            }
            if (c == 3) {
                return Boolean.class;
            }
            if (c == 4) {
                return JButton.class;
            }
            if (c == 5) {
                return JButton.class;
            }
            return String.class;
        }

        public void configureTable(JTable table) {
            table.getTableHeader().setReorderingAllowed(true);
            table.setAutoResizeMode(0);
            for (int i = 0; i < table.getColumnCount(); ++i) {
                int width = this.getPreferredWidth(i);
                table.getColumnModel().getColumn(i).setPreferredWidth(width);
            }
            table.sizeColumnsToFit(-1);
            this.configEditColumn(table);
        }

        @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: {
                    return new JTextField((int)15).getPreferredSize().width;
                }
                case 2: 
                case 3: {
                    return new JTextField((int)5).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)15).getPreferredSize().width;
                }
                case 4: {
                    return new JTextField((int)22).getPreferredSize().width;
                }
                case 5: {
                    return new JTextField((int)22).getPreferredSize().width;
                }
            }
            log.warn("Unexpected column in getPreferredWidth: {}", (Object)col);
            return new JTextField((int)8).getPreferredSize().width;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 1) {
                return Bundle.getMessage("ColumnUserName");
            }
            if (col == 0) {
                return Bundle.getMessage("DestMast");
            }
            if (col == 2) {
                return Bundle.getMessage("SensorStateActive");
            }
            if (col == 3) {
                return Bundle.getMessage("ColumnHeadEnabled");
            }
            if (col == 4) {
                return "";
            }
            if (col == 5) {
                return "";
            }
            return "";
        }

        public void dispose() {
            if (SignallingSourcePanel.this.sml != null) {
                SignallingSourcePanel.this.sml.removePropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            switch (e.getPropertyName()) {
                case "length": {
                    SignallingSourcePanel.this._signalMastList = SignallingSourcePanel.this.sml.getDestinationList();
                    int length = (Integer)e.getNewValue();
                    if (length == 0) {
                        SignallingSourcePanel.this.sml.removePropertyChangeListener(this);
                        SignallingSourcePanel.this.sml = null;
                    }
                    this.fireTableDataChanged();
                    break;
                }
                case "updatedDestination": {
                    SignallingSourcePanel.this._signalMastList = SignallingSourcePanel.this.sml.getDestinationList();
                    this.fireTableDataChanged();
                    break;
                }
                case "state": 
                case "Enabled": {
                    this.fireTableDataChanged();
                    this.fireTableRowsUpdated(0, SignallingSourcePanel.this._signalMastList.size() - 1);
                    break;
                }
            }
            log.debug("SSP 310 Event: {}", (Object)e.getPropertyName());
        }

        protected void configEditColumn(JTable table) {
            this.setColumnToHoldButton(table, 4, new JButton(Bundle.getMessage("ButtonEdit")));
            this.setColumnToHoldButton(table, 5, new JButton(Bundle.getMessage("ButtonDelete")));
        }

        protected void setColumnToHoldButton(JTable table, int column, JButton sample) {
            ButtonRenderer buttonRenderer = new ButtonRenderer();
            table.setDefaultRenderer(JButton.class, buttonRenderer);
            ButtonEditor buttonEditor = new ButtonEditor(new JButton());
            table.setDefaultEditor(JButton.class, buttonEditor);
            table.setRowHeight(sample.getPreferredSize().height);
            table.getColumnModel().getColumn(column).setPreferredWidth(sample.getPreferredSize().width + 4);
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            if (c == 4) {
                return true;
            }
            if (c == 5) {
                return true;
            }
            if (c == 3) {
                return true;
            }
            return c == 1;
        }

        protected void editPair(int r) {
            class WindowMaker
            implements Runnable {
                int row;

                WindowMaker(int r) {
                    this.row = r;
                }

                @Override
                public void run() {
                    log.debug("SML Edit existing logic started");
                    SignallingAction sigLog = new SignallingAction();
                    sigLog.setMast(SignallingSourcePanel.this.sourceMast, SignallingSourcePanel.this._signalMastList.get(this.row));
                    sigLog.actionPerformed(null);
                }
            }
            WindowMaker t = new WindowMaker(r);
            SwingUtilities.invokeLater(t);
        }

        protected void deletePair(int r) {
            InstanceManager.getDefault(SignalMastLogicManager.class).removeSignalMastLogic(SignallingSourcePanel.this.sml, SignallingSourcePanel.this._signalMastList.get(r));
        }

        public void setSetToState(String x) {
        }

        @Override
        public int getRowCount() {
            if (SignallingSourcePanel.this._signalMastList == null) {
                return 0;
            }
            return SignallingSourcePanel.this._signalMastList.size();
        }

        @Override
        public Object getValueAt(int r, int c) {
            if (SignallingSourcePanel.this.sml == null) {
                return null;
            }
            if (r >= SignallingSourcePanel.this._signalMastList.size()) {
                log.debug("row is greater than turnout list size");
                return null;
            }
            switch (c) {
                case 1: {
                    return SignallingSourcePanel.this._signalMastList.get(r).getUserName();
                }
                case 0: {
                    return SignallingSourcePanel.this._signalMastList.get(r).getSystemName();
                }
                case 2: {
                    return SignallingSourcePanel.this.sml.isActive(SignallingSourcePanel.this._signalMastList.get(r));
                }
                case 3: {
                    return SignallingSourcePanel.this.sml.isEnabled(SignallingSourcePanel.this._signalMastList.get(r));
                }
                case 4: {
                    return Bundle.getMessage("ButtonEdit");
                }
                case 5: {
                    return Bundle.getMessage("ButtonDelete");
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object type, int r, int c) {
            if (c == 4) {
                this.editPair(r);
            } else if (c == 5) {
                this.deletePair(r);
            } else if (c == 3) {
                boolean b = (Boolean)type;
                if (b) {
                    SignallingSourcePanel.this.sml.setEnabled(SignallingSourcePanel.this._signalMastList.get(r));
                } else {
                    SignallingSourcePanel.this.sml.setDisabled(SignallingSourcePanel.this._signalMastList.get(r));
                }
            }
        }
    }
}

