/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.signalsystemeditor.configurexml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import jmri.jmrit.XmlFile;
import jmri.jmrit.signalsystemeditor.Appearance;
import jmri.jmrit.signalsystemeditor.AspectMapping;
import jmri.jmrit.signalsystemeditor.Author;
import jmri.jmrit.signalsystemeditor.ImageLink;
import jmri.jmrit.signalsystemeditor.ImageType;
import jmri.jmrit.signalsystemeditor.Revision;
import jmri.jmrit.signalsystemeditor.SignalMastType;
import jmri.jmrit.signalsystemeditor.SignalSystem;
import jmri.jmrit.signalsystemeditor.StringWithLinks;
import jmri.jmrit.signalsystemeditor.configurexml.StringWithLinksXml;
import jmri.util.FileUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalMastTypeXml {
    private static final Logger log = LoggerFactory.getLogger(SignalMastTypeXml.class);

    public SignalMastType load(SignalSystem signalSystem, File file) {
        Namespace namespace = Namespace.getNamespace((String)"http://docbook.org/ns/docbook");
        SignalMastType signalMastType = new SignalMastType(file.getName());
        URL url = FileUtil.findURL(file.getAbsolutePath(), "resources", "xml");
        if (url == null) {
            log.error("appearance file (xml/{}) doesn't exist", (Object)file);
            throw new IllegalArgumentException("appearance file (xml/" + file + ") doesn't exist");
        }
        XmlFile xf = new XmlFile();
        try {
            Element specificappearances;
            ImageType imageType;
            Element root = xf.rootFromURL(url);
            signalMastType.setProcessingInstructionType(xf.getProcessingInstructionType());
            signalMastType.setProcessingInstructionHRef(xf.getProcessingInstructionHRef());
            Element aspecttable = root;
            assert ("appearancetable".equals(aspecttable.getName()));
            Attribute attr = aspecttable.getAttribute("noNamespaceSchemaLocation");
            if (attr == null) {
                for (Object a : aspecttable.getAttributes()) {
                    if (!"noNamespaceSchemaLocation".equals(a.getName())) continue;
                    attr = a;
                }
                if (attr == null) {
                    throw new RuntimeException("Attribute 'noNamespaceSchemaLocation' is not found for element 'appearancetable'");
                }
            }
            signalMastType.setAppearanceSchema(attr.getValue());
            Element copyright = aspecttable.getChild("copyright", namespace);
            signalMastType.getCopyright().getDates().clear();
            if (copyright != null) {
                for (Object date : copyright.getChildren("year", namespace)) {
                    signalMastType.getCopyright().getDates().add(date.getTextTrim());
                }
                signalMastType.getCopyright().setHolder(copyright.getChildText("holder", namespace));
            }
            Element authors = aspecttable.getChild("authorgroup", namespace);
            signalMastType.getAuthors().clear();
            if (authors != null) {
                for (Object author : authors.getChildren("author", namespace)) {
                    Element personName = author.getChild("personname", namespace);
                    signalMastType.getAuthors().add(new Author(personName.getChildText("firstname", namespace), personName.getChildText("surname", namespace), author.getChildText("email", namespace)));
                }
            }
            Element revhistory = aspecttable.getChild("revhistory", namespace);
            signalMastType.getRevisions().clear();
            if (revhistory != null) {
                for (Element revision : revhistory.getChildren("revision", namespace)) {
                    signalMastType.getRevisions().add(new Revision(revision.getChildText("revnumber", namespace), revision.getChildText("date", namespace), revision.getChildText("authorinitials", namespace), revision.getChildText("revremark", namespace)));
                }
            }
            signalMastType.setAspectTable(aspecttable.getChildText("aspecttable"));
            signalMastType.setName(aspecttable.getChildText("name"));
            signalMastType.getReferences().clear();
            for (Element referenceElement : aspecttable.getChildren("reference")) {
                signalMastType.getReferences().add(StringWithLinksXml.load(referenceElement));
            }
            signalMastType.getDescriptions().clear();
            for (Object descriptionElement : aspecttable.getChildren("description")) {
                signalMastType.getDescriptions().add(StringWithLinksXml.load((Element)descriptionElement));
            }
            Element appearances = aspecttable.getChild("appearances");
            signalMastType.getAppearances().clear();
            if (appearances != null) {
                for (Element appearanceElement : appearances.getChildren("appearance")) {
                    Appearance appearance = new Appearance(appearanceElement.getChildText("aspectname"));
                    appearance.getShowList().clear();
                    for (Element e : appearanceElement.getChildren("show")) {
                        appearance.getShowList().add(e.getText());
                    }
                    appearance.getReferences().clear();
                    for (Element e : appearanceElement.getChildren("reference")) {
                        appearance.getReferences().add(e.getText());
                    }
                    appearance.getComments().clear();
                    for (Element e : appearanceElement.getChildren("comment")) {
                        appearance.getComments().add(e.getText());
                    }
                    if (appearanceElement.getChild("delay") != null) {
                        appearance.setDelay(appearanceElement.getChildText("delay"));
                    }
                    appearance.getImageLinks().clear();
                    for (Element imageLinkElement : appearanceElement.getChildren("imagelink")) {
                        imageType = null;
                        if (imageLinkElement.getAttribute("type") != null) {
                            try {
                                imageType = signalSystem.getImageType(imageLinkElement.getAttributeValue("type"));
                            }
                            catch (IllegalArgumentException ex) {
                                log.error("ERROR: image type {} does not exists, {}", (Object)imageLinkElement.getAttributeValue("type"), (Object)file.toString());
                            }
                        }
                        appearance.getImageLinks().add(new ImageLink(imageLinkElement.getTextTrim(), imageType));
                    }
                    signalMastType.getAppearances().add(appearance);
                }
            }
            if ((specificappearances = aspecttable.getChild("specificappearances")) != null) {
                Element appearanceDark;
                Element appearanceHeld;
                Element appearancePermissive;
                Element appearanceDanger = specificappearances.getChild("danger");
                if (appearanceDanger != null) {
                    signalMastType.getAppearanceDanger().setAspectName(appearanceDanger.getChildText("aspect"));
                    for (Element imagelink : appearanceDanger.getChildren("imagelink")) {
                        ImageType imageType2 = null;
                        if (imagelink.getAttribute("type") != null) {
                            imageType2 = signalSystem.getImageType(imagelink.getAttributeValue("type"));
                        }
                        signalMastType.getAppearanceDanger().getImageLinks().add(new ImageLink(imagelink.getTextTrim(), imageType2));
                    }
                }
                if ((appearancePermissive = specificappearances.getChild("permissive")) != null) {
                    signalMastType.getAppearancePermissive().setAspectName(appearancePermissive.getChildText("aspect"));
                    for (Element imagelink : appearancePermissive.getChildren("imagelink")) {
                        imageType = null;
                        if (imagelink.getAttribute("type") != null) {
                            imageType = signalSystem.getImageType(imagelink.getAttributeValue("type"));
                        }
                        signalMastType.getAppearancePermissive().getImageLinks().add(new ImageLink(appearancePermissive.getChildText("imagelink"), imageType));
                    }
                }
                if ((appearanceHeld = specificappearances.getChild("held")) != null) {
                    signalMastType.getAppearanceHeld().setAspectName(appearanceHeld.getChildText("aspect"));
                    for (Element imagelink : appearanceHeld.getChildren("imagelink")) {
                        ImageType imageType3 = null;
                        if (imagelink.getAttribute("type") != null) {
                            imageType3 = signalSystem.getImageType(imagelink.getAttributeValue("type"));
                        }
                        signalMastType.getAppearanceHeld().getImageLinks().add(new ImageLink(imagelink.getTextTrim(), imageType3));
                    }
                }
                if ((appearanceDark = specificappearances.getChild("dark")) != null) {
                    signalMastType.getAppearanceDark().setAspectName(appearanceDark.getChildText("aspect"));
                    for (Element imagelink : appearanceDark.getChildren("imagelink")) {
                        ImageType imageType4 = null;
                        if (imagelink.getAttribute("type") != null) {
                            imageType4 = signalSystem.getImageType(imagelink.getAttributeValue("type"));
                        }
                        signalMastType.getAppearanceDark().getImageLinks().add(new ImageLink(imagelink.getTextTrim(), imageType4));
                    }
                }
            }
            Element aspectMappings = aspecttable.getChild("aspectMappings");
            signalMastType.getAspectMappings().clear();
            if (aspectMappings != null) {
                for (Element aspectMappingElement : aspectMappings.getChildren("aspectMapping")) {
                    AspectMapping aspectMapping = new AspectMapping(aspectMappingElement.getChildText("advancedAspect"));
                    for (Element ourAspectElement : aspectMappingElement.getChildren("ourAspect")) {
                        aspectMapping.getOurAspects().add(ourAspectElement.getText());
                    }
                    signalMastType.getAspectMappings().add(aspectMapping);
                }
            }
            log.debug("loading complete");
        }
        catch (IOException | JDOMException e) {
            log.error("error reading file {}", (Object)url.getPath(), (Object)e);
            return null;
        }
        return signalMastType;
    }

    public void save(SignalSystem signalSystem, SignalMastType signalMastType, boolean makeBackup) {
        this.save(signalSystem, signalMastType, FileUtil.getProfilePath(), makeBackup);
    }

    public void save(SignalSystem signalSystem, SignalMastType signalMastType, String path, boolean makeBackup) {
        String fileName = path + "xml/signals/" + signalSystem.getFolderName() + "/" + signalMastType.getFileName();
        XmlFile xmlFile = new XmlFile();
        if (makeBackup) {
            xmlFile.makeBackupFile(fileName);
        }
        File file = new File(fileName);
        try {
            File parentDir = file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                log.warn("Could not create parent directories for signal file :{}", (Object)fileName);
                return;
            }
            if (file.createNewFile()) {
                log.debug("Creating new signal file: {}", (Object)fileName);
            }
        }
        catch (IOException ea) {
            log.error("Could not create signal file at {}.", (Object)fileName, (Object)ea);
        }
        try {
            Element root = new Element("appearancetable");
            Document doc = new Document(root);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("type", signalMastType.getProcessingInstructionType() != null ? signalMastType.getProcessingInstructionType() : "text/xsl");
            m.put("href", signalMastType.getProcessingInstructionHRef() != null ? signalMastType.getProcessingInstructionHRef() : "../../XSLT/appearancetable.xsl");
            ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
            doc.addContent(0, (Content)p);
            root.setAttribute("noNamespaceSchemaLocation", signalMastType.getAppearanceSchema() != null ? signalMastType.getAppearanceSchema() : "http://jmri.org/xml/schema/appearancetable.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
            if (this.store(signalMastType, root)) {
                xmlFile.writeXML(file, doc);
            }
        }
        catch (IOException eb) {
            log.warn("Exception in storing signal xml", (Throwable)eb);
        }
    }

    public boolean store(SignalMastType signalMastType, Element root) {
        String string;
        String heldAspect;
        String permissiveAspect;
        Element e;
        Namespace namespace = Namespace.getNamespace((String)"http://docbook.org/ns/docbook");
        Element copyright = new Element("copyright", namespace);
        for (String string2 : signalMastType.getCopyright().getDates()) {
            copyright.addContent((Content)new Element("year", namespace).setText(string2));
        }
        copyright.addContent((Content)new Element("holder", namespace).setText(signalMastType.getCopyright().getHolder()));
        root.addContent((Content)copyright);
        Element authorGroup = new Element("authorgroup", namespace);
        for (Author author : signalMastType.getAuthors()) {
            Element element = new Element("author", namespace);
            Element personName = new Element("personname", namespace);
            personName.addContent((Content)new Element("firstname", namespace).setText(author.getFirstName()));
            personName.addContent((Content)new Element("surname", namespace).setText(author.getSurName()));
            element.addContent((Content)personName);
            if (author.getEmail() != null && !author.getEmail().isBlank()) {
                element.addContent((Content)new Element("email", namespace).addContent(author.getEmail()));
            }
            authorGroup.addContent((Content)element);
        }
        root.addContent((Content)authorGroup);
        Element element = new Element("revhistory", namespace);
        for (Revision revision : signalMastType.getRevisions()) {
            Element revisionElement = new Element("revision", namespace);
            revisionElement.addContent((Content)new Element("revnumber", namespace).setText(revision.getRevNumber()));
            revisionElement.addContent((Content)new Element("date", namespace).setText(revision.getDate()));
            revisionElement.addContent((Content)new Element("authorinitials", namespace).setText(revision.getAuthorInitials()));
            revisionElement.addContent((Content)new Element("revremark", namespace).setText(revision.getRemark()));
            element.addContent((Content)revisionElement);
        }
        root.addContent((Content)element);
        root.addContent((Content)new Element("aspecttable").setText(signalMastType.getAspectTable()));
        root.addContent((Content)new Element("name").setText(signalMastType.getName()));
        for (StringWithLinks stringWithLinks : signalMastType.getReferences()) {
            e = StringWithLinksXml.store(stringWithLinks, "reference");
            if (e == null) continue;
            root.addContent((Content)e);
        }
        for (StringWithLinks stringWithLinks : signalMastType.getDescriptions()) {
            e = StringWithLinksXml.store(stringWithLinks, "description");
            if (e == null) continue;
            root.addContent((Content)e);
        }
        Element element2 = new Element("appearances");
        for (Appearance appearance : signalMastType.getAppearances()) {
            Element appearanceElement = new Element("appearance");
            appearanceElement.addContent((Content)new Element("aspectname").setText(appearance.getAspectName()));
            for (String string3 : appearance.getShowList()) {
                appearanceElement.addContent((Content)new Element("show").setText(string3));
            }
            for (String string4 : appearance.getReferences()) {
                appearanceElement.addContent((Content)new Element("reference").setText(string4));
            }
            for (String string5 : appearance.getComments()) {
                appearanceElement.addContent((Content)new Element("comment").setText(string5));
            }
            if (appearance.getDelay() != null && !appearance.getDelay().isBlank()) {
                appearanceElement.addContent((Content)new Element("delay").setText(appearance.getDelay()));
            }
            for (ImageLink imageLink : appearance.getImageLinks()) {
                Element element3 = new Element("imagelink");
                element3.setText(imageLink.getImageLink());
                if (imageLink.getType() != null) {
                    element3.setAttribute("type", imageLink.getType().getType());
                }
                appearanceElement.addContent((Content)element3);
            }
            element2.addContent((Content)appearanceElement);
        }
        root.addContent((Content)element2);
        Element element4 = new Element("specificappearances");
        String dangerAspect = signalMastType.getAppearanceDanger().getAspectName();
        if (dangerAspect != null && !dangerAspect.isBlank()) {
            Element specificAppearancesDanger = new Element("danger");
            specificAppearancesDanger.addContent((Content)new Element("aspect").setText(dangerAspect));
            for (ImageLink imageLink : signalMastType.getAppearanceDanger().getImageLinks()) {
                Element element5 = new Element("imagelink");
                element5.setText(imageLink.getImageLink());
                if (imageLink.getType() != null) {
                    element5.setAttribute("type", imageLink.getType().getType());
                }
                specificAppearancesDanger.addContent((Content)element5);
            }
            element4.addContent((Content)specificAppearancesDanger);
        }
        if ((permissiveAspect = signalMastType.getAppearancePermissive().getAspectName()) != null && !permissiveAspect.isBlank()) {
            Element specificAppearancesPermissive = new Element("permissive");
            specificAppearancesPermissive.addContent((Content)new Element("aspect").setText(permissiveAspect));
            for (ImageLink imageLink : signalMastType.getAppearancePermissive().getImageLinks()) {
                Element imageLinkElement2 = new Element("imagelink");
                imageLinkElement2.setText(imageLink.getImageLink());
                if (imageLink.getType() != null) {
                    imageLinkElement2.setAttribute("type", imageLink.getType().getType());
                }
                specificAppearancesPermissive.addContent((Content)imageLinkElement2);
            }
            element4.addContent((Content)specificAppearancesPermissive);
        }
        if ((heldAspect = signalMastType.getAppearanceHeld().getAspectName()) != null && !heldAspect.isBlank()) {
            Element element6 = new Element("held");
            element6.addContent((Content)new Element("aspect").setText(heldAspect));
            for (ImageLink imageLink : signalMastType.getAppearanceHeld().getImageLinks()) {
                Element imageLinkElement3 = new Element("imagelink");
                imageLinkElement3.setText(imageLink.getImageLink());
                if (imageLink.getType() != null) {
                    imageLinkElement3.setAttribute("type", imageLink.getType().getType());
                }
                element6.addContent((Content)imageLinkElement3);
            }
            element4.addContent((Content)element6);
        }
        if ((string = signalMastType.getAppearanceDark().getAspectName()) != null && !string.isBlank()) {
            Element element7 = new Element("dark");
            element7.addContent((Content)new Element("aspect").setText(string));
            for (ImageLink imageLink : signalMastType.getAppearanceDark().getImageLinks()) {
                Element imageLinkElement4 = new Element("imagelink");
                imageLinkElement4.setText(imageLink.getImageLink());
                if (imageLink.getType() != null) {
                    imageLinkElement4.setAttribute("type", imageLink.getType().getType());
                }
                element7.addContent((Content)imageLinkElement4);
            }
            element4.addContent((Content)element7);
        }
        if (!element4.getChildren().isEmpty()) {
            root.addContent((Content)element4);
        }
        Element element8 = new Element("aspectMappings");
        for (AspectMapping aspectMapping : signalMastType.getAspectMappings()) {
            Element aspectMappingElement = new Element("aspectMapping");
            aspectMappingElement.addContent((Content)new Element("advancedAspect").setText(aspectMapping.getAdvancedAspect()));
            for (String ourAspect : aspectMapping.getOurAspects()) {
                aspectMappingElement.addContent((Content)new Element("ourAspect").setText(ourAspect));
            }
            element8.addContent((Content)aspectMappingElement);
        }
        if (!element8.getChildren().isEmpty()) {
            root.addContent((Content)element8);
        }
        return true;
    }
}

