/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.signalsystemeditor.configurexml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import jmri.jmrit.XmlFile;
import jmri.jmrit.signalsystemeditor.Aspect;
import jmri.jmrit.signalsystemeditor.Author;
import jmri.jmrit.signalsystemeditor.ImageType;
import jmri.jmrit.signalsystemeditor.Revision;
import jmri.jmrit.signalsystemeditor.SignalMastType;
import jmri.jmrit.signalsystemeditor.SignalSystem;
import jmri.jmrit.signalsystemeditor.configurexml.SignalMastTypeXml;
import jmri.jmrit.signalsystemeditor.configurexml.StringWithCommentXml;
import jmri.util.FileUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalSystemXml {
    private static final Logger log = LoggerFactory.getLogger(SignalSystemXml.class);

    public SignalSystem load(File file) {
        Namespace namespace = Namespace.getNamespace((String)"http://docbook.org/ns/docbook");
        SignalSystem signalSystem = new SignalSystem(file.getParentFile().getName());
        URL url = FileUtil.findURL(file.getAbsolutePath(), "resources", "xml");
        if (url == null) {
            log.error("appearance file (xml/{}) doesn't exist", (Object)file);
            throw new IllegalArgumentException("appearance file (xml/" + file + ") doesn't exist");
        }
        XmlFile xf = new XmlFile();
        try {
            Element root = xf.rootFromURL(url);
            signalSystem.setProcessingInstructionType(xf.getProcessingInstructionType());
            signalSystem.setProcessingInstructionHRef(xf.getProcessingInstructionHRef());
            Element aspecttable = root;
            assert ("aspecttable".equals(aspecttable.getName()));
            Attribute attr = aspecttable.getAttribute("noNamespaceSchemaLocation");
            if (attr == null) {
                for (Attribute a : aspecttable.getAttributes()) {
                    if (!"noNamespaceSchemaLocation".equals(a.getName())) continue;
                    attr = a;
                }
                if (attr == null) {
                    throw new RuntimeException("Attribute 'noNamespaceSchemaLocation' is not found for element 'aspecttable'");
                }
            }
            signalSystem.setAspectSchema(attr.getValue());
            signalSystem.setName(aspecttable.getChildText("name"));
            if (aspecttable.getChild("date") != null) {
                signalSystem.setDate(aspecttable.getChildText("date"));
            }
            signalSystem.getReferences().clear();
            for (Object e : aspecttable.getChildren("reference")) {
                signalSystem.getReferences().add(e.getText());
            }
            Element copyright = aspecttable.getChild("copyright", namespace);
            signalSystem.getCopyright().getDates().clear();
            if (copyright != null) {
                for (Object date : copyright.getChildren("year", namespace)) {
                    signalSystem.getCopyright().getDates().add(date.getTextTrim());
                }
                signalSystem.getCopyright().setHolder(copyright.getChildText("holder", namespace));
            } else {
                log.debug("ERROR: No copyright");
            }
            Element authors = aspecttable.getChild("authorgroup", namespace);
            signalSystem.getAuthors().clear();
            if (authors != null) {
                for (Object author : authors.getChildren("author", namespace)) {
                    Element personName = author.getChild("personname", namespace);
                    signalSystem.getAuthors().add(new Author(personName.getChildText("firstname", namespace), personName.getChildText("surname", namespace), author.getChildText("email", namespace)));
                }
            } else {
                log.debug("ERROR: No authors");
            }
            Element revhistory = aspecttable.getChild("revhistory", namespace);
            signalSystem.getRevisions().clear();
            if (revhistory != null) {
                for (Object revision : revhistory.getChildren("revision", namespace)) {
                    signalSystem.getRevisions().add(new Revision(revision.getChildText("revnumber", namespace), revision.getChildText("date", namespace), revision.getChildText("authorinitials", namespace), revision.getChildText("revremark", namespace)));
                }
            } else {
                log.debug("ERROR: No authors");
            }
            Element aspectsElement = aspecttable.getChild("aspects");
            signalSystem.getAspects().clear();
            if (aspectsElement != null) {
                for (Object aspectElement : aspectsElement.getChildren("aspect")) {
                    Aspect aspect = new Aspect(StringWithCommentXml.load(aspectElement.getChild("name")), aspectElement.getChildText("title"), aspectElement.getChildText("rule"), aspectElement.getChildText("indication"), aspectElement.getChildText("route"), aspectElement.getChildText("dccAspect"));
                    for (Element e : aspectElement.getChildren()) {
                        switch (e.getName()) {
                            case "description": {
                                aspect.getDescriptions().add(e.getText());
                                break;
                            }
                            case "reference": {
                                aspect.getReferences().add(e.getText());
                                break;
                            }
                            case "comment": {
                                aspect.getComments().add(e.getText());
                                break;
                            }
                            case "speed": {
                                aspect.getSpeedList().add(e.getText());
                                break;
                            }
                            case "speed2": {
                                aspect.getSpeed2List().add(e.getText());
                                break;
                            }
                        }
                    }
                    signalSystem.getAspects().add(aspect);
                }
            } else {
                log.debug("ERROR: No aspects");
            }
            Element imagetypes = aspecttable.getChild("imagetypes");
            signalSystem.getImageTypes().clear();
            if (imagetypes != null) {
                for (Element imagetype : imagetypes.getChildren("imagetype")) {
                    signalSystem.getImageTypes().add(new ImageType(imagetype.getAttributeValue("type")));
                }
            }
            Element appearancefiles = aspecttable.getChild("appearancefiles");
            signalSystem.getSignalMastTypes().clear();
            if (appearancefiles != null) {
                for (Element appearancefile : appearancefiles.getChildren("appearancefile")) {
                    signalSystem.getSignalMastTypes().add(new SignalMastTypeXml().load(signalSystem, new File("xml/signals/" + file.getParentFile().getName() + "/" + appearancefile.getAttributeValue("href"))));
                }
            }
            log.debug("loading complete");
        }
        catch (IOException | JDOMException e) {
            log.error("error reading file {}", (Object)url.getPath(), (Object)e);
            return null;
        }
        return signalSystem;
    }

    public void save(SignalSystem signalSystem) {
        this.save(signalSystem, FileUtil.getProfilePath() + "xml/signals/");
    }

    public void save(SignalSystem signalSystem, String path) {
        String fileName = path + signalSystem.getFolderName() + "/aspects.xml";
        XmlFile xmlFile = new XmlFile();
        xmlFile.makeBackupFile(fileName);
        File file = new File(fileName);
        try {
            File parentDir = file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                log.warn("Could not create parent directories for signal file :{}", (Object)fileName);
                return;
            }
            if (file.createNewFile()) {
                log.debug("Creating new signal file: {}", (Object)fileName);
            }
        }
        catch (IOException ea) {
            log.error("Could not create signal file at {}.", (Object)fileName, (Object)ea);
        }
        try {
            Element root = new Element("aspecttable");
            Document doc = new Document(root);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("type", signalSystem.getProcessingInstructionType() != null ? signalSystem.getProcessingInstructionType() : "text/xsl");
            m.put("href", signalSystem.getProcessingInstructionHRef() != null ? signalSystem.getProcessingInstructionHRef() : "../../XSLT/aspecttable.xsl");
            ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
            doc.addContent(0, (Content)p);
            root.setAttribute("noNamespaceSchemaLocation", signalSystem.getAspectSchema() != null ? signalSystem.getAspectSchema() : "http://jmri.org/xml/schema/aspecttable.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
            if (this.store(signalSystem, root)) {
                xmlFile.writeXML(file, doc);
            }
        }
        catch (IOException eb) {
            log.warn("Exception in storing signal xml", (Throwable)eb);
        }
    }

    public boolean store(SignalSystem signalSystem, Element root) {
        Namespace namespace = Namespace.getNamespace((String)"http://docbook.org/ns/docbook");
        root.addContent((Content)new Element("name").setText(signalSystem.getName()));
        if (signalSystem.getDate() != null) {
            root.addContent((Content)new Element("date").setText(signalSystem.getDate()));
        }
        for (String string : signalSystem.getReferences()) {
            root.addContent((Content)new Element("reference").setText(string));
        }
        Element copyright = new Element("copyright", namespace);
        for (String string : signalSystem.getCopyright().getDates()) {
            copyright.addContent((Content)new Element("year", namespace).setText(string));
        }
        copyright.addContent((Content)new Element("holder", namespace).setText(signalSystem.getCopyright().getHolder()));
        root.addContent((Content)copyright);
        Element element = new Element("authorgroup", namespace);
        for (Author author : signalSystem.getAuthors()) {
            Element element2 = new Element("author", namespace);
            Element personName = new Element("personname", namespace);
            personName.addContent((Content)new Element("firstname", namespace).setText(author.getFirstName()));
            personName.addContent((Content)new Element("surname", namespace).setText(author.getSurName()));
            element2.addContent((Content)personName);
            if (author.getEmail() != null && !author.getEmail().isBlank()) {
                element2.addContent((Content)new Element("email", namespace).addContent(author.getEmail()));
            }
            element.addContent((Content)element2);
        }
        root.addContent((Content)element);
        Element element3 = new Element("revhistory", namespace);
        for (Revision revision : signalSystem.getRevisions()) {
            Element revisionElement = new Element("revision", namespace);
            revisionElement.addContent((Content)new Element("revnumber", namespace).setText(revision.getRevNumber()));
            revisionElement.addContent((Content)new Element("date", namespace).setText(revision.getDate()));
            revisionElement.addContent((Content)new Element("authorinitials", namespace).setText(revision.getAuthorInitials()));
            revisionElement.addContent((Content)new Element("revremark", namespace).setText(revision.getRemark()));
            element3.addContent((Content)revisionElement);
        }
        root.addContent((Content)element3);
        Element element4 = new Element("aspects");
        for (Aspect aspect : signalSystem.getAspects()) {
            Element aspectElement = new Element("aspect");
            aspectElement.addContent((Content)StringWithCommentXml.store(aspect.getName(), "name"));
            if (aspect.getTitle() != null && !aspect.getTitle().isBlank()) {
                aspectElement.addContent((Content)new Element("title").setText(aspect.getTitle()));
            }
            if (aspect.getRule() != null && !aspect.getRule().isBlank()) {
                aspectElement.addContent((Content)new Element("rule").setText(aspect.getRule()));
            }
            aspectElement.addContent((Content)new Element("indication").setText(aspect.getIndication()));
            for (String description : aspect.getDescriptions()) {
                aspectElement.addContent((Content)new Element("description").setText(description));
            }
            for (String reference : aspect.getReferences()) {
                aspectElement.addContent((Content)new Element("reference").setText(reference));
            }
            for (String comment : aspect.getComments()) {
                aspectElement.addContent((Content)new Element("comment").setText(comment));
            }
            for (String speed : aspect.getSpeedList()) {
                aspectElement.addContent((Content)new Element("speed").setText(speed));
            }
            for (String speed2 : aspect.getSpeed2List()) {
                aspectElement.addContent((Content)new Element("speed2").setText(speed2));
            }
            if (aspect.getRoute() != null && !aspect.getRoute().isBlank()) {
                aspectElement.addContent((Content)new Element("route").setText(aspect.getRoute()));
            }
            if (aspect.getDccAspect() != null && !aspect.getDccAspect().isBlank()) {
                aspectElement.addContent((Content)new Element("dccAspect").setText(aspect.getDccAspect()));
            }
            element4.addContent((Content)aspectElement);
        }
        root.addContent((Content)element4);
        if (!signalSystem.getImageTypes().isEmpty()) {
            Element element5 = new Element("imagetypes");
            for (ImageType imageType : signalSystem.getImageTypes()) {
                Element imageTypeElement = new Element("imagetype");
                imageTypeElement.setAttribute("type", imageType.getType());
                element5.addContent((Content)imageTypeElement);
            }
            root.addContent((Content)element5);
        }
        Element element6 = new Element("appearancefiles");
        for (SignalMastType signalMastType : signalSystem.getSignalMastTypes()) {
            Element appearanceFileElement = new Element("appearancefile");
            appearanceFileElement.setAttribute("href", signalMastType.getFileName());
            element6.addContent((Content)appearanceFileElement);
        }
        root.addContent((Content)element6);
        return true;
    }
}

