/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.signalsystemeditor.configurexml;

import java.util.List;
import jmri.jmrit.signalsystemeditor.StringWithLinks;
import org.jdom2.Content;
import org.jdom2.Element;

public class StringWithLinksXml {
    public static StringWithLinks load(Element element) {
        StringWithLinks swl = new StringWithLinks();
        List<String> _strings = swl.getStrings();
        List<StringWithLinks.Link> _links = swl.getLinks();
        for (Content content : element.getContent()) {
            if (content.getCType() == Content.CType.Text) {
                int stringsSize = _strings.size();
                if (stringsSize > _links.size()) {
                    _strings.set(stringsSize - 1, _strings.get(stringsSize - 1) + content.getValue());
                    continue;
                }
                _strings.add(content.getValue());
                continue;
            }
            if (content.getCType() == Content.CType.Element) {
                Element e = (Element)content;
                if ("a".equals(e.getName())) {
                    if (_strings.size() <= _links.size()) {
                        _strings.add("");
                    }
                    _links.add(new StringWithLinks.Link(e.getText(), e.getAttributeValue("href")));
                    continue;
                }
                throw new RuntimeException("Unkown tag: " + e.getName());
            }
            throw new RuntimeException("Unkown CType: " + content.getCType().name());
        }
        if (_links.isEmpty()) {
            _strings.clear();
            _strings.add(element.getText());
        }
        return swl;
    }

    public static Element store(StringWithLinks stringWithLinks, String tagName) {
        Element element = new Element(tagName);
        List<String> _strings = stringWithLinks.getStrings();
        List<StringWithLinks.Link> _links = stringWithLinks.getLinks();
        if (_strings.size() == 1 && _links.isEmpty()) {
            element.setText(_strings.get(0));
            return element;
        }
        for (int i = 0; i < _strings.size() || i < _links.size(); ++i) {
            if (i < _strings.size()) {
                int j;
                StringBuilder sb = new StringBuilder(_strings.get(i));
                for (j = 0; j < sb.length() && sb.charAt(j) == ' '; ++j) {
                    sb.setCharAt(j, '\u00a0');
                }
                for (j = sb.length() - 1; j > 0 && sb.charAt(j) == ' '; --j) {
                    sb.setCharAt(j, '\u00a0');
                }
                element.addContent(sb.toString());
            }
            if (i >= _links.size()) continue;
            Element link = new Element("a");
            link.setText(_links.get(i).getName());
            link.setAttribute("href", _links.get(i).getHref());
            element.addContent((Content)link);
        }
        return !element.getChildren().isEmpty() ? element : null;
    }
}

