/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.simpleclock;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.ClockControl;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.TimebaseRateException;
import jmri.UserPreferencesManager;
import jmri.configurexml.ShutdownPreferences;
import jmri.configurexml.StoreMenu;
import jmri.jmrit.simpleclock.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.LoggingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClockFrame
extends JmriJFrame
implements PropertyChangeListener {
    private Timebase clock;
    private String hardwareName = null;
    private boolean changed = false;
    protected boolean showTime = false;
    private final DecimalFormat threeDigits = new DecimalFormat("0.000");
    private boolean checkEnabled = InstanceManager.getDefault(ShutdownPreferences.class).isStoreCheckEnabled();
    protected JComboBox<String> timeSourceBox = null;
    protected JComboBox<String> clockStartBox = null;
    protected JComboBox<String> startRunBox = null;
    private static final int START_RUNNING = 0;
    private static final int START_STOPPED = 1;
    private static final int START_NORUNCHANGE = 2;
    protected JCheckBox synchronizeCheckBox = null;
    protected JCheckBox correctCheckBox = null;
    protected JCheckBox displayCheckBox = null;
    protected JCheckBox startSetTimeCheckBox = null;
    protected JCheckBox startSetRateCheckBox = null;
    protected JCheckBox displayStartStopButton = null;
    protected JTextField factorField = new JTextField(5);
    protected JTextField startFactorField = new JTextField(5);
    protected JTextField hoursField = new JTextField(2);
    protected JTextField minutesField = new JTextField(2);
    protected JTextField startHoursField = new JTextField(2);
    protected JTextField startMinutesField = new JTextField(2);
    protected JButton setRateButton = new JButton(Bundle.getMessage("ButtonSet"));
    protected JButton setTimeButton = new JButton(Bundle.getMessage("ButtonSet"));
    protected JButton startButton = new JButton(Bundle.getMessage("ButtonStart"));
    protected JButton stopButton = new JButton(Bundle.getMessage("ButtonStop"));
    protected JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
    protected JLabel clockStatus = new JLabel();
    protected JLabel timeLabel = new JLabel();
    private final int internalSourceIndex = 0;
    private final int hardwareSourceIndex = 1;
    private final int startNone = 0;
    private final int startNixieClock = 1;
    private final int startAnalogClock = 2;
    private final int startLcdClock = 3;
    private final int startPragotronClock = 4;
    private static final Logger log = LoggerFactory.getLogger(SimpleClockFrame.class);

    @Override
    public void initComponents() {
        this.setTitle(Bundle.getMessage("SimpleClockWindowTitle"));
        this.clock = InstanceManager.getNullableDefault(Timebase.class);
        if (this.clock == null) {
            log.error("Could not obtain a Timebase instance.");
            this.setVisible(false);
            this.dispose();
        }
        if (!this.clock.getIsInitialized()) {
            this.clock.initializeHardwareClock();
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this.getClockStatePanel());
        JPanel saveContainerPanel = new JPanel();
        saveContainerPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        saveContainerPanel.setLayout(new BoxLayout(saveContainerPanel, 1));
        saveContainerPanel.add(this.getSourcePane());
        saveContainerPanel.add(this.getStartupOptionsPane());
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BoxLayout(panel4, 0));
        panel4.add(this.doneButton);
        this.doneButton.addActionListener(this::doneButtonActionPerformed);
        saveContainerPanel.add(panel4);
        contentPane.add(saveContainerPanel);
        this.updateRunningButton();
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        menuBar.add(fileMenu);
        fileMenu.add(new StoreMenu());
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.simpleclock.SimpleClockFrame", true);
        this.pack();
        this.clock.addPropertyChangeListener(this);
    }

    private JPanel getClockStatePanel() {
        JPanel clockStatePanel = new JPanel();
        clockStatePanel.setLayout(new BoxLayout(clockStatePanel, 1));
        clockStatePanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BoxLabelClockState")));
        JPanel panel31 = new JPanel();
        panel31.add(this.clockStatus);
        JPanel panel32 = new JPanel();
        panel32.add(new JLabel(Bundle.getMessage("CurrentTime") + " "));
        this.setTimeLabel();
        panel32.add(this.timeLabel);
        clockStatePanel.add(panel32);
        this.startButton.setToolTipText(Bundle.getMessage("TipStartButton"));
        this.startButton.addActionListener(this::startButtonActionPerformed);
        panel31.add(this.startButton);
        this.stopButton.setToolTipText(Bundle.getMessage("TipStopButton"));
        this.stopButton.addActionListener(this::stopButtonActionPerformed);
        panel31.add(this.stopButton);
        clockStatePanel.add(panel31);
        JPanel panel2 = new JPanel();
        panel2.add(new JLabel(Bundle.getMessage("NewTime") + " "));
        panel2.add(this.hoursField);
        this.hoursField.setText("00");
        this.hoursField.setToolTipText(Bundle.getMessage("TipHoursField"));
        panel2.add(new JLabel(":"));
        panel2.add(this.minutesField);
        this.minutesField.setText("00");
        this.minutesField.setToolTipText(Bundle.getMessage("TipMinutesField"));
        this.setTimeButton.setToolTipText(Bundle.getMessage("TipSetTimeButton"));
        this.setTimeButton.addActionListener(this::setTimeButtonActionPerformed);
        panel2.add(this.setTimeButton);
        clockStatePanel.add(panel2);
        JPanel panel12 = new JPanel();
        panel12.add(new JLabel(Bundle.getMessage("SpeedUpFactor") + " "));
        panel12.add(this.factorField);
        this.factorField.setText(this.threeDigits.format(this.clock.userGetRate()));
        this.factorField.setToolTipText(Bundle.getMessage("TipFactorField"));
        panel12.add(new JLabel(":1 "));
        this.setRateButton.setToolTipText(Bundle.getMessage("TipSetRateButton"));
        this.setRateButton.addActionListener(this::setRateButtonActionPerformed);
        panel12.add(this.setRateButton);
        clockStatePanel.add(panel12);
        JPanel clockStatePanelContainer = new JPanel();
        clockStatePanelContainer.setBorder(BorderFactory.createRaisedBevelBorder());
        clockStatePanelContainer.setLayout(new BoxLayout(clockStatePanelContainer, 0));
        clockStatePanelContainer.add(clockStatePanel);
        return clockStatePanelContainer;
    }

    private JPanel getSourcePane() {
        JPanel sourcePanel = new JPanel();
        sourcePanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TimeSource")));
        sourcePanel.setLayout(new BoxLayout(sourcePanel, 1));
        JPanel panel11 = new JPanel();
        this.timeSourceBox = new JComboBox();
        panel11.add(this.timeSourceBox);
        this.timeSourceBox.addItem(Bundle.getMessage("ComputerClock"));
        this.hardwareName = InstanceManager.getDefault(ClockControl.class).getHardwareClockName();
        if (this.hardwareName != null) {
            this.timeSourceBox.addItem(this.hardwareName);
        }
        this.timeSourceBox.setToolTipText(Bundle.getMessage("TipTimeSource"));
        this.timeSourceBox.addActionListener(this::setTimeSourceChanged);
        sourcePanel.add(panel11);
        if (this.hardwareName != null) {
            this.timeSourceBox.setSelectedIndex(this.clock.getInternalMaster() ? 0 : 1);
            JPanel panel11x = new JPanel();
            this.synchronizeCheckBox = new JCheckBox(Bundle.getMessage("Synchronize") + " " + this.hardwareName);
            this.synchronizeCheckBox.setToolTipText(Bundle.getMessage("TipSynchronize"));
            this.synchronizeCheckBox.setSelected(this.clock.getSynchronize());
            this.synchronizeCheckBox.addActionListener(this::synchronizeChanged);
            panel11x.add(this.synchronizeCheckBox);
            sourcePanel.add(panel11x);
            if (InstanceManager.getDefault(ClockControl.class).canCorrectHardwareClock()) {
                JPanel panel11y = new JPanel();
                this.correctCheckBox = new JCheckBox(Bundle.getMessage("Correct"));
                this.correctCheckBox.setToolTipText(Bundle.getMessage("TipCorrect"));
                this.correctCheckBox.setSelected(this.clock.getCorrectHardware());
                this.correctCheckBox.addActionListener(this::correctChanged);
                panel11y.add(this.correctCheckBox);
                sourcePanel.add(panel11y);
            }
            if (InstanceManager.getDefault(ClockControl.class).canSet12Or24HourClock()) {
                JPanel panel11z = new JPanel();
                this.displayCheckBox = new JCheckBox(Bundle.getMessage("Display12Hour"));
                this.displayCheckBox.setToolTipText(Bundle.getMessage("TipDisplay"));
                this.displayCheckBox.setSelected(this.clock.use12HourDisplay());
                this.displayCheckBox.addActionListener(this::displayChanged);
                panel11z.add(this.displayCheckBox);
                sourcePanel.add(panel11z);
            }
        }
        return sourcePanel;
    }

    private JPanel getStartupOptionsPane() {
        JPanel startupOptionsPane = new JPanel();
        startupOptionsPane.setLayout(new BoxLayout(startupOptionsPane, 1));
        JPanel panel61 = new JPanel();
        panel61.add(new JLabel(Bundle.getMessage("StartBoxLabel") + " "));
        this.startRunBox = new JComboBox();
        this.startRunBox.addItem(Bundle.getMessage("StartSelectRunning"));
        this.startRunBox.addItem(Bundle.getMessage("StartSelectStopped"));
        this.startRunBox.addItem(Bundle.getMessage("StartSelectNoChange"));
        this.startRunBox.setToolTipText(Bundle.getMessage("TipStartRunSelect"));
        switch (this.clock.getClockInitialRunState()) {
            case DO_STOP: {
                this.startRunBox.setSelectedIndex(1);
                break;
            }
            case DO_START: {
                this.startRunBox.setSelectedIndex(0);
                break;
            }
            case DO_NOTHING: {
                this.startRunBox.setSelectedIndex(2);
                break;
            }
            default: {
                LoggingUtil.warnOnce(log, "Unexpected initial run state = {}", new Object[]{this.clock.getClockInitialRunState()});
            }
        }
        this.startRunBox.addActionListener(this::startRunBoxChanged);
        panel61.add(this.startRunBox);
        startupOptionsPane.add(panel61);
        JPanel panel62 = new JPanel();
        this.startSetTimeCheckBox = new JCheckBox(Bundle.getMessage("StartSetTime"));
        this.startSetTimeCheckBox.setToolTipText(Bundle.getMessage("TipStartSetTime"));
        this.startSetTimeCheckBox.setSelected(this.clock.getStartSetTime());
        this.startSetTimeCheckBox.addActionListener(this::startSetTimeChanged);
        panel62.add(this.startSetTimeCheckBox);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.clock.getStartTime());
        this.startHoursField.setText("" + cal.get(11));
        this.startHoursField.setToolTipText(Bundle.getMessage("TipStartHours"));
        panel62.add(this.startHoursField);
        panel62.add(new JLabel(":"));
        this.startMinutesField.setText("" + cal.get(12));
        this.startMinutesField.setToolTipText(Bundle.getMessage("TipStartMinutes"));
        panel62.add(this.startMinutesField);
        this.startMinutesField.addFocusListener(this.getStartUpSetTimeChangedAdapter());
        this.startHoursField.addFocusListener(this.getStartUpSetTimeChangedAdapter());
        startupOptionsPane.add(panel62);
        JPanel panelStartSetRate = new JPanel();
        this.startSetRateCheckBox = new JCheckBox(Bundle.getMessage("StartSetSpeedUpFactor") + " ");
        this.startSetRateCheckBox.setToolTipText(Bundle.getMessage("TipStartSetRate"));
        this.startSetRateCheckBox.setSelected(this.clock.getSetRateAtStart());
        this.startSetRateCheckBox.addActionListener(this::startSetRateChanged);
        panelStartSetRate.add(this.startSetRateCheckBox);
        panelStartSetRate.add(this.startFactorField);
        this.startFactorField.setText(this.threeDigits.format(this.clock.getStartRate()));
        this.startFactorField.setToolTipText(Bundle.getMessage("TipFactorField"));
        this.startFactorField.addActionListener(this::startFactorFieldChanged);
        this.startFactorField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SimpleClockFrame.this.startFactorFieldChanged(null);
                }
                super.focusLost(focusEvent);
            }
        });
        panelStartSetRate.add(new JLabel(":1 "));
        startupOptionsPane.add(panelStartSetRate);
        JPanel panel63 = new JPanel();
        panel63.add(new JLabel(Bundle.getMessage("StartClock") + " "));
        this.clockStartBox = new JComboBox();
        panel63.add(this.clockStartBox);
        this.clockStartBox.addItem(Bundle.getMessage("None"));
        this.clockStartBox.addItem(Bundle.getMessage("MenuItemNixieClock"));
        this.clockStartBox.addItem(Bundle.getMessage("MenuItemAnalogClock"));
        this.clockStartBox.addItem(Bundle.getMessage("MenuItemLcdClock"));
        this.clockStartBox.addItem(Bundle.getMessage("MenuItemPragotronClock"));
        this.clockStartBox.setSelectedIndex(0);
        if (this.clock.getStartClockOption() == 1) {
            this.clockStartBox.setSelectedIndex(1);
        } else if (this.clock.getStartClockOption() == 2) {
            this.clockStartBox.setSelectedIndex(2);
        } else if (this.clock.getStartClockOption() == 4) {
            this.clockStartBox.setSelectedIndex(3);
        } else if (this.clock.getStartClockOption() == 8) {
            this.clockStartBox.setSelectedIndex(4);
        }
        this.clockStartBox.setToolTipText(Bundle.getMessage("TipClockStartOption"));
        this.clockStartBox.addActionListener(this::setClockStartChanged);
        startupOptionsPane.add(panel63);
        JPanel panel64 = new JPanel();
        this.displayStartStopButton = new JCheckBox(Bundle.getMessage("DisplayOnOff"));
        this.displayStartStopButton.setSelected(this.clock.getShowStopButton());
        this.displayStartStopButton.addActionListener(this::showStopButtonChanged);
        panel64.add(this.displayStartStopButton);
        startupOptionsPane.add(panel64);
        startupOptionsPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BoxLabelStartUp")));
        return startupOptionsPane;
    }

    private FocusAdapter getStartUpSetTimeChangedAdapter() {
        return new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    SimpleClockFrame.this.startSetTimeChanged(null);
                }
                super.focusLost(focusEvent);
            }
        };
    }

    private void startFactorFieldChanged(ActionEvent e) {
        Double v = this.parseRate(this.startFactorField.getText());
        if (v != null && !v.equals(this.clock.getStartRate())) {
            this.clock.setStartRate(v);
            this.changed = true;
        }
        this.startFactorField.setText(this.threeDigits.format(this.clock.getStartRate()));
    }

    private void startSetRateChanged(ActionEvent e) {
        this.clock.setSetRateAtStart(this.startSetRateCheckBox.isSelected());
        this.changed = true;
    }

    void updateRunningButton() {
        boolean running = this.clock.getRun();
        if (running) {
            this.clockStatus.setText(Bundle.getMessage("ClockRunning"));
            this.startButton.setVisible(false);
            this.stopButton.setVisible(true);
        } else {
            this.clockStatus.setText(Bundle.getMessage("ClockStopped"));
            this.startButton.setVisible(true);
            this.stopButton.setVisible(false);
        }
        this.clockStatus.setVisible(true);
    }

    @CheckForNull
    Double parseRate(String fieldEntry) {
        double frac;
        double rate;
        try {
            char decimalSeparator = this.threeDigits.getDecimalFormatSymbols().getDecimalSeparator();
            if (decimalSeparator != '.') {
                fieldEntry = fieldEntry.replace(decimalSeparator, '.');
            }
            rate = Double.parseDouble(fieldEntry);
        }
        catch (NumberFormatException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ParseRateError") + "\n" + e, Bundle.getMessage("ErrorTitle"), 0);
            log.error("Exception when parsing user-entered rate", (Throwable)e);
            return null;
        }
        if (rate < 0.0) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("NegativeRateError"), Bundle.getMessage("ErrorTitle"), 0);
            return null;
        }
        if (InstanceManager.getDefault(ClockControl.class).requiresIntegerRate() && !this.clock.getInternalMaster() && (frac = rate - (double)((int)rate)) > 0.001) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("NonIntegerError"), Bundle.getMessage("ErrorTitle"), 0);
            return null;
        }
        return rate;
    }

    public void setRateButtonActionPerformed(ActionEvent ev) {
        Double parsedRate = this.parseRate(this.factorField.getText());
        if (parsedRate == null) {
            this.factorField.setText(this.threeDigits.format(this.clock.userGetRate()));
            return;
        }
        try {
            this.clock.userSetRate(parsedRate);
        }
        catch (TimebaseRateException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("SetRateError") + "\n" + e.getLocalizedMessage(), Bundle.getMessage("ErrorTitle"), 0);
        }
        this.changed = true;
    }

    private void setTimeSourceChanged(ActionEvent e) {
        int index = this.timeSourceBox.getSelectedIndex();
        int oldIndex = 0;
        if (!this.clock.getInternalMaster()) {
            oldIndex = 1;
        }
        if (oldIndex == index) {
            return;
        }
        if (index == 0) {
            this.clock.setInternalMaster(true, true);
        } else {
            double rate;
            double frac;
            if (InstanceManager.getDefault(ClockControl.class).requiresIntegerRate() && (frac = (rate = this.clock.userGetRate()) - (double)((int)rate)) > 0.001) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("NonIntegerErrorCantChangeSource"), Bundle.getMessage("ErrorTitle"), 0);
                this.timeSourceBox.setSelectedIndex(0);
                return;
            }
            this.clock.setInternalMaster(false, true);
        }
        this.changed = true;
    }

    private void synchronizeChanged(ActionEvent e) {
        this.clock.setSynchronize(this.synchronizeCheckBox.isSelected(), true);
        this.changed = true;
    }

    private void correctChanged(ActionEvent e) {
        this.clock.setCorrectHardware(this.correctCheckBox.isSelected(), true);
        this.changed = true;
    }

    private void displayChanged(ActionEvent e) {
        this.clock.set12HourDisplay(this.displayCheckBox.isSelected(), true);
        this.changed = true;
    }

    public void setTimeButtonActionPerformed(ActionEvent ex) {
        int minutes;
        int hours;
        try {
            hours = Integer.parseInt(this.hoursField.getText());
        }
        catch (NumberFormatException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("HoursError") + "\n" + e, Bundle.getMessage("ErrorTitle"), 0);
            log.error("Exception when parsing hours Field", (Throwable)e);
            return;
        }
        if (hours < 0 || hours > 23) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("HoursRangeError"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        try {
            minutes = Integer.parseInt(this.minutesField.getText());
        }
        catch (NumberFormatException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("MinutesError") + "\n" + e, Bundle.getMessage("ErrorTitle"), 0);
            log.error("Exception when parsing Minutes Field", (Throwable)e);
            return;
        }
        if (minutes < 0 || minutes > 59) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("MinutesRangeError"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        long mSecPerHour = 3600000L;
        long mSecPerMinute = 60000L;
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.clock.getTime());
        int cHours = cal.get(11);
        long cNumMSec = cal.getTime().getTime();
        long nNumMSec = cNumMSec / mSecPerHour * mSecPerHour - (long)cHours * mSecPerHour + (long)hours * mSecPerHour + (long)minutes * mSecPerMinute;
        this.clock.userSetTime(new Date(nNumMSec));
        this.showTime = true;
        this.updateTime();
    }

    private void startRunBoxChanged(ActionEvent e) {
        switch (this.startRunBox.getSelectedIndex()) {
            case 1: {
                this.clock.setClockInitialRunState(Timebase.ClockInitialRunState.DO_STOP);
                break;
            }
            case 0: {
                this.clock.setClockInitialRunState(Timebase.ClockInitialRunState.DO_START);
                break;
            }
            default: {
                this.clock.setClockInitialRunState(Timebase.ClockInitialRunState.DO_NOTHING);
            }
        }
        this.changed = true;
    }

    private void showStopButtonChanged(ActionEvent e) {
        this.clock.setShowStopButton(this.displayStartStopButton.isSelected());
        this.changed = true;
    }

    private void startSetTimeChanged(ActionEvent ev) {
        int minutes;
        int hours;
        try {
            hours = Integer.parseInt(this.startHoursField.getText());
        }
        catch (NumberFormatException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("HoursError") + "\n" + e, Bundle.getMessage("ErrorTitle"), 0);
            log.error("Exception when parsing hours Field", (Throwable)e);
            return;
        }
        if (hours < 0 || hours > 23) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("HoursRangeError"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        try {
            minutes = Integer.parseInt(this.startMinutesField.getText());
        }
        catch (NumberFormatException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("MinutesError") + "\n" + e, Bundle.getMessage("ErrorTitle"), 0);
            log.error("Exception when parsing Minutes Field", (Throwable)e);
            return;
        }
        if (minutes < 0 || minutes > 59) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("MinutesRangeError"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        long mSecPerHour = 3600000L;
        long mSecPerMinute = 60000L;
        Calendar cal = Calendar.getInstance();
        int cHours = cal.get(11);
        long cNumMSec = cal.getTime().getTime();
        long nNumMSec = cNumMSec / mSecPerHour * mSecPerHour - (long)cHours * mSecPerHour + (long)hours * mSecPerHour + (long)minutes * mSecPerMinute;
        this.clock.setStartSetTime(this.startSetTimeCheckBox.isSelected(), new Date(nNumMSec));
        this.changed = true;
    }

    private void setClockStartChanged(ActionEvent e) {
        int sel = 0;
        switch (this.clockStartBox.getSelectedIndex()) {
            case 1: {
                sel = 1;
                break;
            }
            case 2: {
                sel = 2;
                break;
            }
            case 3: {
                sel = 4;
                break;
            }
            case 4: {
                sel = 8;
                break;
            }
        }
        this.clock.setStartClockOption(sel);
        this.changed = true;
    }

    public void startButtonActionPerformed(ActionEvent e) {
        this.clock.setRun(true);
    }

    public void stopButtonActionPerformed(ActionEvent e) {
        this.clock.setRun(false);
    }

    void updateTime() {
        if (this.clock.getRun() || this.showTime) {
            this.showTime = false;
            this.setTimeLabel();
            this.timeLabel.setVisible(true);
        }
    }

    void setTimeLabel() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.clock.getTime());
        int hours = cal.get(11);
        int minutes = cal.get(12);
        this.timeLabel.setText(" " + hours / 10 + (hours - hours / 10 * 10) + ":" + minutes / 10 + (minutes - minutes / 10 * 10));
        this.timeLabel.setToolTipText(this.clock.getTime().toString());
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        log.trace("propertyChange({})", (Object)event.getPropertyName());
        switch (event.getPropertyName()) {
            case "run": {
                this.updateRunningButton();
                break;
            }
            case "rate": {
                this.factorField.setText(this.threeDigits.format(this.clock.userGetRate()));
                break;
            }
            case "time": {
                this.updateTime();
                break;
            }
            case "config": {
                this.synchronizeCheckBox.setSelected(this.clock.getSynchronize());
                this.timeSourceBox.setSelectedIndex(this.clock.getInternalMaster() ? 0 : 1);
                switch (this.clock.getClockInitialRunState()) {
                    case DO_STOP: {
                        this.startRunBox.setSelectedIndex(1);
                        break;
                    }
                    case DO_START: {
                        this.startRunBox.setSelectedIndex(0);
                        break;
                    }
                    case DO_NOTHING: {
                        this.startRunBox.setSelectedIndex(2);
                        break;
                    }
                    default: {
                        LoggingUtil.warnOnce(log, "Unexpected initial run state = {}", new Object[]{this.clock.getClockInitialRunState()});
                    }
                }
                this.startSetTimeCheckBox.setSelected(this.clock.getStartSetTime());
                this.displayStartStopButton.setSelected(this.clock.getShowStopButton());
                this.startSetRateCheckBox.setSelected(this.clock.getSetRateAtStart());
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.clock.getStartTime());
                this.startHoursField.setText("" + cal.get(11));
                this.startMinutesField.setText("" + cal.get(12));
                this.startSetRateCheckBox.setSelected(this.clock.getSetRateAtStart());
                this.startFactorField.setText(this.threeDigits.format(this.clock.getStartRate()));
                if (this.clock.getStartClockOption() == 0) {
                    this.clockStartBox.setSelectedIndex(0);
                } else if (this.clock.getStartClockOption() == 1) {
                    this.clockStartBox.setSelectedIndex(1);
                } else if (this.clock.getStartClockOption() == 2) {
                    this.clockStartBox.setSelectedIndex(2);
                } else if (this.clock.getStartClockOption() == 4) {
                    this.clockStartBox.setSelectedIndex(3);
                } else if (this.clock.getStartClockOption() == 8) {
                    this.clockStartBox.setSelectedIndex(4);
                }
                if (this.correctCheckBox == null) break;
                this.correctCheckBox.setSelected(this.clock.getCorrectHardware());
                break;
            }
        }
    }

    @Override
    protected void handleModified() {
    }

    public void doneButtonActionPerformed(ActionEvent e) {
        if (this.changed && !this.checkEnabled && InstanceManager.getNullableDefault(UserPreferencesManager.class) != null) {
            InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("ReminderTitle"), Bundle.getMessage("ReminderSaveString", Bundle.getMessage("SimpleClockWindowTitle")), this.getClassName(), "remindSaveClock");
        }
        this.changed = false;
        this.setVisible(false);
        super.windowClosing(null);
        this.dispose();
    }

    public String getClassDescription() {
        return "Fast Clock";
    }

    public void setMessagePreferencesDetails() {
        InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails(this.getClassName(), "remindSaveClock", "HideSaveReminder");
    }

    protected String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.doneButtonActionPerformed(null);
    }

    @Override
    public void dispose() {
        if (this.clock != null) {
            this.clock.removePropertyChangeListener(this);
        }
        super.dispose();
    }
}

