/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.simpleclock.configurexml;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.TimebaseRateException;
import jmri.configurexml.AbstractXmlAdapter;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTimebaseXml
extends AbstractXmlAdapter {
    final SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
    private static final Logger log = LoggerFactory.getLogger(SimpleTimebaseXml.class);

    @Override
    public Element store(Object o) {
        Timebase clock = InstanceManager.getDefault(Timebase.class);
        Element elem = new Element("timebase");
        elem.setAttribute("class", this.getClass().getName());
        elem.setAttribute("time", clock.getStartTime().toString());
        elem.setAttribute("rate", "" + clock.userGetRate());
        elem.setAttribute("startrate", "" + clock.getStartRate());
        elem.setAttribute("run", clock.getClockInitialRunState() == Timebase.ClockInitialRunState.DO_START ? "yes" : "no");
        elem.setAttribute("master", clock.getInternalMaster() ? "yes" : "no");
        if (!clock.getInternalMaster()) {
            elem.setAttribute("mastername", clock.getMasterName());
        }
        elem.setAttribute("sync", clock.getSynchronize() ? "yes" : "no");
        elem.setAttribute("correct", clock.getCorrectHardware() ? "yes" : "no");
        elem.setAttribute("display", clock.use12HourDisplay() ? "yes" : "no");
        elem.setAttribute("startstopped", clock.getClockInitialRunState() == Timebase.ClockInitialRunState.DO_STOP ? "yes" : "no");
        elem.setAttribute("startrunning", clock.getClockInitialRunState() == Timebase.ClockInitialRunState.DO_START ? "yes" : "no");
        elem.setAttribute("startsettime", clock.getStartSetTime() ? "yes" : "no");
        elem.setAttribute("startclockoption", Integer.toString(clock.getStartClockOption()));
        elem.setAttribute("showbutton", clock.getShowStopButton() ? "yes" : "no");
        elem.setAttribute("startsetrate", clock.getSetRateAtStart() ? "yes" : "no");
        return elem;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        double r;
        String val;
        boolean result = true;
        Timebase clock = InstanceManager.getDefault(Timebase.class);
        if (shared.getAttribute("master") != null) {
            val = shared.getAttributeValue("master");
            if (val.equals("yes")) {
                clock.setInternalMaster(true, false);
            }
            if (val.equals("no")) {
                clock.setInternalMaster(false, false);
                if (shared.getAttribute("mastername") != null) {
                    clock.setMasterName(shared.getAttributeValue("mastername"));
                }
            }
        }
        if (shared.getAttribute("sync") != null) {
            val = shared.getAttributeValue("sync");
            if (val.equals("yes")) {
                clock.setSynchronize(true, false);
            }
            if (val.equals("no")) {
                clock.setSynchronize(false, false);
            }
        }
        if (shared.getAttribute("correct") != null) {
            val = shared.getAttributeValue("correct");
            if (val.equals("yes")) {
                clock.setCorrectHardware(true, false);
            }
            if (val.equals("no")) {
                clock.setCorrectHardware(false, false);
            }
        }
        if (shared.getAttribute("display") != null) {
            val = shared.getAttributeValue("display");
            if (val.equals("yes")) {
                clock.set12HourDisplay(true, false);
            }
            if (val.equals("no")) {
                clock.set12HourDisplay(false, false);
            }
        }
        if (shared.getAttribute("showbutton") != null) {
            val = shared.getAttributeValue("showbutton");
            if (val.equals("yes")) {
                clock.setShowStopButton(true);
            }
            if (val.equals("no")) {
                clock.setShowStopButton(false);
            }
        }
        if ("yes".equals(shared.getAttributeValue("startrunning"))) {
            clock.setRun(true);
            clock.setClockInitialRunState(Timebase.ClockInitialRunState.DO_START);
        } else if ("yes".equals(shared.getAttributeValue("startstopped"))) {
            clock.setRun(false);
            clock.setClockInitialRunState(Timebase.ClockInitialRunState.DO_STOP);
        } else if (shared.getAttribute("startrunning") != null) {
            clock.setClockInitialRunState(Timebase.ClockInitialRunState.DO_NOTHING);
        } else if (shared.getAttribute("run") != null) {
            val = shared.getAttributeValue("run");
            if (val.equals("yes")) {
                clock.setRun(true);
                clock.setClockInitialRunState(Timebase.ClockInitialRunState.DO_START);
            }
            if (val.equals("no")) {
                clock.setRun(false);
                clock.setClockInitialRunState(Timebase.ClockInitialRunState.DO_STOP);
            }
        }
        if (shared.getAttribute("startsetrate") != null) {
            val = shared.getAttributeValue("startsetrate");
            clock.setSetRateAtStart(!val.equals("no"));
        }
        boolean hasRate = false;
        if (shared.getAttribute("startrate") != null) {
            try {
                r = shared.getAttribute("startrate").getDoubleValue();
                clock.setStartRate(r);
                hasRate = true;
            }
            catch (DataConversionException e2) {
                log.error("Cannot convert start rate", (Throwable)e2);
                result = false;
            }
        }
        if (!hasRate && shared.getAttribute("rate") != null) {
            try {
                r = shared.getAttribute("rate").getDoubleValue();
                clock.setStartRate(r);
                hasRate = true;
            }
            catch (DataConversionException e2) {
                log.error("Cannot convert rate", (Throwable)e2);
                result = false;
            }
        }
        if (clock.getSetRateAtStart() && hasRate) {
            try {
                clock.userSetRate(clock.getStartRate());
            }
            catch (TimebaseRateException e1) {
                log.error("Cannot restore rate: {}", (Object)clock.getStartRate(), (Object)e1);
                result = false;
            }
        }
        if (shared.getAttribute("startsettime") != null) {
            val = shared.getAttributeValue("startsettime");
            if (val.equals("yes")) {
                if (shared.getAttribute("time") != null) {
                    String val2 = shared.getAttributeValue("time");
                    try {
                        clock.setStartSetTime(true, this.format.parse(val2));
                        clock.setTime(this.format.parse(val2));
                    }
                    catch (ParseException e) {
                        log.warn("Cannot set date using value stored in file: {}", (Object)val2);
                        result = false;
                    }
                }
            } else if (val.equals("no") && shared.getAttribute("time") != null) {
                String val2 = shared.getAttributeValue("time");
                try {
                    clock.setStartSetTime(false, this.format.parse(val2));
                }
                catch (ParseException e) {
                    log.warn("Cannot set date using value stored in file: {}", (Object)val2);
                    result = false;
                }
            }
        } else if (shared.getAttribute("time") != null) {
            String val2 = shared.getAttributeValue("time");
            try {
                clock.setStartSetTime(true, this.format.parse(val2));
                clock.setTime(this.format.parse(val2));
            }
            catch (ParseException e) {
                log.warn("Cannot set date using value stored in file: {}", (Object)val2);
                result = false;
            }
        }
        if (shared.getAttribute("startclockoption") != null) {
            int option = Integer.parseInt(shared.getAttribute("startclockoption").getValue());
            clock.setStartClockOption(option);
            clock.initializeClock();
        }
        clock.initializeHardwareClock();
        return result;
    }

    @Override
    public int loadOrder() {
        return 260;
    }
}

