/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.sound;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import jmri.jmrit.sound.WavBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundUtil {
    private static final int BUFFER_LENGTH = 4096;
    private static final Logger log = LoggerFactory.getLogger(SoundUtil.class);

    public static void playSoundBuffer(byte[] wavData) {
        SourceDataLine line;
        boolean bigEndian;
        boolean signed;
        int channels;
        int sampleSizeInBits;
        WavBuffer wb = new WavBuffer(wavData);
        float sampleRate = wb.getSampleRate();
        AudioFormat format = new AudioFormat(sampleRate, sampleSizeInBits = wb.getSampleSizeInBits(), channels = wb.getChannels(), signed = wb.getSigned(), bigEndian = wb.getBigEndian());
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        if (!AudioSystem.isLineSupported(info)) {
            log.warn("line not supported: {}", (Object)info);
            return;
        }
        try {
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format);
        }
        catch (LineUnavailableException ex) {
            log.error("error opening line", (Throwable)ex);
            return;
        }
        line.start();
        line.write(wavData, 0, wavData.length);
    }

    public static byte[] bufferFromFile(String filename, float sampleRate, int sampleSizeInBits, int channels, boolean signed, boolean bigEndian) throws IOException, UnsupportedAudioFileException {
        File sourceFile = new File(filename);
        AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(sourceFile);
        AudioFormat audioFormat = fileFormat.getFormat();
        AudioFormat format = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        AudioInputStream stream = AudioSystem.getAudioInputStream(sourceFile);
        AudioInputStream inputAIS = AudioSystem.getAudioInputStream(format, stream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int nBufferSize = 4096 * audioFormat.getFrameSize();
        byte[] abBuffer = new byte[nBufferSize];
        while (true) {
            if (log.isDebugEnabled()) {
                log.debug("trying to read (bytes): {}", (Object)abBuffer.length);
            }
            int nBytesRead = inputAIS.read(abBuffer);
            if (log.isDebugEnabled()) {
                log.debug("read (bytes): {}", (Object)nBytesRead);
            }
            if (nBytesRead == -1) break;
            baos.write(abBuffer, 0, nBytesRead);
        }
        byte[] abAudioData = baos.toByteArray();
        return abAudioData;
    }
}

