/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.sound;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WavBuffer {
    int fmtOffset;
    int dataOffset;
    byte[] buffer;
    private static final Logger log = LoggerFactory.getLogger(WavBuffer.class);

    public WavBuffer(byte[] content) {
        this.buffer = Arrays.copyOf(content, content.length);
        this.initFmt();
        this.initData();
    }

    public WavBuffer(File file) throws IOException {
        if (file == null) {
            throw new IOException("Null file during ctor");
        }
        BufferedInputStream s = new BufferedInputStream(new FileInputStream(file));
        try {
            this.buffer = new byte[(int)file.length()];
            int count = ((InputStream)s).read(this.buffer);
            if (count != this.buffer.length) {
                log.warn("Excepted {} bytes but read {} from file {}", new Object[]{this.buffer.length, count, file.getName()});
            }
            this.initFmt();
            this.initData();
        }
        catch (IOException e1) {
            log.error("error reading file", (Throwable)e1);
            throw e1;
        }
        finally {
            try {
                ((InputStream)s).close();
            }
            catch (IOException e2) {
                log.error("Exception closing file", (Throwable)e2);
            }
        }
    }

    public int findHeader(int i1, int i2, int i3, int i4) {
        int index = 12;
        while (index < this.buffer.length) {
            if (this.buffer[index] == i1 && this.buffer[index + 1] == i2 && this.buffer[index + 2] == i3 && this.buffer[index + 3] == i4) {
                return index;
            }
            index = index + 8 + this.fourByte(index + 4);
        }
        log.error("Didn't find chunk");
        return 0;
    }

    private void initFmt() {
        this.fmtOffset = this.findHeader(102, 109, 116, 32);
        if (this.fmtOffset > 0) {
            return;
        }
        log.error("Didn't find fmt chunk");
    }

    private void initData() {
        this.dataOffset = this.findHeader(100, 97, 116, 97);
        if (this.dataOffset > 0) {
            return;
        }
        log.error("Didn't find data chunk");
    }

    public float getSampleRate() {
        return this.fourByte(this.fmtOffset + 12);
    }

    public int getSampleSizeInBits() {
        return this.twoByte(this.fmtOffset + 22);
    }

    public int getChannels() {
        return this.twoByte(this.fmtOffset + 10);
    }

    public boolean getBigEndian() {
        return false;
    }

    public boolean getSigned() {
        return this.getSampleSizeInBits() > 8;
    }

    public int getDataStart() {
        return this.dataOffset + 8;
    }

    public int getDataSize() {
        return this.fourByte(this.dataOffset + 4);
    }

    public int getDataEnd() {
        return this.dataOffset + 8 + this.getDataSize() - 1;
    }

    int twoByte(int index) {
        return this.buffer[index] + this.buffer[index + 1] * 256;
    }

    int fourByte(int index) {
        return (this.buffer[index] & 0xFF) + (this.buffer[index + 1] & 0xFF) * 256 + (this.buffer[index + 2] & 0xFF) * 256 * 256 + (this.buffer[index + 3] & 0xFF) * 256 * 256 * 256;
    }

    public byte[] getByteArray() {
        return Arrays.copyOf(this.buffer, this.buffer.length);
    }
}

