/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import jmri.jmrit.symbolicprog.AbstractQualifier;
import jmri.jmrit.symbolicprog.VariableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArithmeticQualifier
extends AbstractQualifier {
    Test test;
    long value;
    boolean warnedDoesntExist = false;
    private static final Logger log = LoggerFactory.getLogger(ArithmeticQualifier.class);

    public ArithmeticQualifier(VariableValue watchedVal, int value, String relation) {
        super(watchedVal);
        this.test = Test.decode(relation);
        this.value = Integer.toUnsignedLong(value);
    }

    @Override
    public boolean currentDesiredState() {
        if (this.returnFromExistsLogic()) {
            return this.valueOfExistsLogic();
        }
        return this.availableStateFromValue(this.watchedVal.getLongValue());
    }

    @Override
    protected boolean availableStateFromValue(Object now) {
        if (this.returnFromExistsLogic()) {
            return this.valueOfExistsLogic();
        }
        long nowVal = 0L;
        if (now instanceof Integer) {
            nowVal = Integer.toUnsignedLong((Integer)now);
        } else if (now instanceof Long) {
            nowVal = (Long)now;
        }
        int compare = Long.compareUnsigned(nowVal, this.value);
        switch (this.test) {
            case GE: {
                return compare >= 0;
            }
            case LE: {
                return compare <= 0;
            }
            case GT: {
                return compare > 0;
            }
            case LT: {
                return compare < 0;
            }
            case EQ: {
                return compare == 0;
            }
            case NE: {
                return compare != 0;
            }
        }
        log.error("Unexpected switch value: {}", (Object)this.test);
        return false;
    }

    @Override
    public void update() {
        this.setWatchedAvailable(this.currentDesiredState());
    }

    private boolean returnFromExistsLogic() {
        if (this.test == Test.EXISTS) {
            return true;
        }
        return this.watchedVal == null;
    }

    private boolean valueOfExistsLogic() {
        if (this.test == Test.EXISTS) {
            if (this.value == 0L && this.watchedVal == null) {
                return true;
            }
            return this.value != 0L && this.watchedVal != null;
        }
        if (this.watchedVal == null) {
            if (!this.warnedDoesntExist) {
                this.warnedDoesntExist = true;
                log.error("Arithmetic {} operation when watched value doesn't exist", (Object)this.test);
            }
            return true;
        }
        return false;
    }

    public static enum Test {
        GE("ge"),
        LE("le"),
        GT("gt"),
        LT("lt"),
        EQ("eq"),
        NE("ne"),
        EXISTS("exists");

        String relation;

        private Test(String relation) {
            this.relation = relation;
        }

        static Test decode(String r) {
            for (Test t : Test.values()) {
                if (!t.relation.equals(r)) continue;
                return t;
            }
            return null;
        }
    }
}

