/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.decoderdefn.IdentifyDecoder;
import jmri.jmrit.progsupport.ProgModeSelector;
import jmri.jmrit.roster.IdentifyLoco;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.GlobalRosterEntryComboBox;
import jmri.jmrit.symbolicprog.Bundle;
import jmri.jmrit.symbolicprog.LocoSelPane;
import jmri.jmrit.symbolicprog.ProgDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedLocoSelPane
extends LocoSelPane
implements PropertyChangeListener {
    ProgModeSelector selector;
    JLabel _statusLabel = null;
    protected GlobalRosterEntryComboBox locoBox = new GlobalRosterEntryComboBox();
    private JComboBox<String> decoderBox = null;
    protected JComboBox<String> programmerBox = null;
    protected JToggleButton iddecoder;
    protected JToggleButton idloco;
    protected JButton go2;
    private static final Logger log = LoggerFactory.getLogger(CombinedLocoSelPane.class);

    public CombinedLocoSelPane(JLabel s, ProgModeSelector selector) {
        this._statusLabel = s;
        this.selector = selector;
        this.init();
    }

    protected JPanel layoutDecoderSelection() {
        JPanel pane1a = new JPanel();
        pane1a.setLayout(new BoxLayout(pane1a, 0));
        pane1a.add(new JLabel("Decoder installed: "));
        this.decoderBox = InstanceManager.getDefault(DecoderIndexFile.class).matchingComboBox(null, null, null, null, null, null);
        this.decoderBox.getAccessibleContext().setAccessibleName("Decoder installed: ");
        this.decoderBox.insertItemAt("<from locomotive settings>", 0);
        this.decoderBox.setSelectedIndex(0);
        this.decoderBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CombinedLocoSelPane.this.decoderBox.getSelectedIndex() != 0) {
                    CombinedLocoSelPane.this.locoBox.setSelectedIndex(0);
                    CombinedLocoSelPane.this.go2.setEnabled(true);
                    CombinedLocoSelPane.this.go2.setRequestFocusEnabled(true);
                    CombinedLocoSelPane.this.go2.requestFocus();
                    CombinedLocoSelPane.this.go2.setToolTipText(Bundle.getMessage("TipClickToOpen"));
                } else {
                    CombinedLocoSelPane.this.go2.setEnabled(false);
                    CombinedLocoSelPane.this.go2.setToolTipText(Bundle.getMessage("TipSelectLoco"));
                }
            }
        });
        pane1a.add(this.decoderBox);
        this.iddecoder = this.addDecoderIdentButton();
        if (this.iddecoder != null) {
            pane1a.add(this.iddecoder);
        }
        pane1a.setAlignmentX(1.0f);
        return pane1a;
    }

    JToggleButton addDecoderIdentButton() {
        Programmer p;
        JToggleButton button = new JToggleButton(Bundle.getMessage("ButtonReadType"));
        button.setToolTipText(Bundle.getMessage("TipSelectType"));
        button.getAccessibleContext().setAccessibleName(Bundle.getMessage("ButtonReadType"));
        if (InstanceManager.getNullableDefault(GlobalProgrammerManager.class) != null && (p = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer()) != null && !p.getCanRead()) {
            button.setEnabled(false);
            button.setToolTipText(Bundle.getMessage("TipNoRead"));
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CombinedLocoSelPane.this.startIdentifyDecoder();
            }
        });
        return button;
    }

    void setDecoderSelectionFromLoco(String loco) {
        this.decoderBox.setSelectedIndex(0);
    }

    boolean isDecoderSelected() {
        return this.decoderBox.getSelectedIndex() != 0;
    }

    protected String selectedDecoderType() {
        if (!this.isDecoderSelected()) {
            return null;
        }
        return (String)this.decoderBox.getSelectedItem();
    }

    protected JPanel layoutRosterSelection() {
        Programmer p;
        JPanel pane2a = new JPanel();
        pane2a.setLayout(new BoxLayout(pane2a, 0));
        pane2a.add(new JLabel(Bundle.getMessage("USE LOCOMOTIVE SETTINGS FOR:")));
        this.locoBox.getAccessibleContext().setAccessibleName(Bundle.getMessage("USE LOCOMOTIVE SETTINGS FOR:"));
        this.locoBox.setNonSelectedItem(Bundle.getMessage("<NONE - NEW LOCO>"));
        Roster.getDefault().addPropertyChangeListener(this);
        pane2a.add(this.locoBox);
        this.locoBox.addPropertyChangeListener("selectedRosterEntries", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (CombinedLocoSelPane.this.locoBox.getSelectedRosterEntries().length != 0) {
                    CombinedLocoSelPane.this.setDecoderSelectionFromLoco(CombinedLocoSelPane.this.locoBox.getSelectedRosterEntries()[0].titleString());
                    CombinedLocoSelPane.this.go2.setEnabled(true);
                    CombinedLocoSelPane.this.go2.setRequestFocusEnabled(true);
                    CombinedLocoSelPane.this.go2.requestFocus();
                    CombinedLocoSelPane.this.go2.setToolTipText(Bundle.getMessage("TipClickToOpen"));
                } else {
                    CombinedLocoSelPane.this.go2.setEnabled(false);
                    CombinedLocoSelPane.this.go2.setToolTipText(Bundle.getMessage("TipSelectLoco"));
                }
            }
        });
        this.idloco = new JToggleButton(Bundle.getMessage("IDENT"));
        this.idloco.getAccessibleContext().setAccessibleName(Bundle.getMessage("IDENT"));
        this.idloco.setToolTipText(Bundle.getMessage("READ THE LOCOMOTIVE'S ADDRESS AND ATTEMPT TO SELECT THE RIGHT SETTINGS"));
        if (InstanceManager.getNullableDefault(GlobalProgrammerManager.class) != null && (p = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer()) != null && !p.getCanRead()) {
            this.idloco.setEnabled(false);
            this.idloco.setToolTipText(Bundle.getMessage("BUTTON DISABLED BECAUSE CONFIGURED COMMAND STATION CAN'T READ CVS"));
        }
        this.idloco.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (log.isDebugEnabled()) {
                    log.debug("Identify locomotive pressed");
                }
                CombinedLocoSelPane.this.startIdentifyLoco();
            }
        });
        pane2a.add(this.idloco);
        pane2a.setAlignmentX(1.0f);
        return pane2a;
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JPanel pane2a = this.layoutRosterSelection();
        if (pane2a != null) {
            this.add((Component)pane2a, "North");
        }
        this.add((Component)this.layoutDecoderSelection(), "Center");
        this.add((Component)this.createProgrammerSelection(), "South");
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
    }

    protected JPanel createProgrammerSelection() {
        JPanel pane3a = new JPanel();
        pane3a.setLayout(new BoxLayout(pane3a, 1));
        JPanel progFormat = new JPanel();
        progFormat.setLayout(new BoxLayout(progFormat, 0));
        progFormat.add(new JLabel(Bundle.getMessage("ProgrammerFormat")));
        progFormat.setAlignmentX(1.0f);
        this.programmerBox = new JComboBox<String>(ProgDefault.findListOfProgFiles());
        this.programmerBox.setSelectedIndex(0);
        if (ProgDefault.getDefaultProgFile() != null) {
            this.programmerBox.setSelectedItem(ProgDefault.getDefaultProgFile());
        }
        progFormat.add(this.programmerBox);
        this.go2 = new JButton(Bundle.getMessage("OpenProgrammer"));
        this.go2.getAccessibleContext().setAccessibleName(Bundle.getMessage("OpenProgrammer"));
        this.go2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (log.isDebugEnabled()) {
                    log.debug("Open programmer pressed");
                }
                CombinedLocoSelPane.this.openButton();
            }
        });
        this.go2.setAlignmentX(1.0f);
        this.go2.setEnabled(false);
        this.go2.setToolTipText(Bundle.getMessage("TipSelectLoco"));
        pane3a.add(progFormat);
        pane3a.add(this.go2);
        return pane3a;
    }

    protected void startIdentifyLoco() {
        Programmer p = null;
        if (this.selector != null && this.selector.isSelected()) {
            p = this.selector.getProgrammer();
        }
        if (p == null) {
            log.warn("Selector did not provide a programmer, use default");
            p = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer();
        }
        IdentifyLoco id = new IdentifyLoco(p){

            @Override
            protected void done(int dccAddress) {
                CombinedLocoSelPane.this.selectLoco(dccAddress);
            }

            @Override
            protected void message(String m) {
                if (CombinedLocoSelPane.this._statusLabel != null) {
                    CombinedLocoSelPane.this._statusLabel.setText(m);
                }
            }

            @Override
            protected void error() {
                CombinedLocoSelPane.this.idloco.setSelected(false);
            }
        };
        id.start();
    }

    protected void startIdentifyDecoder() {
        Programmer p = null;
        if (this.selector != null && this.selector.isSelected()) {
            p = this.selector.getProgrammer();
        }
        if (p == null) {
            log.warn("Selector did not provide a programmer, use default");
            p = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer();
        }
        IdentifyDecoder id = new IdentifyDecoder(p){

            @Override
            protected void done(int mfg, int model, int productID) {
                CombinedLocoSelPane.this.selectDecoder(mfg, model, productID);
            }

            @Override
            protected void message(String m) {
                if (CombinedLocoSelPane.this._statusLabel != null) {
                    CombinedLocoSelPane.this._statusLabel.setText(m);
                }
            }

            @Override
            protected void error() {
                CombinedLocoSelPane.this.iddecoder.setSelected(false);
            }
        };
        id.start();
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        this.locoBox.update();
    }

    protected void selectLoco(int dccAddress) {
        this.idloco.setSelected(false);
        List<RosterEntry> l = Roster.getDefault().matchingList(null, null, Integer.toString(dccAddress), null, null, null, null);
        if (log.isDebugEnabled()) {
            log.debug("selectLoco found {} matches", (Object)l.size());
        }
        if (l.size() > 0) {
            RosterEntry r = l.get(0);
            if (log.isDebugEnabled()) {
                log.debug("Loco id is {}", (Object)r.getId());
            }
            this.locoBox.setSelectedItem(r);
        } else {
            log.warn("Read address {}, but no such loco in roster", (Object)dccAddress);
            this._statusLabel.setText(Bundle.getMessage("ReadNoSuchLoco", dccAddress));
        }
    }

    protected void selectDecoder(int mfgID, int modelID, int productID) {
        this.iddecoder.setSelected(false);
        List<DecoderFile> temp = null;
        if (productID != -1) {
            String sz_productID = Integer.toString(productID);
            temp = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, Integer.toString(mfgID), Integer.toString(modelID), sz_productID, null);
            if (temp.isEmpty()) {
                log.debug("selectDecoder found no items with product ID {}", (Object)productID);
                temp = null;
            } else {
                log.debug("selectDecoder found {} matches with productID {}", (Object)temp.size(), (Object)productID);
            }
        }
        if (temp == null) {
            temp = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, Integer.toString(mfgID), Integer.toString(modelID), null, null);
            if (log.isDebugEnabled()) {
                log.debug("selectDecoder without productID found {} matches", (Object)temp.size());
            }
        }
        int tempOriginalSize = temp.size();
        String theFamily = "";
        String theModel = "";
        String lastWasFamily = "";
        ListIterator it = temp.listIterator();
        while (it.hasNext()) {
            log.debug("Match List size is currently {}, scanning for unwanted entries", (Object)temp.size());
            DecoderFile t = (DecoderFile)it.next();
            theFamily = t.getFamily();
            theModel = t.getModel();
            if (t.getFamily().equals(theModel)) {
                log.debug("Match List index={} is family entry '{}'", (Object)it.previousIndex(), (Object)theFamily);
                lastWasFamily = theFamily;
                continue;
            }
            if (lastWasFamily.equals(theFamily)) {
                log.debug("Match List index={} is first model '{}' in family '{}'", new Object[]{it.previousIndex(), theModel, theFamily});
                log.debug("Removing family entry '{}'", (Object)theFamily);
                t = (DecoderFile)it.previous();
                t = (DecoderFile)it.previous();
                it.remove();
                lastWasFamily = "";
                continue;
            }
            if (t.getModelElement().getAttribute("show") != null && t.getModelElement().getAttribute("show").getValue().equals("no")) {
                log.debug("Match List index={} is legacy model '{}' in family '{}'", new Object[]{it.previousIndex(), theModel, theFamily});
                log.debug("Removing legacy model '{}'", (Object)theModel);
                t = (DecoderFile)it.previous();
                it.remove();
                lastWasFamily = "";
                continue;
            }
            log.debug("Match List index={} is model '{}' in family '{}'", new Object[]{it.previousIndex(), theModel, theFamily});
            lastWasFamily = "";
        }
        log.debug("Final Match List size is {}", (Object)temp.size());
        if (tempOriginalSize > 0 && temp.isEmpty()) {
            log.debug("Filtering removed all matches so reverting to coarse match with mfgID='{}' & modelID='{}'", (Object)Integer.toString(mfgID), (Object)Integer.toString(modelID));
            temp = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, Integer.toString(mfgID), Integer.toString(modelID), null, null);
            log.debug("selectDecoder without productID found {} matches", (Object)temp.size());
        }
        if (temp.size() > 0) {
            this.updateForDecoderTypeID(temp);
        } else {
            String mfg = InstanceManager.getDefault(DecoderIndexFile.class).mfgNameFromID(Integer.toString(mfgID));
            if (mfg == null) {
                this.updateForDecoderNotID(mfgID, modelID);
            } else {
                this.updateForDecoderMfgID(mfg, mfgID, modelID);
            }
        }
    }

    void updateForDecoderTypeID(List<DecoderFile> pList) {
        this.decoderBox.setModel(DecoderIndexFile.jComboBoxModelFromList(pList));
        this.decoderBox.insertItemAt("<from locomotive settings>", 0);
        this.decoderBox.setSelectedIndex(1);
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="String also built for display in _statusLabel")
    void updateForDecoderMfgID(String pMfg, int pMfgID, int pModelID) {
        String msg = "Found mfg " + pMfgID + " (" + pMfg + ") version " + pModelID + "; no such decoder defined";
        log.warn(msg);
        this._statusLabel.setText(msg);
        JComboBox<String> temp = InstanceManager.getDefault(DecoderIndexFile.class).matchingComboBox(null, null, Integer.toString(pMfgID), null, null, null);
        if (log.isDebugEnabled()) {
            log.debug("mfg-only selectDecoder found {} matches", (Object)temp.getItemCount());
        }
        if (temp.getItemCount() > 0) {
            this.decoderBox.setModel(temp.getModel());
            this.decoderBox.insertItemAt("<from locomotive settings>", 0);
            this.decoderBox.setSelectedIndex(1);
        } else {
            temp = InstanceManager.getDefault(DecoderIndexFile.class).matchingComboBox(null, null, null, null, null, null);
            this.decoderBox.setModel(temp.getModel());
            this.decoderBox.insertItemAt("<from locomotive settings>", 0);
            this.decoderBox.setSelectedIndex(1);
        }
    }

    void updateForDecoderNotID(int pMfgID, int pModelID) {
        log.warn("Found mfg {} version {}; no such manufacturer defined", (Object)pMfgID, (Object)pModelID);
        JComboBox<String> temp = InstanceManager.getDefault(DecoderIndexFile.class).matchingComboBox(null, null, null, null, null, null);
        this.decoderBox.setModel(temp.getModel());
        this.decoderBox.insertItemAt("<from locomotive settings>", 0);
        this.decoderBox.setSelectedIndex(1);
    }

    protected void openButton() {
        if (this.locoBox.getSelectedRosterEntries().length != 0) {
            this.openKnownLoco();
        } else if (this.isDecoderSelected()) {
            this.openNewLoco();
        } else {
            log.error("openButton with neither combobox nonzero");
        }
    }

    protected void openKnownLoco() {
        if (this.locoBox.getSelectedRosterEntries().length != 0) {
            RosterEntry re = this.locoBox.getSelectedRosterEntries()[0];
            if (log.isDebugEnabled()) {
                log.debug("loco file: {}", (Object)re.getFileName());
            }
            this.startProgrammer(null, re, (String)this.programmerBox.getSelectedItem());
        } else {
            log.error("No roster entry was selected to open.");
        }
    }

    protected void openNewLoco() {
        DecoderFile decoderFile = InstanceManager.getDefault(DecoderIndexFile.class).fileFromTitle(this.selectedDecoderType());
        if (log.isDebugEnabled()) {
            log.debug("decoder file: {}", (Object)decoderFile.getFileName());
        }
        RosterEntry re = new RosterEntry();
        re.setDecoderFamily(decoderFile.getFamily());
        re.setDecoderModel(decoderFile.getModel());
        re.setId(Bundle.getMessage("LabelNewDecoder"));
        Roster.getDefault().addEntry(re);
        this.startProgrammer(decoderFile, re, (String)this.programmerBox.getSelectedItem());
    }

    protected void startProgrammer(@CheckForNull DecoderFile decoderFile, @Nonnull RosterEntry r, @Nonnull String progName) {
        log.error("startProgrammer method in CombinedLocoSelPane should have been overridden");
    }
}

