/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import jmri.jmrit.symbolicprog.AbstractValue;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.VariableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantValue
extends VariableValue {
    JComboBox<Integer> _value = null;
    String[] _itemArray = null;
    int _nstored;
    private int _maxVal;
    private int _minVal;
    Color _defaultColor;
    List<JCheckBox> comboCBs = new ArrayList<JCheckBox>();
    List<JRadioButton> comboRBs = new ArrayList<JRadioButton>();
    private static final Logger log = LoggerFactory.getLogger(ConstantValue.class);

    public ConstantValue(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname) {
        super(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, v, status, stdname);
        this._maxVal = maxVal;
        this._minVal = minVal;
        this._value = new JComboBox();
        for (int i = 0; i <= maxVal; ++i) {
            this._value.addItem(i);
        }
    }

    public ConstantValue() {
    }

    @Override
    public CvValue[] usesCVs() {
        return new CvValue[0];
    }

    @Override
    public String getCvDescription() {
        return null;
    }

    @Override
    public void setToolTipText(String t) {
        super.setToolTipText(t);
        this._value.setToolTipText(t);
    }

    @Override
    public Object rangeVal() {
        return "constant: " + this._minVal + " - " + this._maxVal;
    }

    @Override
    public String getValueString() {
        return "" + this._value.getSelectedIndex();
    }

    @Override
    public void setIntValue(int i) {
        this._value.setSelectedIndex(i);
    }

    @Override
    public int getIntValue() {
        return this._value.getSelectedIndex();
    }

    @Override
    public Object getValueObject() {
        return this._value.getSelectedIndex();
    }

    @Override
    public Component getCommonRep() {
        return this._value;
    }

    public void setValue(int value) {
        int oldVal = this._value.getSelectedIndex();
        this._value.setSelectedIndex(value);
        if (oldVal != value || this.getState() == AbstractValue.ValueState.UNKNOWN) {
            this.prop.firePropertyChange("Value", null, (Object)value);
        }
    }

    @Override
    public Component getNewRep(String format) {
        if (format.equals("checkbox")) {
            JCheckBox b = new JCheckBox();
            b.setEnabled(false);
            b.setSelected(this.getIntValue() == 1);
            this.comboCBs.add(b);
            this.updateRepresentation(b);
            return b;
        }
        if (format.equals("radiobuttons")) {
            JRadioButton b = new JRadioButton();
            this.comboRBs.add(b);
            this.updateRepresentation(b);
            return b;
        }
        if (format.equals("onradiobutton")) {
            JRadioButton b = new JRadioButton();
            this.comboRBs.add(b);
            this.updateRepresentation(b);
            return b;
        }
        if (format.equals("offradiobutton")) {
            JRadioButton b = new JRadioButton();
            this.comboRBs.add(b);
            this.updateRepresentation(b);
            return b;
        }
        log.error("Did not recognize a value format: {}", (Object)format);
        return null;
    }

    @Override
    void setColor(Color c) {
    }

    @Override
    public void setCvState(AbstractValue.ValueState state) {
    }

    @Override
    public boolean isChanged() {
        return false;
    }

    @Override
    public void setToRead(boolean state) {
    }

    @Override
    public boolean isToRead() {
        return false;
    }

    @Override
    public void setToWrite(boolean state) {
    }

    @Override
    public boolean isToWrite() {
        return false;
    }

    @Override
    public void readChanges() {
        if (this.isChanged()) {
            this.readAll();
        }
    }

    @Override
    public void writeChanges() {
        if (this.isChanged()) {
            this.writeAll();
        }
    }

    @Override
    public void readAll() {
        log.debug("read invoked");
        this.setToRead(false);
        this.setState(AbstractValue.ValueState.READ);
        this.setBusy(true);
        this.setBusy(false);
    }

    @Override
    public void writeAll() {
        log.debug("write invoked");
        this.setToWrite(false);
        this.setState(AbstractValue.ValueState.STORED);
        this.setBusy(true);
        this.setBusy(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.warn("Unexpected propertyChange: {}", (Object)e);
    }

    @Override
    public void dispose() {
        log.debug("dispose");
        this._value = null;
    }
}

