/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.util.swing.JmriJFileChooser;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvExportAction
extends AbstractAction {
    JFileChooser fileChooser;
    JFrame mParent;
    CvTableModel mModel;
    private static final Logger log = LoggerFactory.getLogger(CsvExportAction.class);

    public CsvExportAction(String actionName, CvTableModel pModel, JFrame pParent) {
        super(actionName);
        this.mModel = pModel;
        this.mParent = pParent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int retVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JmriJFileChooser();
        }
        if ((retVal = this.fileChooser.showSaveDialog(this.mParent)) == 0) {
            File file = this.fileChooser.getSelectedFile();
            if (log.isDebugEnabled()) {
                log.debug("start to export to CSV file {}", (Object)file);
            }
            try (CSVPrinter str = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), CSVFormat.DEFAULT);){
                str.printRecord(new Object[]{"CV", "value"});
                for (int i = 0; i < this.mModel.getRowCount(); ++i) {
                    CvValue cv = this.mModel.getCvByRow(i);
                    if (!this.isWritable(cv)) continue;
                    String num = cv.number();
                    int value = cv.getValue();
                    str.printRecord(new Object[]{num, value});
                }
                str.flush();
            }
            catch (IOException ex) {
                log.error("Error writing file", (Throwable)ex);
            }
        }
    }

    protected boolean isWritable(CvValue cv) {
        return true;
    }
}

