/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jmri.Programmer;
import jmri.jmrit.symbolicprog.AbstractValue;
import jmri.jmrit.symbolicprog.Bundle;
import jmri.jmrit.symbolicprog.CvValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvTableModel
extends AbstractTableModel
implements ActionListener,
PropertyChangeListener {
    private int _numRows = 0;
    static final int MAXCVNUM = 1024;
    private Vector<CvValue> _cvDisplayVector = new Vector();
    private HashMap<String, CvValue> _cvAllMap = new HashMap();
    private Vector<JButton> _writeButtons = new Vector();
    private Vector<JButton> _readButtons = new Vector();
    private Vector<JButton> _compareButtons = new Vector();
    private Programmer mProgrammer;
    public static final int NUMCOLUMN = 0;
    private static final int VALCOLUMN = 1;
    private static final int STATECOLUMN = 2;
    private static final int READCOLUMN = 3;
    private static final int WRITECOLUMN = 4;
    private static final int COMPARECOLUMN = 5;
    private static final int HIGHESTCOLUMN = 6;
    private static final int HIGHESTNOPROG = 3;
    private JLabel _status = null;
    private HashMap<String, Set<String>> cvToVarMap = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(CvTableModel.class);

    public HashMap<String, CvValue> allCvMap() {
        return this._cvAllMap;
    }

    public JLabel getStatusLabel() {
        return this._status;
    }

    public CvTableModel(JLabel status, Programmer pProgrammer) {
        this.mProgrammer = pProgrammer;
        this._status = status;
    }

    public void setNoDecoder() {
        for (JButton b : this._readButtons) {
            b.setEnabled(false);
        }
        for (JButton b : this._writeButtons) {
            b.setEnabled(false);
        }
        for (JButton b : this._compareButtons) {
            b.setEnabled(false);
        }
    }

    public Programmer getProgrammer() {
        return this.mProgrammer;
    }

    public void setProgrammer(Programmer p) {
        this.mProgrammer = p;
        for (CvValue cv : this.allCvMap().values()) {
            if (cv == null) continue;
            cv.setProgrammer(p);
        }
        for (CvValue cv : this._cvDisplayVector) {
            if (cv == null) continue;
            cv.setProgrammer(p);
        }
    }

    @Override
    public int getRowCount() {
        return this._numRows;
    }

    @Override
    public int getColumnCount() {
        if (this.getProgrammer() != null) {
            return 6;
        }
        return 3;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColumnNameNumber");
            }
            case 1: {
                return Bundle.getMessage("ColumnNameValue");
            }
            case 2: {
                return Bundle.getMessage("ColumnNameState");
            }
            case 3: {
                return Bundle.getMessage("ColumnNameRead");
            }
            case 4: {
                return Bundle.getMessage("ColumnNameWrite");
            }
            case 5: {
                return Bundle.getMessage("ColumnNameCompare");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return JTextField.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return JButton.class;
            }
            case 4: {
                return JButton.class;
            }
            case 5: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return false;
            }
            case 1: {
                return !this._cvDisplayVector.elementAt(row).getReadOnly() && !this._cvDisplayVector.elementAt(row).getInfoOnly();
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public String getName(int row) {
        return this._cvDisplayVector.elementAt(row).number();
    }

    public String getValString(int row) {
        return "" + this._cvDisplayVector.elementAt(row).getValue();
    }

    public CvValue getCvByRow(int row) {
        return this._cvDisplayVector.elementAt(row);
    }

    public CvValue getCvByNumber(String number) {
        return this._cvAllMap.get(number);
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this._cvDisplayVector.elementAt(row).number();
            }
            case 1: {
                return this._cvDisplayVector.elementAt(row).getTableEntry();
            }
            case 2: {
                AbstractValue.ValueState state = this._cvDisplayVector.elementAt(row).getState();
                switch (state) {
                    case UNKNOWN: {
                        return Bundle.getMessage("CvStateUnknown");
                    }
                    case READ: {
                        return Bundle.getMessage("CvStateRead");
                    }
                    case EDITED: {
                        return Bundle.getMessage("CvStateEdited");
                    }
                    case STORED: {
                        return Bundle.getMessage("CvStateStored");
                    }
                    case FROMFILE: {
                        return Bundle.getMessage("CvStateFromFile");
                    }
                    case SAME: {
                        return Bundle.getMessage("CvStateSame");
                    }
                    case DIFFERENT: {
                        return Bundle.getMessage("CvStateDiff") + " " + this._cvDisplayVector.elementAt(row).getDecoderValue();
                    }
                }
                return "inconsistent";
            }
            case 3: {
                return this._readButtons.elementAt(row);
            }
            case 4: {
                return this._writeButtons.elementAt(row);
            }
            case 5: {
                return this._compareButtons.elementAt(row);
            }
        }
        return "unknown";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 1: {
                if (this._cvDisplayVector.elementAt(row).getValue() == ((Integer)value).intValue()) break;
                this._cvDisplayVector.elementAt(row).setValue((Integer)value);
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("action command: {}", (Object)e.getActionCommand());
        }
        char b = e.getActionCommand().charAt(0);
        int row = Integer.parseInt(e.getActionCommand().substring(1));
        if (log.isDebugEnabled()) {
            log.debug("event on {} row {}", (Object)Character.valueOf(b), (Object)row);
        }
        if (b == 'R') {
            this._cvDisplayVector.elementAt(row).read(this._status);
        } else if (b == 'C') {
            this._cvDisplayVector.elementAt(row).confirm(this._status);
        } else {
            this._cvDisplayVector.elementAt(row).write(this._status);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!e.getPropertyName().equals("Busy")) {
            this.fireTableDataChanged();
        }
    }

    public void addCV(String s, boolean readOnly, boolean infoOnly, boolean writeOnly) {
        CvValue cv;
        if (this._cvAllMap.get(s) == null) {
            cv = new CvValue(s, this.mProgrammer);
            cv.setReadOnly(readOnly);
            this._cvAllMap.put(s, cv);
            this._cvDisplayVector.addElement(cv);
            cv.addPropertyChangeListener(this);
            JButton bw = new JButton(Bundle.getMessage("ButtonWrite"));
            this._writeButtons.addElement(bw);
            JButton br = new JButton(Bundle.getMessage("ButtonRead"));
            this._readButtons.addElement(br);
            JButton bc = new JButton(Bundle.getMessage("ButtonCompare"));
            this._compareButtons.addElement(bc);
            if (infoOnly || readOnly) {
                if (writeOnly) {
                    bw.setEnabled(true);
                    bw.setActionCommand("W" + this._numRows);
                    bw.addActionListener(this);
                } else {
                    bw.setEnabled(false);
                }
                if (infoOnly) {
                    br.setEnabled(false);
                    bc.setEnabled(false);
                } else {
                    br.setEnabled(true);
                    br.setActionCommand("R" + this._numRows);
                    br.addActionListener(this);
                    bc.setEnabled(true);
                    bc.setActionCommand("C" + this._numRows);
                    bc.addActionListener(this);
                }
            } else {
                bw.setEnabled(true);
                bw.setActionCommand("W" + this._numRows);
                bw.addActionListener(this);
                if (writeOnly) {
                    br.setEnabled(false);
                    bc.setEnabled(false);
                } else {
                    br.setEnabled(true);
                    br.setActionCommand("R" + this._numRows);
                    br.addActionListener(this);
                    bc.setEnabled(true);
                    bc.setActionCommand("C" + this._numRows);
                    bc.addActionListener(this);
                }
            }
            ++this._numRows;
            this.fireTableDataChanged();
        }
        cv = this._cvAllMap.get(s);
        if (readOnly) {
            cv.setReadOnly(readOnly);
        }
        if (infoOnly) {
            cv.setReadOnly(!infoOnly);
            cv.setWriteOnly(!infoOnly);
            cv.setInfoOnly(infoOnly);
        }
        if (writeOnly) {
            cv.setWriteOnly(writeOnly);
        }
    }

    public boolean decoderDirty() {
        int len = this._cvDisplayVector.size();
        for (int i = 0; i < len; ++i) {
            if (this._cvDisplayVector.elementAt(i).getState() != AbstractValue.ValueState.EDITED) continue;
            if (log.isDebugEnabled()) {
                log.debug("CV decoder dirty due to {}", (Object)this._cvDisplayVector.elementAt(i).number());
            }
            return true;
        }
        return false;
    }

    public void registerCvToVariableMapping(String cv, String variableName) {
        if (!this.cvToVarMap.containsKey(cv)) {
            this.cvToVarMap.put(cv, Collections.newSetFromMap(new HashMap()));
        }
        this.cvToVarMap.get(cv).add(variableName);
    }

    public Set<String> getCvToVariableMapping(String cv) {
        return this.cvToVarMap.get(cv);
    }

    public void dispose() {
        int i;
        if (log.isDebugEnabled()) {
            log.debug("dispose");
        }
        for (i = 0; i < this._writeButtons.size(); ++i) {
            this._writeButtons.elementAt(i).removeActionListener(this);
        }
        for (i = 0; i < this._readButtons.size(); ++i) {
            this._readButtons.elementAt(i).removeActionListener(this);
        }
        for (i = 0; i < this._compareButtons.size(); ++i) {
            this._compareButtons.elementAt(i).removeActionListener(this);
        }
        for (i = 0; i < this._cvDisplayVector.size(); ++i) {
            this._cvDisplayVector.elementAt(i).removePropertyChangeListener(this);
        }
        this.cvToVarMap = null;
        this._cvDisplayVector.removeAllElements();
        this._cvDisplayVector = null;
        this._writeButtons.removeAllElements();
        this._writeButtons = null;
        this._readButtons.removeAllElements();
        this._readButtons = null;
        this._compareButtons.removeAllElements();
        this._compareButtons = null;
        this._cvAllMap.clear();
        this._cvAllMap = null;
        this._status = null;
    }

    int holdsAddress() {
        int shortAddr = this.getCvByNumber("1").getValue();
        int longAddr = (this.getCvByNumber("17").getValue() - 192 << 8) + this.getCvByNumber("18").getValue();
        int addr = this.holdsLongAddress() ? longAddr : shortAddr;
        return addr;
    }

    boolean holdsLongAddress() {
        return (this.getCvByNumber("29").getValue() & 0x20) != 0;
    }
}

