/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import jmri.jmrit.symbolicprog.AbstractValue;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.DecVarSlider;
import jmri.jmrit.symbolicprog.VariableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecVariableValue
extends VariableValue
implements ActionListener,
FocusListener {
    int _maxVal;
    int _minVal;
    int _offset;
    int _factor;
    String oldContents = "";
    List<Component> reps = new ArrayList<Component>();
    ArrayList<DecVarSlider> sliders = new ArrayList();
    Color _defaultColor;
    JTextField _value;
    private static final Logger log = LoggerFactory.getLogger(DecVariableValue.class);

    public DecVariableValue(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname) {
        this(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, minVal, maxVal, v, status, stdname, 0, 1);
    }

    public DecVariableValue(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, int offset, int factor) {
        super(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, v, status, stdname);
        this._maxVal = maxVal;
        this._minVal = minVal;
        this._offset = offset;
        this._factor = factor;
        this._value = new JTextField("0", this.fieldLength());
        this._value.getAccessibleContext().setAccessibleName(this.label());
        this._defaultColor = this._value.getBackground();
        this._value.setBackground(AbstractValue.ValueState.UNKNOWN.getColor());
        this._value.addActionListener(this);
        this._value.addFocusListener(this);
        CvValue cv = (CvValue)this._cvMap.get(this.getCvNum());
        cv.addPropertyChangeListener(this);
        cv.setState(AbstractValue.ValueState.FROMFILE);
        this.simplifyMask();
    }

    @Override
    public void setToolTipText(String t) {
        super.setToolTipText(t);
        this._value.setToolTipText(t);
    }

    int fieldLength() {
        if (this._maxVal <= 255) {
            return 3;
        }
        return (int)Math.ceil(Math.log10(this._maxVal)) + 1;
    }

    @Override
    public CvValue[] usesCVs() {
        return new CvValue[]{(CvValue)this._cvMap.get(this.getCvNum())};
    }

    @Override
    public Object rangeVal() {
        return "Decimal: " + this._minVal + " - " + this._maxVal;
    }

    void enterField() {
        this.oldContents = this._value.getText();
    }

    int textToValue(String s) {
        return Integer.parseInt(s);
    }

    String valueToText(int v) {
        return Integer.toString(v);
    }

    void exitField() {
        block7: {
            if (this._value == null) {
                return;
            }
            if (!this._value.getText().equals("")) {
                if (!this.oldContents.equals(this._value.getText())) {
                    try {
                        int newVal = this.textToValue(this._value.getText());
                        int oldVal = this.textToValue(this.oldContents);
                        if (newVal < this._minVal || newVal > this._maxVal) {
                            this._value.setText(this.oldContents);
                            break block7;
                        }
                        this.updatedTextField();
                        this.prop.firePropertyChange("Value", oldVal, newVal);
                    }
                    catch (NumberFormatException ex) {
                        this._value.setText(this.oldContents);
                    }
                }
            } else {
                this._value.setText(this.oldContents);
            }
        }
    }

    @Override
    void updatedTextField() {
        int newVal;
        log.debug("updatedTextField");
        CvValue cv = (CvValue)this._cvMap.get(this.getCvNum());
        int oldCvVal = cv.getValue();
        try {
            newVal = this.textToValue(this._value.getText());
        }
        catch (NumberFormatException ex) {
            newVal = 0;
        }
        int transfer = Math.max(newVal - this._offset, 0);
        if (this._factor != 0) {
            transfer /= this._factor;
        } else {
            log.error("Variable param 'factor' = 0 not valid; Decoder definition needs correction");
        }
        int newCvVal = this.setValueInCV(oldCvVal, transfer, this.getMask(), this._maxVal);
        log.debug("newVal={} transfer={} newCvVal ={}", new Object[]{newVal, transfer, newCvVal});
        if (oldCvVal != newCvVal) {
            cv.setValue(newCvVal);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("actionPerformed");
        try {
            int newVal = this.textToValue(this._value.getText());
            if (newVal < this._minVal || newVal > this._maxVal) {
                this._value.setText(this.oldContents);
            } else {
                this.updatedTextField();
                this.prop.firePropertyChange("Value", null, (Object)newVal);
            }
        }
        catch (NumberFormatException ex) {
            this._value.setText(this.oldContents);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        log.debug("focusGained");
        this.enterField();
    }

    @Override
    public void focusLost(FocusEvent e) {
        log.debug("focusLost");
        this.exitField();
    }

    @Override
    public String getValueString() {
        return this._value.getText();
    }

    @Override
    public void setIntValue(int i) {
        this.setValue(i);
    }

    @Override
    public int getIntValue() {
        return this.textToValue(this._value.getText());
    }

    @Override
    public Object getValueObject() {
        return Integer.valueOf(this._value.getText());
    }

    @Override
    public Component getCommonRep() {
        if (this.getReadOnly()) {
            JLabel r = new JLabel(this._value.getText());
            this.reps.add(r);
            this.updateRepresentation(r);
            return r;
        }
        return this._value;
    }

    @Override
    public void setAvailable(boolean a) {
        this._value.setVisible(a);
        for (Component c : this.reps) {
            c.setVisible(a);
        }
        super.setAvailable(a);
    }

    @Override
    public Component getNewRep(String format) {
        switch (format) {
            case "vslider": {
                DecVarSlider b = new DecVarSlider(this, this._minVal, this._maxVal);
                b.setOrientation(1);
                this.sliders.add(b);
                this.reps.add(b);
                this.updateRepresentation(b);
                return b;
            }
            case "hslider": {
                DecVarSlider b = new DecVarSlider(this, this._minVal, this._maxVal);
                b.setOrientation(0);
                this.sliders.add(b);
                this.reps.add(b);
                this.updateRepresentation(b);
                return b;
            }
            case "hslider-percent": {
                DecVarSlider b = new DecVarSlider(this, this._minVal, this._maxVal);
                b.setOrientation(0);
                if (this._maxVal > 20) {
                    b.setMajorTickSpacing(this._maxVal / 2);
                    b.setMinorTickSpacing((this._maxVal + 1) / 8);
                } else {
                    b.setMajorTickSpacing(5);
                    b.setMinorTickSpacing(1);
                    b.setSnapToTicks(true);
                }
                b.setSize(b.getWidth(), 28);
                Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
                labelTable.put(0, new JLabel("0%"));
                if (this._maxVal == 63) {
                    labelTable.put(this._maxVal / 2, new JLabel("25%"));
                    labelTable.put(this._maxVal, new JLabel("50%"));
                } else {
                    labelTable.put(this._maxVal / 2, new JLabel("50%"));
                    labelTable.put(this._maxVal, new JLabel("100%"));
                }
                b.setLabelTable(labelTable);
                b.setPaintTicks(true);
                b.setPaintLabels(true);
                this.sliders.add(b);
                this.updateRepresentation(b);
                if (!this.getAvailable()) {
                    b.setVisible(false);
                }
                return b;
            }
        }
        VarTextField value = new VarTextField(this._value.getDocument(), this._value.getText(), this.fieldLength(), this);
        if (this.getReadOnly() || this.getInfoOnly()) {
            value.setEditable(false);
        }
        this.reps.add(value);
        this.updateRepresentation(value);
        return value;
    }

    public void setValue(int value) {
        int oldVal;
        try {
            oldVal = this.textToValue(this._value.getText());
        }
        catch (NumberFormatException ex) {
            oldVal = -999;
        }
        if (value < this._minVal) {
            value = this._minVal;
        }
        if (value > this._maxVal) {
            value = this._maxVal;
        }
        log.debug("setValue with new value {} old value {}", (Object)value, (Object)oldVal);
        if (oldVal != value) {
            this._value.setText(this.valueToText(value));
            this.updatedTextField();
            this.prop.firePropertyChange("Value", (Object)oldVal, (Object)value);
        }
    }

    Color getDefaultColor() {
        return this._defaultColor;
    }

    Color getColor() {
        return this._value.getBackground();
    }

    @Override
    void setColor(Color c) {
        if (c != null) {
            this._value.setBackground(c);
        } else {
            this._value.setBackground(this._defaultColor);
        }
    }

    @Override
    public void setCvState(AbstractValue.ValueState state) {
        ((CvValue)this._cvMap.get(this.getCvNum())).setState(state);
    }

    @Override
    public boolean isChanged() {
        CvValue cv = (CvValue)this._cvMap.get(this.getCvNum());
        log.debug("isChanged for {} state {}", (Object)this.getCvNum(), (Object)cv.getState());
        return DecVariableValue.considerChanged(cv);
    }

    @Override
    public void readChanges() {
        if (this.isChanged()) {
            this.readAll();
        }
    }

    @Override
    public void writeChanges() {
        if (this.isChanged()) {
            this.writeAll();
        }
    }

    @Override
    public void readAll() {
        this.setToRead(false);
        this.setBusy(true);
        ((CvValue)this._cvMap.get(this.getCvNum())).read(this._status);
    }

    @Override
    public void writeAll() {
        this.setToWrite(false);
        if (this.getReadOnly()) {
            log.error("unexpected write operation when readOnly is set");
        }
        this.setBusy(true);
        ((CvValue)this._cvMap.get(this.getCvNum())).write(this._status);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("Property changed: {}", (Object)e.getPropertyName());
        }
        if (e.getPropertyName().equals("Busy")) {
            if (e.getNewValue().equals(Boolean.FALSE)) {
                this.setToRead(false);
                this.setToWrite(false);
                this.setBusy(false);
            }
        } else if (e.getPropertyName().equals("State")) {
            CvValue cv = (CvValue)this._cvMap.get(this.getCvNum());
            if (cv.getState() == AbstractValue.ValueState.STORED) {
                this.setToWrite(false);
            }
            if (cv.getState() == AbstractValue.ValueState.READ) {
                this.setToRead(false);
            }
            this.setState(cv.getState());
        } else if (e.getPropertyName().equals("Value")) {
            CvValue cv = (CvValue)this._cvMap.get(this.getCvNum());
            int transfer = this.getValueInCV(cv.getValue(), this.getMask(), this._maxVal);
            int newVal = transfer * this._factor + this._offset;
            this.setValue(newVal);
        }
    }

    @Override
    public void dispose() {
        log.debug("dispose");
        if (this._value != null) {
            this._value.removeActionListener(this);
        }
        ((CvValue)this._cvMap.get(this.getCvNum())).removePropertyChangeListener(this);
        this._value = null;
    }

    public class VarTextField
    extends JTextField {
        DecVariableValue _var;

        VarTextField(Document doc, String text, int col, DecVariableValue var) {
            super(doc, text, col);
            this._var = var;
            this.setBackground(this._var._value.getBackground());
            this.addActionListener(this::thisActionPerformed);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    log.debug("focusGained");
                    DecVariableValue.this.enterField();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    log.debug("focusLost");
                    DecVariableValue.this.exitField();
                }
            });
            this._var.addPropertyChangeListener(this::originalPropertyChanged);
        }

        void thisActionPerformed(ActionEvent e) {
            this._var.actionPerformed(e);
        }

        void originalPropertyChanged(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("State")) {
                this.setBackground(this._var._value.getBackground());
            }
        }
    }
}

