/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;
import jmri.Programmer;
import jmri.ProgrammingMode;
import jmri.jmrit.symbolicprog.AbstractValue;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.util.jdom.LocaleSelector;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtraMenuTableModel
extends AbstractTableModel
implements ActionListener,
PropertyChangeListener {
    private String[] headers = new String[]{"Label", "Name", "Value", "Write", "State"};
    private List<CvValue> rowVector = new ArrayList<CvValue>();
    private List<String> labelVector = new ArrayList<String>();
    private List<List<String>> modeVector = new ArrayList<List<String>>();
    private List<JButton> _writeButtons = new ArrayList<JButton>();
    private JLabel _status = null;
    private Programmer mProgrammer;
    String name = "<default>";
    private boolean hasOpsModeFlag = false;
    private ProgrammingMode savedMode;
    private String decoderModel;
    private int _progState = 0;
    private static final int IDLE = 0;
    private static final int WRITING_CV = 3;
    private static final Logger log = LoggerFactory.getLogger(ExtraMenuTableModel.class);

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public ExtraMenuTableModel(JLabel status, Programmer pProgrammer) {
        this.mProgrammer = pProgrammer;
        this._status = status;
    }

    public String toString() {
        return "Element id: " + this.getTopLevelElementName() + " name: " + this.name + ": " + this.rowVector.size() + " rows";
    }

    public void setProgrammer(Programmer p) {
        this.mProgrammer = p;
        this.rowVector.forEach(cv -> cv.setProgrammer(p));
    }

    protected void flagIfOpsMode(String mode) {
        log.trace(" flagIfOpsMode {}", (Object)mode);
        if (mode.contains("OPS")) {
            this.hasOpsModeFlag = true;
        }
    }

    public boolean hasOpsModeReset() {
        return this.hasOpsModeFlag;
    }

    @Override
    public int getRowCount() {
        return this.rowVector.size();
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.rowVector.size()) {
            log.debug("row greater than row vector");
            return "Error";
        }
        CvValue cv = this.rowVector.get(row);
        if (cv == null) {
            log.debug("cv is null!");
            return "Error CV";
        }
        switch (this.headers[col]) {
            case "Label": {
                return this.labelVector.get(row);
            }
            case "Name": {
                return cv.cvName();
            }
            case "Value": {
                return "" + cv.getValue();
            }
            case "Write": {
                return this._writeButtons.get(row);
            }
            case "State": {
                AbstractValue.ValueState state = cv.getState();
                switch (state) {
                    case UNKNOWN: {
                        return "Unknown";
                    }
                    case READ: {
                        return "Read";
                    }
                    case EDITED: {
                        return "Edited";
                    }
                    case STORED: {
                        return "Stored";
                    }
                    case FROMFILE: {
                        return "From file";
                    }
                }
                return "inconsistent";
            }
        }
        return "hmmm ... missed it";
    }

    public void setRow(int row, Element e, Element p, String model) {
        this.decoderModel = model;
        String label = LocaleSelector.getAttribute(e, "label");
        log.debug("Starting to setRow \"{}\"", (Object)label);
        String cv = e.getAttribute("CV").getValue();
        int cvVal = Integer.parseInt(e.getAttribute("default").getValue());
        log.debug("            CV \"{}\" value {}", (Object)cv, (Object)cvVal);
        CvValue resetCV = new CvValue(cv, this.mProgrammer);
        resetCV.addPropertyChangeListener(this);
        resetCV.setValue(cvVal);
        resetCV.setWriteOnly(true);
        resetCV.setState(AbstractValue.ValueState.STORED);
        this.rowVector.add(resetCV);
        this.labelVector.add(label);
        this.modeVector.add(this.getResetModeList(e, p));
    }

    protected List<String> getResetModeList(Element e, Element p) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        ArrayList<String> modeList = new ArrayList<String>();
        boolean resetsModeFound = false;
        elementList.add(p);
        elementList.add(e);
        for (Element ep : elementList) {
            try {
                String mode = ep.getAttribute("mode").getValue();
                if (ep.getName().equals(this.getTopLevelElementName())) {
                    resetsModeFound = true;
                } else if (resetsModeFound) {
                    modeList.clear();
                    resetsModeFound = false;
                }
                modeList.add(mode);
                this.flagIfOpsMode(mode);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            try {
                List elementModes = ep.getChildren("mode");
                for (Element s : elementModes) {
                    if (ep.getName().equals(this.getTopLevelElementName())) {
                        resetsModeFound = true;
                    } else if (resetsModeFound) {
                        modeList.clear();
                        resetsModeFound = false;
                    }
                    modeList.add(s.getText());
                    this.flagIfOpsMode(s.getText());
                }
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        return modeList;
    }

    public String getTopLevelElementName() {
        return "resets";
    }

    public String getIndividualElementName() {
        return "factReset";
    }

    protected void performReset(int row) {
        this.savedMode = this.mProgrammer.getMode();
        if (this.modeVector.get(row) != null) {
            List<ProgrammingMode> modes = this.mProgrammer.getSupportedModes();
            List<String> validModes = this.modeVector.get(row);
            StringBuilder programmerModeListBuffer = new StringBuilder("");
            modes.forEach(m -> programmerModeListBuffer.append(",").append(m.toString()));
            String programmerModeList = programmerModeListBuffer.toString();
            if (programmerModeList.length() <= 1) {
                programmerModeList = "";
            } else if (programmerModeList.startsWith(",")) {
                programmerModeList = programmerModeList.substring(1);
            }
            StringBuilder resetModeBuilder = new StringBuilder("");
            validModes.forEach(mode -> resetModeBuilder.append(",").append(new ProgrammingMode((String)mode).toString()));
            String resetModeList = resetModeBuilder.toString();
            if (resetModeList.length() <= 1) {
                resetModeList = "";
            } else if (resetModeList.startsWith(",")) {
                resetModeList = resetModeList.substring(1);
            }
            if (resetModeList.length() > 0) {
                boolean modeFound = false;
                block0: for (ProgrammingMode m2 : modes) {
                    for (String mode2 : validModes) {
                        if (!mode2.equals(m2.getStandardName())) continue;
                        this.mProgrammer.setMode(m2);
                        modeFound = true;
                        break block0;
                    }
                }
                if (this.mProgrammer.getMode().getStandardName().contains("OPS") && !this.opsResetOk()) {
                    return;
                }
                if (!modeFound) {
                    if (!this.badModeOk(this.savedMode.toString(), resetModeList, programmerModeList)) {
                        return;
                    }
                    log.warn("{} for {} was attempted in {} mode.", new Object[]{this.labelVector.get(row), this.decoderModel, this.savedMode});
                    log.warn("Recommended mode(s) were \"{}\" but available modes were \"{}\"", (Object)resetModeList, (Object)programmerModeList);
                }
            }
        }
        CvValue cv = this.rowVector.get(row);
        log.debug("performReset: {}", (Object)cv);
        this._progState = 3;
        cv.write(this._status);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("action command: {}", (Object)e.getActionCommand());
        char b = e.getActionCommand().charAt(0);
        int row = Integer.parseInt(e.getActionCommand().substring(1));
        log.debug("event on {} row {}", (Object)Character.valueOf(b), (Object)row);
        if (b == 'W') {
            this.performReset(row);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property changed: {}", (Object)e.getPropertyName());
        if (e.getPropertyName().equals("Busy") && ((Boolean)e.getNewValue()).equals(Boolean.FALSE)) {
            switch (this._progState) {
                case 0: {
                    log.debug("Busy goes false with state IDLE");
                    return;
                }
                case 3: {
                    log.debug("Finished writing the CV");
                    this.mProgrammer.setMode(this.savedMode);
                    this._progState = 0;
                    return;
                }
            }
            log.error("Unexpected state found: {}", (Object)this._progState);
            this.mProgrammer.setMode(this.savedMode);
            this._progState = 0;
        }
    }

    boolean badModeOk(String currentMode, String resetModes, String availableModes) {
        return true;
    }

    boolean opsResetOk() {
        return true;
    }

    public void dispose() {
        int i;
        log.debug("dispose");
        for (i = 0; i < this._writeButtons.size(); ++i) {
            this._writeButtons.get(i).removeActionListener(this);
        }
        this._writeButtons.clear();
        this._writeButtons = null;
        for (i = 0; i < this.rowVector.size(); ++i) {
            CvValue cv = this.rowVector.get(i);
            cv.dispose();
        }
        this.rowVector.clear();
        this.rowVector = null;
        this.labelVector.clear();
        this.labelVector = null;
        this.modeVector.clear();
        this.modeVector = null;
        this.headers = null;
        this._status = null;
    }
}

