/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.stream.IntStream;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.AbstractValue;
import jmri.jmrit.symbolicprog.Bundle;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrit.symbolicprog.VariableValue;
import jmri.util.CvUtil;
import jmri.util.FileUtil;
import jmri.util.jdom.LocaleSelector;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Parent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FnMapPanelESU
extends JPanel {
    int firstCol = 0;
    int firstOut = 2;
    int currentCol = this.firstCol;
    static final int HINTS_ROW = 0;
    static final int MOVE_ARROWS_TOP_ROW = 1;
    static final int BLOCK_NAME_ROW = 1;
    static final int FIRST_ROW = 3;
    static final int ROW_LABEL_ROW = 2;
    int currentRow = 3;
    static final int PI_CV = 16;
    static final int SI_START_CV = 2;
    static final int SI_CV_MODULUS = 16;
    static final int START_CV = 257;
    static final int CV_PAGE_MODULUS = 256;
    static final int BIT_MODULUS = 8;
    GridBagLayout gl = null;
    GridBagConstraints cs = null;
    VariableTableModel varModel;
    String[] outBlockName;
    int[] outBlockLength;
    int[] outBlockSiStartCv;
    int[] outBlockSiCvModulus;
    int[] outBlockStartCv;
    int[] outBlockCvModulus;
    int[] outBlockItemBits;
    int[] outBlockStartCol;
    int[] outBlockUsed;
    JTextField[][] summaryLine;
    int maxItems;
    String[] itemDescESU;
    String[] itemLabel;
    String[][] itemName;
    boolean[] itemIsUsed;
    int[][] iVarIndex;
    String extFnsESU = "no";
    int numItems = -1;
    int numFns = 1;
    int numRows = 5;
    int numOuts;
    int numOutsFromDefinition = this.numOuts = 2;
    int numStates = 2;
    int numWheelSensors = 1;
    int numReserved = 1;
    int numSensors = 4;
    int numConfig2 = 4;
    int numLogic = 1;
    int numSounds = 1;
    int selectedRow = -1;
    JRadioButton[] rowButton;
    private static final Logger log = LoggerFactory.getLogger(FnMapPanelESU.class);

    public FnMapPanelESU(VariableTableModel v, List<Integer> varsUsed, Element model, RosterEntry rosterEntry, CvTableModel cvModel) {
        Attribute a = model.getAttribute("extFnsESU");
        try {
            if (a != null) {
                this.extFnsESU = a.getValue();
            }
        }
        catch (Exception ex) {
            log.error("error handling decoder's extFnsESU value");
        }
        switch (this.extFnsESU) {
            case "V4": 
            case "yes": {
                this.numFns = 29;
                this.numReserved = 0;
                this.numOuts = 12;
                this.numLogic = 16;
                this.numSounds = 24;
                this.numRows = 40;
                this.outBlockSiStartCv = new int[]{2, 2, 2, 2};
                this.outBlockSiCvModulus = new int[]{16, 16, 16, 16};
                this.outBlockStartCv = new int[]{257, 266, 268, 270};
                this.outBlockCvModulus = new int[]{16, 16, 16, 16};
                break;
            }
            case "V5": {
                this.numFns = 32;
                this.numReserved = 1;
                this.numOuts = 20;
                this.numLogic = 24;
                this.numSounds = 32;
                this.numRows = 72;
                this.outBlockSiStartCv = new int[]{3, 8, 8, 8};
                this.outBlockSiCvModulus = new int[]{16, 16, 16, 16};
                this.outBlockStartCv = new int[]{257, 257, 260, 263};
                this.outBlockCvModulus = new int[]{16, 16, 16, 16};
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid extFnsESU value '" + this.extFnsESU + "'");
            }
        }
        this.loadModelAttributes(model);
        this.outBlockLength = new int[]{this.numStates + this.numFns + this.numWheelSensors + this.numReserved + this.numSensors, this.numOuts + this.numConfig2, this.numLogic, this.numSounds};
        this.outBlockItemBits = new int[]{2, 1, 1, 1};
        log.debug("Constructor outBlockLength[0]={}, outBlockLength[1]={}, outBlockLength[2]={}, outBlockLength[3]={}", new Object[]{this.outBlockLength[0], this.outBlockLength[1], this.outBlockLength[2], this.outBlockLength[3]});
        this.maxItems = IntStream.of(this.outBlockLength).sum();
        if (this.numItems <= 0) {
            this.numItems = this.maxItems;
        }
        if (this.numItems > this.maxItems) {
            log.error("numItems={} exceeds the maximum number of items ({}) defined in the code", (Object)this.numItems, (Object)this.maxItems);
            this.numItems = Math.min(this.numItems, this.maxItems);
        }
        log.debug("Constructor numFns={}, numRows={}, numOuts={}, numItems={}, maxItems={}", new Object[]{this.numFns, this.numRows, this.numOuts, this.numItems, this.maxItems});
        this.itemName = new String[this.maxItems][3];
        this.iVarIndex = new int[this.maxItems][this.numRows];
        this.itemIsUsed = new boolean[this.maxItems];
        this.itemLabel = new String[this.maxItems];
        this.itemDescESU = new String[this.maxItems];
        this.summaryLine = new JTextField[this.numRows][this.outBlockLength.length];
        this.outBlockUsed = new int[this.outBlockLength.length];
        this.outBlockStartCol = new int[this.outBlockLength.length];
        this.outBlockName = new String[this.outBlockLength.length];
        log.debug("ESU Function map starts");
        this.varModel = v;
        this.setupDefaultNamesLabels();
        this.configOutputs(model);
        this.gl = new GridBagLayout();
        this.cs = new GridBagConstraints();
        this.setLayout(this.gl);
        this.cs.anchor = 21;
        this.cs.gridwidth = 0;
        this.saveAt(0, 0, new JLabel("<html><em>(For hints and instructions for using this pane, see the </em><strong>&quot;Function Map&quot;</strong><em> section of the </em><strong>&quot;Read Me - IMPORTANT&quot;</strong><em> pane.)</em><br />&nbsp;</html>"));
        this.cs.gridwidth = 1;
        ButtonGroup group = new ButtonGroup();
        this.rowButton = new JRadioButton[this.numRows];
        this.addRowMoveButtons();
        this.cs.anchor = 22;
        this.saveAt(2, this.firstOut - 1, new JLabel("Row"));
        this.cs.anchor = 21;
        int siCV = 0;
        for (int iRow = 0; iRow < this.numRows; ++iRow) {
            this.currentCol = this.firstCol;
            int outBlockNum = -1;
            int nextOutBlockStart = 0;
            int thisOutBlockStart = 0;
            int nextFreeBit = 0;
            this.rowButton[iRow] = new JRadioButton();
            this.rowButton[iRow].setActionCommand(String.valueOf(iRow));
            this.rowButton[iRow].setToolTipText(Bundle.getMessage("FnMapESURowSelect"));
            this.rowButton[iRow].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FnMapPanelESU.this.selectedRow = Integer.parseInt(e.getActionCommand());
                }
            });
            group.add(this.rowButton[iRow]);
            this.cs.anchor = 10;
            this.saveAt(this.currentRow, this.currentCol++, this.rowButton[iRow]);
            this.cs.anchor = 22;
            this.saveAt(this.currentRow, this.currentCol++, new JLabel(Integer.toString(iRow + 1)));
            this.cs.anchor = 21;
            int item = 0;
            do {
                final JPanel blockPanel = new JPanel();
                GridBagConstraints blockPanelCs = new GridBagConstraints();
                JPanel blockItemsSelectorPanel = new JPanel();
                GridBagConstraints bIsPcs = new GridBagConstraints();
                if (item == nextOutBlockStart) {
                    this.outBlockStartCol[++outBlockNum] = item;
                    thisOutBlockStart = item;
                    nextOutBlockStart = item + this.outBlockLength[outBlockNum];
                    blockItemsSelectorPanel = new JPanel();
                    siCV = this.outBlockSiStartCv[outBlockNum] + iRow / this.outBlockSiCvModulus[outBlockNum];
                    nextFreeBit = 0;
                    GridBagLayout bIsPlay = new GridBagLayout();
                    bIsPcs = new GridBagConstraints();
                    blockItemsSelectorPanel.setLayout(bIsPlay);
                    bIsPcs.gridx = 0;
                    bIsPcs.gridy = 0;
                    GridBagLayout blockPanelLay = new GridBagLayout();
                    blockPanelCs = new GridBagConstraints();
                    blockPanel.setLayout(blockPanelLay);
                    blockPanelCs.gridx = 0;
                    blockPanelCs.gridy = 0;
                }
                do {
                    if (!this.itemName[item][0].equals("")) {
                        String name = "ESU Function Row " + Integer.toString(iRow + 1) + " Item " + Integer.toString(item + 1);
                        int iCV = this.outBlockStartCv[outBlockNum] + (this.outBlockCvModulus[outBlockNum] * iRow + nextFreeBit / 8) % 256;
                        String thisCV = "16." + siCV + "." + iCV;
                        int bitValue = (int)(Math.pow(2.0, this.outBlockItemBits[outBlockNum]) - 1.0) << nextFreeBit % 8;
                        Object bitMask = "00000000" + Integer.toBinaryString(bitValue);
                        bitMask = ((String)bitMask).substring(((String)bitMask).length() - 8);
                        String bitPattern = ((String)bitMask).replace("0", "X").replace("1", "V");
                        log.debug("Block {} CV{} mask'{}' {}", new Object[]{outBlockNum, thisCV, bitPattern, name});
                        int savedValue = 0;
                        CvValue cvObject = cvModel.allCvMap().get(thisCV);
                        if (cvObject != null) {
                            savedValue = cvObject.getValue();
                        }
                        String defaultValue = Integer.toString((savedValue & bitValue) >>> nextFreeBit % 8);
                        if (outBlockNum == 1 && item >= thisOutBlockStart + this.numOutsFromDefinition && item < thisOutBlockStart + this.numOuts) {
                            log.debug("Skipping previous item because function output AUX {} does not exist on this decoder", (Object)(item - thisOutBlockStart - 2 + 1));
                        } else {
                            Element thisVar;
                            Element root = new Element("decoder-config");
                            Document doc = new Document(root);
                            doc.setDocType(new DocType("decoder-config"));
                            String defChoice1 = "On";
                            String defChoice2 = "Off";
                            if (!this.itemName[item][1].equals("")) {
                                defChoice1 = this.itemName[item][1];
                            }
                            if (!this.itemName[item][2].equals("")) {
                                defChoice2 = this.itemName[item][2];
                            }
                            if (this.outBlockItemBits[outBlockNum] == 2) {
                                thisVar = new Element("variable").setAttribute("CV", thisCV).setAttribute("default", defaultValue).setAttribute("mask", bitPattern).setAttribute("item", name).setAttribute("readOnly", "no").addContent((Content)new Element("enumVal").addContent((Content)new Element("enumChoice").setAttribute("choice", "-")).addContent((Content)new Element("enumChoice").setAttribute("choice", defChoice1)).addContent((Content)new Element("enumChoice").setAttribute("choice", defChoice2)));
                                root.addContent((Content)new Element("decoder").addContent((Content)new Element("variables").addContent((Content)thisVar)));
                            } else {
                                thisVar = new Element("variable").setAttribute("CV", thisCV).setAttribute("default", defaultValue).setAttribute("mask", bitPattern).setAttribute("item", name).setAttribute("readOnly", "no").addContent((Content)new Element("enumVal").addContent((Content)new Element("enumChoice").setAttribute("choice", "Off")).addContent((Content)new Element("enumChoice").setAttribute("choice", "On")));
                                root.addContent((Content)new Element("decoder").addContent((Content)new Element("variables").addContent((Content)thisVar)));
                            }
                            this.varModel.setRow(0, thisVar);
                            root = null;
                            doc = null;
                            thisVar = null;
                        }
                        int iVar = this.varModel.findVarIndex(name, true);
                        if (iVar >= 0) {
                            if (this.itemName[item][0].startsWith(Bundle.getMessage("FnMapSndSlot"))) {
                                try {
                                    this.itemLabel[item] = rosterEntry.getSoundLabel(Integer.parseInt(this.itemName[item][0].substring((Bundle.getMessage("FnMapSndSlot") + " ").length())));
                                }
                                catch (NumberFormatException e) {
                                    log.warn("Error for sound slot label \"{}\" in \"{}\"", (Object)this.itemName[item][0], (Object)item);
                                }
                            } else if (this.itemName[item][0].matches("F\\d+")) {
                                try {
                                    int fn = Integer.parseInt(this.itemName[item][0].substring(1));
                                    if (fn <= rosterEntry.getMaxFnNumAsInt()) {
                                        this.itemLabel[item] = rosterEntry.getFunctionLabel(fn);
                                    }
                                }
                                catch (NumberFormatException e) {
                                    log.warn("Error for function label \"{}\" in \"{}\"", (Object)this.itemName[item][0], (Object)item);
                                }
                            }
                            if (this.itemLabel[item] == null) {
                                this.itemLabel[item] = "";
                            }
                            Object fullItemName = this.itemName[item][0];
                            if (!this.itemLabel[item].equals("")) {
                                fullItemName = (String)fullItemName + ": " + this.itemLabel[item];
                            }
                            log.debug("Process var: {} as index {}", (Object)name, (Object)iVar);
                            varsUsed.add(iVar);
                            JComponent varComp = this.outBlockItemBits[outBlockNum] == 1 ? (JComponent)this.varModel.getRep(iVar, "checkbox") : (JComponent)this.varModel.getRep(iVar, "");
                            VariableValue var = this.varModel.getVariable(iVar);
                            varComp.setToolTipText(CvUtil.addCvDescription(Bundle.getMessage("FnMapESURow") + " " + Integer.toString(iRow + 1) + ", " + (String)fullItemName, var.getCvDescription(), var.getMask()));
                            if (cvObject == null) {
                                cvObject = cvModel.allCvMap().get(thisCV);
                            }
                            if (cvObject != null) {
                                cvObject.addPropertyChangeListener(new PropertyChangeListener(){
                                    private int row;
                                    private int block;

                                    @Override
                                    public void propertyChange(PropertyChangeEvent e) {
                                        log.debug("Updating Summary Line for row {} block {}", (Object)this.row, (Object)this.block);
                                        FnMapPanelESU.this.updateSummaryLine(this.row, this.block);
                                    }

                                    private PropertyChangeListener init(int i, int j) {
                                        this.row = i;
                                        this.block = j;
                                        return this;
                                    }
                                }.init(iRow, outBlockNum));
                            } else {
                                log.error("cvObject still null after attempt to allocate");
                            }
                            Object label = this.itemName[item][0];
                            if (this.outBlockItemBits[outBlockNum] == 1) {
                                label = fullItemName;
                            }
                            bIsPcs.anchor = 21;
                            bIsPcs.gridx = this.outBlockItemBits[outBlockNum] % 2;
                            blockItemsSelectorPanel.add((Component)new JLabel((String)label), bIsPcs);
                            bIsPcs.gridx = this.outBlockItemBits[outBlockNum] - 1;
                            blockItemsSelectorPanel.add((Component)varComp, bIsPcs);
                            ++bIsPcs.gridy;
                            this.itemIsUsed[item] = true;
                            this.iVarIndex[item][iRow] = iVar;
                        } else {
                            log.debug("Did not find var: {}", (Object)name);
                        }
                    }
                    nextFreeBit += this.outBlockItemBits[outBlockNum];
                } while (++item < nextOutBlockStart && item < this.numItems);
                final JScrollPane blockItemsScrollPane = new JScrollPane(blockItemsSelectorPanel);
                blockItemsScrollPane.setPreferredSize(new Dimension(400, 400));
                blockPanelCs.anchor = 21;
                blockPanelCs.gridx = 0;
                blockPanelCs.gridy = 0;
                blockPanelCs.insets = new Insets(0, 20, 0, 0);
                blockPanel.add((Component)this.summaryLine[iRow][outBlockNum], blockPanelCs);
                this.updateSummaryLine(iRow, outBlockNum);
                JButton button = new JButton("Change");
                button.setActionCommand(iRow + "," + outBlockNum);
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String[] params = e.getActionCommand().split(",");
                        JmriJOptionPane.showMessageDialog(blockPanel, blockItemsScrollPane, "Row " + (Integer.parseInt(params[0]) + 1) + ", " + FnMapPanelESU.this.outBlockName[Integer.parseInt(params[1])], -1);
                    }
                });
                blockPanelCs.anchor = 21;
                blockPanelCs.gridx = 1;
                blockPanelCs.gridy = 0;
                blockPanelCs.insets = new Insets(0, 0, 0, 0);
                blockPanel.add((Component)button, blockPanelCs);
                this.saveAt(this.currentRow, this.currentCol, blockPanel);
                ++this.currentCol;
            } while (item < this.numItems);
            this.saveAt(this.currentRow++, this.currentCol, new JLabel(Integer.toString(iRow + 1)));
        }
        this.saveAt(2, this.currentCol, new JLabel(Bundle.getMessage("FnMapESURow")));
        int currentBlock = -1;
        int blockStart = 0;
        for (int item = 0; item < this.maxItems; ++item) {
            if (item == blockStart) {
                blockStart += this.outBlockLength[++currentBlock];
                this.outBlockUsed[currentBlock] = 0;
            }
            if (!this.itemIsUsed[item]) continue;
            int n = currentBlock;
            this.outBlockUsed[n] = this.outBlockUsed[n] + 1;
        }
        for (int iBlock = 0; iBlock < this.outBlockLength.length; ++iBlock) {
            if (this.outBlockUsed[iBlock] <= 0) continue;
            StringBuilder label = new StringBuilder("<html><strong>" + this.outBlockName[iBlock]);
            try {
                String s = Bundle.getMessage("FnMapESUBlockDesc_" + (iBlock + 1));
                label.append("</strong><br>");
                label.append(s);
                label.append("</html>");
            }
            catch (MissingResourceException e) {
                label.append("</strong></html>");
            }
            JLabel lx = new JLabel(label.toString());
            GridBagConstraints csx = new GridBagConstraints();
            csx.gridy = 1;
            csx.gridx = this.firstOut + iBlock;
            csx.insets = new Insets(0, 40, 0, 0);
            csx.gridwidth = 1;
            csx.anchor = 21;
            this.gl.setConstraints(lx, csx);
            this.add(lx);
        }
        log.debug("Function map complete");
    }

    void setupDefaultNamesLabels() {
        int i;
        for (int i2 = 0; i2 < this.outBlockName.length; ++i2) {
            this.outBlockName[i2] = Bundle.getMessage("FnMapESUBlockName_" + (i2 + 1));
        }
        int item = 0;
        this.itemDescESU[item++] = Bundle.getMessage("FnMap_STATE") + "|" + Bundle.getMessage("FnMap_DRIVE") + "|" + Bundle.getMessage("FnMap_STOP");
        this.itemDescESU[item++] = Bundle.getMessage("FnMap_DIR") + "|" + Bundle.getMessage("FnMap_FWD") + "|" + Bundle.getMessage("FnMap_REV");
        for (i = 0; i < this.numFns; ++i) {
            this.itemDescESU[item++] = "F" + i;
        }
        this.itemDescESU[item++] = Bundle.getMessage("FnMap_WS");
        if (this.extFnsESU.equalsIgnoreCase("V5")) {
            this.itemDescESU[item++] = Bundle.getMessage("FnMap_RS");
        }
        for (i = 1; i <= this.numSensors; ++i) {
            this.itemDescESU[item++] = Bundle.getMessage("FnMap_S") + " " + i;
        }
        this.itemDescESU[item++] = Bundle.getMessage("FnMap_HL") + "[1]";
        this.itemDescESU[item++] = Bundle.getMessage("FnMap_RL") + "[1]";
        for (i = 1; i <= this.numOuts - 2; ++i) {
            this.itemDescESU[item++] = Bundle.getMessage("FnMap_A") + " " + i + (i <= 2 ? "[1]" : "");
        }
        this.itemDescESU[item++] = Bundle.getMessage("FnMap_HL") + "[2]";
        this.itemDescESU[item++] = Bundle.getMessage("FnMap_RL") + "[2]";
        for (i = 1; i <= 2; ++i) {
            this.itemDescESU[item++] = Bundle.getMessage("FnMap_A") + " " + i + "[2]";
        }
        for (i = 1; i <= this.outBlockLength[2]; ++i) {
            this.itemDescESU[item] = "(output 3," + Integer.toString(i) + ")";
            ++item;
        }
        for (i = 1; i <= this.outBlockLength[3]; ++i) {
            this.itemDescESU[item++] = Bundle.getMessage("FnMapSndSlot") + " " + i;
        }
        for (int itemNum = 0; itemNum < this.maxItems; ++itemNum) {
            this.itemLabel[itemNum] = "";
            this.itemName[itemNum][0] = "";
            this.itemName[itemNum][1] = "";
            this.itemName[itemNum][2] = "";
            this.itemIsUsed[itemNum] = false;
            for (int iRow = 0; iRow < this.numRows; ++iRow) {
                this.iVarIndex[itemNum][iRow] = 0;
                for (int outBlockNum = 0; outBlockNum < this.outBlockLength.length; ++outBlockNum) {
                    this.summaryLine[iRow][outBlockNum] = new JTextField(20);
                    this.summaryLine[iRow][outBlockNum].setHorizontalAlignment(2);
                    this.summaryLine[iRow][outBlockNum].setEditable(false);
                }
            }
        }
    }

    void updateAllSummaryLines() {
        for (int row = 0; row < this.numRows; ++row) {
            for (int block = 0; block < this.outBlockLength.length; ++block) {
                this.updateSummaryLine(row, block);
            }
        }
    }

    void updateSummaryLine(int row, int block) {
        StringBuilder retString = new StringBuilder("");
        AbstractValue.ValueState retState = AbstractValue.ValueState.SAME;
        for (int item = this.outBlockStartCol[block]; item < this.outBlockStartCol[block] + this.outBlockLength[block]; ++item) {
            if (!this.itemIsUsed[item]) continue;
            int value = Integer.parseInt(this.varModel.getValString(this.iVarIndex[item][row]));
            AbstractValue.ValueState state = this.varModel.getState(this.iVarIndex[item][row]);
            if (item == this.outBlockStartCol[block] || this.priorityValue(state) > this.priorityValue(retState)) {
                retState = state;
            }
            if (value <= 0) continue;
            if (this.outBlockItemBits[block] == 1) {
                if (this.itemLabel[item].equals("")) {
                    retString.append(",").append(this.itemName[item][0]);
                    continue;
                }
                retString.append(",").append(this.itemLabel[item]);
                continue;
            }
            if (this.outBlockItemBits[block] != 2) continue;
            if (value > 2) {
                retString.append(",").append("reserved value ").append(value);
                continue;
            }
            if (this.itemName[item][value].equals("")) {
                if (value == 1) {
                    retString.append(",").append(this.itemName[item][0]);
                    continue;
                }
                retString.append(",not ").append(this.itemName[item][0]);
                continue;
            }
            retString.append(",").append(this.itemName[item][value]);
        }
        if (retString.length() == 0) {
            retString.append("-");
        } else if (retString.charAt(0) == ',') {
            retString.deleteCharAt(0);
        }
        this.summaryLine[row][block].setBackground(retState.getColor());
        this.summaryLine[row][block].setText(retString.toString());
        this.summaryLine[row][block].setToolTipText(retString.toString());
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT", "SF_SWITCH_FALLTHROUGH"})
    int priorityValue(AbstractValue.ValueState state) {
        int value = 0;
        switch (state) {
            case UNKNOWN: {
                ++value;
            }
            case DIFFERENT: {
                ++value;
            }
            case EDITED: {
                ++value;
            }
            case FROMFILE: {
                ++value;
            }
        }
        return value;
    }

    void saveAt(int row, int column, JComponent j) {
        if (row < 0 || column < 0) {
            return;
        }
        this.cs.gridy = row;
        this.cs.gridx = column;
        this.gl.setConstraints(j, this.cs);
        this.add(j);
    }

    void moveRow(int increment) {
        if (this.selectedRow == -1) {
            return;
        }
        if (this.selectedRow + increment < 0) {
            return;
        }
        if (this.selectedRow + increment >= this.numRows) {
            return;
        }
        int newRow = this.selectedRow + increment;
        for (int item = 0; item < this.maxItems; ++item) {
            if (!this.itemIsUsed[item]) continue;
            int selectedRowValue = Integer.parseInt(this.varModel.getValString(this.iVarIndex[item][this.selectedRow]));
            int newRowValue = Integer.parseInt(this.varModel.getValString(this.iVarIndex[item][newRow]));
            this.varModel.setIntValue(this.iVarIndex[item][this.selectedRow], newRowValue);
            this.varModel.setIntValue(this.iVarIndex[item][newRow], selectedRowValue);
        }
        this.selectedRow = newRow;
        this.rowButton[this.selectedRow].setSelected(true);
    }

    void addRowMoveButtons() {
        JButton button = new JButton(new ImageIcon(FileUtil.findURL("resources/icons/misc/ArrowUp-16.png")));
        button.setActionCommand(String.valueOf(-1));
        button.setToolTipText(Bundle.getMessage("FnMapESUMoveUp"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FnMapPanelESU.this.moveRow(Integer.parseInt(e.getActionCommand()));
            }
        });
        this.cs.anchor = 10;
        this.saveAt(1, 0, button);
        button = new JButton(new ImageIcon(FileUtil.findURL("resources/icons/misc/ArrowDown-16.png")));
        button.setActionCommand(String.valueOf(1));
        button.setToolTipText(Bundle.getMessage("FnMapESUMoveDown"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FnMapPanelESU.this.moveRow(Integer.parseInt(e.getActionCommand()));
            }
        });
        this.cs.anchor = 10;
        this.saveAt(1, 1, button);
        button = new JButton(new ImageIcon(FileUtil.findURL("resources/icons/misc/ArrowUp-16.png")));
        button.setActionCommand(String.valueOf(-1));
        button.setToolTipText(Bundle.getMessage("FnMapESUMoveUp"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FnMapPanelESU.this.moveRow(Integer.parseInt(e.getActionCommand()));
            }
        });
        this.cs.anchor = 10;
        this.saveAt(3 + this.numRows, 0, button);
        button = new JButton(new ImageIcon(FileUtil.findURL("resources/icons/misc/ArrowDown-16.png")));
        button.setActionCommand(String.valueOf(1));
        button.setToolTipText(Bundle.getMessage("FnMapESUMoveDown"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FnMapPanelESU.this.moveRow(Integer.parseInt(e.getActionCommand()));
            }
        });
        this.cs.anchor = 10;
        this.saveAt(3 + this.numRows, 1, button);
    }

    void configOutputs(Element model) {
        if (model == null) {
            log.debug("configOutputs was given a null model");
            return;
        }
        Parent parent = model.getParent();
        if (parent == null || !(parent instanceof Element)) {
            log.debug("configOutputs found an invalid parent family");
            return;
        }
        Element family = (Element)parent;
        for (int item = 0; item < this.maxItems; ++item) {
            this.loadSplitLabel(item, this.itemDescESU[item]);
        }
        ArrayList<Element> elemList = new ArrayList<Element>();
        this.addOutputElements(family.getChildren(), elemList);
        this.addOutputElements(model.getChildren(), elemList);
        log.debug("output scan starting with {} elements", (Object)elemList.size());
        for (int i = 0; i < elemList.size(); ++i) {
            Element e = (Element)elemList.get(i);
            String name = e.getAttribute("name").getValue();
            log.debug("output element name: {} value: {}", (Object)e.getAttributeValue("name"), (Object)e.getAttributeValue("label"));
            String label = LocaleSelector.getAttribute(e, "label");
            if (label == null) continue;
            this.parseLoadLabel(i, name, label);
        }
    }

    void loadModelAttributes(Element model) {
        if (model == null) {
            log.debug("loadModelAttributes was given a null model");
            return;
        }
        Attribute a = model.getAttribute("numFns");
        try {
            if (a != null) {
                this.numRows = Integer.parseInt(a.getValue());
            }
        }
        catch (NumberFormatException e) {
            log.error("error handling decoder's numFns value");
        }
        a = model.getAttribute("numOuts");
        try {
            if (a != null) {
                this.numOutsFromDefinition = Integer.parseInt(a.getValue());
            }
        }
        catch (NumberFormatException e) {
            log.error("error handling decoder's numOuts value");
        }
        log.debug("loadModelAttributes numFns={}, numRows={}, numOuts={}, numOutsFromDefinition={}, numItems={}", new Object[]{this.numFns, this.numRows, this.numOuts, this.numOutsFromDefinition, this.numItems});
    }

    void addOutputElements(List<Element> input, List<Element> accumulate) {
        for (Element elem : input) {
            if (elem.getName().equals("outputs")) {
                log.debug(" found outputs element of size {}", (Object)elem.getChildren().size());
                this.addOutputElements(elem.getChildren(), accumulate);
                continue;
            }
            if (!elem.getName().equals("output")) continue;
            log.debug("adding output element name: {} value: {}", (Object)elem.getAttributeValue("name"), (Object)elem.getAttributeValue("label"));
            accumulate.add(elem);
        }
    }

    void parseLoadLabel(int item, String name, String label) {
        try {
            int outputNum = Integer.parseInt(name);
            log.debug("Output name='{}', label='{}' has an item number.", (Object)name, (Object)label);
            this.loadSplitLabel(outputNum - 1, label);
            return;
        }
        catch (NumberFormatException ex) {
            log.debug("Output name='{}', label='{}' is not a simple item number.", (Object)name, (Object)label);
            String[] itemList = name.split(",");
            if (itemList.length == 2) {
                try {
                    int blockNum = Integer.parseInt(itemList[0]);
                    int blockItemNum = Integer.parseInt(itemList[1]);
                    int itemNum = Arrays.stream(this.outBlockLength, 0, blockNum - 1).sum() + blockItemNum - 1;
                    log.debug("Output name='{}', label='{}', blockNum='{}', blockItemNum='{}', itemNum='{}'.", new Object[]{name, label, blockNum, blockItemNum, itemNum});
                    this.loadSplitLabel(itemNum, label);
                    return;
                }
                catch (NumberFormatException ex1) {
                    log.debug("Output name='{}', label='{}' is not a \"block,item\" construct.", (Object)name, (Object)label);
                }
            }
            if (item < this.maxItems) {
                this.itemName[item][0] = name;
                this.itemName[item][1] = "";
                this.itemName[item][2] = "";
                log.debug("Output name='{}', label='{}' has no item number.", (Object)name, (Object)label);
                this.loadSplitLabel(item, name + "|" + label);
            }
            return;
        }
    }

    void loadSplitLabel(int item, String theLabel) {
        if (item < this.maxItems) {
            String[] itemList = theLabel.split("\\|");
            if (theLabel.equals("|")) {
                this.itemName[item][0] = "";
                this.itemName[item][1] = "";
                this.itemName[item][2] = "";
            } else if (itemList.length == 1) {
                this.itemName[item][0] = itemList[0];
                this.itemName[item][1] = "";
            } else if (itemList.length == 2) {
                this.itemName[item][0] = itemList[0];
                this.itemName[item][1] = itemList[1];
                this.itemName[item][2] = "";
            } else if (itemList.length > 2) {
                this.itemName[item][0] = itemList[0];
                this.itemName[item][1] = itemList[1];
                this.itemName[item][2] = itemList[2];
            }
        }
    }

    public void dispose() {
        this.varModel = null;
        for (int i = 0; i < this.rowButton.length; ++i) {
            this.rowButton[i] = null;
        }
        for (JTextField[] summaryLine1 : this.summaryLine) {
            for (int j = 0; j < summaryLine1.length; ++j) {
                summaryLine1[j] = null;
            }
        }
        this.removeAll();
    }
}

