/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LokProgImporter {
    private static final Logger log = LoggerFactory.getLogger(LokProgImporter.class);
    private static final String DECODER_PREFIX = "Decoder:";
    private static final String CREATED_PREFIX = "Created:";
    private static final String INDEX_PREFIX = "Index:";
    private static final String INDEX_1 = "CV31=";
    private static final String INDEX_1_TERMINATOR = ",";
    private static final String INDEX_2 = "CV32=";
    private static final String INDEX_2_TERMINATOR = ")";
    private static final String CV_PREFIX = "CV ";
    private static final String CV_SEPARATOR = " = ";
    private static final String NOWARN_THESE_CVs = "(1\\.1\\.\\d+|1\\.0\\.2(58|59|60))";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"}, justification="string not kept between iterations, reduces object creation on each iteration")
    public LokProgImporter(File file, CvTableModel cvModel) throws IOException {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            Object cvIndex = "";
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith(INDEX_PREFIX)) {
                    cvIndex = line.substring(line.indexOf(INDEX_1) + INDEX_1.length(), line.indexOf(INDEX_1_TERMINATOR)) + ".";
                    cvIndex = (String)cvIndex + line.substring(line.indexOf(INDEX_2) + INDEX_2.length(), line.indexOf(INDEX_2_TERMINATOR)) + ".";
                    continue;
                }
                if (line.startsWith(CV_PREFIX) && line.regionMatches(6, CV_SEPARATOR, 0, 3)) {
                    String name = (String)cvIndex + String.valueOf(Integer.parseInt(line.substring(3, 6)));
                    int value = Integer.parseInt(line.substring(9, 12));
                    CvValue cvObject = cvModel.allCvMap().get(name);
                    if (cvObject == null) {
                        if (name.matches(NOWARN_THESE_CVs)) {
                            log.debug("Skipping warning for added CV {}, not yet supported by JMRI", (Object)name);
                        } else {
                            log.warn("CV {} was in import file, but not defined by the decoder definition", (Object)name);
                        }
                        cvModel.addCV(name, false, false, false);
                        cvObject = cvModel.allCvMap().get(name);
                    }
                    log.debug("Settting CV {} to {}", (Object)name, (Object)value);
                    cvObject.setValue(value);
                    continue;
                }
                if (!line.startsWith(DECODER_PREFIX) && !line.startsWith(CREATED_PREFIX)) continue;
                log.info("Imorting CVs from file {}", (Object)line);
            }
        }
        catch (IOException e) {
            log.error("Error reading file", (Throwable)e);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileReader != null) {
                fileReader.close();
            }
        }
        log.info("Completed import from LokProgrammer CV List file");
    }
}

