/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import jmri.jmrit.symbolicprog.AbstractValue;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.VariableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongAddrVariableValue
extends VariableValue
implements ActionListener,
FocusListener {
    CvValue highCV;
    int _maxVal;
    int _minVal;
    String oldContents = "";
    Color _defaultColor;
    private int _progState = 0;
    private static final int IDLE = 0;
    private static final int READING_FIRST = 1;
    private static final int READING_SECOND = 2;
    private static final int WRITING_FIRST = 3;
    private static final int WRITING_SECOND = 4;
    JTextField _value = null;
    private static final Logger log = LoggerFactory.getLogger(LongAddrVariableValue.class);

    public LongAddrVariableValue(@Nonnull String name, @Nonnull String comment, @Nonnull String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, @Nonnull String cvNum, @Nonnull String mask, int minVal, int maxVal, @Nonnull HashMap<String, CvValue> v, @Nonnull JLabel status, @Nonnull String stdname, @Nonnull CvValue mHighCV) {
        super(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, v, status, stdname);
        this._maxVal = maxVal;
        this._minVal = minVal;
        this._value = new JTextField("0", 5);
        this._value.getAccessibleContext().setAccessibleName(this.label());
        this._defaultColor = this._value.getBackground();
        this._value.setBackground(AbstractValue.ValueState.UNKNOWN.getColor());
        this._value.addActionListener(this);
        this._value.addFocusListener(this);
        CvValue cv = (CvValue)this._cvMap.get(this.getCvNum());
        cv.addPropertyChangeListener(this);
        cv.setState(AbstractValue.ValueState.FROMFILE);
        this.highCV = mHighCV;
        this.highCV.addPropertyChangeListener(this);
        this.highCV.setState(AbstractValue.ValueState.FROMFILE);
    }

    @Override
    public CvValue[] usesCVs() {
        return new CvValue[]{(CvValue)this._cvMap.get(this.getCvNum()), this.highCV};
    }

    @Override
    public String getCvDescription() {
        return "CV" + this.getCvNum() + " & CV" + this.highCV.number();
    }

    @Override
    public void setToolTipText(String t) {
        super.setToolTipText(t);
        this._value.setToolTipText(t);
    }

    @Override
    public Object rangeVal() {
        return "Long address";
    }

    void enterField() {
        this.oldContents = this._value.getText();
    }

    void exitField() {
        if (this._value != null && !this.oldContents.equals(this._value.getText())) {
            int newVal = Integer.parseInt(this._value.getText());
            int oldVal = Integer.parseInt(this.oldContents);
            this.updatedTextField();
            this.prop.firePropertyChange("Value", (Object)oldVal, (Object)newVal);
        }
    }

    @Override
    void updatedTextField() {
        int newVal;
        if (log.isDebugEnabled()) {
            log.debug("actionPerformed");
        }
        CvValue cv17 = (CvValue)this._cvMap.get(this.getCvNum());
        CvValue cv18 = this.highCV;
        try {
            newVal = Integer.parseInt(this._value.getText());
        }
        catch (NumberFormatException ex) {
            newVal = 0;
        }
        int newCv17 = newVal / 256 & 0x3F | 0xC0;
        int newCv18 = newVal & 0xFF;
        cv17.setValue(newCv17);
        cv18.setValue(newCv18);
        if (log.isDebugEnabled()) {
            log.debug("new value {} gives CV17={} CV18={}", new Object[]{newVal, newCv17, newCv18});
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("actionPerformed");
        }
        int newVal = Integer.parseInt(this._value.getText());
        this.updatedTextField();
        this.prop.firePropertyChange("Value", null, (Object)newVal);
    }

    @Override
    public void focusGained(FocusEvent e) {
        log.debug("focusGained");
        this.enterField();
    }

    @Override
    public void focusLost(FocusEvent e) {
        log.debug("focusLost");
        this.exitField();
    }

    @Override
    public String getValueString() {
        return this._value.getText();
    }

    @Override
    public void setIntValue(int i) {
        this.setValue(i);
    }

    @Override
    public int getIntValue() {
        return Integer.parseInt(this._value.getText());
    }

    @Override
    public Object getValueObject() {
        return Integer.valueOf(this._value.getText());
    }

    @Override
    public Component getCommonRep() {
        if (this.getReadOnly()) {
            JLabel r = new JLabel(this._value.getText());
            this.updateRepresentation(r);
            return r;
        }
        return this._value;
    }

    public void setValue(int value) {
        int oldVal;
        try {
            oldVal = Integer.parseInt(this._value.getText());
        }
        catch (NumberFormatException ex) {
            oldVal = -999;
        }
        log.debug("setValue with new value {} old value {}", (Object)value, (Object)oldVal);
        this._value.setText("" + value);
        if (oldVal != value || this.getState() == AbstractValue.ValueState.UNKNOWN) {
            this.actionPerformed(null);
        }
        this.prop.firePropertyChange("Value", (Object)oldVal, (Object)value);
    }

    @Override
    void setColor(Color c) {
        if (c != null) {
            this._value.setBackground(c);
        } else {
            this._value.setBackground(this._defaultColor);
        }
    }

    @Override
    public Component getNewRep(String format) {
        JComponent retval = this.updateRepresentation(new VarTextField(this._value.getDocument(), this._value.getText(), 5, this));
        retval.getAccessibleContext().setAccessibleName(this.label());
        return retval;
    }

    @Override
    public void setCvState(AbstractValue.ValueState state) {
        ((CvValue)this._cvMap.get(this.getCvNum())).setState(state);
    }

    @Override
    public boolean isChanged() {
        CvValue cv1 = (CvValue)this._cvMap.get(this.getCvNum());
        CvValue cv2 = this.highCV;
        return LongAddrVariableValue.considerChanged(cv1) || LongAddrVariableValue.considerChanged(cv2);
    }

    @Override
    public void setToRead(boolean state) {
        ((CvValue)this._cvMap.get(this.getCvNum())).setToRead(state);
        this.highCV.setToRead(state);
    }

    @Override
    public boolean isToRead() {
        return ((CvValue)this._cvMap.get(this.getCvNum())).isToRead() || this.highCV.isToRead();
    }

    @Override
    public void setToWrite(boolean state) {
        ((CvValue)this._cvMap.get(this.getCvNum())).setToWrite(state);
        this.highCV.setToWrite(state);
    }

    @Override
    public boolean isToWrite() {
        return ((CvValue)this._cvMap.get(this.getCvNum())).isToWrite() || this.highCV.isToWrite();
    }

    @Override
    public void readChanges() {
        if (this.isChanged()) {
            this.readAll();
        }
    }

    @Override
    public void writeChanges() {
        if (this.isChanged()) {
            this.writeAll();
        }
    }

    @Override
    public void readAll() {
        log.debug("longAddr read() invoked");
        this.setToRead(false);
        this.setBusy(true);
        if (this._progState != 0) {
            log.warn("Programming state {}, not IDLE, in read()", (Object)this._progState);
        }
        this._progState = 1;
        log.debug("invoke CV read");
        ((CvValue)this._cvMap.get(this.getCvNum())).read(this._status);
    }

    @Override
    public void writeAll() {
        log.debug("write() invoked");
        if (this.getReadOnly()) {
            log.error("unexpected write operation when readOnly is set");
        }
        this.setToWrite(false);
        this.setBusy(true);
        if (this._progState != 0) {
            log.warn("Programming state {}, not IDLE, in write()", (Object)this._progState);
        }
        this._progState = 3;
        log.debug("invoke CV write");
        ((CvValue)this._cvMap.get(this.getCvNum())).write(this._status);
    }

    @Override
    public void propertyChange(@Nonnull PropertyChangeEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("property changed event - name: {}", (Object)e.getPropertyName());
        }
        if (e.getPropertyName().equals("Busy") && ((Boolean)e.getNewValue()).equals(Boolean.FALSE)) {
            switch (this._progState) {
                case 0: {
                    log.error("Busy goes false with state IDLE");
                    return;
                }
                case 1: {
                    log.debug("Busy goes false with state READING_FIRST");
                    this._progState = 2;
                    this.highCV.read(this._status);
                    return;
                }
                case 2: {
                    log.debug("Busy goes false with state READING_SECOND");
                    this._progState = 0;
                    ((CvValue)this._cvMap.get(this.getCvNum())).setState(AbstractValue.ValueState.READ);
                    this.highCV.setState(AbstractValue.ValueState.READ);
                    this.setBusy(false);
                    return;
                }
                case 3: {
                    log.debug("Busy goes false with state WRITING_FIRST");
                    this._progState = 4;
                    this.highCV.write(this._status);
                    return;
                }
                case 4: {
                    log.debug("Busy goes false with state WRITING_SECOND");
                    this._progState = 0;
                    super.setState(AbstractValue.ValueState.STORED);
                    this.setBusy(false);
                    return;
                }
            }
            log.error("Unexpected state found: {}", (Object)this._progState);
            this._progState = 0;
            return;
        }
        if (e.getPropertyName().equals("State")) {
            CvValue cv = (CvValue)this._cvMap.get(this.getCvNum());
            if (log.isDebugEnabled()) {
                log.debug("CV State changed to {}", (Object)cv.getState());
            }
            this.setState(cv.getState());
        } else if (e.getPropertyName().equals("Value")) {
            CvValue cv0 = (CvValue)this._cvMap.get(this.getCvNum());
            CvValue cv1 = this.highCV;
            int newVal = (cv0.getValue() & 0x3F) * 256 + cv1.getValue();
            this.setValue(newVal);
            this.setState(cv0.getState());
            switch (this._progState) {
                case 0: {
                    log.debug("Value changed with state IDLE");
                    return;
                }
                case 1: {
                    log.debug("Value changed with state READING_FIRST");
                    return;
                }
                case 2: {
                    log.debug("Value changed with state READING_SECOND");
                    return;
                }
            }
            log.error("Unexpected state found: {}", (Object)this._progState);
            this._progState = 0;
            return;
        }
    }

    @Override
    public void dispose() {
        log.debug("dispose");
        if (this._value != null) {
            this._value.removeActionListener(this);
        }
        ((CvValue)this._cvMap.get(this.getCvNum())).removePropertyChangeListener(this);
        this.highCV.removePropertyChangeListener(this);
        this._value = null;
    }

    public class VarTextField
    extends JTextField {
        LongAddrVariableValue _var;

        VarTextField(Document doc, String text, int col, LongAddrVariableValue var) {
            super(doc, text, col);
            this._var = var;
            this.setBackground(this._var._value.getBackground());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VarTextField.this.thisActionPerformed(e);
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    log.debug("focusGained");
                    LongAddrVariableValue.this.enterField();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    log.debug("focusLost");
                    LongAddrVariableValue.this.exitField();
                }
            });
            this._var.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    VarTextField.this.originalPropertyChanged(e);
                }
            });
        }

        void thisActionPerformed(ActionEvent e) {
            this._var.actionPerformed(e);
        }

        void originalPropertyChanged(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("State")) {
                this.setBackground(this._var._value.getBackground());
            }
        }
    }
}

