/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.util.swing.JmriJFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pr1WinExportAction
extends AbstractAction {
    JFileChooser fileChooser;
    JFrame mParent;
    CvTableModel mModel;
    private static final Logger log = LoggerFactory.getLogger(Pr1WinExportAction.class);

    public Pr1WinExportAction(String actionName, CvTableModel pModel, JFrame pParent) {
        super(actionName);
        this.mModel = pModel;
        this.mParent = pParent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int retVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JmriJFileChooser();
        }
        if ((retVal = this.fileChooser.showSaveDialog(this.mParent)) == 0) {
            File file = this.fileChooser.getSelectedFile();
            if (log.isDebugEnabled()) {
                log.debug("start to export to PR1 file {}", (Object)file);
            }
            try (PrintStream str = new PrintStream(new FileOutputStream(file));){
                str.println("[DecoderData]");
                for (int i = 1; i <= 256; ++i) {
                    int lowCvIndex = (i - 1) * 4;
                    CvValue cv1 = this.mModel.allCvMap().get("" + (lowCvIndex + 1));
                    int value1 = cv1 != null ? cv1.getValue() : 0;
                    CvValue cv2 = this.mModel.allCvMap().get("" + (lowCvIndex + 2));
                    int value2 = cv2 != null ? cv2.getValue() : 0;
                    CvValue cv3 = this.mModel.allCvMap().get("" + (lowCvIndex + 3));
                    int value3 = cv3 != null ? cv3.getValue() : 0;
                    CvValue cv4 = this.mModel.allCvMap().get("" + lowCvIndex);
                    int value4 = cv4 != null ? cv4.getValue() : 0;
                    long lValue = value1 + (value2 << 8) + (value3 << 16);
                    lValue = value4 > 127 ? -2147483647L + lValue + (long)(value4 - 127 << 24) : (lValue += (long)(value4 << 24));
                    str.println("CV" + i + "=" + lValue);
                }
                str.println("Version=0");
                str.flush();
                str.close();
            }
            catch (IOException ex) {
                log.error("Error writing file", (Throwable)ex);
            }
        }
    }
}

