/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.Bundle;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgFrame;
import jmri.util.FileUtil;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintCvAction
extends AbstractAction {
    static final int TABLE_COLS = 3;
    private final PaneProgFrame mFrame;
    private final CvTableModel mModel;
    private final RosterEntry mRoster;
    private final boolean isPreview;
    private static final Logger log = LoggerFactory.getLogger(PrintCvAction.class);

    public PrintCvAction(String actionName, CvTableModel pModel, PaneProgFrame pParent, boolean preview, RosterEntry pRoster) {
        super(actionName);
        this.mModel = pModel;
        this.mFrame = pParent;
        this.isPreview = preview;
        this.mRoster = pRoster;
    }

    public void printInfoSection(HardcopyWriter w) {
        ImageIcon icon = new ImageIcon(FileUtil.findURL("resources/decoderpro.gif", FileUtil.Location.INSTALLED));
        w.write(icon.getImage(), new JLabel(icon));
        w.setFontStyle(1);
        int height = icon.getImage().getHeight(null);
        int blanks = (height - w.getLineAscent()) / w.getLineHeight();
        try {
            for (int i = 0; i < blanks; ++i) {
                String s = "\n";
                w.write(s, 0, s.length());
            }
        }
        catch (IOException e) {
            log.warn("error during printing", (Throwable)e);
        }
        this.mRoster.printEntry(w);
        w.setFontStyle(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HardcopyWriter writer;
        try {
            int i;
            boolean swap;
            int i2;
            writer = new HardcopyWriter(this.mFrame, this.mFrame.getRosterEntry().getId(), 10, 0.8, 0.5, 0.5, 0.5, this.isPreview);
            this.printInfoSection(writer);
            Object s = "\n\n";
            writer.write((String)s, 0, ((String)s).length());
            int cvCount = this.mModel.getRowCount();
            int tableLeft = 1;
            int tableRight = 73;
            int tableHeight = cvCount / 3;
            if (cvCount % 3 > 0) {
                ++tableHeight;
            }
            int tableTopRow = writer.getCurrentLineNumber();
            writer.write(tableTopRow, tableLeft, tableTopRow, tableRight);
            int tableBottomRow = tableTopRow + tableHeight + 2;
            for (int i3 = 1; i3 < 76; i3 += 24) {
                writer.write(tableTopRow, i3, tableBottomRow, i3);
            }
            writer.write(tableTopRow + 2, tableLeft, tableTopRow + 2, tableRight);
            writer.write(tableBottomRow, tableLeft, tableBottomRow, tableRight);
            writer.setFontStyle(1);
            s = String.format("%1$21s%1$24s%1$24s", Bundle.getMessage("Value"));
            writer.write((String)s, 0, ((String)s).length());
            s = "\n";
            writer.write((String)s, 0, ((String)s).length());
            s = "            CV  Dec Hex             CV  Dec Hex             CV  Dec Hex\n";
            writer.write((String)s, 0, ((String)s).length());
            writer.setFontStyle(0);
            String[] cvStrings = new String[3 * tableHeight];
            for (i2 = 0; i2 < cvStrings.length; ++i2) {
                cvStrings[i2] = "";
            }
            for (i2 = 0; i2 < this.mModel.getRowCount(); ++i2) {
                CvValue cv = this.mModel.getCvByRow(i2);
                int value = cv.getValue();
                String numString = String.format("%12s", cv.number());
                Object valueString = Integer.toString(value);
                Object valueStringHex = Integer.toHexString(value).toUpperCase(Locale.ENGLISH);
                if (value < 16) {
                    valueStringHex = "0" + (String)valueStringHex;
                }
                for (int j = 1; j < 3; ++j) {
                    if (((String)valueString).length() >= 3) continue;
                    valueString = " " + (String)valueString;
                }
                cvStrings[i2] = s = "  " + numString + "  " + (String)valueString + "  " + (String)valueStringHex + " ";
            }
            do {
                swap = false;
                for (i = 0; i < this.mModel.getRowCount() - 1; ++i) {
                    if (PrintCvAction.cvSortOrderVal(cvStrings[i + 1].substring(0, 15).trim()) >= PrintCvAction.cvSortOrderVal(cvStrings[i].substring(0, 15).trim())) continue;
                    String temp = cvStrings[i + 1];
                    cvStrings[i + 1] = cvStrings[i];
                    cvStrings[i] = temp;
                    swap = true;
                }
            } while (swap);
            for (i = 0; i < tableHeight; ++i) {
                s = cvStrings[i] + cvStrings[i + tableHeight] + cvStrings[i + tableHeight * 2] + "\n";
                writer.write((String)s, 0, ((String)s).length());
            }
            s = " \n";
            writer.write((String)s, 0, ((String)s).length());
        }
        catch (IOException ex1) {
            log.error("IO exception while printing");
            return;
        }
        catch (HardcopyWriter.PrintCanceledException ex2) {
            log.debug("Print cancelled");
            return;
        }
        writer.close();
    }

    public static long cvSortOrderVal(String cvName) {
        int MAX_CVMNUM_SPACE = 1200;
        String[] cvNumStrings = cvName.split("\\D+");
        long sortVal = 0L;
        for (int i = 0; i < cvNumStrings.length; ++i) {
            sortVal = sortVal * 1200L + (long)Integer.parseInt(cvNumStrings[i]);
        }
        return sortVal;
    }
}

