/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.util.Collection;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import jmri.implementation.FileLocationsPreferences;
import jmri.jmrit.symbolicprog.ProgDefault;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgFrame;
import jmri.profile.Profile;
import jmri.profile.ProfileUtils;
import jmri.spi.PreferencesManager;
import jmri.util.prefs.AbstractPreferencesManager;
import jmri.util.prefs.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgrammerConfigManager
extends AbstractPreferencesManager {
    private static final Logger log = LoggerFactory.getLogger(ProgrammerConfigManager.class);
    public static final String DEFAULT_FILE = "defaultFile";
    public static final String SHOW_EMPTY_PANES = "showEmptyPanes";
    public static final String SHOW_CV_NUMBERS = "showCvNumbers";
    public static final String CAN_CACHE_DEFAULT = "canCacheDefault";
    public static final String DO_CONFIRM_READ = "doConfirmRead";
    private String defaultFile = null;
    private boolean showEmptyPanes = true;
    private boolean showCvNumbers = false;
    private boolean canCacheDefault = false;
    private boolean doConfirmRead = false;

    @Override
    public void initialize(Profile profile) throws InitializationException {
        if (!this.isInitialized(profile)) {
            Preferences preferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
            if (preferences.get(DEFAULT_FILE, this.getDefaultFile()) != null) {
                this.setDefaultFile(preferences.get(DEFAULT_FILE, this.getDefaultFile()));
                ProgDefault.setDefaultProgFile(this.getDefaultFile());
            }
            this.setShowEmptyPanes(preferences.getBoolean(SHOW_EMPTY_PANES, this.isShowEmptyPanes()));
            PaneProgFrame.setShowEmptyPanes(this.isShowEmptyPanes());
            this.setShowCvNumbers(preferences.getBoolean(SHOW_CV_NUMBERS, this.isShowCvNumbers()));
            PaneProgFrame.setShowCvNumbers(this.isShowCvNumbers());
            this.setCanCacheDefault(preferences.getBoolean(CAN_CACHE_DEFAULT, this.isCanCacheDefault()));
            PaneProgFrame.setCanCacheDefault(this.isCanCacheDefault());
            this.setDoConfirmRead(preferences.getBoolean(DO_CONFIRM_READ, this.isDoConfirmRead()));
            PaneProgFrame.setDoConfirmRead(this.isDoConfirmRead());
            this.setInitialized(profile, true);
        }
    }

    @Override
    @Nonnull
    public Set<Class<? extends PreferencesManager>> getRequires() {
        Collection requires = super.getRequires();
        requires.add(FileLocationsPreferences.class);
        return requires;
    }

    @Override
    @Nonnull
    public Set<Class<?>> getProvides() {
        Iterable provides = super.getProvides();
        provides.stream().forEach(provide -> log.debug("ProgammerConfigManager provides {}", provide));
        return provides;
    }

    @Override
    public void savePreferences(Profile profile) {
        Preferences preferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
        if (this.defaultFile != null) {
            preferences.put(DEFAULT_FILE, this.defaultFile);
        } else {
            preferences.remove(DEFAULT_FILE);
        }
        preferences.putBoolean(SHOW_EMPTY_PANES, this.showEmptyPanes);
        preferences.putBoolean(SHOW_CV_NUMBERS, this.showCvNumbers);
        preferences.putBoolean(CAN_CACHE_DEFAULT, this.canCacheDefault);
        preferences.putBoolean(DO_CONFIRM_READ, this.doConfirmRead);
        try {
            preferences.sync();
        }
        catch (BackingStoreException ex) {
            log.error("Unable to save preferences.", (Throwable)ex);
        }
    }

    public String getDefaultFile() {
        return this.defaultFile;
    }

    public void setDefaultFile(String defaultFile) {
        String oldDefaultFile = this.defaultFile;
        this.defaultFile = defaultFile;
        this.firePropertyChange(DEFAULT_FILE, oldDefaultFile, defaultFile);
    }

    public boolean isShowEmptyPanes() {
        return this.showEmptyPanes;
    }

    public void setShowEmptyPanes(boolean showEmptyPanes) {
        boolean oldShowEmptyPanes = this.showEmptyPanes;
        this.showEmptyPanes = showEmptyPanes;
        this.firePropertyChange(SHOW_EMPTY_PANES, oldShowEmptyPanes, showEmptyPanes);
    }

    public boolean isShowCvNumbers() {
        return this.showCvNumbers;
    }

    public void setShowCvNumbers(boolean showCvNumbers) {
        boolean oldShowCvNumbers = this.showCvNumbers;
        this.showCvNumbers = showCvNumbers;
        this.firePropertyChange(SHOW_CV_NUMBERS, oldShowCvNumbers, showCvNumbers);
    }

    public boolean isCanCacheDefault() {
        return this.canCacheDefault;
    }

    public void setCanCacheDefault(boolean canCacheDefault) {
        boolean oldCanCacheDefault = this.canCacheDefault;
        this.canCacheDefault = canCacheDefault;
        this.firePropertyChange(CAN_CACHE_DEFAULT, oldCanCacheDefault, canCacheDefault);
    }

    public boolean isDoConfirmRead() {
        return this.doConfirmRead;
    }

    public void setDoConfirmRead(boolean doConfirmRead) {
        boolean oldDoConfirmRead = this.doConfirmRead;
        this.doConfirmRead = doConfirmRead;
        this.firePropertyChange(DO_CONFIRM_READ, oldDoConfirmRead, doConfirmRead);
    }
}

