/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.FlowLayout;
import java.util.ResourceBundle;
import javax.annotation.CheckForNull;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.symbolicprog.ProgDefault;
import jmri.jmrit.symbolicprog.ProgrammerConfigManager;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgFrame;
import jmri.profile.ProfileManager;
import jmri.swing.PreferencesPanel;
import jmri.util.swing.JComboBoxUtil;

public class ProgrammerConfigPane
extends JPanel
implements PreferencesPanel {
    private final ResourceBundle apb = ResourceBundle.getBundle("apps.AppsConfigBundle");
    JComboBox<String> programmerBox;
    JPanel advancedPanel;
    JCheckBox showEmptyTabs;
    JCheckBox showCvNums;
    JCheckBox canCacheDefault;
    JCheckBox doConfirmRead;

    public ProgrammerConfigPane() {
        this.setLayout(new BoxLayout(this, 3));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(new JLabel("Format:"));
        this.programmerBox = new JComboBox<String>(ProgDefault.findListOfProgFiles());
        p.add(this.programmerBox);
        JComboBoxUtil.setupComboBoxMaxRows(this.programmerBox);
        this.programmerBox.setSelectedItem(ProgDefault.getDefaultProgFile());
        this.programmerBox.addActionListener(e -> InstanceManager.getDefault(ProgrammerConfigManager.class).setDefaultFile(this.programmerBox.getSelectedItem().toString()));
        this.add(p);
        this.advancedPanel = new JPanel();
        this.advancedPanel.setLayout(new BoxLayout(this.advancedPanel, 1));
        this.showEmptyTabs = new JCheckBox(this.apb.getString("ProgShowEmptyTabs"));
        this.advancedPanel.add(this.showEmptyTabs);
        this.showEmptyTabs.setSelected(PaneProgFrame.getShowEmptyPanes());
        this.showEmptyTabs.addItemListener(e -> InstanceManager.getDefault(ProgrammerConfigManager.class).setShowEmptyPanes(this.showEmptyTabs.isSelected()));
        this.showCvNums = new JCheckBox(this.apb.getString("ProgShowCVInTips"));
        this.advancedPanel.add(this.showCvNums);
        this.showCvNums.setSelected(PaneProgFrame.getShowCvNumbers());
        this.showCvNums.addItemListener(e -> InstanceManager.getDefault(ProgrammerConfigManager.class).setShowCvNumbers(this.showCvNums.isSelected()));
        this.canCacheDefault = new JCheckBox(this.apb.getString("ProgCanCacheDefault"));
        this.advancedPanel.add(this.canCacheDefault);
        this.canCacheDefault.setSelected(PaneProgFrame.getCanCacheDefault());
        this.canCacheDefault.addItemListener(e -> InstanceManager.getDefault(ProgrammerConfigManager.class).setCanCacheDefault(this.canCacheDefault.isSelected()));
        this.doConfirmRead = new JCheckBox(this.apb.getString("ProgDoConfirmRead"));
        this.advancedPanel.add(this.doConfirmRead);
        this.doConfirmRead.setSelected(PaneProgFrame.getDoConfirmRead());
        this.doConfirmRead.addItemListener(e -> InstanceManager.getDefault(ProgrammerConfigManager.class).setDoConfirmRead(this.doConfirmRead.isSelected()));
        this.add(this.advancedPanel);
        this.add(Box.createVerticalGlue());
    }

    @CheckForNull
    public String getSelectedItem() {
        return (String)this.programmerBox.getSelectedItem();
    }

    public JPanel getAdvancedPanel() {
        return this.advancedPanel;
    }

    public boolean getShowEmptyTabs() {
        return this.showEmptyTabs.isSelected();
    }

    public boolean getShowCvNums() {
        return this.showCvNums.isSelected();
    }

    public boolean getCanCacheDefault() {
        return this.canCacheDefault.isSelected();
    }

    public boolean getDoConfirmRead() {
        return this.doConfirmRead.isSelected();
    }

    @Override
    public String getPreferencesItem() {
        return "ROSTER";
    }

    @Override
    public String getPreferencesItemText() {
        return this.apb.getString("MenuRoster");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return this.apb.getString("TabbedLayoutProgrammer");
    }

    @Override
    public String getLabelKey() {
        return this.apb.getString("LabelTabbedLayoutProgrammer");
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return true;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        InstanceManager.getDefault(ProgrammerConfigManager.class).savePreferences(ProfileManager.getDefault().getActiveProfile());
    }

    @Override
    public boolean isDirty() {
        String programmer = this.getSelectedItem();
        return this.getShowEmptyTabs() != PaneProgFrame.getShowEmptyPanes() || this.getShowCvNums() != PaneProgFrame.getShowCvNumbers() || this.getCanCacheDefault() != PaneProgFrame.getCanCacheDefault() || this.getDoConfirmRead() != PaneProgFrame.getDoConfirmRead() || (programmer != null ? !programmer.equals(ProgDefault.getDefaultProgFile()) : ProgDefault.getDefaultProgFile() != null);
    }

    @Override
    public boolean isRestartRequired() {
        return this.isDirty();
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }
}

