/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantumCvMgrImporter {
    private static final Logger log = LoggerFactory.getLogger(QuantumCvMgrImporter.class);
    private static final String SEARCH_STRING = "^CV([0-9.]+)=([0-9.]+)\\s*(//)?\\s*(.*)$";

    public QuantumCvMgrImporter(File file, CvTableModel cvModel) throws IOException {
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line = null;
            String name = null;
            int value = 0;
            while ((line = bufferedReader.readLine()) != null) {
                log.debug("Line='{}'", (Object)line);
                Pattern pattern = Pattern.compile(SEARCH_STRING);
                Matcher matcher = pattern.matcher(line);
                while (matcher.find()) {
                    log.debug("I found the text {} and  {} and  {}\nstarting at index {} and ending at index {}", new Object[]{matcher.group(1), matcher.group(2), matcher.group(4), matcher.start(), matcher.end()});
                    name = matcher.group(1);
                    value = Integer.parseInt(matcher.group(2));
                    CvValue cvObject = cvModel.allCvMap().get(name);
                    if (cvObject == null) {
                        log.warn("Adding CV {} description \"{}\", which was in import file but not defined by the decoder definition", (Object)name, (Object)matcher.group(4));
                        cvModel.addCV(name, false, false, false);
                        cvObject = cvModel.allCvMap().get(name);
                    }
                    cvObject.setValue(value);
                }
            }
            fileReader.close();
        }
        catch (IOException e) {
            log.error("Error reading file", (Throwable)e);
        }
    }
}

