/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.symbolicprog.AbstractValue;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.DecVariableValue;
import jmri.jmrit.symbolicprog.SpeedTableNumbers;
import jmri.jmrit.symbolicprog.VariableValue;
import jmri.util.CvUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedTableVarValue
extends VariableValue
implements ChangeListener {
    int nValues;
    int numCvs;
    String[] cvList;
    BoundedRangeModel[] models;
    int _min;
    int _max;
    int _range;
    boolean mfx;
    List<JCheckBox> stepCheckBoxes;
    Color _defaultColor;
    private int _progState = -1;
    private static final int IDLE = -1;
    boolean isReading;
    boolean isWriting;
    private int retries = 0;
    private static final int RETRY_MAX = 2;
    boolean onlyChanges = false;
    private static final Logger log = LoggerFactory.getLogger(SpeedTableVarValue.class);

    public SpeedTableVarValue(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, int entries, boolean mfxFlag) {
        super(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, v, status, stdname);
        this.nValues = entries;
        this._min = minVal;
        this._max = maxVal;
        this._range = maxVal - minVal;
        this.mfx = mfxFlag;
        this.numCvs = this.nValues;
        this.cvList = new String[this.numCvs];
        this.models = new BoundedRangeModel[this.nValues];
        for (int i = 0; i < this.nValues; ++i) {
            this.cvList[i] = Integer.toString(Integer.parseInt(this.getCvNum()) + i);
            DefaultBoundedRangeModel j = new DefaultBoundedRangeModel(this._range * i / (this.nValues - 1) + this._min, 0, this._min, this._max);
            this.models[i] = j;
            CvValue c = (CvValue)this._cvMap.get(this.cvList[i]);
            c.setValue(this._range * i / (this.nValues - 1) + this._min);
            c.addPropertyChangeListener(this);
            c.setState(AbstractValue.ValueState.FROMFILE);
        }
        this._defaultColor = new JSlider().getBackground();
    }

    public SpeedTableVarValue() {
    }

    @Override
    public Object rangeVal() {
        log.warn("rangeVal doesn't make sense for a speed table");
        return "Speed table";
    }

    @Override
    public CvValue[] usesCVs() {
        CvValue[] retval = new CvValue[this.numCvs];
        for (int i = 0; i < this.numCvs; ++i) {
            retval[i] = (CvValue)this._cvMap.get(this.cvList[i]);
        }
        return retval;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider j = (JSlider)e.getSource();
        BoundedRangeModel r = j.getModel();
        for (int i = 0; i < this.nValues; ++i) {
            if (r != this.models[i]) continue;
            this.setModel(i, r.getValue());
            break;
        }
        this.prop.firePropertyChange("Value", null, j);
    }

    void setModel(int i, int value) {
        if (value < this._min || this.mfx && i == 0) {
            value = this._min;
        }
        if (value > this._max || this.mfx && i == this.nValues - 1) {
            value = this._max;
        }
        if (i < this.nValues && this.models[i].getValue() != value) {
            this.models[i].setValue(value);
        }
        ((CvValue)this._cvMap.get(this.cvList[i])).setValue(value);
        if (this.isReading || this.isWriting) {
            return;
        }
        if (i < this.nValues && (!this.mfx || i != 0 && i != this.nValues - 1)) {
            this.forceMonotonic(i, value);
            this.matchPoints(i);
        }
    }

    void forceMonotonic(int modifiedStepIndex, int value) {
        if (modifiedStepIndex > 0 && this.models[modifiedStepIndex - 1].getValue() > value) {
            this.setModel(modifiedStepIndex - 1, value);
        }
        if (modifiedStepIndex < this.nValues - 1 && value > this.models[modifiedStepIndex + 1].getValue()) {
            this.setModel(modifiedStepIndex + 1, value);
        }
    }

    void matchPoints(int modifiedStepIndex) {
        if (this.stepCheckBoxes == null) {
            return;
        }
        if (modifiedStepIndex < 0) {
            log.error("matchPoints called with index too small: {}", (Object)modifiedStepIndex);
        }
        if (modifiedStepIndex >= this.stepCheckBoxes.size()) {
            log.error("matchPoints called with index too large: {} >= {}", (Object)modifiedStepIndex, (Object)this.stepCheckBoxes.size());
        }
        if (this.stepCheckBoxes.get(modifiedStepIndex) == null) {
            log.error("matchPoints found null checkbox {}", (Object)modifiedStepIndex);
        }
        if (!this.stepCheckBoxes.get(modifiedStepIndex).isSelected()) {
            return;
        }
        this.matchPointsLeft(modifiedStepIndex);
        this.matchPointsRight(modifiedStepIndex);
    }

    void matchPointsLeft(int modifiedStepIndex) {
        for (int i = modifiedStepIndex - 1; i >= 0; --i) {
            if (!this.stepCheckBoxes.get(i).isSelected()) continue;
            int leftval = ((CvValue)this._cvMap.get(this.cvList[i])).getValue();
            int rightval = ((CvValue)this._cvMap.get(this.cvList[modifiedStepIndex])).getValue();
            int steps = modifiedStepIndex - i;
            log.debug("left found {} {} {}", new Object[]{leftval, rightval, steps});
            for (int j = i + 1; j < modifiedStepIndex; ++j) {
                int newValue = leftval + (rightval - leftval) * (j - i) / steps;
                log.debug("left set {} to {}", (Object)j, (Object)newValue);
                if (((CvValue)this._cvMap.get(this.cvList[j])).getValue() == newValue) continue;
                ((CvValue)this._cvMap.get(this.cvList[j])).setValue(newValue);
            }
            return;
        }
    }

    void matchPointsRight(int modifiedStepIndex) {
        for (int i = modifiedStepIndex + 1; i < this.nValues; ++i) {
            if (!this.stepCheckBoxes.get(i).isSelected()) continue;
            int rightval = ((CvValue)this._cvMap.get(this.cvList[i])).getValue();
            int leftval = ((CvValue)this._cvMap.get(this.cvList[modifiedStepIndex])).getValue();
            int steps = i - modifiedStepIndex;
            log.debug("right found {} {} {}", new Object[]{leftval, rightval, steps});
            for (int j = modifiedStepIndex + 1; j < i; ++j) {
                int newValue = leftval + (rightval - leftval) * (j - modifiedStepIndex) / steps;
                log.debug("right set {} to {}", (Object)j, (Object)newValue);
                if (((CvValue)this._cvMap.get(this.cvList[j])).getValue() == newValue) continue;
                ((CvValue)this._cvMap.get(this.cvList[j])).setValue(newValue);
            }
            return;
        }
    }

    @Override
    public AbstractValue.ValueState getState() {
        int i;
        for (i = 0; i < this.numCvs; ++i) {
            if (((CvValue)this._cvMap.get(this.cvList[i])).getState() != AbstractValue.ValueState.UNKNOWN) continue;
            return AbstractValue.ValueState.UNKNOWN;
        }
        for (i = 0; i < this.numCvs; ++i) {
            if (((CvValue)this._cvMap.get(this.cvList[i])).getState() != AbstractValue.ValueState.EDITED) continue;
            return AbstractValue.ValueState.EDITED;
        }
        for (i = 0; i < this.numCvs; ++i) {
            if (((CvValue)this._cvMap.get(this.cvList[i])).getState() != AbstractValue.ValueState.FROMFILE) continue;
            return AbstractValue.ValueState.FROMFILE;
        }
        for (i = 0; i < this.numCvs; ++i) {
            if (((CvValue)this._cvMap.get(this.cvList[i])).getState() != AbstractValue.ValueState.READ) continue;
            return AbstractValue.ValueState.READ;
        }
        for (i = 0; i < this.numCvs; ++i) {
            if (((CvValue)this._cvMap.get(this.cvList[i])).getState() != AbstractValue.ValueState.STORED) continue;
            return AbstractValue.ValueState.STORED;
        }
        log.error("getState did not decode a possible state");
        return AbstractValue.ValueState.UNKNOWN;
    }

    @Override
    public String getValueString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.models.length; ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(Integer.toString(this.models[i].getValue()));
        }
        return buf.toString();
    }

    @Override
    public void setValue(String value) {
        log.debug("skipping setValue in SpeedTableVarValue");
    }

    @Override
    public void setIntValue(int i) {
        log.warn("setIntValue doesn't make sense for a speed table: {}", (Object)i);
    }

    @Override
    public int getIntValue() {
        log.warn("getValue doesn't make sense for a speed table");
        return 0;
    }

    @Override
    public Object getValueObject() {
        return null;
    }

    @Override
    public Component getCommonRep() {
        log.warn("getValue not implemented yet");
        return new JLabel("speed table");
    }

    public void setValue(int value) {
        log.warn("setValue doesn't make sense for a speed table: {}", (Object)value);
    }

    @Override
    void setColor(Color c) {
    }

    @Override
    public Component getNewRep(String format) {
        int GRID_Y_BUTTONS = 3;
        JPanel j = new JPanel();
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints cs = new GridBagConstraints();
        j.setLayout(g);
        this.initStepCheckBoxes();
        for (int i = 0; i < this.nValues; ++i) {
            SpeedTableNumbers speedTableNumbersSelection;
            cs.gridy = 0;
            cs.gridx = i;
            CvValue cv = (CvValue)this._cvMap.get(this.cvList[i]);
            VarSlider s = new VarSlider(this.models[i], cv, i + 1);
            s.setOrientation(1);
            s.addChangeListener(this);
            AbstractValue.ValueState currentState = cv.getState();
            int currentValue = cv.getValue();
            DecVariableValue decVal = new DecVariableValue("val" + i, "", "", false, false, false, false, this.cvList[i], "VVVVVVVV", this._min, this._max, this._cvMap, this._status, "");
            decVal.setValue(currentValue);
            decVal.setState(currentState);
            Component v = decVal.getCommonRep();
            String start = ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("TextStep") + " " + (i + 1);
            ((JTextField)v).setToolTipText(CvUtil.addCvDescription(start, "CV " + this.cvList[i], null));
            ((JComponent)v).setBorder(null);
            if (this.mfx && (i == 0 || i == this.nValues - 1)) {
                ((JTextField)v).setEditable(false);
                s.setEnabled(false);
            }
            g.setConstraints(v, cs);
            if (i == 0 && log.isDebugEnabled()) {
                log.debug("Font size {}", (Object)v.getFont().getSize());
            }
            float newSize = (float)v.getFont().getSize() * 0.8f;
            v.setFont(v.getFont().deriveFont(newSize));
            j.add(v);
            ++cs.gridy;
            g.setConstraints(s, cs);
            j.add(s);
            ++cs.gridy;
            JCheckBox b = this.stepCheckBoxes.get(i);
            g.setConstraints(b, cs);
            j.add((Component)b, cs);
            UserPreferencesManager upm = InstanceManager.getDefault(UserPreferencesManager.class);
            Object speedTableNumbersSelectionObj = upm.getProperty(SpeedTableNumbers.class.getName(), "selection");
            if (speedTableNumbersSelectionObj == null || (speedTableNumbersSelection = SpeedTableNumbers.valueOf(speedTableNumbersSelectionObj.toString())) == SpeedTableNumbers.None || !speedTableNumbersSelection.filter(i) && i != 0 && i + 1 != this.nValues) continue;
            ++cs.gridy;
            JLabel num = new JLabel("" + (i + 1));
            num.setToolTipText("Step Number");
            g.setConstraints(num, cs);
            j.add((Component)num, cs);
        }
        JPanel k = new JPanel();
        JButton b = new JButton(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("ButtonForceStraight"));
        k.add(b);
        b.setToolTipText(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("TooltipForceStraight"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedTableVarValue.this.doForceStraight(e);
            }
        });
        b = new JButton(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("ButtonMatchEnds"));
        k.add(b);
        b.setToolTipText(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("TooltipMatchEnds"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedTableVarValue.this.doMatchEnds(e);
            }
        });
        b = new JButton(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("ButtonConstantRatio"));
        k.add(b);
        b.setToolTipText(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("TooltipConstantRatio"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedTableVarValue.this.doRatioCurve(e);
            }
        });
        b = new JButton(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("ButtonLogCurve"));
        k.add(b);
        b.setToolTipText(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("TooltipLogCurve"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedTableVarValue.this.doLogCurve(e);
            }
        });
        b = new JButton(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("ButtonShiftLeft"));
        k.add(b);
        b.setToolTipText(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("TooltipShiftLeft"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedTableVarValue.this.doShiftLeft(e);
            }
        });
        b = new JButton(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("ButtonShiftRight"));
        k.add(b);
        b.setToolTipText(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("TooltipShiftRight"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedTableVarValue.this.doShiftRight(e);
            }
        });
        cs.gridy = 3;
        cs.gridx = 0;
        cs.gridwidth = -1;
        g.setConstraints(k, cs);
        JPanel l = new JPanel();
        JPanel val = new JPanel();
        val.setLayout(new BorderLayout());
        val.add((Component)j, "North");
        val.add((Component)k, "Center");
        if (this.mfx) {
            val.add((Component)l, "South");
        }
        this.updateRepresentation(val);
        return val;
    }

    void initStepCheckBoxes() {
        this.stepCheckBoxes = new ArrayList<JCheckBox>();
        for (int i = 0; i < this.nValues; ++i) {
            JCheckBox b = new JCheckBox();
            b.setToolTipText(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("TooltipCheckToFix"));
            this.stepCheckBoxes.add(b);
        }
    }

    void doForceStraight(ActionEvent e) {
        ((CvValue)this._cvMap.get(this.cvList[0])).setValue(this._min);
        ((CvValue)this._cvMap.get(this.cvList[this.nValues - 1])).setValue(this._max);
        this.doMatchEnds(e);
    }

    void doMatchEnds(ActionEvent e) {
        int first = ((CvValue)this._cvMap.get(this.cvList[0])).getValue();
        int last = ((CvValue)this._cvMap.get(this.cvList[this.nValues - 1])).getValue();
        log.debug(" first={} last={}", (Object)first, (Object)last);
        ((CvValue)this._cvMap.get(this.cvList[0])).setValue(last);
        for (int i = 0; i < this.nValues; ++i) {
            int value = first + i * (last - first) / (this.nValues - 1);
            ((CvValue)this._cvMap.get(this.cvList[i])).setValue(value);
        }
    }

    void doRatioCurve(ActionEvent e) {
        double last;
        double first = ((CvValue)this._cvMap.get(this.cvList[0])).getValue();
        if (first < 1.0) {
            first = 1.0;
        }
        if ((last = (double)((CvValue)this._cvMap.get(this.cvList[this.nValues - 1])).getValue()) < first + 1.0) {
            last = first + 1.0;
        }
        double step = Math.log(last / first) / (double)(this.nValues - 1);
        log.debug("log ratio step is {}", (Object)step);
        ((CvValue)this._cvMap.get(this.cvList[0])).setValue((int)Math.round(last));
        for (int i = 0; i < this.nValues; ++i) {
            int value = (int)Math.floor(first * Math.exp(step * (double)i));
            ((CvValue)this._cvMap.get(this.cvList[i])).setValue(value);
        }
    }

    void doLogCurve(ActionEvent e) {
        double first = ((CvValue)this._cvMap.get(this.cvList[0])).getValue();
        double last = ((CvValue)this._cvMap.get(this.cvList[this.nValues - 1])).getValue();
        if (last < first + 1.0) {
            last = first + 1.0;
        }
        double factor = 0.1;
        ((CvValue)this._cvMap.get(this.cvList[1])).setValue((int)Math.round(last));
        double ratio = Math.pow(1.0 - factor, (double)this.nValues - 1.0);
        double limit = last + (last - first) * ratio;
        for (int i = 1; i < this.nValues; ++i) {
            double previous = limit - (limit - first) * ratio / Math.pow(1.0 - factor, (double)this.nValues - 1.0 - (double)i);
            int value = (int)Math.floor(previous);
            ((CvValue)this._cvMap.get(this.cvList[i])).setValue(value);
        }
    }

    void doShiftLeft(ActionEvent e) {
        for (int i = 0; i < this.nValues - 1; ++i) {
            int value = ((CvValue)this._cvMap.get(this.cvList[i + 1])).getValue();
            ((CvValue)this._cvMap.get(this.cvList[i])).setValue(value);
        }
    }

    void doShiftRight(ActionEvent e) {
        for (int i = this.nValues - 1; i > 0; --i) {
            int value = ((CvValue)this._cvMap.get(this.cvList[i - 1])).getValue();
            ((CvValue)this._cvMap.get(this.cvList[i])).setValue(value);
        }
    }

    @Override
    public void setCvState(AbstractValue.ValueState state) {
        ((CvValue)this._cvMap.get(this.cvList[0])).setState(state);
    }

    @Override
    public boolean isChanged() {
        for (int i = 0; i < this.numCvs; ++i) {
            if (!SpeedTableVarValue.considerChanged((CvValue)this._cvMap.get(this.cvList[i]))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readChanges() {
        if (log.isDebugEnabled()) {
            log.debug("readChanges() invoked");
        }
        if (!this.isChanged()) {
            return;
        }
        this.onlyChanges = true;
        this.setBusy(true);
        if (this._progState != -1) {
            log.warn("Programming state {}, not IDLE, in read()", (Object)this._progState);
        }
        this.isReading = true;
        this.isWriting = false;
        this._progState = -1;
        this.retries = 0;
        if (log.isDebugEnabled()) {
            log.debug("start series of read operations");
        }
        this.readNext();
    }

    @Override
    public void writeChanges() {
        if (log.isDebugEnabled()) {
            log.debug("writeChanges() invoked");
        }
        if (!this.isChanged()) {
            return;
        }
        this.onlyChanges = true;
        if (this.getReadOnly()) {
            log.error("unexpected write operation when readOnly is set");
        }
        this.setBusy(true);
        super.setState(AbstractValue.ValueState.STORED);
        if (this._progState != -1) {
            log.warn("Programming state {}, not IDLE, in write()", (Object)this._progState);
        }
        this.isReading = false;
        this.isWriting = true;
        this._progState = -1;
        this.retries = 0;
        if (log.isDebugEnabled()) {
            log.debug("start series of write operations");
        }
        this.writeNext();
    }

    @Override
    public void readAll() {
        if (log.isDebugEnabled()) {
            log.debug("readAll() invoked");
        }
        this.onlyChanges = false;
        this.setToRead(false);
        this.setBusy(true);
        if (this._progState != -1) {
            log.warn("Programming state {}, not IDLE, in read()", (Object)this._progState);
        }
        this.isReading = true;
        this.isWriting = false;
        this._progState = -1;
        this.retries = 0;
        if (log.isDebugEnabled()) {
            log.debug("start series of read operations");
        }
        this.readNext();
    }

    @Override
    public void writeAll() {
        if (log.isDebugEnabled()) {
            log.debug("writeAll() invoked");
        }
        this.onlyChanges = false;
        if (this.getReadOnly()) {
            log.error("unexpected write operation when readOnly is set");
        }
        this.setToWrite(false);
        this.setBusy(true);
        super.setState(AbstractValue.ValueState.STORED);
        if (this._progState != -1) {
            log.warn("Programming state {}, not IDLE, in write()", (Object)this._progState);
        }
        this.isReading = false;
        this.isWriting = true;
        this._progState = -1;
        this.retries = 0;
        if (log.isDebugEnabled()) {
            log.debug("start series of write operations");
        }
        this.writeNext();
    }

    void readNext() {
        if (this._progState >= 0 && this.retries < 2 && ((CvValue)this._cvMap.get(this.cvList[this._progState])).getState() != AbstractValue.ValueState.READ) {
            ++this.retries;
        } else {
            this.retries = 0;
            ++this._progState;
        }
        if (this._progState >= this.numCvs) {
            this._progState = -1;
            this.isReading = false;
            this.isWriting = false;
            this.setBusy(false);
            return;
        }
        CvValue cv = (CvValue)this._cvMap.get(this.cvList[this._progState]);
        AbstractValue.ValueState state = cv.getState();
        if (log.isDebugEnabled()) {
            log.debug("invoke CV read index {} cv state {}", (Object)this._progState, (Object)state);
        }
        if (!this.onlyChanges || SpeedTableVarValue.considerChanged(cv)) {
            cv.read(this._status);
        } else {
            this.readNext();
        }
    }

    void writeNext() {
        if (this._progState >= 0 && this.retries < 2 && ((CvValue)this._cvMap.get(this.cvList[this._progState])).getState() != AbstractValue.ValueState.STORED) {
            ++this.retries;
        } else {
            this.retries = 0;
            ++this._progState;
        }
        if (this._progState >= this.numCvs) {
            this._progState = -1;
            this.isReading = false;
            this.isWriting = false;
            this.setBusy(false);
            return;
        }
        CvValue cv = (CvValue)this._cvMap.get(this.cvList[this._progState]);
        AbstractValue.ValueState state = cv.getState();
        if (log.isDebugEnabled()) {
            log.debug("invoke CV write index {} cv state {}", (Object)this._progState, (Object)state);
        }
        if (!this.onlyChanges || SpeedTableVarValue.considerChanged(cv)) {
            cv.write(this._status);
        } else {
            this.writeNext();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("property changed event - name: {}", (Object)e.getPropertyName());
        }
        if (e.getPropertyName().equals("Busy") && ((Boolean)e.getNewValue()).equals(Boolean.FALSE)) {
            if (this.isReading) {
                this.readNext();
                return;
            } else {
                if (!this.isWriting) return;
                this.writeNext();
            }
            return;
        } else if (e.getPropertyName().equals("State")) {
            CvValue cv = (CvValue)this._cvMap.get(this.cvList[0]);
            if (log.isDebugEnabled()) {
                log.debug("CV State changed to {}", (Object)cv.getState());
            }
            this.setState(cv.getState());
            return;
        } else {
            if (!e.getPropertyName().equals("Value")) return;
            CvValue cv = (CvValue)e.getSource();
            int value = cv.getValue();
            for (int i = 0; i < this.numCvs; ++i) {
                if (this._cvMap.get(this.cvList[i]) != cv) continue;
                this.setModel(i, value);
                return;
            }
        }
    }

    @Override
    public void dispose() {
        if (log.isDebugEnabled()) {
            log.debug("dispose");
        }
        for (int i = 0; i < this.numCvs; ++i) {
            ((CvValue)this._cvMap.get(this.cvList[i])).removePropertyChangeListener(this);
        }
    }

    public class VarSlider
    extends JSlider {
        CvValue _var;

        VarSlider(BoundedRangeModel m, CvValue var, int step) {
            super(m);
            this._var = var;
            this.setBackground(this._var.getColor());
            if (this._var.getColor() == this._var.getDefaultColor()) {
                this.setOpaque(false);
            } else {
                this.setOpaque(true);
            }
            String start = ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("TextStep") + " " + step;
            this.setToolTipText(CvUtil.addCvDescription(start, "CV " + var.number(), null));
            this._var.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    VarSlider.this.originalPropertyChanged(e);
                }
            });
        }

        void originalPropertyChanged(PropertyChangeEvent e) {
            if (log.isDebugEnabled()) {
                log.debug("VarSlider saw property change: {}", (Object)e);
            }
            if (e.getPropertyName().equals("State")) {
                this.setBackground(this._var.getColor());
                if (this._var.getColor() == this._var.getDefaultColor()) {
                    this.setOpaque(false);
                } else {
                    this.setOpaque(true);
                }
            }
        }
    }
}

