/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.HashMap;
import javax.swing.JLabel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.SplitVariableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitDateTimeVariableValue
extends SplitVariableValue {
    LocalDateTime base;
    long factor;
    String unit;
    String display;
    long storedValue = 0L;
    private static final Logger log = LoggerFactory.getLogger(SplitDateTimeVariableValue.class);

    public SplitDateTimeVariableValue(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, String pSecondCV, int pFactor, int pOffset, String uppermask, String extra1, String extra2, String extra3, String extra4) {
        super(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, minVal, maxVal, v, status, stdname, pSecondCV, pFactor, pOffset, uppermask, extra1, extra2, extra3, extra4);
    }

    @Override
    public void stepOneActions(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, String pSecondCV, int pFactor, int pOffset, String uppermask, String extra1, String extra2, String extra3, String extra4) {
        this.base = LocalDateTime.parse(extra1);
        this.factor = Long.parseLong(extra2);
        this.unit = extra3;
        this.display = extra4;
        this._minVal = 0L;
        this._maxVal = -1L;
    }

    @Override
    public void stepTwoActions() {
        log.debug("{} SplitDateTimeVariableValue stepTwoActions", (Object)this._name);
        super.stepTwoActions();
        this._columns = this.cvCount * 4;
        switch (this.display) {
            case "dateOnly": 
            case "timeOnly": {
                this._columns = this.cvCount * 2;
                break;
            }
            default: {
                this._columns = this.cvCount * 4;
            }
        }
    }

    @Override
    long getValueFromText(String s) {
        return this.storedValue;
    }

    @Override
    String getTextFromValue(long v) {
        this.storedValue = v;
        for (ChronoUnit theUnit : ChronoUnit.values()) {
            if (!theUnit.toString().equals(this.unit)) continue;
            return this.getTextFromDateTime(this.base.plus(v * this.factor, ChronoUnit.valueOf(theUnit.name())));
        }
        throw new UnsupportedTemporalTypeException("Invalid time unit '" + this.unit + "'.");
    }

    String getTextFromDateTime(LocalDateTime dateTime) {
        switch (this.display) {
            case "dateOnly": {
                return dateTime.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM));
            }
            case "timeOnly": {
                return dateTime.format(DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM));
            }
        }
        return dateTime.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM));
    }

    @Override
    public void setValue(String value) {
        log.debug("skipping set of date/time value \"{}\"", (Object)value);
    }
}

