/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jmri.jmrit.symbolicprog.AbstractValue;
import jmri.jmrit.symbolicprog.ComboCheckBox;
import jmri.jmrit.symbolicprog.ComboRadioButtons;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.VariableValue;
import jmri.util.CvUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitEnumVariableValue
extends VariableValue
implements ActionListener,
FocusListener {
    private static final int RETRY_COUNT = 2;
    int atest = 1;
    private final List<JTree> trees = new ArrayList<JTree>();
    private final List<ComboCheckBox> comboCBs = new ArrayList<ComboCheckBox>();
    private final List<VarComboBox> comboVars = new ArrayList<VarComboBox>();
    private final List<ComboRadioButtons> comboRBs = new ArrayList<ComboRadioButtons>();
    JComboBox<String> _value = null;
    private String[] _itemArray = null;
    private TreePath[] _pathArray = null;
    private int[] _valueArray = null;
    private int _nstored;
    Deque<DefaultMutableTreeNode> treeNodes = new ArrayDeque<DefaultMutableTreeNode>();
    String mSecondCV;
    String _uppermask;
    int mFactor;
    int mOffset;
    String _name;
    String _mask;
    String[] _maskArray = new String[0];
    String _cvNum;
    List<CvItem> cvList;
    int cvCount = 0;
    int currentOffset = 0;
    long _minVal = 0L;
    long _maxVal = -1L;
    String oldContents = "0";
    boolean _fieldShrink = false;
    Color _defaultColor;
    int _columns = 1;
    List<Component> reps = new ArrayList<Component>();
    public int retry = 0;
    int _progState = 0;
    static final int IDLE = 0;
    static final int READING_FIRST = 1;
    static final int WRITING_FIRST = -1;
    static final int bitCount = Long.bitCount(-1L);
    static final long intMask = Integer.toUnsignedLong(-1);
    private static final Logger log = LoggerFactory.getLogger((String)SplitEnumVariableValue.class.getName());

    public SplitEnumVariableValue(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, String pSecondCV, int pFactor, int pOffset, String uppermask, String extra1, String extra2, String extra3, String extra4) {
        super(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, v, status, stdname);
        int i;
        this.stepOneActions(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, minVal, maxVal, v, status, stdname, pSecondCV, pFactor, pOffset, uppermask, extra1, extra2, extra3, extra4);
        this._name = name;
        this._mask = mask;
        if (mask != null && mask.contains(" ")) {
            this._maskArray = mask.split(" ");
        } else {
            this._maskArray = new String[1];
            this._maskArray[0] = mask;
        }
        this._cvNum = cvNum;
        this.mFactor = pFactor;
        this.mOffset = pOffset;
        this.mSecondCV = pSecondCV;
        this._uppermask = uppermask;
        log.debug("Variable={};comment={};cvName={};cvNum={};stdname={}", new Object[]{this._name, comment, cvName, this._cvNum, stdname});
        log.debug("Variable={}; upper mask {} had offsetVal={} so upperbitoffset={}", new Object[]{this._name, this._uppermask, this.offsetVal(this._uppermask), this.offsetVal(this._uppermask)});
        this.cvList = new ArrayList<CvItem>();
        List<String> nameList = CvUtil.expandCvList(this._cvNum);
        if (nameList.isEmpty()) {
            String tMask;
            if (this._maskArray != null && this._maskArray.length == 1) {
                log.debug("PrimaryCV mask={}", (Object)this._maskArray[0]);
                tMask = this._maskArray[0];
            } else {
                tMask = this._mask;
            }
            this.cvList.add(new CvItem(this._cvNum, tMask));
            if (pSecondCV != null && !pSecondCV.equals("")) {
                this.cvList.add(new CvItem(pSecondCV, this._uppermask));
            }
        } else {
            for (int i2 = 0; i2 < nameList.size(); ++i2) {
                this.cvList.add(new CvItem(nameList.get(i2), this._maskArray[Math.min(i2, this._maskArray.length - 1)]));
                log.debug("Added mask #{}: {}", (Object)i2, (Object)this._maskArray[Math.min(i2, this._maskArray.length - 1)]);
            }
        }
        this.cvCount = this.cvList.size();
        for (i = 0; i < this.cvCount; ++i) {
            CvValue cv;
            this.cvList.get((int)i).startOffset = this.currentOffset;
            String t = this.cvList.get((int)i).cvMask;
            if (t.contains("V")) {
                this.currentOffset = this.currentOffset + t.lastIndexOf("V") - t.indexOf("V") + 1;
            } else {
                log.error("Variable={};cvName={};cvMask={} is an invalid bitmask", new Object[]{this._name, this.cvList.get((int)i).cvName, this.cvList.get((int)i).cvMask});
            }
            log.debug("Variable={};cvName={};cvMask={};startOffset={};currentOffset={}", new Object[]{this._name, this.cvList.get((int)i).cvName, this.cvList.get((int)i).cvMask, this.cvList.get((int)i).startOffset, this.currentOffset});
            this.cvList.get((int)i).thisCV = cv = (CvValue)this._cvMap.get(this.cvList.get((int)i).cvName);
        }
        this.stepTwoActions();
        for (i = 0; i < this.cvCount; ++i) {
            this.cvList.get((int)i).thisCV.addPropertyChangeListener(this);
            this.cvList.get((int)i).thisCV.setState(AbstractValue.ValueState.FROMFILE);
        }
        this.treeNodes.addLast(new DefaultMutableTreeNode(""));
    }

    public void stepOneActions(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, String pSecondCV, int pFactor, int pOffset, String uppermask, String extra1, String extra2, String extra3, String extra4) {
        if (extra3 != null) {
            this._minVal = this.getValueFromText(extra3);
        }
        if (extra4 != null) {
            this._maxVal = this.getValueFromText(extra4);
        }
    }

    public void nItems(int n) {
        this._itemArray = new String[n];
        this._pathArray = new TreePath[n];
        this._valueArray = new int[n];
        this._nstored = 0;
        log.debug("enumeration arrays size={}", (Object)n);
    }

    public void addItem(String s) {
        if (this._nstored == 0) {
            this.addItem(s, 0);
        } else {
            this.addItem(s, this._valueArray[this._nstored - 1] + 1);
        }
    }

    public void addItem(String s, int value) {
        this._valueArray[this._nstored] = value;
        TreeLeafNode node = new TreeLeafNode(s, this._nstored);
        this.treeNodes.getLast().add(node);
        this._pathArray[this._nstored] = new TreePath(node.getPath());
        this._itemArray[this._nstored++] = s;
        log.debug("_itemArray.length={},_nstored={},s='{}',value={}", new Object[]{this._itemArray.length, this._nstored, s, value});
    }

    public void startGroup(String name) {
        DefaultMutableTreeNode next = new DefaultMutableTreeNode(name);
        this.treeNodes.getLast().add(next);
        this.treeNodes.addLast(next);
    }

    public void endGroup() {
        this.treeNodes.removeLast();
    }

    public void lastItem() {
        this._value = new JComboBox<String>(Arrays.copyOf(this._itemArray, this._nstored));
        this._value.getAccessibleContext().setAccessibleName(this.label());
        this._value.setActionCommand("");
        this._defaultColor = this._value.getBackground();
        this._value.setBackground(AbstractValue.ValueState.UNKNOWN.getColor());
        this._value.setOpaque(true);
        this._value.addActionListener(this);
        CvValue cv1 = this.cvList.get((int)0).thisCV;
        CvValue cv2 = this.cvList.get((int)1).thisCV;
        if (cv1 == null || cv2 == null) {
            log.error("no CV defined in enumVal {}, skipping setState", (Object)this.getCvName());
            return;
        }
        cv1.addPropertyChangeListener(this);
        cv1.setState(AbstractValue.ValueState.FROMFILE);
        cv2.addPropertyChangeListener(this);
        cv2.setState(AbstractValue.ValueState.FROMFILE);
    }

    @Override
    public void setToolTipText(String t) {
        super.setToolTipText(t);
        this._value.setToolTipText(t);
    }

    public void stepTwoActions() {
        if (this.currentOffset > bitCount) {
            String eol = System.getProperty("line.separator");
            throw new Error("Decoder File parsing error:" + eol + "The Decoder Definition File specified \"" + this._cvNum + "\" for variable \"" + this._name + "\". This expands to:" + eol + "\"" + this.getCvDescription() + "\"" + eol + "This requires " + this.currentOffset + " bits, which exceeds the " + bitCount + " bit capacity of the long integer used to store the variable." + eol + "The Decoder Definition File needs correction.");
        }
        this._columns = this.cvCount * 2;
    }

    @Override
    public void setAvailable(boolean a) {
        this._value.setVisible(a);
        for (ComboCheckBox comboCheckBox : this.comboCBs) {
            comboCheckBox.setVisible(a);
        }
        for (VarComboBox varComboBox : this.comboVars) {
            varComboBox.setVisible(a);
        }
        for (ComboRadioButtons comboRadioButtons : this.comboRBs) {
            comboRadioButtons.setVisible(a);
        }
        super.setAvailable(a);
    }

    @Override
    public CvValue[] usesCVs() {
        CvValue[] theseCvs = new CvValue[this.cvCount];
        for (int i = 0; i < this.cvCount; ++i) {
            theseCvs[i] = this.cvList.get((int)i).thisCV;
        }
        return theseCvs;
    }

    @Override
    public String getMask() {
        if (this.mSecondCV != null && !this.mSecondCV.equals("")) {
            return this._uppermask + this._mask;
        }
        return this._mask;
    }

    protected String getMask(int i) {
        if (i < this.cvCount) {
            return this.cvList.get((int)i).cvMask;
        }
        return "";
    }

    @Override
    public String getCvDescription() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.cvCount; ++i) {
            if (buf.length() > 0) {
                buf.append(" & ");
            }
            buf.append("CV");
            buf.append(this.cvList.get((int)i).cvName);
            String temp = CvUtil.getMaskDescription(this.cvList.get((int)i).cvMask);
            if (temp.length() <= 0) continue;
            buf.append(" ");
            buf.append(temp);
        }
        buf.append(".");
        return buf.toString();
    }

    @Override
    public String getCvNum() {
        String retString = "";
        if (this.cvCount > 0) {
            retString = this.cvList.get((int)0).cvName;
        }
        return retString;
    }

    @Deprecated
    public String getSecondCvNum() {
        String retString = "";
        if (this.cvCount > 1) {
            retString = this.cvList.get((int)1).cvName;
        }
        return retString;
    }

    @Override
    public Object rangeVal() {
        return "Split value";
    }

    long getValueFromText(String s) {
        return Long.parseUnsignedLong(s);
    }

    String getTextFromValue(long v) {
        return Long.toUnsignedString(v);
    }

    void updateVariableValue(int[] intVals) {
        if (intVals.length > 0) {
            long newVal = 0L;
            for (int i = 0; i < intVals.length; ++i) {
                log.debug("Variable={}; i={}; intVals={}; startOffset={}; newVal={}", new Object[]{this._name, i, intVals[i], this.cvList.get((int)i).startOffset, this.getTextFromValue(newVal |= (long)intVals[i] << this.cvList.get((int)i).startOffset)});
            }
            log.debug("Variable={}; set value to {}", (Object)this._name, (Object)newVal);
            this.setLongValue(newVal);
            log.debug("Variable={}; in property change after setValue call", (Object)this._name);
        }
    }

    void enterField() {
        this.oldContents = String.valueOf(this._value.getSelectedItem());
        log.debug("enterField sets oldContents to {}", (Object)this.oldContents);
    }

    void exitField() {
        log.trace("exitField starts");
        if (this._value != null && !this.oldContents.equals(this._value.getSelectedItem())) {
            long newFieldVal = 0L;
            try {
                newFieldVal = Long.parseLong((String)Objects.requireNonNull(this._value.getSelectedItem()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            log.debug("_minVal={};_maxVal={};newFieldVal={}", new Object[]{Long.toUnsignedString(this._minVal), Long.toUnsignedString(this._maxVal), Long.toUnsignedString(newFieldVal)});
            if (Long.compareUnsigned(newFieldVal, this._minVal) >= 0 && Long.compareUnsigned(newFieldVal, this._maxVal) <= 0) {
                long newVal = (newFieldVal - (long)this.mOffset) / (long)this.mFactor;
                long oldVal = (this.getValueFromText(this.oldContents) - (long)this.mOffset) / (long)this.mFactor;
                this.prop.firePropertyChange("Value", oldVal, newVal);
            }
        }
        log.trace("exitField ends");
    }

    void updatedDropDown() {
        log.debug("Variable='{}'; enter updatedDropDown in {} with DropDownValue='{}'", new Object[]{this._name, this.getClass().getSimpleName(), this._value.getSelectedIndex()});
        int[] retVals = this.getCvValsFromSingleInt(this.getIntValue());
        for (int j = 0; j < this.cvCount; ++j) {
            int i = j;
            log.debug("retVals[{}]={};cvList.get({}).cvMask{};offsetVal={}", new Object[]{i, retVals[i], i, this.cvList.get((int)i).cvMask, this.offsetVal(this.cvList.get((int)i).cvMask)});
            int cvMask = this.maskValAsInt(this.cvList.get((int)i).cvMask);
            CvValue thisCV = this.cvList.get((int)i).thisCV;
            int oldCvVal = thisCV.getValue();
            int newCvVal = oldCvVal & ~cvMask | retVals[i] << this.offsetVal(this.cvList.get((int)i).cvMask) & cvMask;
            log.debug("{};cvMask={};oldCvVal={};retVals[{}]={};newCvVal={}", new Object[]{this.cvList.get((int)i).cvName, cvMask, oldCvVal, i, retVals[i], newCvVal});
            if (newCvVal == oldCvVal) continue;
            thisCV.setValue(newCvVal);
        }
        log.debug("Variable={}; exit updatedDropDown", (Object)this._name);
    }

    int[] getCvValsFromSingleInt(long newEntry) {
        long newVal = (newEntry - (long)this.mOffset) / (long)this.mFactor;
        log.debug("getCvValsFromSingleInt Variable={};newEntry={};newVal={} with Offset={} + Factor={} applied", new Object[]{this._name, newEntry, newVal, this.mOffset, this.mFactor});
        int[] retVals = new int[this.cvCount];
        for (int i = 0; i < this.cvCount; ++i) {
            log.trace("      Starting with newVal={} startOffset={} mask={} offsetVal={}", new Object[]{newVal, this.cvList.get((int)i).startOffset, this.maskValAsInt(this.cvList.get((int)i).cvMask), this.offsetVal(this.cvList.get((int)i).cvMask)});
            retVals[i] = (int)(newVal >>> this.cvList.get((int)i).startOffset) & this.maskValAsInt(this.cvList.get((int)i).cvMask) >>> this.offsetVal(this.cvList.get((int)i).cvMask);
            log.trace("      Calculated {} entry is {}", (Object)i, (Object)retVals[i]);
        }
        return retVals;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            CvValue cv;
            if (log.isDebugEnabled()) {
                log.debug("Variable = {} start action event cmd={}", (Object)this.label(), (Object)e.getActionCommand());
            }
            if (!e.getActionCommand().equals("")) {
                log.debug("{} action event {} was from alternate rep", (Object)this.label(), (Object)e.getActionCommand());
                this._value.setSelectedItem(e.getActionCommand());
                if (this._nstored > 0) {
                    for (int i = 0; i < this._nstored; ++i) {
                        if (!e.getActionCommand().equals(this._itemArray[i])) continue;
                        TreePath path = this._pathArray[i];
                        for (JTree tree : this.trees) {
                            tree.setSelectionPath(path);
                            tree.scrollPathToVisible(path);
                        }
                        break;
                    }
                }
            }
            if ((cv = (CvValue)this._cvMap.get(this.getCvNum())) == null) {
                log.error("no CV defined in enumVal {}, skipping setValue", this._cvMap.get(this.getCvName()));
                return;
            }
            this.updatedDropDown();
        }
        this.exitField();
    }

    @Override
    public void focusGained(FocusEvent e) {
        log.debug("Variable={}; focusGained", (Object)this._name);
        this.enterField();
    }

    @Override
    public void focusLost(FocusEvent e) {
        log.debug("Variable={}; focusLost", (Object)this._name);
        this.exitField();
    }

    @Override
    public String getValueString() {
        return Integer.toString(this.getIntValue());
    }

    public void setValue(int value) {
        if (value > 0) {
            try {
                long longVal;
                long val = longVal = (long)value;
                this.setLongValue(val);
            }
            catch (NumberFormatException e) {
                log.warn("skipping set of non-long value \"{}\"", (Object)value);
            }
            this.selectValue(value);
        }
    }

    @Override
    public void setIntValue(int i) {
        this.setLongValue(i);
    }

    @Override
    public int getIntValue() {
        if (this._value.getSelectedIndex() >= this._valueArray.length || this._value.getSelectedIndex() < 0) {
            log.error("trying to get value {} too large for array length {} in var {}", new Object[]{this._value.getSelectedIndex(), this._valueArray.length, this.label()});
        }
        log.debug("SelectedIndex={} value={}", (Object)this._value.getSelectedIndex(), (Object)this._valueArray[this._value.getSelectedIndex()]);
        return this._valueArray[this._value.getSelectedIndex()];
    }

    @Override
    public long getLongValue() {
        return this._valueArray[this._value.getSelectedIndex()];
    }

    @Override
    public String getTextValue() {
        if (this._value.getSelectedItem() != null) {
            return this._value.getSelectedItem().toString();
        }
        return "";
    }

    @Override
    public Object getValueObject() {
        return this.getLongValue();
    }

    @Override
    public Component getCommonRep() {
        if (this.getReadOnly()) {
            JLabel r = new JLabel((String)this._value.getSelectedItem());
            this.updateRepresentation(r);
            return r;
        }
        return this._value;
    }

    private void addReservedEntry(long value) {
        log.warn("Variable \"{}\" had to add reserved entry for {}", (Object)this._name, (Object)value);
        log.debug("Create new item with value {} count was {} in {}", new Object[]{value, this._value.getItemCount(), this.label()});
        this._valueArray = Arrays.copyOf(this._valueArray, this._valueArray.length + 1);
        this._itemArray = Arrays.copyOf(this._itemArray, this._itemArray.length + 1);
        this._pathArray = Arrays.copyOf(this._pathArray, this._pathArray.length + 1);
        this.addItem("Reserved value " + value, (int)value);
        this._value.addItem(this._itemArray[this._nstored - 1]);
        this._value.setSelectedItem(this._itemArray[this._nstored - 1]);
        for (JTree tree : this.trees) {
            ((DefaultTreeModel)tree.getModel()).reload();
            tree.setSelectionPath(this._pathArray[this._nstored - 1]);
            tree.scrollPathToVisible(this._pathArray[this._nstored - 1]);
        }
    }

    public void setLongValue(long value) {
        long oldVal;
        log.debug("Variable={}; enter setLongValue {}", (Object)this._name, (Object)value);
        try {
            oldVal = (Long.parseLong((String)this._value.getSelectedItem()) - (long)this.mOffset) / (long)this.mFactor;
        }
        catch (NumberFormatException ex) {
            oldVal = -999L;
        }
        log.debug("Variable={}; setValue with new value {} old value {}", new Object[]{this._name, value, oldVal});
        int lengthOfArray = this._valueArray.length;
        boolean foundIt = false;
        for (int i = 0; i < lengthOfArray; ++i) {
            if ((long)this._valueArray[i] != value) continue;
            log.trace("{} setLongValue setSelectedIndex to {}", (Object)this._name, (Object)i);
            this._value.setSelectedIndex(i);
            foundIt = true;
        }
        if (!foundIt) {
            this.addReservedEntry(value);
        }
        if (oldVal != value || this.getState() == AbstractValue.ValueState.UNKNOWN) {
            this.actionPerformed(null);
        }
        this.prop.firePropertyChange("Value", oldVal, value * (long)this.mFactor + (long)this.mOffset);
        log.debug("Variable={}; exit setLongValue old={} new={}", new Object[]{this._name, oldVal, value});
    }

    @Override
    void setColor(Color c) {
        if (c != null && this._value != null) {
            this._value.setBackground(c);
            log.debug("Variable={}; Set Color to {}", (Object)this._name, (Object)c.toString());
        } else if (this._value != null) {
            log.debug("Variable={}; Set Color to defaultColor {}", (Object)this._name, (Object)this._defaultColor.toString());
            this._value.setBackground(this._defaultColor);
        }
    }

    @Override
    public Component getNewRep(String format) {
        switch (format) {
            case "tree": {
                DefaultTreeModel dModel = new DefaultTreeModel(this.treeNodes.getFirst());
                JTree dTree = new JTree(dModel);
                this.trees.add(dTree);
                JScrollPane dScroll = new JScrollPane(dTree);
                dTree.setRootVisible(false);
                dTree.setShowsRootHandles(true);
                dTree.setScrollsOnExpand(true);
                dTree.setExpandsSelectedPaths(true);
                dTree.getSelectionModel().setSelectionMode(1);
                dTree.addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        TreePath[] paths;
                        for (TreePath path : paths = e.getPaths()) {
                            DefaultMutableTreeNode o = (DefaultMutableTreeNode)path.getLastPathComponent();
                            if (o.getChildCount() <= 0) continue;
                            ((JTree)e.getSource()).removeSelectionPath(path);
                        }
                        if (paths.length >= 1 && paths[0].getLastPathComponent() instanceof TreeLeafNode) {
                            SplitEnumVariableValue.this.setValue(SplitEnumVariableValue.this._valueArray[((TreeLeafNode)paths[0].getLastPathComponent()).index]);
                        }
                    }
                });
                TreePath path = this._pathArray[this._value.getSelectedIndex()];
                dTree.setSelectionPath(path);
                dTree.scrollPathToVisible(path);
                if (this.getReadOnly() || this.getInfoOnly()) {
                    log.error("read only variables cannot use tree format: {}", (Object)this.item());
                }
                this.updateRepresentation(dScroll);
                return dScroll;
            }
        }
        VarComboBox b = new VarComboBox(this._value.getModel(), this);
        this.comboVars.add(b);
        if (this.getReadOnly() || this.getInfoOnly()) {
            b.setEnabled(false);
        }
        this.updateRepresentation(b);
        return b;
    }

    protected void selectValue(int value) {
        if (this._nstored > 0 && value != 0) {
            for (int i = 0; i < this._nstored; ++i) {
                if (this._valueArray[i] != value) continue;
                log.debug("{}: selectValue sets to {}", (Object)this._name, (Object)i);
                this._value.setSelectedIndex(i);
                TreePath path = this._pathArray[i];
                for (JTree tree : this.trees) {
                    tree.setSelectionPath(path);
                    tree.scrollPathToVisible(path);
                }
                return;
            }
        }
        this.addReservedEntry(value);
    }

    @Override
    public void setCvState(AbstractValue.ValueState state) {
        for (int i = 0; i < this.cvCount; ++i) {
            this.cvList.get((int)i).thisCV.setState(state);
        }
    }

    @Override
    public boolean isChanged() {
        boolean changed = false;
        for (int i = 0; i < this.cvCount; ++i) {
            changed = changed || SplitEnumVariableValue.considerChanged(this.cvList.get((int)i).thisCV);
        }
        return changed;
    }

    @Override
    public boolean isToRead() {
        boolean toRead = false;
        for (int i = 0; i < this.cvCount; ++i) {
            toRead = toRead || this.cvList.get((int)i).thisCV.isToRead();
        }
        return toRead;
    }

    @Override
    public boolean isToWrite() {
        boolean toWrite = false;
        for (int i = 0; i < this.cvCount; ++i) {
            toWrite = toWrite || this.cvList.get((int)i).thisCV.isToWrite();
        }
        return toWrite;
    }

    @Override
    public void readChanges() {
        if (this.isToRead() && !this.isChanged()) {
            log.debug("!!!!!!! unacceptable combination in readChanges: {}", (Object)this.label());
        }
        if (this.isChanged() || this.isToRead()) {
            this.readAll();
        }
    }

    @Override
    public void writeChanges() {
        if (this.isToWrite() && !this.isChanged()) {
            log.debug("!!!!!! unacceptable combination in writeChanges: {}", (Object)this.label());
        }
        if (this.isChanged() || this.isToWrite()) {
            this.writeAll();
        }
    }

    @Override
    public void readAll() {
        log.debug("Variable={}; splitVal read() invoked", (Object)this._name);
        this.setToRead(false);
        this.setBusy(true);
        for (int i = 0; i < this.cvCount; ++i) {
            this.cvList.get((int)i).thisCV.setState(AbstractValue.ValueState.READ);
        }
        this._progState = 1;
        this.retry = 0;
        log.debug("Variable={}; Start CV read", (Object)this._name);
        log.debug("    Reading CV={}", (Object)this.cvList.get((int)0).cvName);
        this.cvList.get((int)0).thisCV.read(this._status);
    }

    @Override
    public void writeAll() {
        log.debug("Variable={}; write() invoked", (Object)this._name);
        if (this.getReadOnly()) {
            log.error("Variable={}; unexpected write operation when readOnly is set", (Object)this._name);
        }
        this.setToWrite(false);
        this.setBusy(true);
        if (this._progState != 0) {
            log.warn("Variable={}; Programming state {}, not IDLE, in write()", (Object)this._name, (Object)this._progState);
        }
        for (int i = 0; i < this.cvCount; ++i) {
            this.cvList.get((int)i).thisCV.setState(AbstractValue.ValueState.STORED);
        }
        this._progState = -1;
        log.debug("Variable={}; Start CV write", (Object)this._name);
        log.debug("     Writing CV={}", (Object)this.cvList.get((int)0).cvName);
        this.cvList.get((int)0).thisCV.write(this._status);
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT", "SF_SWITCH_FALLTHROUGH"}, justification="Intentional fallthrough to produce correct value")
    int priorityValue(AbstractValue.ValueState state) {
        int value = 0;
        switch (state) {
            case UNKNOWN: {
                ++value;
            }
            case DIFFERENT: {
                ++value;
            }
            case EDITED: {
                ++value;
            }
            case FROMFILE: {
                ++value;
            }
        }
        return value;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.trace("propertyChange for {} {} _progState = {} from {}", new Object[]{e.getPropertyName(), e.getNewValue(), this._progState, e.getSource()});
        switch (e.getPropertyName()) {
            case "Busy": {
                if (!((Boolean)e.getNewValue()).equals(Boolean.FALSE)) break;
                if ((this._progState >= 1 || this._progState <= -1) && e.getSource() != this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV) {
                    log.trace("From \"{}\" but expected \"{}\", ignoring", e.getSource(), (Object)this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV);
                    break;
                }
                if (this._progState >= 1) {
                    AbstractValue.ValueState curState = this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV.getState();
                    log.trace("propertyChange Busy _progState={} curState={}", (Object)this._progState, (Object)curState);
                    if (curState == AbstractValue.ValueState.READ) {
                        this.retry = 0;
                        log.debug("   Variable={}; Busy finds ValueState.READ cvCount={}", (Object)this._name, (Object)this.cvCount);
                        if (Math.abs(this._progState) < this.cvCount) {
                            ++this._progState;
                            log.debug("Increment _progState to {}, reading CV={}", (Object)this._progState, (Object)this.cvList.get((int)(Math.abs((int)this._progState) - 1)).cvName);
                            this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV.read(this._status);
                            break;
                        }
                        log.debug("Variable={}; Busy goes false with success READING _progState {}", (Object)this._name, (Object)this._progState);
                        this._progState = 0;
                        this.setToRead(false);
                        this.setBusy(false);
                        break;
                    }
                    log.debug("   Variable={}; Busy finds other than ValueState.READ _progState {}", (Object)this._name, (Object)this._progState);
                    if (this.retry < 2) {
                        ++this.retry;
                        this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV.read(this._status);
                        break;
                    }
                    log.warn("Retry failed for CV{}", (Object)this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV.toString());
                    this._progState = 0;
                    this.setToRead(false);
                    this.setBusy(false);
                    for (int i = 0; i < this.cvCount; ++i) {
                        this.cvList.get((int)i).thisCV.setState(AbstractValue.ValueState.UNKNOWN);
                    }
                    break;
                }
                if (this._progState > -1) break;
                if (this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV.getState() == AbstractValue.ValueState.STORED) {
                    if (Math.abs(this._progState) < this.cvCount) {
                        --this._progState;
                        log.debug("Writing CV={}", (Object)this.cvList.get((int)(Math.abs((int)this._progState) - 1)).cvName);
                        this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV.write(this._status);
                        break;
                    }
                    log.debug("Variable={}; Busy goes false with success WRITING _progState {}", (Object)this._name, (Object)this._progState);
                    this._progState = 0;
                    this.setBusy(false);
                    this.setToWrite(false);
                    break;
                }
                log.debug("Variable={}; Busy goes false with failure WRITING _progState {}", (Object)this._name, (Object)this._progState);
                this._progState = 0;
                this.setToWrite(false);
                this.setBusy(false);
                break;
            }
            case "State": {
                log.debug("Possible {} variable state change due to CV state change, so propagate that", (Object)this._name);
                AbstractValue.ValueState varState = this.getState();
                log.debug("{} variable state was {}", (Object)this._name, (Object)varState.getName());
                for (int i = 0; i < this.cvCount; ++i) {
                    AbstractValue.ValueState state = this.cvList.get((int)i).thisCV.getState();
                    if (i == 0) {
                        varState = state;
                        continue;
                    }
                    if (this.priorityValue(state) <= this.priorityValue(varState)) continue;
                    varState = AbstractValue.ValueState.UNKNOWN;
                }
                this.setState(varState);
                for (JTree tree : this.trees) {
                    tree.setBackground(this._value.getBackground());
                }
                log.debug("{} variable state set to {}", (Object)this._name, (Object)varState.getName());
                break;
            }
            case "Value": {
                log.debug("update value of Variable {} cvCount={}", (Object)this._name, (Object)this.cvCount);
                int[] intVals = new int[this.cvCount];
                for (int i = 0; i < this.cvCount; ++i) {
                    intVals[i] = (this.cvList.get((int)i).thisCV.getValue() & this.maskValAsInt(this.cvList.get((int)i).cvMask)) >>> this.offsetVal(this.cvList.get((int)i).cvMask);
                    log.trace("   with intVal[{}] = {}", (Object)i, (Object)intVals[i]);
                }
                this.updateVariableValue(intVals);
                log.debug("state change due to CV value change, so propagate that");
                AbstractValue.ValueState varState = AbstractValue.ValueState.SAME;
                for (int i = 0; i < this.cvCount; ++i) {
                    AbstractValue.ValueState state = this.cvList.get((int)i).thisCV.getState();
                    if (this.priorityValue(state) <= this.priorityValue(varState)) continue;
                    varState = state;
                }
                this.setState(varState);
                this.updatedDropDown();
                break;
            }
        }
    }

    @Override
    public void dispose() {
        log.debug("dispose");
        if (this._cvMap.get(this.getCvNum()) == null) {
            log.error("no CV defined for variable {}, no listeners to remove", (Object)this.getCvNum());
        } else {
            ((CvValue)this._cvMap.get(this.getCvNum())).removePropertyChangeListener(this);
        }
        this.disposeReps();
    }

    void disposeReps() {
        int i;
        if (this._value != null) {
            this._value.removeActionListener(this);
        }
        for (i = 0; i < this.comboCBs.size(); ++i) {
            this.comboCBs.get(i).dispose();
        }
        for (i = 0; i < this.comboVars.size(); ++i) {
            this.comboVars.get(i).dispose();
        }
        for (i = 0; i < this.comboRBs.size(); ++i) {
            this.comboRBs.get(i).dispose();
        }
    }

    static class TreeLeafNode
    extends DefaultMutableTreeNode {
        int index;

        TreeLeafNode(String name, int index) {
            super(name);
            this.index = index;
        }
    }

    static class CvItem {
        String cvName;
        String cvMask;
        int startOffset;
        CvValue thisCV;

        CvItem(String cvNameVal, String cvMaskVal) {
            this.cvName = cvNameVal;
            this.cvMask = cvMaskVal;
        }
    }

    public static class VarComboBox
    extends JComboBox<String> {
        SplitEnumVariableValue _var;
        transient PropertyChangeListener _l = null;

        VarComboBox(ComboBoxModel<String> m, SplitEnumVariableValue var) {
            super(m);
            this._var = var;
            this._l = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    log.debug("VarComboBox saw property change: {}", (Object)e);
                    this.originalPropertyChanged(e);
                }
            };
            this.setBackground(this._var._value.getBackground());
            this.setOpaque(true);
            this._var.addPropertyChangeListener(this._l);
        }

        void originalPropertyChanged(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("State")) {
                this.setBackground(this._var._value.getBackground());
                this.setOpaque(true);
            }
        }

        public void dispose() {
            if (this._var != null && this._l != null) {
                this._var.removePropertyChangeListener(this._l);
            }
            this._l = null;
            this._var = null;
        }
    }
}

