/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.util.HashMap;
import javax.swing.JLabel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.SplitVariableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitHundredsVariableValue
extends SplitVariableValue {
    private static final Logger log = LoggerFactory.getLogger(SplitHundredsVariableValue.class);

    public SplitHundredsVariableValue(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, String pSecondCV, int pFactor, int pOffset, String uppermask, String extra1, String extra2, String extra3, String extra4) {
        super(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, minVal, maxVal, v, status, stdname, pSecondCV, pFactor, pOffset, uppermask, extra1, extra2, extra3, extra4);
    }

    @Override
    public void stepOneActions(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, String pSecondCV, int pFactor, int pOffset, String uppermask, String extra1, String extra2, String extra3, String extra4) {
        if (extra3 != null) {
            this._minVal = this.getValueFromText(extra3);
        }
        if (extra4 != null) {
            this._maxVal = this.getValueFromText(extra4);
        }
    }

    @Override
    long getValueFromText(String s) {
        if (s.isEmpty()) {
            return 0L;
        }
        long val = Long.parseUnsignedLong(s);
        long result = 0L;
        long multiplier = 1L;
        long INRADIX = 100L;
        long OUTRADIX = 256L;
        while (val > 0L) {
            long digits = val % 100L;
            val /= 100L;
            result += multiplier * digits;
            multiplier *= 256L;
        }
        return result;
    }

    @Override
    String getTextFromValue(long val) {
        Object result = "";
        long INRADIX = 256L;
        while (val > 0L) {
            long digits = val % 256L;
            val /= 256L;
            result = String.format("%02d", digits) + (String)result;
        }
        result = "0" + (String)result;
        while (((String)result).startsWith("0") && ((String)result).length() > 1) {
            result = ((String)result).substring(1);
        }
        return result;
    }

    @Override
    public void setValue(String value) {
        try {
            long result = this.getValueFromText(value);
            this.setLongValue(result);
        }
        catch (NumberFormatException e) {
            log.warn("handling non-numeric value \"{}\"", (Object)value);
            return;
        }
    }
}

