/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import jmri.jmrit.symbolicprog.Bundle;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.SplitVariableValue;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitTextVariableValue
extends SplitVariableValue {
    public static final String NO_TERM_BYTE = "";
    public static final String NO_PAD_BYTE = "";
    String matchRegex;
    String termByteStr;
    String padByteStr;
    String charSet;
    Byte termByteVal;
    Byte padByteVal;
    int atest;
    private static final Logger log = LoggerFactory.getLogger(SplitTextVariableValue.class);

    public SplitTextVariableValue(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, String pSecondCV, int pFactor, int pOffset, String uppermask, String extra1, String extra2, String extra3, String extra4) {
        super(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, minVal, maxVal, v, status, stdname, pSecondCV, pFactor, pOffset, uppermask, extra1, extra2, extra3, extra4);
    }

    @Override
    public void stepOneActions(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, String pSecondCV, int pFactor, int pOffset, String uppermask, String extra1, String extra2, String extra3, String extra4) {
        this.atest = 77;
        this.matchRegex = extra1;
        this.termByteStr = extra2;
        this.padByteStr = extra3;
        this.charSet = extra4;
        if (!this.termByteStr.equals("")) {
            this.termByteVal = (byte)Integer.parseUnsignedInt(this.termByteStr);
        }
        if (!this.padByteStr.equals("")) {
            this.padByteVal = (byte)Integer.parseUnsignedInt(this.padByteStr);
        }
        log.debug("stepOneActions");
        log.debug("atest={}", (Object)this.atest);
        log.debug("termByteStr=\"{}\",padByteStr=\"{}\"", (Object)this.termByteStr, (Object)this.padByteStr);
        log.debug("termByteVal={},padByteVal={}", (Object)this.termByteVal, (Object)this.padByteVal);
    }

    @Override
    public void stepTwoActions() {
        log.debug("stepTwoActions");
        log.debug("atest={}", (Object)this.atest);
        log.debug("termByteStr=\"{}\",padByteStr=\"{}\"", (Object)this.termByteStr, (Object)this.padByteStr);
        log.debug("termByteVal={},padByteVal={}", (Object)this.termByteVal, (Object)this.padByteVal);
        this._columns = this.cvCount + 2;
    }

    boolean isMatched(String s) {
        if (this.matchRegex != null && !this.matchRegex.equals("")) {
            return s.matches(this.matchRegex);
        }
        return true;
    }

    byte[] getBytesFromText(String s) {
        byte[] ret = new byte[]{};
        try {
            ret = s.getBytes(this.charSet);
        }
        catch (UnsupportedEncodingException ex) {
            this.unsupportedCharset();
        }
        return ret;
    }

    String getTextFromBytes(byte[] v) {
        String ret = "";
        int textBytesLength = v.length;
        for (int i = 0; i < v.length; ++i) {
            if (this.termByteStr.equals("") || v[i] != this.termByteVal) continue;
            textBytesLength = i;
            break;
        }
        if (textBytesLength > 0) {
            byte[] textBytes = new byte[textBytesLength];
            System.arraycopy(v, 0, textBytes, 0, textBytesLength);
            try {
                ret = new String(textBytes, this.charSet);
            }
            catch (UnsupportedEncodingException ex) {
                this.unsupportedCharset();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N of Error Message")
    void unsupportedCharset() {
        SplitTextVariableValue splitTextVariableValue = this;
        synchronized (splitTextVariableValue) {
            JmriJOptionPane.showMessageDialog(new JFrame(), Bundle.getMessage("UnsupportedCharset", this.charSet, this._name), Bundle.getMessage("DecoderDefError"), 0);
        }
        log.error(Bundle.getMessage("UnsupportedCharset", this.charSet, this._name));
    }

    @Override
    int[] getCvValsFromTextField() {
        byte[] newEntries = this.getBytesFromText(this._textField.getText());
        log.debug("getCvValsFromTextField>newEntries.length={}", (Object)newEntries.length);
        int[] retVals = new int[this.cvCount];
        for (int i = 0; i < this.cvCount; ++i) {
            if (i < newEntries.length) {
                retVals[i] = Byte.toUnsignedInt(newEntries[i]);
                continue;
            }
            if (i == newEntries.length && !this.termByteStr.equals("")) {
                retVals[i] = this.termByteVal.byteValue();
                continue;
            }
            if (this.padByteStr.equals("")) continue;
            retVals[i] = this.padByteVal.byteValue();
        }
        return retVals;
    }

    @Override
    void updateVariableValue(int[] intVals) {
        byte[] byteVals = new byte[intVals.length];
        for (int i = 0; i < intVals.length; ++i) {
            byteVals[i] = (byte)intVals[i];
        }
        String newVal = this.getTextFromBytes(byteVals);
        log.debug("Variable={}; set value to '{}';length = {}", new Object[]{this._name, newVal, newVal.length()});
        if (log.isDebugEnabled()) {
            log.debug("Variable={}; set value to {}", (Object)this._name, (Object)newVal);
        }
        log.debug("setValue(newVal)to {}", (Object)newVal);
        this.setValue(newVal);
        log.debug("done setValue(newVal)to {}", (Object)newVal);
        if (log.isDebugEnabled()) {
            log.debug("Variable={}; in property change after setValueFromString call", (Object)this._name);
        }
    }

    @Override
    void exitField() {
        String oldVal = this.oldContents;
        String newVal = this._textField.getText();
        if (!this.isMatched(newVal)) {
            this._textField.setText(oldVal);
            return;
        }
        if (!oldVal.equals(newVal)) {
            log.debug("Value changed from '{}' to '{}", (Object)oldVal, (Object)newVal);
            this._fieldShrink = newVal.length() < oldVal.length();
            log.debug("_fieldShrink={}", (Object)this._fieldShrink);
            this.updatedTextField();
            this.prop.firePropertyChange("Value", oldVal, newVal);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("Variable={}; actionPerformed", (Object)this._name);
        this.exitField();
    }

    @Override
    public int getIntValue() {
        log.error("getValue doesn't make sense for a split text value");
        return 0;
    }

    @Override
    public long getLongValue() {
        log.error("getLongValue doesn't make sense for a split text value");
        return 0L;
    }

    @Override
    public void setValue(String value) {
        log.debug("Variable={}; enter setValue {}", (Object)this._name, (Object)value);
        String oldVal = this._textField.getText();
        log.debug("Variable={}; setValue with new value {} old value {}", new Object[]{this._name, value, oldVal});
        this._textField.setText(value);
        this.prop.firePropertyChange("Value", oldVal, value);
        log.debug("Variable={}; exit setValue {}", (Object)this._name, (Object)value);
    }

    @Override
    public void setIntValue(int i) {
        log.warn("setIntValue doesn't make sense for a split text value: {}", (Object)i);
    }

    @Override
    public void setLongValue(long i) {
        log.warn("setLongValue doesn't make sense for a split text value: {}", (Object)i);
    }
}

