/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrit.symbolicprog.VariableValue;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgFrame;
import jmri.util.swing.JmriJFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcsExportAction
extends AbstractAction {
    JFileChooser fileChooser;
    PaneProgFrame frame;
    RosterEntry rosterEntry;
    CvTableModel mModel;
    VariableTableModel vModel;
    private static final Logger log = LoggerFactory.getLogger(TcsExportAction.class);

    public TcsExportAction(String actionName, CvTableModel mModel, VariableTableModel vModel, RosterEntry rosterEntry, PaneProgFrame pParent) {
        super(actionName);
        this.mModel = mModel;
        this.vModel = vModel;
        this.frame = pParent;
        this.rosterEntry = rosterEntry;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int retVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JmriJFileChooser();
        }
        if ((retVal = this.fileChooser.showSaveDialog(this.frame)) == 0) {
            File file = this.fileChooser.getSelectedFile();
            if (log.isDebugEnabled()) {
                log.debug("start to export to TCS file {}", (Object)file);
            }
            this.frame.getRosterPane().update(this.rosterEntry);
            this.frame.getFnLabelPane().update(this.rosterEntry);
            try (PrintStream str = new PrintStream(new FileOutputStream(file));){
                TcsExportAction.formatTcsVirtualNodeDefinition(str, this.rosterEntry, this.mModel, this.vModel);
            }
            catch (IOException ex) {
                log.error("Error writing file", (Throwable)ex);
            }
        }
    }

    public static void formatTcsVirtualNodeDefinition(PrintStream str, RosterEntry rosterEntry, CvTableModel model, VariableTableModel vModel) {
        str.println("Train.Name=" + rosterEntry.getId());
        str.println("Train.User Description=" + rosterEntry.getComment());
        str.println("Train.Address=" + rosterEntry.getDccAddress());
        str.println("Train.Speed Step Mode=" + (rosterEntry.isLongAddress() ? "15" : "14"));
        for (int i = 0; i <= 27; ++i) {
            String label = rosterEntry.getFunctionLabel(i + 1);
            if (label == null) {
                label = "";
            }
            int displayValue = TcsExportAction.intFromFunctionString(label);
            str.println("Train.Functions(" + i + ").Display=" + displayValue);
            str.println("Train.Functions(" + i + ").Momentary=" + (rosterEntry.getFunctionLockable(i + 1) ? "0" : "1"));
            VariableValue variable = vModel.findVar("Consist Address Active For F" + (i + 1));
            if (variable != null) {
                int value = variable.getIntValue();
                log.trace("For index {} found consist value {}", (Object)i, (Object)value);
                str.println("Train.Functions(" + i + ").Consist Behavior=" + value);
            }
            str.println("Train.Functions(" + i + ").Description=" + (displayValue != 0 ? "" : label));
        }
        str.println("Train.Delete From Roster?=0");
        str.flush();
        str.close();
    }

    static int intFromFunctionString(String fn) {
        if (fn == null) {
            return 0;
        }
        switch (fn.toLowerCase().strip()) {
            case "unassigned": {
                return 0;
            }
            case "headlight": {
                return 1;
            }
            case "bell": {
                return 13;
            }
            case "horn": {
                return 14;
            }
            case "whistle": {
                return 15;
            }
            case "pantograph": {
                return 11;
            }
            case "smoke": {
                return 10;
            }
            case "engine": {
                return 4;
            }
            case "light": {
                return 74;
            }
            case "coupler clank": {
                return 28;
            }
            case "couple": {
                return 122;
            }
            case "uncouple": {
                return 9;
            }
            case "shunting mode": {
                return 7;
            }
            case "momentum": {
                return 8;
            }
            case "brake": {
                return 57;
            }
            case "brake release": {
                return 200;
            }
            case "dynamic brake": {
                return 41;
            }
            case "manual notch down": {
                return 31;
            }
            case "manual notch up": {
                return 30;
            }
            case "reverser": {
                return 69;
            }
            case "mute": {
                return 100;
            }
            case "far light": {
                return 12;
            }
            case "cab light": {
                return 3;
            }
            case "ditch lights": {
                return 48;
            }
            case "step lights": {
                return 98;
            }
            case "tail lights": {
                return 62;
            }
            case "switching lights": {
                return 58;
            }
            case "dimmer": {
                return 51;
            }
            case "interior lights": {
                return 2;
            }
            case "air compressor": {
                return 42;
            }
            case "air pump": {
                return 45;
            }
            case "injector": {
                return 60;
            }
            case "exhaust fan": {
                return 108;
            }
            case "radiator fan": {
                return 17;
            }
            case "steam generator": {
                return 66;
            }
            case "blower": {
                return 105;
            }
            case "blow down": {
                return 56;
            }
            case "safety": {
                return 38;
            }
            case "sanding": {
                return 55;
            }
            case "ash dump": {
                return 88;
            }
            case "shoveling": {
                return 18;
            }
            case "water fill": {
                return 35;
            }
            case "long whistle": {
                return 103;
            }
            case "short whistle": {
                return 64;
            }
            case "doppler horn": {
                return 63;
            }
            case "curve squeal": {
                return 36;
            }
            case "brake squeal": {
                return 21;
            }
            case "announce": {
                return 6;
            }
            case "cab chatter": {
                return 27;
            }
        }
        return 0;
    }
}

